/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.com.itextpdf.forms.PdfAcroForm;
import cfca.sadk.com.itextpdf.forms.fields.PdfFormField;
import cfca.sadk.com.itextpdf.forms.fields.PdfSignatureFormField;
import cfca.sadk.com.itextpdf.io.image.ImageData;
import cfca.sadk.com.itextpdf.io.image.ImageDataFactory;
import cfca.sadk.com.itextpdf.kernel.PdfException;
import cfca.sadk.com.itextpdf.kernel.color.Color;
import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.geom.PageSize;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNumber;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfPage;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfWriter;
import cfca.sadk.com.itextpdf.kernel.pdf.StampingProperties;
import cfca.sadk.com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import cfca.sadk.com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import cfca.sadk.com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import cfca.sadk.com.itextpdf.layout.Canvas;
import cfca.sadk.com.itextpdf.layout.Style;
import cfca.sadk.com.itextpdf.layout.border.FixedBorder;
import cfca.sadk.com.itextpdf.layout.element.Cell;
import cfca.sadk.com.itextpdf.layout.element.Paragraph;
import cfca.sadk.com.itextpdf.layout.element.Text;
import cfca.sadk.com.itextpdf.layout.property.TextAlignment;
import cfca.sadk.com.itextpdf.layout.property.VerticalAlignment;
import cfca.sadk.com.itextpdf.signatures.PdfSignatureAppearance;
import cfca.sadk.com.itextpdf.signatures.PdfSigner;
import cfca.sadk.com.itextpdf.signatures.SignatureUtil;
import cfca.sadk.com.itextpdf.svg.converter.SvgConverter;
import cfca.sadk.seal.base.bean.appearance.AbstractAppearance;
import cfca.sadk.seal.base.bean.appearance.BlankAppearance;
import cfca.sadk.seal.base.bean.appearance.GraphicAppearance;
import cfca.sadk.seal.base.bean.appearance.MixAppearance;
import cfca.sadk.seal.base.bean.appearance.TextAppearance;
import cfca.sadk.seal.base.bean.sign.SealResultInfo;
import cfca.sadk.seal.base.bean.sign.SignInfoConfig;
import cfca.sadk.seal.base.bean.svg.SVGData;
import cfca.sadk.seal.base.config.SysEnv;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.external.AbstractExternalP7Signer;
import cfca.sadk.seal.base.util.BytesUtil;
import cfca.sadk.seal.base.util.CFCANoCertP7Signer;
import cfca.sadk.seal.base.util.CFCAP7Signer;
import cfca.sadk.seal.base.util.CoordinateUtil;
import cfca.sadk.seal.base.util.FontUtil;
import cfca.sadk.seal.base.util.MethodCostTimeUtil;
import cfca.sadk.seal.base.util.PDFUtil;
import cfca.sadk.seal.base.util.ParamsCheckUtil;
import cfca.sadk.seal.base.util.SVGUtil;
import cfca.sadk.seal.base.util.UCS4FontUtil;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class SealSignatureUtil {
    private static Logger businessLog = LoggerFactory.getLogger(SealSignatureUtil.class);

    public static SealResultInfo signGraphic(byte[] sourceData, GraphicAppearance appearance, SignInfoConfig signInfo) throws SealException {
        businessLog.info("signGraphic begin...");
        try {
            ParamsCheckUtil.checkSignParams(sourceData, appearance, signInfo);
            int type = 2;
            if (appearance instanceof MixAppearance) {
                type = 3;
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream(sourceData.length + 8192);
            PdfReader reader = new PdfReader(sourceData);
            SealResultInfo resultInfo = SealSignatureUtil.combineExternalSignature(reader, (OutputStream)os, appearance, signInfo, type);
            resultInfo.setSignedPDFData(os.toByteArray());
            os.reset();
            os = null;
            SealResultInfo sealResultInfo = resultInfo;
            return sealResultInfo;
        }
        catch (SealException e) {
            businessLog.error("signGraphic:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("signGraphic:", (Throwable)e);
            throw new SealException("signGraphic failed:", e);
        }
        finally {
            businessLog.info("signGraphic end...");
        }
    }

    public static SealResultInfo signText(byte[] sourceData, TextAppearance appearance, SignInfoConfig signInfo) throws SealException {
        businessLog.info("signText begin...");
        try {
            ParamsCheckUtil.checkSignParams(sourceData, appearance, signInfo);
            ByteArrayOutputStream os = new ByteArrayOutputStream(sourceData.length + 8192);
            PdfReader reader = new PdfReader(sourceData);
            SealResultInfo resultInfo = SealSignatureUtil.combineExternalSignature(reader, (OutputStream)os, appearance, signInfo, 1);
            resultInfo.setSignedPDFData(os.toByteArray());
            SealResultInfo sealResultInfo = resultInfo;
            return sealResultInfo;
        }
        catch (SealException e) {
            businessLog.error("signText:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("signText:", (Throwable)e);
            throw new SealException("signText failed:", e);
        }
        finally {
            businessLog.info("signText end...");
        }
    }

    public static SealResultInfo signGraphic(InputStream sourceStream, OutputStream outputStream, GraphicAppearance appearance, SignInfoConfig signInfo) throws SealException {
        businessLog.info("signGraphic begin...");
        try {
            SealResultInfo resultInfo;
            ParamsCheckUtil.checkSignParams(sourceStream, outputStream, appearance, signInfo);
            int type = 2;
            if (appearance instanceof MixAppearance) {
                type = 3;
            }
            SealResultInfo sealResultInfo = resultInfo = SealSignatureUtil.combineExternalSignature(new PdfReader(sourceStream), outputStream, appearance, signInfo, type);
            return sealResultInfo;
        }
        catch (SealException e) {
            businessLog.error("signGraphic:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("signGraphic:", (Throwable)e);
            throw new SealException("signGraphic Stream failed:", e);
        }
        finally {
            businessLog.info("signGraphic end...");
        }
    }

    public static SealResultInfo signGraphic(InputStream sourceStream, OutputStream outputStream, List<AbstractAppearance> appearanceList, SignInfoConfig signInfo) throws SealException {
        businessLog.info("signGraphic begin...");
        try {
            SealResultInfo resultInfo;
            ParamsCheckUtil.checkSignParams(sourceStream, outputStream, appearanceList, signInfo);
            SealResultInfo sealResultInfo = resultInfo = SealSignatureUtil.combineExternalSignature(new PdfReader(sourceStream), outputStream, appearanceList, signInfo, 2);
            return sealResultInfo;
        }
        catch (SealException e) {
            businessLog.error("signGraphic:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("signGraphic:", (Throwable)e);
            throw new SealException("signGraphic Stream failed:", e);
        }
        finally {
            businessLog.info("signGraphic end...");
        }
    }

    public static SealResultInfo signText(InputStream sourceStream, OutputStream outputStream, TextAppearance appearance, SignInfoConfig signInfo) throws SealException {
        businessLog.info("signText begin...");
        try {
            SealResultInfo resultInfo;
            ParamsCheckUtil.checkSignParams(sourceStream, outputStream, appearance, signInfo);
            SealResultInfo sealResultInfo = resultInfo = SealSignatureUtil.combineExternalSignature(new PdfReader(sourceStream), outputStream, appearance, signInfo, 1);
            return sealResultInfo;
        }
        catch (SealException e) {
            businessLog.error("signText:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("signText:", (Throwable)e);
            throw new SealException("signText Stream failed:", e);
        }
        finally {
            businessLog.info("signText end...");
        }
    }

    public static SealResultInfo signText(InputStream sourceStream, OutputStream outputStream, List<AbstractAppearance> appearanceList, SignInfoConfig signInfo) throws SealException {
        businessLog.info("signText begin...");
        try {
            SealResultInfo resultInfo;
            ParamsCheckUtil.checkSignParams(sourceStream, outputStream, appearanceList, signInfo);
            SealResultInfo sealResultInfo = resultInfo = SealSignatureUtil.combineExternalSignature(new PdfReader(sourceStream), outputStream, appearanceList, signInfo, 1);
            return sealResultInfo;
        }
        catch (SealException e) {
            businessLog.error("signText:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("signText:", (Throwable)e);
            throw new SealException("signText Stream failed:", e);
        }
        finally {
            businessLog.info("signText end...");
        }
    }

    public static SealResultInfo signKeyword(byte[] sourceData, AbstractAppearance appearance, SignInfoConfig signInfo, String keyword, boolean replaceSpace) throws SealException {
        ParamsCheckUtil.checkSignParams(sourceData, appearance, signInfo);
        if (appearance instanceof GraphicAppearance) {
            return SealSignatureUtil.signKeyword(sourceData, (GraphicAppearance)appearance, signInfo, keyword, replaceSpace);
        }
        if (appearance instanceof TextAppearance) {
            return SealSignatureUtil.signKeyword(sourceData, (TextAppearance)appearance, signInfo, keyword, replaceSpace);
        }
        throw new SealException("appearance is wrong:" + appearance);
    }

    public static SealResultInfo signKeyword(byte[] sourceData, GraphicAppearance appearance, SignInfoConfig signInfo, String keyword) throws SealException {
        return SealSignatureUtil.signKeyword(sourceData, appearance, signInfo, keyword, true);
    }

    public static SealResultInfo signKeyword(byte[] sourceData, GraphicAppearance appearance, SignInfoConfig signInfo, String keyword, boolean replaceSpace) throws SealException {
        businessLog.info("signKeyword begin...");
        SealResultInfo finalSignedData = null;
        byte[] openPassword = null;
        ArrayList<AbstractAppearance> list = new ArrayList<AbstractAppearance>();
        try {
            ParamsCheckUtil.checkSignParams(sourceData, appearance, signInfo);
            if (keyword == null || keyword.trim().isEmpty()) {
                throw new SealException("keyword error:keyword is null");
            }
            if (null != signInfo && null != signInfo.getOpenPassword()) {
                openPassword = signInfo.getOpenPassword();
            }
            int inputPageNum = appearance.getPageNum();
            int startPageNum = appearance.getStartPageNum();
            int endPageNum = appearance.getEndPageNum();
            int[] pageArray = appearance.getPageArray();
            HashMap<Integer, List<Rectangle>> keywordMap = null;
            if (null == pageArray) {
                boolean isPageRange = appearance.isPageRange();
                if (isPageRange) {
                    if (startPageNum != 0) {
                        inputPageNum = startPageNum;
                    }
                    if (inputPageNum <= 0) {
                        inputPageNum = 1;
                    }
                    keywordMap = PDFUtil.locationExtraction(sourceData, keyword, inputPageNum, endPageNum, replaceSpace);
                } else {
                    keywordMap = inputPageNum > 0 ? PDFUtil.locationExtraction(sourceData, openPassword, keyword, inputPageNum, replaceSpace) : PDFUtil.locationExtraction(sourceData, openPassword, keyword, replaceSpace);
                }
            } else {
                keywordMap = PDFUtil.locationExtraction(sourceData, keyword, startPageNum, endPageNum, pageArray, replaceSpace);
            }
            if (keywordMap.isEmpty()) {
                throw new SealException("keyword error:" + keyword + " not found!");
            }
            Iterator<Integer> iter = keywordMap.keySet().iterator();
            String signFieldName = appearance.getSignFieldName();
            if (signFieldName == null) {
                signFieldName = "";
            }
            int type = 2;
            if (appearance instanceof MixAppearance) {
                type = 3;
            }
            while (iter.hasNext()) {
                int pageNum = iter.next();
                List<Rectangle> singlePageRects = keywordMap.get(pageNum);
                int size = singlePageRects.size();
                if (size == 0) {
                    throw new SealException("keyword error:" + keyword + " not found in page " + pageNum);
                }
                for (int index = 0; index < size; ++index) {
                    Rectangle rect = singlePageRects.get(index);
                    appearance.setPageNum(pageNum);
                    appearance.setKeywordRect(rect);
                    appearance.setSignFieldName(signFieldName + "_" + pageNum + "_" + index + "_" + UUID.randomUUID());
                    list.add((GraphicAppearance)appearance.clone());
                }
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream(sourceData.length + 8192);
            PdfReader pdfReader = new PdfReader(sourceData);
            if (null != openPassword) {
                pdfReader.setOpenPassword(openPassword);
            }
            finalSignedData = SealSignatureUtil.combineExternalSignature(pdfReader, os, list, signInfo, type, true, false);
            finalSignedData.setSignedPDFData(os.toByteArray());
        }
        catch (SealException e) {
            businessLog.error("signKeyword:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("signKeyword:", (Throwable)e);
            throw new SealException("signKeyword failed:", e);
        }
        businessLog.info("signKeyword end...");
        return finalSignedData;
    }

    public static SealResultInfo signKeyword(byte[] sourceData, TextAppearance appearance, SignInfoConfig signInfo, String keyword) throws SealException {
        return SealSignatureUtil.signKeyword(sourceData, appearance, signInfo, keyword, true);
    }

    public static SealResultInfo signKeyword(byte[] sourceData, TextAppearance appearance, SignInfoConfig signInfo, String keyword, boolean repalceSpace) throws SealException {
        businessLog.info("signKeyword begin...");
        SealResultInfo finalSignedData = null;
        byte[] openPassword = null;
        ArrayList<AbstractAppearance> list = new ArrayList<AbstractAppearance>();
        try {
            ParamsCheckUtil.checkSignParams(sourceData, appearance, signInfo);
            if (keyword == null || keyword.trim().isEmpty()) {
                throw new SealException("keyword error:keyword is null");
            }
            if (null != signInfo && null != signInfo.getOpenPassword()) {
                openPassword = signInfo.getOpenPassword();
            }
            int inputPageNum = appearance.getPageNum();
            int startPageNum = appearance.getStartPageNum();
            int endPageNum = appearance.getEndPageNum();
            int[] pageArray = appearance.getPageArray();
            HashMap<Integer, List<Rectangle>> keywordMap = null;
            if (null == pageArray) {
                boolean isPageRange = appearance.isPageRange();
                if (isPageRange) {
                    if (startPageNum != 0) {
                        inputPageNum = startPageNum;
                    }
                    if (inputPageNum <= 0) {
                        inputPageNum = 1;
                    }
                    keywordMap = PDFUtil.locationExtraction(sourceData, keyword, inputPageNum, endPageNum, repalceSpace);
                } else {
                    keywordMap = inputPageNum > 0 ? PDFUtil.locationExtraction(sourceData, openPassword, keyword, inputPageNum, repalceSpace) : PDFUtil.locationExtraction(sourceData, openPassword, keyword, repalceSpace);
                }
            } else {
                keywordMap = PDFUtil.locationExtraction(sourceData, keyword, inputPageNum, endPageNum, pageArray, repalceSpace);
            }
            if (keywordMap.isEmpty()) {
                throw new SealException("keyword error:" + keyword + " not found!");
            }
            Iterator<Integer> iter = keywordMap.keySet().iterator();
            String signFieldName = appearance.getSignFieldName();
            if (signFieldName == null) {
                signFieldName = "";
            }
            int firstSign = 0;
            while (iter.hasNext()) {
                int pageNum = iter.next();
                List<Rectangle> singlePageRects = keywordMap.get(pageNum);
                if (singlePageRects.size() == 0) {
                    throw new SealException("keyword error:" + keyword + " not found in page " + pageNum);
                }
                for (int index = 0; index < singlePageRects.size(); ++index) {
                    Rectangle rect = singlePageRects.get(index);
                    appearance.setPageNum(pageNum);
                    appearance.setKeywordRect(rect);
                    if (firstSign > 0 && appearance.getFont() != null) {
                        PdfFont font = FontUtil.getInstance().createPdfFont(appearance.getFont().getFontProgram());
                        appearance.setFont(font);
                    }
                    appearance.setSignFieldName(signFieldName + "_" + pageNum + "_" + index + "_" + UUID.randomUUID());
                    ++firstSign;
                    list.add((TextAppearance)appearance.clone());
                }
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream(sourceData.length + 8192);
            PdfReader reader = new PdfReader(sourceData);
            if (null != openPassword) {
                reader.setOpenPassword(openPassword);
            }
            finalSignedData = SealSignatureUtil.combineExternalSignature(reader, (OutputStream)os, list, signInfo, 1);
            finalSignedData.setSignedPDFData(os.toByteArray());
        }
        catch (SealException e) {
            businessLog.error("signKeyword failed:" + keyword, (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("signKeyword failed:" + keyword, (Throwable)e);
            throw new SealException("signKeyword failed:" + keyword, e);
        }
        businessLog.info("signKeyword end...");
        return finalSignedData;
    }

    public static SealResultInfo signCrossPage(byte[] sourceData, GraphicAppearance appearance, SignInfoConfig signInfo) throws SealException {
        businessLog.info("signCrossPage begin...");
        String methodid = MethodCostTimeUtil.recordStartTime("signCrossPage");
        SealResultInfo resultInfo = null;
        PdfDocument pdfDocument = null;
        try {
            ParamsCheckUtil.checkSignParams(sourceData, appearance, signInfo);
            byte[] imageBytes = appearance.getStamperSr();
            if (BytesUtil.isContainsBytes(imageBytes, "</svg>".getBytes("UTF8"))) {
                throw new PdfException("signCrossPage is not support SVG type!");
            }
            int startPageNo = appearance.getStartPageNum();
            int endPageNo = appearance.getEndPageNum();
            appearance.setStamperSr(null);
            PdfReader pdfReader = new PdfReader(sourceData);
            byte[] openPassword = signInfo.getOpenPassword();
            if (null != openPassword) {
                pdfReader.setOpenPassword(openPassword);
            }
            pdfDocument = new PdfDocument(pdfReader, false);
            if (startPageNo == endPageNo && startPageNo != -1 && endPageNo != -1) {
                throw new PdfException("startPageNo must not be equal to endPageNo!");
            }
            if (startPageNo == 0 || -1 > startPageNo) {
                throw new PdfException("startPageNo must be positive or -1!");
            }
            if (endPageNo == 0 || -1 > endPageNo) {
                throw new PdfException("endPageNo must be positive or -1!");
            }
            if (-1 == startPageNo) {
                startPageNo = 1;
            }
            if (-1 == endPageNo) {
                endPageNo = pdfDocument.getNumberOfPages();
            }
            if (startPageNo > endPageNo) {
                int temp = startPageNo;
                startPageNo = endPageNo;
                endPageNo = temp;
            }
            ParamsCheckUtil.checkPageNum(pdfDocument, startPageNo, endPageNo);
            String signFiledName = appearance.getSignFieldName();
            if (signFiledName == null) {
                signFiledName = UUID.randomUUID().toString();
            }
            boolean isSVG = BytesUtil.isContainsBytes(imageBytes, "</svg>".getBytes("UTF8"));
            int crossStyle = appearance.getCrossPageStyle();
            ArrayList<PDFUtil.SplittedImage> splittedImages = null;
            boolean isReuseImage = false;
            if (crossStyle == 5 || crossStyle == 6 || crossStyle == 7 || crossStyle == 8) {
                if (isSVG && crossStyle != 6) {
                    throw new PdfException("signCrossPage is not support SVG type!");
                }
                isReuseImage = true;
                splittedImages = PDFUtil.splitRectangle(pdfDocument, imageBytes, appearance.getImageFormat(), startPageNo, endPageNo, appearance.getCrossPageStyle(), appearance.getCrossPageRangeOption(), appearance.getDpi(), appearance.getRectangle(), appearance.getFirstPagePercent(), appearance.getLastPagePercent());
            } else {
                if (isSVG) {
                    throw new PdfException("signCrossPage is not support SVG type!");
                }
                splittedImages = PDFUtil.splitImage(pdfDocument, new ByteArrayInputStream(imageBytes), appearance.getImageFormat(), startPageNo, endPageNo, appearance.getCrossPageStyle(), appearance.getCrossPageRangeOption(), appearance.getDpi(), appearance.getRectangle());
            }
            int size = splittedImages.size();
            ArrayList<AbstractAppearance> list = new ArrayList<AbstractAppearance>();
            ImageData imageData = null;
            if (!isSVG) {
                imageData = ImageDataFactory.create(imageBytes);
            }
            for (int i = 0; i < size; ++i) {
                float min;
                PDFUtil.SplittedImage splittedImage = splittedImages.get(i);
                float realWidth = splittedImage.imageRect.getWidth();
                if (realWidth < (min = SysEnv.getMinRectWidth())) {
                    throw new SealException("signCross: rectangle width is less than " + min);
                }
                float realHeight = splittedImage.imageRect.getHeight();
                if (realHeight < min) {
                    throw new SealException("signCross: rectangle height is less than " + min);
                }
                appearance.setPageNum(splittedImage.pageNo);
                if (isReuseImage) {
                    if (isSVG) {
                        appearance.setStamperSr(imageBytes);
                    } else {
                        appearance.setImageData(imageData);
                    }
                } else {
                    ImageData subImageData = ImageDataFactory.create(splittedImage.imageBytes);
                    appearance.setImageData(subImageData);
                }
                appearance.setSignFieldName(signFiledName + "_" + i);
                if (appearance.isMoveCrossPosition()) {
                    if (appearance.getRectangle() == null) {
                        throw new SealException("rectangle is null");
                    }
                    if (crossStyle == 1 || crossStyle == 7 || crossStyle == 8 || crossStyle == 3) {
                        splittedImage.imageRect.setX(appearance.getRectangle().getX());
                    } else {
                        splittedImage.imageRect.setY(appearance.getRectangle().getY());
                    }
                }
                appearance.setRectangle(splittedImage.imageRect);
                appearance.setCrossSignOffsetX(splittedImage.offsetX);
                appearance.setCrossSignOffsetY(splittedImage.offsetY);
                list.add((GraphicAppearance)appearance.clone());
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream(sourceData.length + 8192);
            pdfReader = new PdfReader(sourceData);
            resultInfo = SealSignatureUtil.combineExternalSignature(pdfReader, os, list, signInfo, 2, isReuseImage, true);
            resultInfo.setSignedPDFData(os.toByteArray());
        }
        catch (SealException e) {
            businessLog.error("signCrossPage:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("signCrossPage:", (Throwable)e);
            throw new SealException("signCrossPage failed:", e);
        }
        finally {
            if (pdfDocument != null) {
                pdfDocument.close();
            }
            MethodCostTimeUtil.recordEndTime(methodid);
        }
        businessLog.info("signCrossPage end...");
        return resultInfo;
    }

    public static SealResultInfo signBlank(byte[] sourceData, BlankAppearance appearance, SignInfoConfig signatureConfig) throws SealException {
        businessLog.info("signBlank begin...");
        try {
            ParamsCheckUtil.checkSignParams(sourceData, appearance, signatureConfig);
            PdfReader pdfReader = new PdfReader(sourceData);
            if (null != signatureConfig && null != signatureConfig.getOpenPassword()) {
                pdfReader.setOpenPassword(signatureConfig.getOpenPassword());
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream(sourceData.length + 8192);
            SealResultInfo resultInfo = SealSignatureUtil.signBlank(pdfReader, (OutputStream)os, appearance, signatureConfig);
            resultInfo.setSignedPDFData(os.toByteArray());
            SealResultInfo sealResultInfo = resultInfo;
            return sealResultInfo;
        }
        catch (SealException e) {
            businessLog.error("signBlank:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("signBlank:", (Throwable)e);
            throw new SealException("signText failed:", e);
        }
        finally {
            businessLog.info("signBlank end...");
        }
    }

    public static SealResultInfo signBlank(InputStream sourceStream, OutputStream outputStream, BlankAppearance appearance, SignInfoConfig signatureConfig) throws SealException {
        businessLog.info("signBlank begin...");
        try {
            SealResultInfo resultInfo;
            ParamsCheckUtil.checkSignParams(sourceStream, outputStream, appearance, signatureConfig);
            PdfReader reader = new PdfReader(sourceStream);
            if (null != signatureConfig && null != signatureConfig.getOpenPassword()) {
                reader.setOpenPassword(signatureConfig.getOpenPassword());
            }
            SealResultInfo sealResultInfo = resultInfo = SealSignatureUtil.signBlank(reader, outputStream, appearance, signatureConfig);
            return sealResultInfo;
        }
        catch (SealException e) {
            businessLog.error("signBlank:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("signBlank:", (Throwable)e);
            throw new SealException("signBlank failed:", e);
        }
        finally {
            businessLog.info("signBlank end...");
        }
    }

    public static SealResultInfo createBlankSignature(byte[] sourceData, BlankAppearance appearance) throws SealException {
        businessLog.info("createBlankSignature begin...");
        SealResultInfo resultInfo = new SealResultInfo();
        PdfDocument pdfDoc = null;
        try {
            ParamsCheckUtil.checkSignParams(sourceData, appearance);
            PdfReader pdfReader = new PdfReader(sourceData);
            ByteArrayOutputStream output = new ByteArrayOutputStream(sourceData.length + 8192);
            PdfWriter writer = new PdfWriter(output);
            pdfDoc = new PdfDocument(pdfReader, writer, new StampingProperties(), false);
            SignatureUtil signatureUtil = new SignatureUtil(pdfDoc);
            List<String> sigNames = signatureUtil.getSignatureNames();
            if (null != sigNames && sigNames.size() > 0) {
                throw new SealException("createBlankSignature failed: the pdf file has " + sigNames.size() + " signature!");
            }
            Rectangle rect = appearance.getRectangle();
            int pageNum = appearance.getPageNum();
            ParamsCheckUtil.checkPageNum(pdfDoc, pageNum);
            if (appearance.isUpperLeftCoordinate()) {
                Rectangle currentPage = pdfDoc.getPage(pageNum).getPageSizeWithRotation();
                rect = CoordinateUtil.convert(new PageSize(currentPage), rect);
                appearance.setRectangle(rect);
            }
            ParamsCheckUtil.checkBlankPrimaryParam(pdfDoc, appearance, true);
            Rectangle rectDoc = CoordinateUtil.rectangleToTransformedCoordinate(pdfDoc.getPage(pageNum), rect);
            PdfSignatureFormField field = PdfFormField.createSignature(pdfDoc, rectDoc);
            field.setPage(pageNum);
            String fieldName = appearance.getSignFieldName();
            if (fieldName == null || "".equals(fieldName.trim())) {
                throw new SealException("fieldName is null");
            }
            field.setFieldName(fieldName);
            field.getWidgets().get(0).setHighlightMode(PdfAnnotation.HIGHLIGHT_OUTLINE).setFlags(4);
            PdfDictionary mkDictionary = field.getWidgets().get(0).getAppearanceCharacteristics();
            if (null == mkDictionary) {
                mkDictionary = new PdfDictionary();
            }
            PdfArray black = new PdfArray();
            black.add(new PdfNumber(Color.BLACK.getColorValue()[0]));
            black.add(new PdfNumber(Color.BLACK.getColorValue()[1]));
            black.add(new PdfNumber(Color.BLACK.getColorValue()[2]));
            mkDictionary.put(PdfName.BC, black);
            PdfArray white = new PdfArray();
            black.add(new PdfNumber(Color.WHITE.getColorValue()[0]));
            black.add(new PdfNumber(Color.WHITE.getColorValue()[1]));
            black.add(new PdfNumber(Color.WHITE.getColorValue()[2]));
            mkDictionary.put(PdfName.BG, white);
            field.getWidgets().get(0).setAppearanceCharacteristics(mkDictionary);
            PdfAcroForm acroForm = PdfAcroForm.getAcroForm(pdfDoc, true);
            acroForm.addField(field, pdfDoc.getPage(pageNum));
            pdfDoc.close();
            resultInfo.setSignStatus(true);
            resultInfo.setSignedPDFData(output.toByteArray());
            resultInfo.setSignFieldName(appearance.getSignFieldName());
        }
        catch (SealException e) {
            businessLog.error("signBlank:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            resultInfo.setSignStatus(false);
            resultInfo.setFailReason(e.getMessage());
            businessLog.error("createBlankSignature:", (Throwable)e);
            throw new SealException("createBlankSignature failed:", e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
        }
        businessLog.info("createBlankSignature end...");
        return resultInfo;
    }

    public static SealResultInfo signGraphicKeywords(byte[] sourceData, HashMap<String, GraphicAppearance> appearanceMap, HashMap<String, SignInfoConfig> signInfoMap) throws SealException {
        SealResultInfo finalSignedData = null;
        businessLog.info("signGraphicKeywords begin...");
        try {
            if (null == sourceData) {
                throw new SealException("sourceData is null");
            }
            if (appearanceMap == null || appearanceMap.keySet().size() == 0) {
                throw new SealException("keyword error:keywordAppearance is null");
            }
            if (signInfoMap == null || signInfoMap.keySet().size() == 0) {
                throw new SealException("keyword error:keywordSignInfo is null");
            }
            if (appearanceMap.keySet().size() != signInfoMap.keySet().size()) {
                throw new SealException("keyword error:the length of appearanceMap is not equeal to the length of signInfoMap");
            }
            ArrayList<String> keywordList = new ArrayList<String>();
            keywordList.addAll(appearanceMap.keySet());
            HashMap<String, List<Rectangle>> locationMap = PDFUtil.mutiLocationsExtraction(sourceData, keywordList);
            if (locationMap.isEmpty()) {
                throw new SealException("keyword error:" + keywordList + " not found!");
            }
            for (String keyword : locationMap.keySet()) {
                SignInfoConfig signInfo;
                GraphicAppearance appearance = appearanceMap.get(keyword);
                if (appearance == null) {
                    throw new SealException("keyword  error: TextAppearance of " + keyword + " not found!");
                }
                String signFieldName = appearance.getSignFieldName();
                if (signFieldName == null) {
                    signFieldName = "";
                }
                if ((signInfo = signInfoMap.get(keyword)) == null) {
                    throw new SealException("keyword  error: SignInfoConfig of " + keyword + " not found!");
                }
                List<Rectangle> singlePageRects = locationMap.get(keyword);
                if (singlePageRects.size() == 0) {
                    throw new SealException("no keyword found:" + keyword);
                }
                for (int index = 0; index < singlePageRects.size(); ++index) {
                    Rectangle rect = singlePageRects.get(index);
                    int pageNum = rect.getPageNum();
                    if (pageNum == -1) {
                        throw new SealException("keyword error:" + keyword + " pageNum is -1!");
                    }
                    appearance.setPageNum(pageNum);
                    appearance.setKeywordRect(rect);
                    appearance.setSignFieldName(signFieldName + "_" + pageNum + "_" + index + "_" + UUID.randomUUID());
                    finalSignedData = SealSignatureUtil.signGraphic(sourceData, appearance, signInfo);
                    sourceData = finalSignedData.getSignedPDFData();
                }
            }
        }
        catch (SealException e) {
            businessLog.error("signKeyword:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("signKeyword:", (Throwable)e);
            throw new SealException("signKeyword failed:", e);
        }
        businessLog.info("signGraphicKeywords end...");
        return finalSignedData;
    }

    public static SealResultInfo signTextKeywords(byte[] sourceData, HashMap<String, TextAppearance> appearanceMap, HashMap<String, SignInfoConfig> signInfoMap) throws SealException {
        businessLog.info("signTextKeywords begin...");
        SealResultInfo finalSignedData = null;
        ArrayList<String> keywordList = new ArrayList<String>();
        try {
            if (null == sourceData) {
                throw new SealException("sourceData is null");
            }
            if (appearanceMap == null || appearanceMap.keySet().size() == 0) {
                throw new SealException("keyword error:keywordAppearance is null");
            }
            if (signInfoMap == null || signInfoMap.keySet().size() == 0) {
                throw new SealException("keyword error:keywordSignInfo is null");
            }
            if (appearanceMap.keySet().size() != signInfoMap.keySet().size()) {
                throw new SealException("keyword error:the length of appearanceMap is not equeal to the length of signInfoMap");
            }
            keywordList.addAll(appearanceMap.keySet());
            HashMap<String, List<Rectangle>> locationMap = PDFUtil.mutiLocationsExtraction(sourceData, keywordList);
            if (locationMap.isEmpty()) {
                throw new SealException("keyword error:" + keywordList + " not found!");
            }
            Iterator<String> iter = locationMap.keySet().iterator();
            byte[] curSourceData = sourceData;
            int firstSign = 0;
            block3: while (iter.hasNext()) {
                SignInfoConfig signInfo;
                String keyword = iter.next();
                TextAppearance appearance = appearanceMap.get(keyword);
                if (appearance == null) {
                    throw new SealException("keyword  error: TextAppearance of " + keyword + " not found!");
                }
                String signFieldName = appearance.getSignFieldName();
                if (signFieldName == null) {
                    signFieldName = "";
                }
                if ((signInfo = signInfoMap.get(keyword)) == null) {
                    throw new SealException("keyword  error: SignInfoConfig of " + keyword + " not found!");
                }
                List<Rectangle> singlePageRects = locationMap.get(keyword);
                if (singlePageRects.size() == 0) {
                    throw new SealException("no keyword found:" + keyword);
                }
                for (int index = 0; index < singlePageRects.size(); ++index) {
                    Rectangle rect = singlePageRects.get(index);
                    int pageNum = rect.getPageNum();
                    if (pageNum == -1) {
                        throw new SealException("keyword error:" + keyword + " pageNum is -1!");
                    }
                    appearance.setPageNum(pageNum);
                    appearance.setKeywordRect(rect);
                    if (firstSign > 0 && appearance.getFont() != null) {
                        PdfFont font = FontUtil.getInstance().createPdfFont(appearance.getFont().getFontProgram());
                        appearance.setFont(font);
                    }
                    appearance.setSignFieldName(signFieldName + "_" + pageNum + "_" + index + "_" + UUID.randomUUID());
                    finalSignedData = SealSignatureUtil.signText(curSourceData, appearance, signInfo);
                    ++firstSign;
                    curSourceData = finalSignedData.getSignedPDFData();
                    if (curSourceData == null) continue block3;
                }
            }
        }
        catch (SealException e) {
            businessLog.error("signKeyword failed:" + keywordList, (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("signKeyword failed:" + keywordList, (Throwable)e);
            throw new SealException("signKeyword failed:" + keywordList, e);
        }
        businessLog.info("signTextKeywords end...");
        return finalSignedData;
    }

    private static SealResultInfo signBlank(PdfReader reader, OutputStream outputStream, BlankAppearance appearance, SignInfoConfig signatureConfig) throws SealException {
        businessLog.info("signBlank begin...");
        SealResultInfo resultInfo = new SealResultInfo();
        String methodPrex = "signBlank";
        String methodid = MethodCostTimeUtil.recordStartTime(methodPrex);
        try {
            PdfExtGState gs;
            PdfSigner pdfSigner = new PdfSigner(reader, outputStream, true, false);
            int signatureVersion = signatureConfig.getSignatureVersion();
            Mechanism signAlg = signatureConfig.getSignAlg();
            String javaScript = signatureConfig.getJavaScript();
            String mechanismType = signAlg.getMechanismType();
            if (mechanismType.toUpperCase().contains("SM2")) {
                if (0 == signatureVersion) {
                    pdfSigner.setEncryptionAlgorithm("SM2");
                } else if (1 == signatureVersion) {
                    pdfSigner.setEncryptionAlgorithm("SM2");
                    pdfSigner.setJavaScript(javaScript);
                }
            } else if (mechanismType.toUpperCase().contains("RSA")) {
                pdfSigner.setEncryptionAlgorithm("RSA");
            }
            pdfSigner.setSignatureVersion(signatureVersion);
            ParamsCheckUtil.checkBlankPrimaryParam(pdfSigner.getDocument(), appearance, false);
            String signFieldName = appearance.getSignFieldName();
            PdfSignatureAppearance signAppearance = new PdfSignatureAppearance(pdfSigner.getDocument(), new Rectangle(0.0f, 0.0f), appearance.getPageNum());
            pdfSigner.setAppearance(signAppearance);
            signAppearance.setReason(appearance.getReason()).setLocation(appearance.getLocation()).setReuseAppearance(false);
            X509Cert signCert = signatureConfig.getSignCert();
            if (signCert != null) {
                signAppearance.setSignatureCreator("CFCASN" + signCert.getStringSerialNumber());
            }
            pdfSigner.setFieldName(signFieldName);
            Rectangle rect0 = signAppearance.getPageRect();
            Rectangle rect = new Rectangle(rect0);
            PdfFormXObject n2 = signAppearance.getLayer2();
            PdfCanvas canvasn2 = new PdfCanvas(n2, pdfSigner.getDocument());
            if (appearance.getGSBlendMode() == 1) {
                gs = new PdfExtGState();
                gs.put(PdfName.BM, PdfName.Multiply);
                gs.put(PdfName.Type, PdfName.ExtGState);
                gs.setFillOpacity(appearance.getTransparency());
                canvasn2.setExtGState(gs);
            } else if (appearance.getGSBlendMode() == 0) {
                gs = new PdfExtGState();
                gs.setFillOpacity(appearance.getTransparency());
                canvasn2.setExtGState(gs);
            }
            if (appearance.getSignType() == 3) {
                signAppearance.setRenderingMode(PdfSignatureAppearance.RenderingMode.GRAPHIC_AND_DESCRIPTION);
                signAppearance.setLayer2Font(appearance.getFont());
                signAppearance.setLayer2FontColor(appearance.getFontColor());
                signAppearance.setLayer2FontSize(appearance.getFontSize());
                signAppearance.setLayer2Text(appearance.getSignText());
                signAppearance.setTimeRectHeight(appearance.getTextRectHeight());
                signAppearance.setImageRectHeight(appearance.getImageRectHeight());
                signAppearance.setSignatureGraphic(appearance.getImageData());
                signAppearance.setTransparency(appearance.getTransparency());
                signAppearance.setGsBlendMode(appearance.getGSBlendMode());
                signAppearance.setChangeImageHeight(appearance.isChangeImageHeight());
                signAppearance.setAlignmentH(appearance.getAlignmentH());
                signAppearance.setAlignmentV(appearance.getAlignmentV());
                signAppearance.setGraphicAlignmentV(appearance.getGraphicAlignmentV());
                signAppearance.setReverseRect(appearance.isReverseRectangle());
                signAppearance.getLayer0();
                signAppearance.setN2(null);
            } else if (appearance.getSignText() != null && !appearance.getSignText().equals("")) {
                float fontSize = appearance.getFontSize();
                ParamsCheckUtil.checkFontSize(fontSize, appearance.getSignText(), rect0);
                signAppearance.setRenderingMode(PdfSignatureAppearance.RenderingMode.DESCRIPTION);
                if (appearance.getBorderWidth() == 0.0f) {
                    rect.applyMargins(2.0f, 2.0f, 2.0f, 2.0f, false);
                }
                SealSignatureUtil.drawTextSignature(pdfSigner.getDocument(), n2, rect, appearance);
            } else if (appearance.getStamperSr() != null && appearance.getStamperSr().length > 0) {
                signAppearance.setRenderingMode(PdfSignatureAppearance.RenderingMode.GRAPHIC);
                ImageData imageData = ImageDataFactory.create(appearance.getStamperSr());
                if (imageData != null) {
                    float usableScale = Math.min(rect.getWidth() / imageData.getWidth(), rect.getHeight() / imageData.getHeight());
                    float w = imageData.getWidth() * usableScale;
                    float h = imageData.getHeight() * usableScale;
                    float x = (rect.getWidth() - w) / 2.0f;
                    float y = (rect.getHeight() - h) / 2.0f;
                    canvasn2.addImage(imageData, w, 0.0f, 0.0f, h, x, y);
                }
            } else {
                throw new SealException("signBlank failed:signAppearance must have imageBytes or signText!");
            }
            AbstractExternalP7Signer container = signatureConfig.getP7Signer();
            if (container == null) {
                container = new CFCAP7Signer(signatureConfig);
            }
            pdfSigner.signExternalContainer(container, container.getEstimatedSize());
            resultInfo.setSignFieldName(appearance.getSignFieldName());
            resultInfo.setSignedNum(1);
            resultInfo.setSignStatus(true);
        }
        catch (SealException e) {
            resultInfo.setSignStatus(false);
            resultInfo.setFailReason(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            resultInfo.setSignStatus(false);
            resultInfo.setFailReason(e.getMessage());
            businessLog.error("signatureConfig info:" + signatureConfig);
            businessLog.error("appearance info:" + appearance);
            businessLog.error("signBlank:", (Throwable)e);
            throw new SealException("signBlank failed:", e);
        }
        finally {
            MethodCostTimeUtil.recordEndTime(methodid);
        }
        businessLog.info("signBlank end...");
        return resultInfo;
    }

    private static SealResultInfo combineExternalSignature(PdfReader reader, OutputStream outputStream, AbstractAppearance appearance, SignInfoConfig signatureConfig, int type) throws SealException {
        ArrayList<AbstractAppearance> appearanceList = new ArrayList<AbstractAppearance>();
        appearanceList.add(appearance);
        return SealSignatureUtil.combineExternalSignature(reader, outputStream, appearanceList, signatureConfig, type);
    }

    private static SealResultInfo combineExternalSignature(PdfReader reader, OutputStream outputStream, List<AbstractAppearance> appearanceList, SignInfoConfig signatureConfig, int type) throws SealException {
        return SealSignatureUtil.combineExternalSignature(reader, outputStream, appearanceList, signatureConfig, type, false, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SealResultInfo combineExternalSignature(PdfReader reader, OutputStream outputStream, List<AbstractAppearance> appearanceList, SignInfoConfig signatureConfig, int type, boolean reuseImage, boolean isCross) throws SealException {
        PdfDocument pdfDocument;
        String methodid;
        SealResultInfo resultInfo;
        block56: {
            long start = System.currentTimeMillis();
            resultInfo = new SealResultInfo();
            String methodPrex = "combineExternalSignature";
            methodid = MethodCostTimeUtil.recordStartTime(methodPrex);
            PdfSigner pdfSigner = null;
            String tempFileName = null;
            if (null == appearanceList) throw new SealException("appearanceList is null");
            pdfDocument = null;
            try {
                int size = appearanceList.size();
                String tmpFileDir = System.getProperty("java.io.tmpdir");
                byte[] openPassword = signatureConfig.getOpenPassword();
                if (null != openPassword) {
                    reader.setOpenPassword(openPassword);
                }
                tempFileName = tmpFileDir + File.separator + UUID.randomUUID().toString() + ".pdf";
                pdfSigner = new PdfSigner(reader, outputStream, tempFileName, true, true);
                pdfDocument = pdfSigner.getDocument();
                long end = System.currentTimeMillis();
                businessLog.info("get pdfDocument finished,cost= " + (end - start) + " ms");
                PdfName pdfName = null;
                PdfImageXObject imageXObject = null;
                PdfName mixPdfName = null;
                PdfImageXObject mixImageXObject = null;
                float offsetX = 0.0f;
                PdfFormXObject xObject = null;
                for (int i = 0; i < size; ++i) {
                    String fieldName;
                    PdfSignatureAppearance signAppearance;
                    block55: {
                        AbstractAppearance appearance;
                        block60: {
                            GraphicAppearance tmpAppearance;
                            PdfCanvas canvasn2;
                            byte[] svgData;
                            boolean isSvgData;
                            Rectangle rect;
                            block61: {
                                float h;
                                float w;
                                float usableScale;
                                float imageScale;
                                ImageData imageData;
                                Rectangle rect0;
                                block62: {
                                    block59: {
                                        int signatureVersion;
                                        block58: {
                                            String mechanismType;
                                            block57: {
                                                appearance = appearanceList.get(i);
                                                rect0 = appearance.getRectangle();
                                                if (null == rect0) {
                                                    throw new SealException("parameter rectangle must not be null!");
                                                }
                                                if (i == 0 && appearance instanceof MixAppearance) {
                                                    type = 3;
                                                }
                                                signatureVersion = signatureConfig.getSignatureVersion();
                                                Mechanism signAlg = signatureConfig.getSignAlg();
                                                String javaScript = signatureConfig.getJavaScript();
                                                mechanismType = signAlg.getMechanismType();
                                                if (!mechanismType.toUpperCase().contains("SM2")) break block57;
                                                if (0 == signatureVersion) {
                                                    pdfSigner.setEncryptionAlgorithm("SM2");
                                                    break block58;
                                                } else if (1 == signatureVersion) {
                                                    pdfSigner.setEncryptionAlgorithm("SM2");
                                                    pdfSigner.setJavaScript(javaScript);
                                                }
                                                break block58;
                                            }
                                            if (mechanismType.toUpperCase().contains("RSA")) {
                                                pdfSigner.setEncryptionAlgorithm("RSA");
                                            }
                                        }
                                        pdfSigner.setSignatureVersion(signatureVersion);
                                        int pageNum = appearance.getPageNum();
                                        ParamsCheckUtil.checkPageNum(pdfDocument, pageNum);
                                        PdfPage currentPage = pdfDocument.getPage(pageNum);
                                        Rectangle mediaBox = currentPage.getMediaBox();
                                        PageSize currentPageSize = new PageSize(currentPage.getPageSizeWithRotation());
                                        pdfDocument.setDefaultPageSize(currentPageSize);
                                        signAppearance = new PdfSignatureAppearance(pdfDocument, new Rectangle(0.0f, 0.0f), pageNum);
                                        if (i == 0) {
                                            pdfSigner.setAppearance(signAppearance);
                                        }
                                        signAppearance.setReason(appearance.getReason() == null ? "" : appearance.getReason());
                                        signAppearance.setLocation(appearance.getLocation() == null ? "" : appearance.getLocation());
                                        signAppearance.setPageNumber(pageNum);
                                        if (appearance.isHidden()) {
                                            appearance.setTransparency(0.0f);
                                        }
                                        if ((fieldName = appearance.getSignFieldName()) == null || "".equals(fieldName.trim())) {
                                            fieldName = UUID.randomUUID().toString();
                                            appearance.setSignFieldName(fieldName);
                                        }
                                        pdfSigner.setFieldName(fieldName);
                                        rect = new Rectangle(rect0);
                                        imageData = null;
                                        imageScale = -1.0f;
                                        isSvgData = appearance.isSVGImage();
                                        svgData = appearance.getStamperSr();
                                        if (isSvgData) {
                                            if (SysEnv.isChangeSVG()) {
                                                SVGData svgDataBean = SVGUtil.resetSVGPixel(svgData, rect0.getWidth(), rect0.getHeight());
                                                svgData = svgDataBean.getSvgBytes();
                                                rect0.setWidth(svgDataBean.getWidth());
                                                rect0.setHeight(svgDataBean.getHeight());
                                            } else {
                                                float[] svgRect = SVGUtil.getSVGPixel(svgData);
                                                if (svgRect != null && svgRect[0] != 0.0f && svgRect[1] != 0.0f) {
                                                    rect0 = new Rectangle(rect0.getX(), rect0.getY(), svgRect[0] * 72.0f / 96.0f, svgRect[1] * 72.0f / 96.0f);
                                                }
                                            }
                                        }
                                        if (appearance.isUpperLeftCoordinate()) {
                                            rect0 = CoordinateUtil.convert(currentPageSize, rect0);
                                        }
                                        if (mediaBox.getX() != 0.0f || mediaBox.getY() != 0.0f) {
                                            rect0 = new Rectangle(rect0.getX() + mediaBox.getX(), rect0.getY() + mediaBox.getY(), rect0.getWidth(), rect0.getHeight());
                                        }
                                        if (appearance.getKeywordRect() != null) {
                                            Rectangle keywordRect = appearance.getKeywordRect();
                                            rect0 = CoordinateUtil.getKeywordRect(keywordRect, rect0, appearance.getOffsetX(), appearance.getOffsetY());
                                        }
                                        appearance.setRectangle(rect0);
                                        AbstractExternalP7Signer signer = signatureConfig.getP7Signer();
                                        boolean isCheckCert = true;
                                        if (signer instanceof CFCANoCertP7Signer) {
                                            isCheckCert = false;
                                        }
                                        ParamsCheckUtil.checkPrimaryParam(pdfDocument, appearance, signatureConfig, true, isCheckCert);
                                        X509Cert signCert = signatureConfig.getSignCert();
                                        if (signCert != null) {
                                            signAppearance.setSignatureCreator("CFCASN" + signCert.getStringSerialNumber());
                                        }
                                        if (SysEnv.isCheckOutOfPage()) {
                                            float pageWidth = currentPageSize.getWidth();
                                            float pageHeight = currentPageSize.getHeight();
                                            float ldx = rect0.getX();
                                            float ldy = rect0.getY();
                                            float rux = rect0.getX() + rect0.getWidth();
                                            float ruy = rect0.getY() + rect0.getHeight();
                                            if (ldx < 0.0f) {
                                                rect0.setX(0.0f);
                                            }
                                            if (rux > pageWidth) {
                                                rect0.setX(pageWidth - rect0.getWidth());
                                            }
                                            if (ldy < 0.0f) {
                                                rect0.setY(0.0f);
                                            }
                                            if (ruy > pageHeight) {
                                                rect0.setY(pageHeight - rect0.getHeight());
                                            }
                                        }
                                        signAppearance.setPageRect(rect0);
                                        signAppearance.setReuseAppearance(false);
                                        PdfFormXObject n2 = signAppearance.getLayer2();
                                        canvasn2 = new PdfCanvas(n2, pdfDocument);
                                        if (appearance.getGSBlendMode() == 1) {
                                            PdfExtGState gs = new PdfExtGState();
                                            gs.put(PdfName.BM, PdfName.Multiply);
                                            gs.put(PdfName.Type, PdfName.ExtGState);
                                            gs.setFillOpacity(appearance.getTransparency());
                                            canvasn2.setExtGState(gs);
                                        } else if (appearance.getGSBlendMode() == 0) {
                                            PdfExtGState gs = new PdfExtGState();
                                            gs.setFillOpacity(appearance.getTransparency());
                                            canvasn2.setExtGState(gs);
                                        }
                                        if (type != 1) break block59;
                                        signAppearance.setRenderingMode(PdfSignatureAppearance.RenderingMode.DESCRIPTION);
                                        TextAppearance tmpAppearance2 = (TextAppearance)appearance;
                                        SealSignatureUtil.drawTextSignature(pdfSigner.getDocument(), n2, rect0, tmpAppearance2);
                                        break block55;
                                    }
                                    if (type != 2) break block60;
                                    tmpAppearance = (GraphicAppearance)appearance;
                                    imageData = tmpAppearance.getImageData();
                                    signAppearance.setRenderingMode(PdfSignatureAppearance.RenderingMode.GRAPHIC);
                                    imageScale = tmpAppearance.isCenterCoordinate() ? 0.0f : -1.0f;
                                    if (imageData == null) break block61;
                                    if (reuseImage && null == imageXObject) {
                                        imageXObject = new PdfImageXObject(imageData);
                                    }
                                    if (!isCross || !reuseImage) break block62;
                                    usableScale = Math.max(rect.getWidth() / imageData.getWidth(), rect.getHeight() / imageData.getHeight());
                                    w = imageData.getWidth() * usableScale;
                                    h = imageData.getHeight() * usableScale;
                                    pdfName = canvasn2.addImage(imageXObject, w, 0.0f, 0.0f, h, tmpAppearance.getCrossSignOffsetX(), tmpAppearance.getCrossSignOffsetY(), pdfName);
                                    break block55;
                                }
                                if (imageScale == 0.0f) {
                                    canvasn2.addImage(imageData, rect0.getWidth(), 0.0f, 0.0f, rect0.getHeight(), 0.0f, 0.0f);
                                    break block55;
                                } else {
                                    usableScale = Math.min(rect.getWidth() / imageData.getWidth(), rect.getHeight() / imageData.getHeight());
                                    w = imageData.getWidth() * usableScale;
                                    h = imageData.getHeight() * usableScale;
                                    float x = (rect.getWidth() - w) / 2.0f;
                                    float y = (rect.getHeight() - h) / 2.0f;
                                    if (reuseImage) {
                                        pdfName = canvasn2.addImage(imageXObject, w, 0.0f, 0.0f, h, x, y, pdfName);
                                        break block55;
                                    } else {
                                        canvasn2.addImage(imageData, w, 0.0f, 0.0f, h, x, y);
                                    }
                                }
                                break block55;
                            }
                            if (isSvgData) {
                                if (isCross) {
                                    int crossStyle = tmpAppearance.getCrossPageStyle();
                                    if (crossStyle != 6) throw new SealException("SVG CrossSign , only RIGHT_STRIPE is supported!");
                                    String id = "draw svg";
                                    MethodCostTimeUtil.recordStartTime(id);
                                    float clipWidth = rect.getWidth();
                                    xObject = SvgConverter.drawOnCanvas((InputStream)new ByteArrayInputStream(svgData), canvasn2, offsetX, 0.0f, xObject);
                                    offsetX -= clipWidth;
                                    MethodCostTimeUtil.recordEndTime(id);
                                    break block55;
                                } else {
                                    xObject = SvgConverter.drawOnCanvas((InputStream)new ByteArrayInputStream(svgData), canvasn2, 0.0f, 0.0f, xObject);
                                }
                            }
                            break block55;
                        }
                        if (type == 3) {
                            MixAppearance tmpAppearance = (MixAppearance)appearance;
                            signAppearance.setRenderingMode(PdfSignatureAppearance.RenderingMode.GRAPHIC_AND_DESCRIPTION);
                            signAppearance.setLayer2Font(tmpAppearance.getFont());
                            signAppearance.setLayer2FontColor(tmpAppearance.getFontColor());
                            signAppearance.setLayer2FontSize(tmpAppearance.getFontSize());
                            signAppearance.setLayer2Text(tmpAppearance.getSignText());
                            signAppearance.setTimeRectHeight(tmpAppearance.getTextRectHeight());
                            signAppearance.setImageRectHeight(tmpAppearance.getImageRectHeight());
                            signAppearance.setSignatureGraphic(tmpAppearance.getImageData());
                            signAppearance.setTransparency(tmpAppearance.getTransparency());
                            signAppearance.setGsBlendMode(tmpAppearance.getGSBlendMode());
                            signAppearance.setChangeImageHeight(tmpAppearance.isChangeImageHeight());
                            signAppearance.setAlignmentH(tmpAppearance.getAlignmentH());
                            signAppearance.setAlignmentV(tmpAppearance.getAlignmentV());
                            signAppearance.setGraphicAlignmentV(tmpAppearance.getGraphicAlignmentV());
                            signAppearance.setReverseRect(tmpAppearance.isReverseRectangle());
                            signAppearance.getLayer0();
                            signAppearance.setImageName(mixPdfName);
                            signAppearance.setImageXObject(mixImageXObject);
                            signAppearance.setN2(null);
                        }
                    }
                    long end1 = System.currentTimeMillis();
                    businessLog.info("get construct signAppearance finished,cost= " + (end1 - end) + " ms");
                    if (size > 1) {
                        pdfSigner.addAppearanceToDocument(signAppearance, fieldName);
                        if (type == 3 && signAppearance.getImageName() != null) {
                            mixPdfName = signAppearance.getImageName();
                            mixImageXObject = signAppearance.getImageXObject();
                        }
                    }
                    if (i != size - 1) continue;
                    pdfSigner.setAppearance(signAppearance);
                    AbstractExternalP7Signer container = signatureConfig.getP7Signer();
                    if (container == null) {
                        container = new CFCAP7Signer(signatureConfig);
                    }
                    if (size > 1) {
                        pdfSigner.setSignatureOnce(true);
                    }
                    pdfSigner.signExternalContainer(container, container.getEstimatedSize());
                }
                resultInfo.setSignStatus(true);
                resultInfo.setSignedNum(size);
                if (tempFileName == null) break block56;
            }
            catch (SealException e) {
                try {
                    resultInfo.setSignStatus(false);
                    resultInfo.setFailReason(e.getMessage());
                    businessLog.error(methodPrex + ": signatureConfig info:{}\n appearance info:{}", (Object)signatureConfig, appearanceList);
                    throw e;
                    catch (Exception e2) {
                        resultInfo.setSignStatus(false);
                        resultInfo.setFailReason(e2.getMessage());
                        businessLog.error(methodPrex + ": signatureConfig info:{}\n appearance info:{}", (Object)signatureConfig, appearanceList);
                        throw new SealException(e2.getMessage(), e2);
                    }
                }
                catch (Throwable throwable) {
                    if (tempFileName != null) {
                        try {
                            File tmpFile = new File(tempFileName);
                            if (tmpFile != null && tmpFile.exists()) {
                                tmpFile.delete();
                            }
                        }
                        catch (Exception e3) {
                            businessLog.warn(tempFileName + "cannot deleted");
                        }
                    }
                    if (pdfDocument != null) {
                        pdfDocument.close();
                    }
                    MethodCostTimeUtil.recordEndTime(methodid);
                    throw throwable;
                }
            }
            try {
                File tmpFile = new File(tempFileName);
                if (tmpFile != null && tmpFile.exists()) {
                    tmpFile.delete();
                }
            }
            catch (Exception e) {
                businessLog.warn(tempFileName + "cannot deleted");
            }
        }
        if (pdfDocument != null) {
            pdfDocument.close();
        }
        MethodCostTimeUtil.recordEndTime(methodid);
        return resultInfo;
    }

    private static void drawTextSignature(PdfDocument pdfDoc, PdfFormXObject n2, Rectangle rect, TextAppearance appearance) throws SealException {
        String signText = appearance.getSignText();
        if (null == signText || signText.isEmpty()) {
            throw new SealException("signText is null");
        }
        Text text = new Text(signText);
        PdfFont font = appearance.getFont();
        if (font == null) {
            font = FontUtil.getInstance().subsetFont(signText);
        }
        if (PDFUtil.containsUCS4Glyph(signText)) {
            font = UCS4FontUtil.getInstance().subsetFont(signText);
        }
        TextAlignment alignmentH = appearance.getAlignmentH();
        VerticalAlignment alignmentV = appearance.getAlignmentV();
        Canvas canvas = new Canvas(n2, pdfDoc);
        Paragraph paragraph = new Paragraph(text);
        ((Paragraph)paragraph.setFont(font)).setMargin(0.0f);
        Cell cell = new Cell();
        float fontSize = appearance.getFontSize();
        Rectangle innerRect = new Rectangle(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        float border = appearance.getBorderWidth();
        if (border > 0.0f) {
            float height = rect.getHeight() - 2.0f * border;
            float width = rect.getWidth() - 2.0f * border;
            innerRect.setHeight(height);
            innerRect.setWidth(width);
            paragraph.setHeight(height);
            paragraph.setWidth(width);
            paragraph.setSelfBorder(true);
            paragraph.setBorder(new FixedBorder(appearance.getBorderColor(), border, appearance.getTransparency()));
        } else {
            text.setTextRise(rect.getHeight() / 50.0f);
        }
        cell.setHeight(rect.getHeight());
        cell.setWidth(rect.getWidth());
        paragraph.setVerticalAlignment(alignmentV);
        paragraph.setTextAlignment(alignmentH);
        if (fontSize == 0.0f) {
            fontSize = FontUtil.getInstance().normalizeFontSize(0.0f, font, innerRect, signText);
        }
        ParamsCheckUtil.checkFontSize(fontSize, signText, rect);
        if (appearance.getFontColor() != null) {
            cell.setFontColor(appearance.getFontColor());
        }
        if (appearance.isBold()) {
            cell.setBold();
        }
        if (appearance.isItalic()) {
            fontSize = 0.8f * fontSize;
            cell.setItalic();
        }
        if (border > 0.0f) {
            text.setHeight(fontSize);
            Style style = new Style().setVerticalAlignment(alignmentV);
            text.addStyle(style);
        }
        cell.setFont(font);
        cell.setFontSize(fontSize);
        cell.setVerticalAlignment(alignmentV);
        cell.setTextAlignment(alignmentH);
        cell.add(paragraph);
        canvas.add(cell);
        canvas.close();
    }
}

