/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.forms;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.forms.fields.PdfButtonFormField;
import cfca.sadk.com.itextpdf.forms.fields.PdfFormField;
import cfca.sadk.com.itextpdf.forms.xfa.XfaForm;
import cfca.sadk.com.itextpdf.kernel.PdfException;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfBoolean;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfIndirectReference;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNumber;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObjectWrapper;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfPage;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfStream;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfString;
import cfca.sadk.com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.kernel.pdf.tagutils.TagReference;
import cfca.sadk.com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import cfca.sadk.com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PdfAcroForm
extends PdfObjectWrapper<PdfDictionary> {
    public static final int SIGNATURE_EXIST = 1;
    public static final int APPEND_ONLY = 2;
    protected boolean generateAppearance = true;
    protected Map<String, PdfFormField> fields = new LinkedHashMap<String, PdfFormField>();
    protected PdfDocument document;
    Logger logger = LoggerFactory.getLogger(PdfAcroForm.class);
    private static PdfName[] resourceNames = new PdfName[]{PdfName.Font, PdfName.XObject, PdfName.ColorSpace, PdfName.Pattern};
    private PdfDictionary defaultResources;
    private Set<PdfFormField> fieldsForFlattening = new LinkedHashSet<PdfFormField>();
    private XfaForm xfaForm;

    private PdfAcroForm(PdfDictionary pdfObject, PdfDocument pdfDocument) {
        super(pdfObject);
        this.document = pdfDocument;
        this.getFormFields();
        this.xfaForm = new XfaForm(pdfObject);
    }

    private PdfAcroForm(PdfDictionary pdfObject, PdfDocument pdfDocument, boolean isForVerify) {
        super(pdfObject);
        this.document = pdfDocument;
        this.getFormFields(isForVerify);
        this.xfaForm = new XfaForm(pdfObject);
    }

    private PdfAcroForm(PdfArray fields) {
        this(PdfAcroForm.createAcroFormDictionaryByFields(fields), null);
        this.setForbidRelease();
    }

    public static PdfAcroForm getAcroForm(PdfDocument document, boolean createIfNotExist) {
        return PdfAcroForm.getAcroForm(document, createIfNotExist, false);
    }

    public static PdfAcroForm getAcroForm(PdfDocument document, boolean createIfNotExist, boolean isForVerify) {
        PdfDictionary acroFormDictionary = ((PdfDictionary)document.getCatalog().getPdfObject()).getAsDictionary(PdfName.AcroForm);
        PdfAcroForm acroForm = null;
        if (acroFormDictionary == null) {
            if (createIfNotExist) {
                acroForm = new PdfAcroForm(new PdfArray());
                acroForm.makeIndirect(document);
                document.getCatalog().put(PdfName.AcroForm, (PdfObject)acroForm.getPdfObject());
                document.getCatalog().setModified();
                acroForm.setDefaultAppearance("/Helv 0 Tf 0 g ");
            }
        } else {
            acroForm = new PdfAcroForm(acroFormDictionary, document, isForVerify);
        }
        if (acroForm != null) {
            acroForm.defaultResources = acroForm.getDefaultResources();
            if (acroForm.defaultResources == null) {
                acroForm.defaultResources = new PdfDictionary();
            }
            acroForm.document = document;
            acroForm.xfaForm = new XfaForm(document);
        }
        return acroForm;
    }

    public void addField(PdfFormField field) {
        if (this.document.getNumberOfPages() == 0) {
            this.document.addNewPage();
        }
        PdfPage page = this.document.getLastPage();
        this.addField(field, page);
    }

    public void addField(PdfFormField field, PdfPage page) {
        PdfArray kids = field.getKids();
        PdfDictionary fieldDic = (PdfDictionary)field.getPdfObject();
        if (kids != null) {
            this.processKids(kids, fieldDic, page);
        }
        PdfArray fieldArray = this.getFields();
        fieldArray.add(fieldDic);
        if (fieldDic.isModified()) {
            fieldArray.setModified();
        }
        this.fields.put(field.getFieldName().toUnicodeString(), field);
        if (field.getKids() != null) {
            this.iterateFields(field.getKids(), this.fields);
        }
        if (field.getFormType() != null && (field.getFormType().equals(PdfName.Tx) || field.getFormType().equals(PdfName.Ch))) {
            List<PdfDictionary> resources = this.getResources((PdfDictionary)field.getPdfObject());
            for (PdfDictionary resDict : resources) {
                this.mergeResources(this.defaultResources, resDict);
            }
            if (!this.defaultResources.isEmpty()) {
                this.put(PdfName.DR, this.defaultResources);
            }
        }
        if (fieldDic.containsKey(PdfName.Subtype) && page != null) {
            PdfAnnotation annot = PdfAnnotation.makeAnnotation(fieldDic);
            this.addWidgetAnnotationToPage(page, annot);
        }
    }

    public void addFieldAppearanceToPage(PdfFormField field, PdfPage page) {
        PdfDictionary fieldDict = (PdfDictionary)field.getPdfObject();
        PdfArray kids = field.getKids();
        if (kids == null || kids.size() > 1) {
            return;
        }
        PdfDictionary kidDict = (PdfDictionary)kids.get(0);
        PdfName type = kidDict.getAsName(PdfName.Subtype);
        if (type != null && type.equals(PdfName.Widget)) {
            if (!kidDict.containsKey(PdfName.FT)) {
                this.mergeWidgetWithParentField(fieldDict, kidDict);
            }
            this.defineWidgetPageAndAddToIt(page, fieldDict, false);
        }
    }

    public Map<String, PdfFormField> getFormFields() {
        return this.getFormFields(false);
    }

    public Map<String, PdfFormField> getFormFields(boolean isForVerify) {
        if (this.fields.size() == 0) {
            this.fields = this.iterateFields(this.getFields(isForVerify));
        }
        return this.fields;
    }

    public PdfDocument getPdfDocument() {
        return this.document;
    }

    public PdfAcroForm setNeedAppearances(boolean needAppearances) {
        return this.put(PdfName.NeedAppearances, PdfBoolean.valueOf(needAppearances));
    }

    public PdfBoolean getNeedAppearances() {
        return ((PdfDictionary)this.getPdfObject()).getAsBoolean(PdfName.NeedAppearances);
    }

    public PdfAcroForm setSignatureFlags(int sigFlags) {
        return this.put(PdfName.SigFlags, new PdfNumber(sigFlags));
    }

    public PdfAcroForm setSignatureFlag(int sigFlag) {
        int flags = this.getSignatureFlags();
        return this.setSignatureFlags(flags |= sigFlag);
    }

    public int getSignatureFlags() {
        PdfNumber f = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.SigFlags);
        if (f != null) {
            return f.intValue();
        }
        return 0;
    }

    public PdfAcroForm setCalculationOrder(PdfArray calculationOrder) {
        return this.put(PdfName.CO, calculationOrder);
    }

    public PdfArray getCalculationOrder() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.CO);
    }

    public PdfAcroForm setDefaultResources(PdfDictionary defaultResources) {
        return this.put(PdfName.DR, defaultResources);
    }

    public PdfDictionary getDefaultResources() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.DR);
    }

    public PdfAcroForm setDefaultAppearance(String appearance) {
        return this.put(PdfName.DA, new PdfString(appearance));
    }

    public PdfString getDefaultAppearance() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.DA);
    }

    public PdfAcroForm setDefaultJustification(int justification) {
        return this.put(PdfName.Q, new PdfNumber(justification));
    }

    public PdfNumber getDefaultJustification() {
        return ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.Q);
    }

    public PdfAcroForm setXFAResource(PdfStream xfaResource) {
        return this.put(PdfName.XFA, xfaResource);
    }

    public PdfAcroForm setXFAResource(PdfArray xfaResource) {
        return this.put(PdfName.XFA, xfaResource);
    }

    public PdfObject getXFAResource() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.XFA);
    }

    public PdfFormField getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    public boolean isGenerateAppearance() {
        return this.generateAppearance;
    }

    public void setGenerateAppearance(boolean generateAppearance) {
        if (generateAppearance) {
            ((PdfDictionary)this.getPdfObject()).remove(PdfName.NeedAppearances);
        }
        this.generateAppearance = generateAppearance;
    }

    public void flattenFields() {
        this.flattenFields(false);
    }

    public void flattenFields(boolean isRemove) {
        LinkedHashSet<Object> fields;
        if (this.document.isAppendMode()) {
            throw new PdfException("Field flattening is not supported in append mode.");
        }
        if (this.fieldsForFlattening.size() == 0) {
            this.fields.clear();
            fields = new LinkedHashSet<PdfFormField>(this.getFormFields().values());
        } else {
            fields = new LinkedHashSet();
            for (PdfFormField field : this.fieldsForFlattening) {
                fields.addAll(this.prepareFieldsForFlattening(field));
            }
        }
        LinkedHashMap<Integer, PdfObject> initialPageResourceClones = new LinkedHashMap<Integer, PdfObject>();
        for (int i = 1; i <= this.document.getNumberOfPages(); ++i) {
            PdfDictionary resources = ((PdfDictionary)this.document.getPage(i).getPdfObject()).getAsDictionary(PdfName.Resources);
            initialPageResourceClones.put(i, resources == null ? null : resources.clone());
        }
        for (PdfFormField pdfFormField : fields) {
            PdfDictionary parent;
            PdfDictionary fieldObject;
            PdfPage page;
            PdfButtonFormField tmpField;
            if (isRemove && pdfFormField instanceof PdfButtonFormField && !(tmpField = (PdfButtonFormField)pdfFormField).isRadio() && !tmpField.isPushButton()) {
                if ("".equals(pdfFormField.getValueAsString())) {
                    pdfFormField.setValue("Off");
                }
                pdfFormField.setBorderWidth(0.0f);
            }
            if ((page = this.getFieldPage(fieldObject = (PdfDictionary)pdfFormField.getPdfObject())) == null) continue;
            PdfAnnotation annotation = PdfAnnotation.makeAnnotation(fieldObject);
            TagTreePointer tagPointer = null;
            if (annotation != null && this.document.isTagged()) {
                tagPointer = this.document.getTagStructureContext().removeAnnotationTag(annotation);
            }
            PdfDictionary appDic = fieldObject.getAsDictionary(PdfName.AP);
            PdfDictionary asNormal = null;
            if (appDic != null && (asNormal = appDic.getAsStream(PdfName.N)) == null) {
                asNormal = appDic.getAsDictionary(PdfName.N);
            }
            if (this.generateAppearance && (appDic == null || asNormal == null)) {
                pdfFormField.regenerateField();
                appDic = fieldObject.getAsDictionary(PdfName.AP);
            }
            if (appDic != null) {
                PdfName as;
                PdfObject normal = appDic.get(PdfName.N);
                PdfFormXObject xObject = null;
                if (normal.isStream()) {
                    xObject = new PdfFormXObject((PdfStream)normal);
                } else if (normal.isDictionary() && ((PdfDictionary)normal).getAsStream(as = fieldObject.getAsName(PdfName.AS)) != null) {
                    xObject = new PdfFormXObject(((PdfDictionary)normal).getAsStream(as));
                    xObject.makeIndirect(this.document);
                }
                if (xObject != null && ((PdfStream)xObject.getPdfObject()).get(PdfName.Subtype) != null) {
                    Rectangle box = PdfAcroForm.getNormalizedRectangle(fieldObject.getAsArray(PdfName.Rect));
                    if (page.isFlushed()) {
                        throw new PdfException("The page has been already flushed. Use PdfAcroForm#addFieldAppearanceToPage() method before page flushing.");
                    }
                    PdfCanvas canvas = new PdfCanvas(page);
                    PdfObject xObjectResources = ((PdfStream)xObject.getPdfObject()).get(PdfName.Resources);
                    Object pageResources = page.getResources().getPdfObject();
                    if (xObjectResources != null && pageResources != null && xObjectResources == pageResources) {
                        ((PdfStream)xObject.getPdfObject()).put(PdfName.Resources, (PdfObject)initialPageResourceClones.get(this.document.getPageNumber(page)));
                    }
                    if (tagPointer != null) {
                        tagPointer.setPageForTagging(page);
                        TagReference tagRef = tagPointer.getTagReference();
                        canvas.openTag(tagRef);
                    }
                    canvas.addXObject(xObject, box.getX(), box.getY());
                    if (tagPointer != null) {
                        canvas.closeTag();
                    }
                }
            }
            PdfArray fFields = this.getFields();
            this.removeObjectFromArray(fFields, fieldObject);
            if (annotation != null) {
                if (appDic != null) {
                    PdfName as;
                    PdfObject normal = appDic.get(PdfName.N);
                    PdfFormXObject xObject = null;
                    if (normal.isStream()) {
                        xObject = new PdfFormXObject((PdfStream)normal);
                    } else if (normal.isDictionary() && ((PdfDictionary)normal).getAsStream(as = fieldObject.getAsName(PdfName.AS)) != null) {
                        xObject = new PdfFormXObject(((PdfDictionary)normal).getAsStream(as));
                        xObject.makeIndirect(this.document);
                    }
                    if (xObject != null && null == ((PdfStream)xObject.getPdfObject()).get(PdfName.Subtype)) {
                        PdfCanvas pdfCanvas = new PdfCanvas(page);
                        xObject.put(PdfName.Type, PdfName.XObject);
                        xObject.put(PdfName.Subtype, PdfName.Form);
                        xObject.put(PdfName.FormType, new PdfNumber(1));
                        if (tagPointer != null) {
                            tagPointer.setPageForTagging(page);
                            TagReference tagRef = tagPointer.getTagReference();
                            pdfCanvas.openTag(tagRef);
                        }
                        Rectangle box = PdfAcroForm.getNormalizedRectangle(fieldObject.getAsArray(PdfName.Rect));
                        pdfCanvas.addXObject(xObject, box.getX(), box.getY());
                        if (tagPointer != null) {
                            pdfCanvas.closeTag();
                        }
                    }
                }
                page.removeAnnotation(annotation);
            }
            if ((parent = fieldObject.getAsDictionary(PdfName.Parent)) == null) continue;
            PdfArray kids = parent.getAsArray(PdfName.Kids);
            this.removeObjectFromArray(kids, fieldObject);
            if (kids != null && !kids.isEmpty()) continue;
            this.removeObjectFromArray(fFields, parent);
        }
        ((PdfDictionary)this.getPdfObject()).remove(PdfName.NeedAppearances);
        if (this.fieldsForFlattening.size() == 0) {
            this.getFields().clear();
        }
        if (this.getFields().isEmpty()) {
            this.document.getCatalog().remove(PdfName.AcroForm);
        }
    }

    public boolean removeField(String fieldName) {
        PdfFormField field = this.getField(fieldName);
        if (field == null) {
            return false;
        }
        PdfDictionary fieldObject = (PdfDictionary)field.getPdfObject();
        PdfPage page = this.getFieldPage(fieldObject);
        PdfAnnotation annotation = PdfAnnotation.makeAnnotation(fieldObject);
        if (page != null && annotation != null) {
            page.removeAnnotation(annotation);
        }
        boolean removeFlag = false;
        PdfDictionary parent = field.getParent();
        if (parent != null) {
            PdfArray kidsArray = parent.getAsArray(PdfName.Kids);
            if (null != kidsArray) {
                this.removeObjectFromArray(parent.getAsArray(PdfName.Kids), fieldObject);
            }
            this.fields.remove(fieldName);
            removeFlag = true;
        }
        if (this.removeObjectFromArray(this.getFields(), fieldObject)) {
            this.fields.remove(fieldName);
            removeFlag = true;
        }
        return removeFlag;
    }

    public void partialFormFlattening(String fieldName) {
        PdfFormField field = this.getFormFields().get(fieldName);
        if (field != null) {
            this.fieldsForFlattening.add(field);
        }
    }

    public void renameField(String oldName, String newName) {
        Map<String, PdfFormField> fields = this.getFormFields();
        if (fields.containsKey(newName)) {
            return;
        }
        PdfFormField field = fields.get(oldName);
        if (field != null) {
            field.setFieldName(newName);
            fields.remove(oldName);
            fields.put(newName, field);
        }
    }

    public PdfFormField copyField(String name) {
        PdfFormField oldField = this.getField(name);
        if (oldField != null) {
            PdfFormField field = new PdfFormField((PdfDictionary)((PdfDictionary)oldField.getPdfObject()).clone().makeIndirect(this.document));
            return field;
        }
        return null;
    }

    public void replaceField(String name, PdfFormField field) {
        this.removeField(name);
        this.addField(field);
    }

    public PdfArray getFields() {
        return this.getFields(false);
    }

    protected PdfArray getFields(boolean isForVerify) {
        PdfArray fields = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Fields);
        if (fields == null) {
            this.logger.warn("Required AcroForm entry /Fields does not exist in the document. Empty array /Fields will be created.");
            fields = new PdfArray();
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Fields, fields);
        }
        if (isForVerify) {
            try {
                int pages = this.document.getNumberOfPages();
                for (int i = 1; i <= pages; ++i) {
                    PdfPage page = this.document.getPage(i);
                    PdfDictionary pdfObj = (PdfDictionary)page.getPdfObject();
                    PdfArray annots = pdfObj.getAsArray(PdfName.Annots);
                    if (annots == null) continue;
                    int size = annots.size();
                    for (int j = 0; j < size; ++j) {
                        PdfIndirectReference sigObj;
                        PdfDictionary annot = annots.getAsDictionary(j);
                        if (annot == null || !PdfName.Widget.equals(annot.getAsName(PdfName.Subtype)) || fields.contains(sigObj = annot.getIndirectReference())) continue;
                        fields.add(sigObj);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("iterate all pages to find signature failed", (Throwable)e);
            }
        }
        return fields;
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return false;
    }

    private Map<String, PdfFormField> iterateFields(PdfArray array, Map<String, PdfFormField> fields) {
        int index = 1;
        for (PdfObject field : array) {
            if (field.isFlushed()) {
                this.logger.warn("A form field was flushed. There's no way to create this field in the AcroForm dictionary.");
                continue;
            }
            PdfFormField formField = PdfFormField.makeFormField(field, this.document);
            PdfString fieldName = formField.getFieldName();
            String name = null;
            if (fieldName == null) {
                PdfFormField parentField;
                if (formField.getParent() == null || (parentField = PdfFormField.makeFormField(formField.getParent(), this.document)) == null) continue;
                boolean isIterate = true;
                while (fieldName == null && isIterate) {
                    fieldName = parentField.getFieldName();
                    if (fieldName != null) continue;
                    if (parentField.getParent() != null) {
                        parentField = PdfFormField.makeFormField(parentField.getParent(), this.document);
                        continue;
                    }
                    isIterate = false;
                }
                if (fieldName != null) {
                    name = fieldName.toUnicodeString() + "." + index;
                    ++index;
                }
            } else {
                name = fieldName.toUnicodeString();
            }
            if (name != null) {
                if (!fields.containsKey(name)) {
                    fields.put(name, formField);
                } else {
                    PdfObject sig = ((PdfDictionary)fields.get(name).getPdfObject()).get(PdfName.V);
                    if (null == sig) {
                        fields.put(name, formField);
                    }
                }
            }
            if (formField.getKids() == null) continue;
            this.iterateFields(formField.getKids(), fields);
        }
        return fields;
    }

    private Map<String, PdfFormField> iterateFields(PdfArray array) {
        return this.iterateFields(array, new LinkedHashMap<String, PdfFormField>());
    }

    private PdfDictionary processKids(PdfArray kids, PdfDictionary parent, PdfPage page) {
        block6: {
            block4: {
                PdfDictionary kidDict;
                block5: {
                    if (kids.size() != 1) break block4;
                    kidDict = (PdfDictionary)kids.get(0);
                    PdfName type = kidDict.getAsName(PdfName.Subtype);
                    if (type == null || !type.equals(PdfName.Widget)) break block5;
                    if (!kidDict.containsKey(PdfName.FT)) {
                        this.mergeWidgetWithParentField(parent, kidDict);
                        this.defineWidgetPageAndAddToIt(page, parent, true);
                    } else {
                        this.defineWidgetPageAndAddToIt(page, kidDict, true);
                    }
                    break block6;
                }
                PdfArray otherKids = kidDict.getAsArray(PdfName.Kids);
                if (otherKids == null) break block6;
                this.processKids(otherKids, kidDict, page);
                break block6;
            }
            for (int i = 0; i < kids.size(); ++i) {
                PdfArray otherKids;
                PdfObject kid = kids.get(i);
                if (kid.isIndirectReference()) {
                    kid = ((PdfIndirectReference)kid).getRefersTo();
                }
                if ((otherKids = ((PdfDictionary)kid).getAsArray(PdfName.Kids)) == null) continue;
                this.processKids(otherKids, (PdfDictionary)kid, page);
            }
        }
        return parent;
    }

    private void mergeWidgetWithParentField(PdfDictionary parent, PdfDictionary widgetDict) {
        parent.remove(PdfName.Kids);
        widgetDict.remove(PdfName.Parent);
        parent.mergeDifferent(widgetDict);
    }

    private void defineWidgetPageAndAddToIt(PdfPage currentPage, PdfDictionary mergedFieldAndWidget, boolean warnIfPageFlushed) {
        PdfAnnotation annot = PdfAnnotation.makeAnnotation(mergedFieldAndWidget);
        PdfDictionary pageDic = annot.getPageObject();
        if (pageDic != null) {
            if (warnIfPageFlushed && pageDic.isFlushed()) {
                throw new PdfException("The page has been already flushed. Use PdfAcroForm#addFieldAppearanceToPage() method before page flushing.");
            }
            PdfDocument doc = pageDic.getIndirectReference().getDocument();
            PdfPage widgetPage = doc.getPage(pageDic);
            this.addWidgetAnnotationToPage(widgetPage, annot);
        } else {
            this.addWidgetAnnotationToPage(currentPage, annot);
        }
    }

    private void addWidgetAnnotationToPage(PdfPage page, PdfAnnotation annot) {
        if (page.containsAnnotation(annot)) {
            return;
        }
        TagTreePointer tagPointer = null;
        boolean tagged = page.getDocument().isTagged();
        if (tagged) {
            tagPointer = page.getDocument().getTagStructureContext().getAutoTaggingPointer();
            tagPointer.addTag(PdfName.Form);
        }
        page.addAnnotation(annot);
        if (tagged) {
            tagPointer.moveToParent();
        }
    }

    private List<PdfDictionary> getResources(PdfDictionary field) {
        PdfArray kids;
        PdfObject normal;
        ArrayList<PdfDictionary> resources = new ArrayList<PdfDictionary>();
        PdfDictionary ap = field.getAsDictionary(PdfName.AP);
        if (ap != null && !ap.isFlushed() && (normal = ap.get(PdfName.N)) != null && !normal.isFlushed()) {
            PdfDictionary resDict;
            if (normal.isDictionary()) {
                for (PdfName key : ((PdfDictionary)normal).keySet()) {
                    PdfStream appearance = ((PdfDictionary)normal).getAsStream(key);
                    PdfDictionary resDict2 = appearance.getAsDictionary(PdfName.Resources);
                    if (resDict2 == null) continue;
                    resources.add(resDict2);
                    break;
                }
            } else if (normal.isStream() && (resDict = ((PdfStream)normal).getAsDictionary(PdfName.Resources)) != null) {
                resources.add(resDict);
            }
        }
        if ((kids = field.getAsArray(PdfName.Kids)) != null) {
            for (PdfObject kid : kids) {
                resources.addAll(this.getResources((PdfDictionary)kid));
            }
        }
        return resources;
    }

    private void mergeResources(PdfDictionary result, PdfDictionary source) {
        for (PdfName name : resourceNames) {
            PdfDictionary dic = source.isFlushed() ? null : source.getAsDictionary(name);
            PdfDictionary res = result.getAsDictionary(name);
            if (res == null) {
                res = new PdfDictionary();
            }
            if (dic == null) continue;
            res.mergeDifferent(dic);
            result.put(name, res);
        }
    }

    public boolean hasXfaForm() {
        return this.xfaForm != null && this.xfaForm.isXfaPresent();
    }

    public XfaForm getXfaForm() {
        return this.xfaForm;
    }

    public void removeXfaForm() {
        if (this.hasXfaForm()) {
            PdfDictionary root = (PdfDictionary)this.document.getCatalog().getPdfObject();
            PdfDictionary acroform = root.getAsDictionary(PdfName.AcroForm);
            acroform.remove(PdfName.XFA);
            this.xfaForm = null;
        }
    }

    public PdfAcroForm put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        return this;
    }

    public void release() {
        this.unsetForbidRelease();
        ((PdfDictionary)this.getPdfObject()).release();
        for (PdfFormField field : this.fields.values()) {
            field.release();
        }
        this.fields = null;
    }

    private static PdfDictionary createAcroFormDictionaryByFields(PdfArray fields) {
        PdfDictionary dictionary = new PdfDictionary();
        dictionary.put(PdfName.Fields, fields);
        return dictionary;
    }

    private PdfPage getFieldPage(PdfDictionary annotDic) {
        PdfDictionary pageDic = annotDic.getAsDictionary(PdfName.P);
        if (pageDic != null) {
            return this.document.getPage(pageDic);
        }
        for (int i = 1; i <= this.document.getNumberOfPages(); ++i) {
            PdfAnnotation annotation;
            PdfPage page = this.document.getPage(i);
            if (page.isFlushed() || (annotation = PdfAnnotation.makeAnnotation(annotDic)) == null || !page.containsAnnotation(annotation)) continue;
            return page;
        }
        return null;
    }

    private Set<PdfFormField> prepareFieldsForFlattening(PdfFormField field) {
        LinkedHashSet<PdfFormField> preparedFields = new LinkedHashSet<PdfFormField>();
        preparedFields.add(field);
        PdfArray kids = field.getKids();
        if (kids != null) {
            for (PdfObject kid : kids) {
                PdfFormField kidField = new PdfFormField((PdfDictionary)kid);
                preparedFields.add(kidField);
                if (kidField.getKids() == null) continue;
                preparedFields.addAll(this.prepareFieldsForFlattening(kidField));
            }
        }
        return preparedFields;
    }

    private boolean removeObjectFromArray(PdfArray array, PdfObject toRemove) {
        if (null != array) {
            if (array.contains(toRemove)) {
                array.remove(toRemove);
                return true;
            }
            if (array.contains(toRemove.getIndirectReference())) {
                array.remove(toRemove.getIndirectReference());
                return true;
            }
        }
        return false;
    }

    public static Rectangle getNormalizedRectangle(PdfArray box) {
        float llx = ((PdfNumber)box.get(0)).floatValue();
        float lly = ((PdfNumber)box.get(1)).floatValue();
        float urx = ((PdfNumber)box.get(2)).floatValue();
        float ury = ((PdfNumber)box.get(3)).floatValue();
        return new Rectangle(Math.min(llx, urx), Math.min(lly, ury), Math.max(llx, urx), Math.max(lly, ury));
    }
}

