/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.io.font.cmap;

import cfca.sadk.com.itextpdf.io.font.cmap.AbstractCMap;
import cfca.sadk.com.itextpdf.io.font.cmap.CMapObject;
import cfca.sadk.com.itextpdf.io.util.IntHashtable;
import cfca.sadk.com.itextpdf.io.util.TextUtil;
import java.io.IOException;

public class CMapCidUni
extends AbstractCMap {
    private static final long serialVersionUID = 6879167385978230141L;
    private IntHashtable map = new IntHashtable(65537);

    @Override
    void addChar(String mark, CMapObject code) {
        try {
            if (code.isNumber()) {
                String s = this.toUnicodeString(mark, true);
                int codePoint = TextUtil.isSurrogatePair(s, 0) ? TextUtil.convertToUtf32(s, 0) : (int)s.charAt(0);
                this.map.put((Integer)code.getValue(), codePoint);
            } else if (code.isHexString()) {
                if (mark.length() == 1) {
                    char[] dest = this.createCharsFromDoubleBytes((byte[])code.getValue());
                    int unicode = TextUtil.convertToUtf32(new String(dest), 0);
                    this.map.put(mark.charAt(0), unicode);
                } else if (mark.length() == 2) {
                    char[] dest = this.createCharsFromDoubleBytes((byte[])code.getValue());
                    int unicode = 0;
                    unicode = dest.length == 1 ? TextUtil.convertToUtf32(new String(dest))[0] : TextUtil.convertToUtf32(new String(dest), 0);
                    int key = (mark.charAt(0) << 8) + mark.charAt(1);
                    this.map.put(key, unicode);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private char[] createCharsFromDoubleBytes(byte[] bytes) throws IOException {
        char[] chars = new char[bytes.length / 2];
        for (int i = 0; i < bytes.length; i += 2) {
            chars[i / 2] = (char)(((bytes[i] & 0xFF) << 8) + (bytes[i + 1] & 0xFF));
        }
        return chars;
    }

    public int lookup(int character) {
        return this.map.get(character);
    }

    public int[] getCids() {
        return this.map.getKeys();
    }
}

