/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.crypto.securityhandler;

import cfca.sadk.com.itextpdf.kernel.crypto.IDecryptor;
import cfca.sadk.com.itextpdf.kernel.crypto.OutputStreamEncryption;
import cfca.sadk.com.itextpdf.kernel.crypto.OutputStreamStandardEncryption;
import cfca.sadk.com.itextpdf.kernel.crypto.StandardDecryptor;
import cfca.sadk.com.itextpdf.kernel.crypto.securityhandler.PubKeySecurityHandler;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNumber;
import cfca.sadk.com.itextpdf.kernel.security.IExternalDecryptionProcess;
import java.io.OutputStream;
import java.security.Key;
import java.security.cert.Certificate;

public class PubSecHandlerUsingStandard40
extends PubKeySecurityHandler {
    private static final long serialVersionUID = -4875474035831723279L;

    public PubSecHandlerUsingStandard40(PdfDictionary encryptionDictionary, Certificate[] certs, int[] permissions, boolean encryptMetadata, boolean embeddedFilesOnly) {
        this.initKeyAndFillDictionary(encryptionDictionary, certs, permissions, encryptMetadata, embeddedFilesOnly);
    }

    public PubSecHandlerUsingStandard40(PdfDictionary encryptionDictionary, Key certificateKey, Certificate certificate, String certificateKeyProvider, IExternalDecryptionProcess externalDecryptionProcess, boolean encryptMetadata) {
        this.initKeyAndReadDictionary(encryptionDictionary, certificateKey, certificate, certificateKeyProvider, externalDecryptionProcess, encryptMetadata);
    }

    @Override
    public OutputStreamEncryption getEncryptionStream(OutputStream os) {
        return new OutputStreamStandardEncryption(os, this.nextObjectKey, 0, this.nextObjectKeySize);
    }

    @Override
    public IDecryptor getDecryptor() {
        return new StandardDecryptor(this.nextObjectKey, 0, this.nextObjectKeySize);
    }

    @Override
    protected String getDigestAlgorithm() {
        return "SHA-1";
    }

    @Override
    protected void initKey(byte[] globalKey, int keyLength) {
        this.mkey = new byte[keyLength / 8];
        System.arraycopy(globalKey, 0, this.mkey, 0, this.mkey.length);
    }

    @Override
    protected void setPubSecSpecificHandlerDicEntries(PdfDictionary encryptionDictionary, boolean encryptMetadata, boolean embeddedFilesOnly) {
        encryptionDictionary.put(PdfName.Filter, PdfName.Adobe_PubSec);
        encryptionDictionary.put(PdfName.R, new PdfNumber(2));
        PdfArray recipients = this.createRecipientsArray();
        encryptionDictionary.put(PdfName.V, new PdfNumber(1));
        encryptionDictionary.put(PdfName.SubFilter, PdfName.Adbe_pkcs7_s4);
        encryptionDictionary.put(PdfName.Recipients, recipients);
    }
}

