/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.io.source.ByteBuffer;
import cfca.sadk.com.itextpdf.io.source.ByteUtils;
import cfca.sadk.com.itextpdf.io.source.IRandomAccessSource;
import cfca.sadk.com.itextpdf.io.source.PdfTokenizer;
import cfca.sadk.com.itextpdf.io.source.RandomAccessFileOrArray;
import cfca.sadk.com.itextpdf.io.source.RandomAccessSourceFactory;
import cfca.sadk.com.itextpdf.io.source.WindowRandomAccessSource;
import cfca.sadk.com.itextpdf.io.util.MessageFormatUtil;
import cfca.sadk.com.itextpdf.kernel.PdfException;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfBoolean;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfEncryption;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfIndirectReference;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNull;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNumber;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfStream;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfString;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfVersion;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfXrefTable;
import cfca.sadk.com.itextpdf.kernel.pdf.ReaderProperties;
import cfca.sadk.com.itextpdf.kernel.pdf.filters.FilterHandlers;
import cfca.sadk.com.itextpdf.kernel.pdf.filters.IFilterHandler;
import cfca.sadk.seal.base.config.SysEnv;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.PDFUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Map;

public class PdfReader
implements Closeable,
Serializable {
    private static Logger businessLog = LoggerFactory.getLogger(PdfReader.class);
    private static final long serialVersionUID = -3584187443691964939L;
    public static final StrictnessLevel DEFAULT_STRICTNESS_LEVEL = StrictnessLevel.LENIENT;
    private StrictnessLevel strictnessLevel = DEFAULT_STRICTNESS_LEVEL;
    private static final String ENDSTREAM1 = "endstream";
    private static final String ENDSTREAM2 = "\nendstream";
    private static final String ENDSTREAM3 = "\r\nendstream";
    private static final String ENDSTREAM4 = "\rendstream";
    private static final byte[] ENDSTREAM = ByteUtils.getIsoBytes("endstream");
    private static final byte[] ENDOBJ = ByteUtils.getIsoBytes("endobj");
    protected static boolean correctStreamLength = true;
    private boolean unethicalReading = false;
    private PdfIndirectReference currentIndirectReference;
    private PdfIndirectReference lastFailureIndirectReference;
    private String sourcePath;
    protected PdfTokenizer tokens;
    protected PdfEncryption decrypt;
    protected PdfVersion headerPdfVersion;
    protected long lastXref;
    protected long eofPos;
    protected PdfDictionary trailer;
    protected PdfDocument pdfDocument;
    protected PdfAConformanceLevel pdfAConformanceLevel;
    protected ReaderProperties properties;
    protected boolean encrypted = false;
    protected boolean rebuiltXref = false;
    protected boolean hybridXref = false;
    protected boolean fixedXref = false;
    protected boolean xrefStm = false;
    private static final int NEWLINE = 10;
    private boolean useMemery = false;

    public PdfReader(byte[] sourceData) throws IOException {
        this.properties = new ReaderProperties();
        IRandomAccessSource byteSource = new RandomAccessSourceFactory().createSource(sourceData);
        this.checkPdfFileLength(byteSource);
        this.tokens = PdfReader.getOffsetTokeniser(byteSource);
    }

    public PdfReader(byte[] sourceData, ReaderProperties properties) throws IOException {
        this.properties = properties;
        IRandomAccessSource byteSource = new RandomAccessSourceFactory().createSource(sourceData);
        this.checkPdfFileLength(byteSource);
        this.tokens = PdfReader.getOffsetTokeniser(byteSource);
    }

    public PdfReader(IRandomAccessSource byteSource, ReaderProperties properties) throws IOException {
        this.properties = properties;
        this.checkPdfFileLength(byteSource);
        this.tokens = PdfReader.getOffsetTokeniser(byteSource);
    }

    public PdfReader(InputStream is, ReaderProperties properties) throws IOException {
        this(new RandomAccessSourceFactory().createSource(is), properties);
    }

    public PdfReader(File file) throws FileNotFoundException, IOException {
        this(file.getAbsolutePath());
    }

    public PdfReader(InputStream is) throws IOException {
        this(is, new ReaderProperties());
    }

    public PdfReader(String filename, ReaderProperties properties) throws IOException {
        this(new RandomAccessSourceFactory().setForceRead(false).createBestSource(filename), properties);
        this.sourcePath = filename;
    }

    public PdfReader(String filename) throws IOException {
        this(filename, new ReaderProperties());
    }

    @Override
    public void close() throws IOException {
        this.tokens.close();
    }

    public PdfReader setUnethicalReading(boolean unethicalReading) {
        this.unethicalReading = unethicalReading;
        return this;
    }

    public boolean isCloseStream() {
        return this.tokens.isCloseStream();
    }

    public void setCloseStream(boolean closeStream) {
        this.tokens.setCloseStream(closeStream);
    }

    public boolean hasRebuiltXref() {
        return this.rebuiltXref;
    }

    public boolean hasHybridXref() {
        return this.hybridXref;
    }

    public boolean hasXrefStm() {
        return this.xrefStm;
    }

    public boolean hasFixedXref() {
        return this.fixedXref;
    }

    public long getLastXref() {
        return this.lastXref;
    }

    public byte[] readStreamBytes(PdfStream stream, boolean decode) throws IOException {
        byte[] b = this.readStreamBytesRaw(stream);
        if (decode && b != null) {
            return PdfReader.decodeBytes(b, stream);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readStreamBytesRaw(PdfStream stream) throws IOException {
        long offset;
        PdfName type = stream.getAsName(PdfName.Type);
        if (!PdfName.XRef.equals(type) && !PdfName.ObjStm.equals(type)) {
            this.checkPdfStreamLength(stream);
        }
        if ((offset = stream.getOffset()) <= 0L) {
            return null;
        }
        int length = stream.getLength();
        if (length <= 0) {
            return new byte[0];
        }
        RandomAccessFileOrArray file = this.tokens.getSafeFile();
        byte[] bytes = null;
        try {
            file.seek(offset);
            bytes = new byte[length];
            file.readFully(bytes);
            if (this.decrypt != null && !this.decrypt.isEmbeddedFilesOnly()) {
                PdfObject filter = stream.get(PdfName.Filter, true);
                boolean skip = false;
                if (filter != null) {
                    if (PdfName.Crypt.equals(filter)) {
                        skip = true;
                    } else if (filter.getType() == 1) {
                        PdfArray filters = (PdfArray)filter;
                        for (int k = 0; k < filters.size(); ++k) {
                            if (filters.isEmpty() || !PdfName.Crypt.equals(filters.get(k, true))) continue;
                            skip = true;
                            break;
                        }
                    }
                    filter.release();
                }
                if (!skip) {
                    this.decrypt.setHashKeyForNextObject(stream.getIndirectReference().getObjNumber(), stream.getIndirectReference().getGenNumber());
                    bytes = this.decrypt.decryptByteArray(bytes);
                }
            }
        }
        finally {
            try {
                file.close();
            }
            catch (Exception exception) {}
        }
        return bytes;
    }

    public InputStream readStream(PdfStream stream, boolean decode) throws IOException {
        byte[] bytes = this.readStreamBytes(stream, decode);
        return bytes != null ? new ByteArrayInputStream(bytes) : null;
    }

    public static byte[] decodeBytes(byte[] b, PdfDictionary streamDictionary) {
        return PdfReader.decodeBytes(b, streamDictionary, FilterHandlers.getDefaultFilterHandlers());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] decodeBytes(byte[] b, PdfDictionary streamDictionary, Map<PdfName, IFilterHandler> filterHandlers) {
        if (b == null) {
            return null;
        }
        PdfObject filter = streamDictionary.get(PdfName.Filter);
        PdfArray filters = new PdfArray();
        if (filter != null) {
            if (filter.getType() == 6) {
                filters.add(filter);
            } else if (filter.getType() == 1) {
                filters = (PdfArray)filter;
            }
        }
        PdfArray dp = new PdfArray();
        PdfObject dpo = streamDictionary.get(PdfName.DecodeParms);
        if (dpo == null || dpo.getType() != 3 && dpo.getType() != 1) {
            if (dpo != null) {
                dpo.release();
            }
            dpo = streamDictionary.get(PdfName.DP);
        }
        if (dpo != null) {
            if (dpo.getType() == 3) {
                dp.add(dpo);
            } else if (dpo.getType() == 1) {
                dp = (PdfArray)dpo;
            }
            dpo.release();
        }
        for (int j = 0; j < filters.size(); ++j) {
            PdfDictionary decodeParams;
            PdfName filterName = (PdfName)filters.get(j);
            IFilterHandler filterHandler = filterHandlers.get(filterName);
            if (filterHandler == null) {
                throw new PdfException("Filter {0} is not supported.").setMessageParams(filterName);
            }
            if (j < dp.size()) {
                PdfObject dpEntry = dp.get(j, true);
                if (dpEntry == null || dpEntry.getType() == 7) {
                    decodeParams = null;
                } else {
                    if (dpEntry.getType() != 3) throw new PdfException("Decode parameter type {0} is not supported.").setMessageParams(dpEntry.getClass().toString());
                    decodeParams = (PdfDictionary)dpEntry;
                }
            } else {
                decodeParams = null;
            }
            b = filterHandler.decode(b, filterName, decodeParams, streamDictionary);
        }
        return b;
    }

    public RandomAccessFileOrArray getSafeFile() {
        return this.tokens.getSafeFile();
    }

    public long getFileLength() throws IOException {
        return this.tokens.getSafeFile().length();
    }

    public boolean isOpenedWithFullPermission() {
        return !this.encrypted || this.decrypt.isOpenedWithFullPermission() || this.unethicalReading;
    }

    public long getPermissions() {
        long perm = 0L;
        if (this.encrypted && this.decrypt.getPermissions() != null) {
            perm = this.decrypt.getPermissions();
        }
        return perm;
    }

    public int getCryptoMode() {
        if (this.decrypt == null) {
            return -1;
        }
        return this.decrypt.getCryptoMode();
    }

    public PdfAConformanceLevel getPdfAConformanceLevel() {
        return this.pdfAConformanceLevel;
    }

    public byte[] computeUserPassword() {
        if (!this.encrypted || !this.decrypt.isOpenedWithFullPermission()) {
            return null;
        }
        return this.decrypt.computeUserPassword(this.properties.password);
    }

    public byte[] getOriginalFileId() {
        PdfArray id = this.trailer.getAsArray(PdfName.ID);
        if (id != null) {
            return ByteUtils.getIsoBytes(id.getAsString(0).getValue());
        }
        return PdfEncryption.generateNewDocumentId();
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public void setOpenPassword(byte[] password) {
        this.properties.setPassword(password);
    }

    protected void readPdf() throws IOException {
        String version = this.tokens.checkPdfHeader();
        try {
            this.headerPdfVersion = PdfVersion.fromString(version);
        }
        catch (IllegalArgumentException exc) {
            throw new PdfException("PDF version is not valid.", version);
        }
        try {
            this.readXref();
        }
        catch (RuntimeException ex) {
            Logger logger = LoggerFactory.getLogger(PdfReader.class);
            logger.error("Error occurred while reading cross reference table. Cross reference table will be rebuilt. " + ex.getMessage());
            this.rebuildXref();
        }
        this.readDecryptObj();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readObjectStream(PdfStream objectStream) throws IOException {
        int objectStreamNumber = objectStream.getIndirectReference().getObjNumber();
        int first = objectStream.getAsNumber(PdfName.First).intValue();
        int n = objectStream.getAsNumber(PdfName.N).intValue();
        byte[] bytes = this.readStreamBytes(objectStream, true);
        PdfTokenizer saveTokens = this.tokens;
        try {
            int k;
            this.tokens = new PdfTokenizer(new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(bytes)));
            int[] address = new int[n];
            int[] objNumber = new int[n];
            boolean ok = true;
            for (k = 0; k < n && (ok = this.tokens.nextToken()); ++k) {
                if (this.tokens.getTokenType() != PdfTokenizer.TokenType.Number) {
                    ok = false;
                    break;
                }
                objNumber[k] = this.tokens.getIntValue();
                ok = this.tokens.nextToken();
                if (!ok) break;
                if (this.tokens.getTokenType() != PdfTokenizer.TokenType.Number) {
                    ok = false;
                    break;
                }
                address[k] = this.tokens.getIntValue() + first;
            }
            if (!ok) {
                throw new PdfException("Error while reading Object Stream.");
            }
            for (k = 0; k < n; ++k) {
                PdfObject obj;
                this.tokens.seek(address[k]);
                this.tokens.nextToken();
                if (this.tokens.getTokenType() == PdfTokenizer.TokenType.Number) {
                    obj = new PdfNumber(this.tokens.getByteContent());
                } else {
                    this.tokens.seek(address[k]);
                    obj = this.readObject(false, true);
                }
                PdfIndirectReference reference = this.pdfDocument.getXref().get(objNumber[k]);
                if (reference.getObjStreamNumber() != objectStreamNumber) continue;
                reference.setRefersTo(obj);
                obj.setIndirectReference(reference);
            }
            objectStream.getIndirectReference().setState((short)16);
        }
        finally {
            this.tokens = saveTokens;
        }
    }

    protected PdfObject readObject(PdfIndirectReference reference) {
        return this.readObject(reference, true);
    }

    protected PdfObject readObject(boolean readAsDirect) throws IOException {
        return this.readObject(readAsDirect, false);
    }

    protected PdfObject readObject(boolean readAsDirect, boolean objStm) throws IOException {
        this.tokens.nextValidToken();
        PdfTokenizer.TokenType type = this.tokens.getTokenType();
        switch (type) {
            case StartDic: {
                boolean hasNext;
                PdfDictionary dict = this.readDictionary(objStm);
                long pos = this.tokens.getPosition();
                while ((hasNext = this.tokens.nextToken()) && this.tokens.getTokenType() == PdfTokenizer.TokenType.Comment) {
                }
                if (hasNext && this.tokens.tokenValueEqualsTo(PdfTokenizer.Stream)) {
                    int ch;
                    while ((ch = this.tokens.read()) == 32 || ch == 9 || ch == 0 || ch == 12) {
                    }
                    if (ch != 10) {
                        ch = this.tokens.read();
                    }
                    if (ch != 10) {
                        this.tokens.backOnePosition(ch);
                    }
                    return new PdfStream(this.tokens.getPosition(), dict);
                }
                this.tokens.seek(pos);
                return dict;
            }
            case StartArray: {
                return this.readArray(objStm);
            }
            case Number: {
                return new PdfNumber(this.tokens.getByteContent());
            }
            case String: {
                PdfString pdfString = new PdfString(this.tokens.getByteContent(), this.tokens.isHexString());
                if (this.isEncrypted() && !this.decrypt.isEmbeddedFilesOnly() && !objStm) {
                    pdfString.setDecryption(this.currentIndirectReference.getObjNumber(), this.currentIndirectReference.getGenNumber(), this.decrypt);
                }
                return pdfString;
            }
            case Name: {
                return this.readPdfName(readAsDirect);
            }
            case Ref: {
                int num = this.tokens.getObjNr();
                PdfXrefTable table = this.pdfDocument.getXref();
                PdfIndirectReference reference = table.get(num);
                if (reference != null) {
                    if (reference.isFree()) {
                        return PdfNull.PDF_NULL;
                    }
                    if (reference.getGenNumber() != this.tokens.getGenNr()) {
                        if (this.fixedXref) {
                            Logger logger = LoggerFactory.getLogger(PdfReader.class);
                            logger.warn(MessageFormatUtil.format("Invalid indirect reference {0} {1} R", this.tokens.getObjNr(), this.tokens.getGenNr()));
                            return new PdfNull();
                        }
                        throw new PdfException("Invalid indirect reference {0}.");
                    }
                } else {
                    reference = table.add(new PdfIndirectReference(this.pdfDocument, num, this.tokens.getGenNr(), 0L).setState((short)4));
                    businessLog.warn("reference of obj " + num + " is not found!");
                }
                return reference;
            }
            case EndOfFile: {
                throw new PdfException("Unexpected end of file.");
            }
        }
        if (this.tokens.tokenValueEqualsTo(PdfTokenizer.Null)) {
            if (readAsDirect) {
                return PdfNull.PDF_NULL;
            }
            return new PdfNull();
        }
        if (this.tokens.tokenValueEqualsTo(PdfTokenizer.True)) {
            if (readAsDirect) {
                return PdfBoolean.TRUE;
            }
            return new PdfBoolean(true);
        }
        if (this.tokens.tokenValueEqualsTo(PdfTokenizer.False)) {
            if (readAsDirect) {
                return PdfBoolean.FALSE;
            }
            return new PdfBoolean(false);
        }
        return null;
    }

    protected PdfName readPdfName(boolean readAsDirect) {
        PdfName cachedName;
        if (readAsDirect && (cachedName = PdfName.staticNames.get(this.tokens.getStringValue())) != null) {
            return cachedName;
        }
        return new PdfName(this.tokens.getByteContent());
    }

    protected PdfDictionary readDictionary(boolean objStm) throws IOException {
        PdfDictionary dic = new PdfDictionary();
        while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() == PdfTokenizer.TokenType.EndDic) break;
            if (this.tokens.getTokenType() != PdfTokenizer.TokenType.Name) {
                this.tokens.throwError("Dictionary key {0} is not a name.", this.tokens.getStringValue());
            }
            PdfName name = this.readPdfName(true);
            PdfObject obj = this.readObject(true, objStm);
            if (obj == null) {
                if (this.tokens.getTokenType() == PdfTokenizer.TokenType.EndDic) {
                    this.tokens.throwError(MessageFormatUtil.format("unexpected {0} was encountered.", ">>"), new Object[0]);
                }
                if (this.tokens.getTokenType() == PdfTokenizer.TokenType.EndArray) {
                    this.tokens.throwError(MessageFormatUtil.format("unexpected {0} was encountered.", "]"), new Object[0]);
                }
            }
            dic.put(name, obj);
        }
        return dic;
    }

    protected PdfArray readArray(boolean objStm) throws IOException {
        PdfArray array = new PdfArray();
        while (true) {
            PdfObject obj;
            if ((obj = this.readObject(true, objStm)) == null) {
                if (this.tokens.getTokenType() == PdfTokenizer.TokenType.EndArray) break;
                this.processArrayReadError();
                break;
            }
            array.add(obj);
        }
        return array;
    }

    private void processArrayReadError() throws UnsupportedEncodingException {
        String error = MessageFormatUtil.format("unexpected {0} was encountered.", new String(this.tokens.getByteContent(), "UTF8"));
        if (StrictnessLevel.CONSERVATIVE.isStricter(this.getStrictnessLevel())) {
            Logger logger = LoggerFactory.getLogger(PdfReader.class);
            logger.error(error);
        } else {
            this.tokens.throwError(error, new Object[0]);
        }
    }

    protected void readXref() throws IOException {
        long startxref;
        this.tokens.seek(this.tokens.getStartxref());
        this.tokens.nextToken();
        if (!this.tokens.tokenValueEqualsTo(PdfTokenizer.Startxref)) {
            throw new PdfException("PDF startxref not found.", this.tokens);
        }
        this.tokens.nextToken();
        if (this.tokens.getTokenType() != PdfTokenizer.TokenType.Number) {
            throw new PdfException("PDF startxref is not followed by a number.", this.tokens);
        }
        this.lastXref = startxref = this.tokens.getLongValue();
        this.eofPos = this.tokens.getPosition();
        try {
            if (this.readXrefStream(startxref)) {
                this.xrefStm = true;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pdfDocument.getXref().clear();
        this.tokens.seek(startxref);
        PdfDictionary trailer2 = this.trailer = this.readXrefSection();
        HashSet<Long> alreadyVisitedXrefTables = new HashSet<Long>();
        while (true) {
            alreadyVisitedXrefTables.add(startxref);
            PdfNumber prev = (PdfNumber)trailer2.get(PdfName.Prev);
            if (prev == null) break;
            if (prev.longValue() == startxref) {
                throw new PdfException("Trailer prev entry points to its own cross reference section.");
            }
            long prevXrefOffset = prev.longValue();
            if (alreadyVisitedXrefTables.contains(prevXrefOffset)) {
                throw new PdfException("xref table has cycled references.");
            }
            startxref = prev.longValue();
            this.tokens.seek(startxref);
            trailer2 = this.readXrefSection();
        }
        Integer xrefSize = this.trailer.getAsInt(PdfName.Size);
        if (xrefSize == null) {
            throw new PdfException("Invalid xref table.");
        }
    }

    protected PdfDictionary readXrefSection() throws IOException {
        this.tokens.nextValidToken();
        if (!this.tokens.tokenValueEqualsTo(PdfTokenizer.Xref)) {
            this.tokens.throwError("xref subsection not found.", new Object[0]);
        }
        PdfXrefTable xref = this.pdfDocument.getXref();
        block2: while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.tokenValueEqualsTo(PdfTokenizer.Trailer)) break;
            if (this.tokens.getTokenType() != PdfTokenizer.TokenType.Number) {
                this.tokens.throwError("Object number of the first object in this xref subsection not found.", new Object[0]);
            }
            int start = this.tokens.getIntValue();
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() != PdfTokenizer.TokenType.Number) {
                this.tokens.throwError("Number of entries in this xref subsection not found.", new Object[0]);
            }
            int end = this.tokens.getIntValue() + start;
            int num = start;
            while (true) {
                block18: {
                    PdfIndirectReference reference;
                    block20: {
                        int gen;
                        long pos;
                        block19: {
                            block17: {
                                if (num >= end) continue block2;
                                this.tokens.nextValidToken();
                                pos = this.tokens.getLongValue();
                                this.tokens.nextValidToken();
                                gen = this.tokens.getIntValue();
                                this.tokens.nextValidToken();
                                if (pos != 0L || gen != 65535 || num != 1 || start == 0) break block17;
                                num = 0;
                                --end;
                                break block18;
                            }
                            reference = xref.get(num);
                            if (reference != null) break block19;
                            reference = new PdfIndirectReference(this.pdfDocument, num, gen, pos);
                            break block20;
                        }
                        if (!reference.checkState((short)4) || reference.getGenNumber() != gen) break block18;
                        reference.setOffset(pos);
                        reference.clearState((short)4);
                    }
                    if (this.tokens.tokenValueEqualsTo(PdfTokenizer.N)) {
                        if (xref.get(num) == null) {
                            xref.add(reference);
                        }
                    } else if (this.tokens.tokenValueEqualsTo(PdfTokenizer.F)) {
                        if (xref.get(num) == null) {
                            xref.freeReference(reference, true);
                            xref.add(reference);
                        }
                    } else {
                        this.tokens.throwError("Invalid cross reference entry in this xref subsection.", new Object[0]);
                    }
                }
                ++num;
            }
            break;
        }
        PdfDictionary trailer = (PdfDictionary)this.readObject(false);
        PdfObject xrs = trailer.get(PdfName.XRefStm);
        if (xrs != null && xrs.getType() == 8) {
            int loc = ((PdfNumber)xrs).intValue();
            try {
                this.readXrefStream(loc);
                this.xrefStm = false;
                this.hybridXref = true;
            }
            catch (IOException e) {
                xref.clear();
                throw e;
            }
        }
        return trailer;
    }

    protected boolean readXrefStream(long ptr) throws IOException {
        HashSet<Long> alreadyVisitedXrefStreams = new HashSet<Long>();
        while (ptr != -1L) {
            PdfArray index;
            PdfStream xrefStream;
            this.tokens.seek(ptr);
            if (!this.tokens.nextToken()) {
                return false;
            }
            if (this.tokens.getTokenType() != PdfTokenizer.TokenType.Number) {
                return false;
            }
            if (!this.tokens.nextToken() || this.tokens.getTokenType() != PdfTokenizer.TokenType.Number) {
                return false;
            }
            if (!this.tokens.nextToken() || !this.tokens.tokenValueEqualsTo(PdfTokenizer.Obj)) {
                return false;
            }
            alreadyVisitedXrefStreams.add(ptr);
            PdfXrefTable xref = this.pdfDocument.getXref();
            PdfObject object = this.readObject(false);
            if (object.getType() == 9) {
                xrefStream = (PdfStream)object;
                if (!PdfName.XRef.equals(xrefStream.get(PdfName.Type))) {
                    return false;
                }
            } else {
                return false;
            }
            if (this.trailer == null) {
                this.trailer = new PdfDictionary();
                this.trailer.putAll(xrefStream);
                this.trailer.remove(PdfName.DecodeParms);
                this.trailer.remove(PdfName.Filter);
                this.trailer.remove(PdfName.Prev);
                this.trailer.remove(PdfName.Length);
            }
            int size = ((PdfNumber)xrefStream.get(PdfName.Size)).intValue();
            PdfObject obj = xrefStream.get(PdfName.Index);
            if (obj == null) {
                index = new PdfArray();
                index.add(new PdfNumber(0));
                index.add(new PdfNumber(size));
            } else {
                index = (PdfArray)obj;
            }
            PdfArray w = xrefStream.getAsArray(PdfName.W);
            long prev = -1L;
            obj = xrefStream.get(PdfName.Prev);
            if (obj != null) {
                prev = ((PdfNumber)obj).longValue();
            }
            xref.setCapacity(size);
            byte[] b = this.readStreamBytes(xrefStream, true);
            int bptr = 0;
            int[] wc = new int[3];
            for (int k = 0; k < 3; ++k) {
                wc[k] = w.getAsNumber(k).intValue();
            }
            for (int idx = 0; idx < index.size(); idx += 2) {
                int start = index.getAsNumber(idx).intValue();
                int length = index.getAsNumber(idx + 1).intValue();
                xref.setCapacity(start + length);
                while (length-- > 0) {
                    PdfIndirectReference newReference;
                    int type = 1;
                    if (wc[0] > 0) {
                        type = 0;
                        for (int k = 0; k < wc[0]; ++k) {
                            type = (type << 8) + (b[bptr++] & 0xFF);
                        }
                    }
                    long field2 = 0L;
                    for (int k = 0; k < wc[1]; ++k) {
                        field2 = (field2 << 8) + (long)(b[bptr++] & 0xFF);
                    }
                    int field3 = 0;
                    for (int k = 0; k < wc[2]; ++k) {
                        field3 = (field3 << 8) + (b[bptr++] & 0xFF);
                    }
                    int base = start;
                    switch (type) {
                        case 0: {
                            if (base == 0) {
                                newReference = xref.get(base);
                                break;
                            }
                            newReference = new PdfIndirectReference(this.pdfDocument, base, field3, 0L);
                            break;
                        }
                        case 1: {
                            newReference = new PdfIndirectReference(this.pdfDocument, base, field3, field2);
                            break;
                        }
                        case 2: {
                            newReference = new PdfIndirectReference(this.pdfDocument, base, 0, field3);
                            newReference.setObjStreamNumber((int)field2);
                            break;
                        }
                        default: {
                            throw new PdfException("Invalid xref stream.");
                        }
                    }
                    if (xref.get(base) == null) {
                        if (newReference != null) {
                            if (type == 0) {
                                newReference.setFree();
                            }
                            xref.add(newReference);
                        }
                    } else if (xref.get(base).checkState((short)4) && xref.get(base).getObjNumber() == newReference.getObjNumber() && xref.get(base).getGenNumber() == newReference.getGenNumber()) {
                        PdfIndirectReference reference = xref.get(base);
                        reference.setOffset(newReference.getOffset());
                        reference.setObjStreamNumber(newReference.getObjStreamNumber());
                        reference.clearState((short)4);
                    }
                    ++start;
                }
            }
            ptr = prev;
            if (!alreadyVisitedXrefStreams.contains(ptr)) continue;
            throw new PdfException("Xref stream has cycled references.");
        }
        return true;
    }

    protected void fixXref() throws IOException {
        this.fixedXref = true;
        PdfXrefTable xref = this.pdfDocument.getXref();
        this.tokens.seek(0L);
        ByteBuffer buffer = new ByteBuffer(24);
        PdfTokenizer lineTokeniser = new PdfTokenizer(new RandomAccessFileOrArray(new ReusableRandomAccessSource(buffer)));
        while (true) {
            int[] obj;
            long pos = this.tokens.getPosition();
            buffer.reset();
            if (!this.tokens.readLineSegment(buffer, true)) break;
            if (buffer.get(0) < 48 || buffer.get(0) > 57 || (obj = PdfTokenizer.checkObjectStart(lineTokeniser)) == null) continue;
            int num = obj[0];
            int gen = obj[1];
            PdfIndirectReference reference = xref.get(num);
            if (reference == null || reference.getGenNumber() != gen || reference.isFlushed()) continue;
            if (reference.checkState((short)8) && reference.getOffset() > pos) {
                pos = reference.getOffset();
            }
            reference.fixOffset(pos);
        }
    }

    protected void rebuildXref() throws IOException {
        this.xrefStm = false;
        this.hybridXref = false;
        this.rebuiltXref = true;
        PdfXrefTable xref = this.pdfDocument.getXref();
        xref.clear();
        this.tokens.seek(0L);
        this.trailer = null;
        ByteBuffer buffer = new ByteBuffer(24);
        PdfTokenizer lineTokeniser = new PdfTokenizer(new RandomAccessFileOrArray(new ReusableRandomAccessSource(buffer)));
        while (true) {
            int[] obj;
            long pos = this.tokens.getPosition();
            buffer.reset();
            if (!this.tokens.readLineSegment(buffer, true)) break;
            if (buffer.get(0) == 116) {
                if (!PdfTokenizer.checkTrailer(buffer)) continue;
                this.tokens.seek(pos);
                this.tokens.nextToken();
                pos = this.tokens.getPosition();
                try {
                    PdfDictionary dic = (PdfDictionary)this.readObject(false);
                    if (dic.get(PdfName.Root, false) != null) {
                        this.trailer = dic;
                        continue;
                    }
                    this.tokens.seek(pos);
                }
                catch (Exception e) {
                    this.tokens.seek(pos);
                }
                continue;
            }
            if (buffer.get(0) < 48 || buffer.get(0) > 57 || (obj = PdfTokenizer.checkObjectStart(lineTokeniser)) == null) continue;
            int num = obj[0];
            int gen = obj[1];
            if (xref.get(num) != null && xref.get(num).getGenNumber() > gen) continue;
            xref.add(new PdfIndirectReference(this.pdfDocument, num, gen, pos));
        }
        if (this.trailer == null) {
            throw new PdfException("Trailer not found.");
        }
    }

    private void readDecryptObj() {
        if (this.encrypted) {
            return;
        }
        PdfDictionary enc = this.trailer.getAsDictionary(PdfName.Encrypt);
        if (enc == null) {
            return;
        }
        this.encrypted = true;
        PdfName filter = enc.getAsName(PdfName.Filter);
        if (PdfName.Adobe_PubSec.equals(filter)) {
            if (this.properties.certificate == null) {
                throw new PdfException("Certificate is not provided. Document is encrypted with public key certificate, it should be passed to PdfReader constructor with properties. See ReaderProperties#setPublicKeySecurityParams() method.");
            }
            this.decrypt = new PdfEncryption(enc, this.properties.certificateKey, this.properties.certificate, this.properties.certificateKeyProvider, this.properties.externalDecryptionProcess);
        } else if (PdfName.Standard.equals(filter)) {
            this.decrypt = new PdfEncryption(enc, this.properties.password, this.getOriginalFileId());
        }
    }

    private static PdfTokenizer getOffsetTokeniser(IRandomAccessSource byteSource) throws IOException {
        PdfTokenizer tok = new PdfTokenizer(new RandomAccessFileOrArray(byteSource));
        int offset = tok.getHeaderOffset();
        if (offset != 0) {
            WindowRandomAccessSource offsetSource = new WindowRandomAccessSource(byteSource, offset);
            tok = new PdfTokenizer(new RandomAccessFileOrArray(offsetSource));
        }
        return tok;
    }

    private PdfObject readObject(PdfIndirectReference reference, boolean fixXref) {
        if (reference == null) {
            return null;
        }
        if (reference.refersTo != null) {
            return reference.refersTo;
        }
        try {
            this.currentIndirectReference = reference;
            if (reference.getObjStreamNumber() > 0) {
                PdfStream objectStream = (PdfStream)this.pdfDocument.getXref().get(reference.getObjStreamNumber()).getRefersTo(false);
                this.readObjectStream(objectStream);
                return reference.refersTo;
            }
            if (reference.getOffset() > 0L) {
                PdfObject object;
                try {
                    this.tokens.seek(reference.getOffset());
                    this.tokens.nextValidToken();
                    if (this.tokens.getTokenType() != PdfTokenizer.TokenType.Obj || this.tokens.getObjNr() != reference.getObjNumber() || this.tokens.getGenNr() != reference.getGenNumber()) {
                        this.tokens.throwError("Invalid offset for object {0}.", reference.toString());
                    }
                    object = this.readObject(false);
                }
                catch (RuntimeException ex) {
                    if (fixXref && reference.getObjStreamNumber() == 0) {
                        this.lastFailureIndirectReference = reference;
                        this.fixXref();
                        object = this.readObject(reference, false);
                        if (object != null && object instanceof PdfDictionary) {
                            if (PdfName.Catalog.equals(((PdfDictionary)object).get(PdfName.Type))) {
                                return object;
                            }
                        }
                        return null;
                    }
                    if (this.lastFailureIndirectReference != null && reference.getObjNumber() == this.lastFailureIndirectReference.getObjNumber() && reference.getGenNumber() == this.lastFailureIndirectReference.getGenNumber() && reference.getOffset() == this.lastFailureIndirectReference.getOffset()) {
                        return null;
                    }
                    throw ex;
                }
                return object != null ? object.setIndirectReference(reference) : null;
            }
            return null;
        }
        catch (IOException e) {
            throw new PdfException("Cannot read PdfObject.", e);
        }
    }

    private void checkPdfStreamLength(PdfStream pdfStream) throws IOException {
        Object line;
        if (!correctStreamLength) {
            return;
        }
        long fileLength = this.tokens.length();
        long start = pdfStream.getOffset();
        boolean calc = false;
        int streamLength = 0;
        PdfNumber pdfNumber = pdfStream.getAsNumber(PdfName.Length);
        if (pdfNumber != null) {
            streamLength = pdfNumber.intValue();
            if ((long)streamLength + start > fileLength - 20L) {
                calc = true;
            } else {
                this.tokens.seek(start + (long)streamLength);
                line = this.tokens.readString(20);
                if (!(((String)line).startsWith(ENDSTREAM2) || ((String)line).startsWith(ENDSTREAM3) || ((String)line).startsWith(ENDSTREAM4) || ((String)line).startsWith(ENDSTREAM1))) {
                    calc = true;
                }
            }
        } else {
            pdfNumber = new PdfNumber(0);
            pdfStream.put(PdfName.Length, pdfNumber);
            calc = true;
        }
        if (calc) {
            long pos;
            block13: {
                line = new ByteBuffer(16);
                this.tokens.seek(start);
                do {
                    pos = this.tokens.getPosition();
                    ((ByteBuffer)line).reset();
                    if (!this.tokens.readLineSegment((ByteBuffer)line, false)) {
                        if (!StrictnessLevel.CONSERVATIVE.isStricter(this.strictnessLevel)) {
                            throw new PdfException("Stream shall end with endstream keyword.");
                        }
                        break block13;
                    }
                    if (((ByteBuffer)line).startsWith(ENDSTREAM)) break block13;
                } while (!((ByteBuffer)line).startsWith(ENDOBJ));
                this.tokens.seek(pos - 16L);
                String s = this.tokens.readString(16);
                int index = s.indexOf(ENDSTREAM1);
                if (index >= 0) {
                    pos = pos - 16L + (long)index;
                }
            }
            streamLength = (int)(pos - start);
            this.tokens.seek(pos - 2L);
            if (this.tokens.read() == 13) {
                --streamLength;
            }
            this.tokens.seek(pos - 1L);
            if (this.tokens.read() == 10) {
                --streamLength;
            }
            pdfNumber.setValue(streamLength);
            pdfStream.updateLength(streamLength);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.sourcePath != null && this.tokens == null) {
            this.tokens = PdfReader.getOffsetTokeniser(new RandomAccessSourceFactory().setForceRead(false).createBestSource(this.sourcePath));
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.sourcePath != null) {
            PdfTokenizer tempTokens = this.tokens;
            this.tokens = null;
            out.defaultWriteObject();
            this.tokens = tempTokens;
        } else {
            out.defaultWriteObject();
        }
    }

    public PdfDocument getPdfDocument() {
        return this.pdfDocument;
    }

    public boolean isUseMemery() {
        return this.useMemery;
    }

    private void checkPdfFileLength(IRandomAccessSource byteSource) {
        try {
            PDFUtil.checkLength(byteSource.length());
        }
        catch (SealException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (byteSource.length() < (long)SysEnv.getDiskPdfFileLength()) {
            this.useMemery = true;
        }
    }

    public StrictnessLevel getStrictnessLevel() {
        return this.strictnessLevel;
    }

    public PdfReader setStrictnessLevel(StrictnessLevel strictnessLevel) {
        this.strictnessLevel = strictnessLevel == null ? DEFAULT_STRICTNESS_LEVEL : strictnessLevel;
        return this;
    }

    public static enum StrictnessLevel {
        CONSERVATIVE(5000),
        LENIENT(3000);

        private final int levelValue;

        private StrictnessLevel(int levelValue) {
            this.levelValue = levelValue;
        }

        public boolean isStricter(StrictnessLevel compareWith) {
            return compareWith == null || this.levelValue > compareWith.levelValue;
        }
    }

    protected static class ReusableRandomAccessSource
    implements IRandomAccessSource {
        private ByteBuffer buffer;

        public ReusableRandomAccessSource(ByteBuffer buffer) {
            if (buffer == null) {
                throw new NullPointerException();
            }
            this.buffer = buffer;
        }

        @Override
        public int get(long offset) {
            if (offset >= (long)this.buffer.size()) {
                return -1;
            }
            return 0xFF & this.buffer.getInternalBuffer()[(int)offset];
        }

        @Override
        public int get(long offset, byte[] bytes, int off, int len) {
            if (this.buffer == null) {
                throw new IllegalStateException("Already closed");
            }
            if (offset >= (long)this.buffer.size()) {
                return -1;
            }
            if (offset + (long)len > (long)this.buffer.size()) {
                len = (int)((long)this.buffer.size() - offset);
            }
            System.arraycopy(this.buffer.getInternalBuffer(), (int)offset, bytes, off, len);
            return len;
        }

        @Override
        public long length() {
            return this.buffer.size();
        }

        @Override
        public void close() throws IOException {
            this.buffer = null;
        }
    }
}

