/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener;

import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.geom.LineSegment;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.geom.Vector;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.DefaultPdfTextLocation;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.IPdfTextLocation;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.keyword.TextChunk;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.keyword.TextChunkLocationDefaultImp;
import cfca.sadk.seal.base.bean.sign.KeywordPosition;
import cfca.sadk.seal.base.util.KMPUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class KeywordProcessTool {
    public List<IPdfTextLocation> getKeywordLocation(String pageWords, HashMap<Integer, Integer> chunkPositions, String keyword, int[] kmpnext, List<TextChunk> chunkList, boolean ignoreCharNumSpace, boolean ignoreSpace) {
        ArrayList<IPdfTextLocation> retval = new ArrayList<IPdfTextLocation>();
        HashSet<Integer> chunkSet = new HashSet<Integer>();
        ArrayList<KeywordPosition> list = this.getKeywordPosition(pageWords, keyword, kmpnext, ignoreCharNumSpace, ignoreSpace);
        for (int k = 0; k < list.size(); ++k) {
            TextChunk firstChunk;
            KeywordPosition keywordPosition = list.get(k);
            int charStartIndex = keywordPosition.getStartIndex();
            int charEndIndex = keywordPosition.getEndIndex();
            int chunkStartIndex = charStartIndex;
            try {
                chunkStartIndex = chunkPositions.get(charStartIndex);
            }
            catch (NullPointerException e) {
                chunkStartIndex = chunkPositions.get(charStartIndex - 1);
            }
            int chunkEndIndex = charEndIndex;
            if (kmpnext.length != 1) {
                try {
                    chunkEndIndex = chunkPositions.get(chunkEndIndex);
                }
                catch (NullPointerException e) {
                    chunkEndIndex = chunkPositions.get(chunkEndIndex - 1);
                }
            } else {
                chunkEndIndex = chunkPositions.get(charEndIndex);
            }
            if ("".equals((firstChunk = chunkList.get(0)).getText().trim())) {
                int size = chunkList.size();
                for (int i = 1; i < size && "".equals((firstChunk = chunkList.get(i)).getText().trim()); ++i) {
                }
            }
            if (chunkStartIndex == chunkEndIndex) {
                if (chunkSet.contains(chunkStartIndex)) continue;
                chunkSet.add(chunkStartIndex);
            }
            TextChunkLocationDefaultImp textChunkLocation = (TextChunkLocationDefaultImp)firstChunk.getLocation();
            Vector orientationVector = textChunkLocation.getOrientationVector();
            List<TextChunk> subChunkList = this.getSubChunkList(chunkList, chunkStartIndex, chunkEndIndex);
            for (Rectangle r : this.getKeywordRectangleList(subChunkList, keyword, kmpnext, ignoreCharNumSpace, ignoreSpace)) {
                retval.add(new DefaultPdfTextLocation(0, r, keyword, orientationVector));
            }
        }
        return retval;
    }

    public ArrayList<KeywordPosition> getKeywordPosition(String pageWords, String keyword, int[] kmpnext, boolean ignoreCharNumSpace, boolean ignoreSpace) {
        boolean flag = true;
        int lastPosition = 0;
        String sourceStr = pageWords;
        ArrayList<KeywordPosition> list = new ArrayList<KeywordPosition>();
        while (flag) {
            KeywordPosition keywordPosition = null;
            keywordPosition = ignoreSpace ? KMPUtil.getFirstPosition(sourceStr, keyword, kmpnext, ignoreCharNumSpace) : KMPUtil.getFirstPosition(sourceStr, keyword, kmpnext);
            if (null == keywordPosition) {
                flag = false;
                continue;
            }
            int startIndex = keywordPosition.getStartIndex();
            int endIndex = keywordPosition.getEndIndex();
            keywordPosition.setStartIndex(lastPosition + startIndex);
            keywordPosition.setEndIndex(lastPosition + endIndex);
            lastPosition += endIndex + 1;
            list.add(keywordPosition);
            sourceStr = sourceStr.substring(endIndex + 1);
        }
        return list;
    }

    protected List<TextChunk> getSubChunkList(List<TextChunk> chunkList, int startIndex, int endIndex) {
        ArrayList<TextChunk> subChunkList = new ArrayList<TextChunk>();
        TextChunk lastChunk = chunkList.get(startIndex);
        subChunkList.add(lastChunk);
        for (int i = startIndex + 1; i <= endIndex; ++i) {
            TextChunk curChunk = chunkList.get(i);
            subChunkList.add(curChunk);
            lastChunk = curChunk;
        }
        return subChunkList;
    }

    protected List<Rectangle> getKeywordRectangleList(List<TextChunk> chunkList, String keyword, int[] kmpnext, boolean ignoreCharNumSpace, boolean ignoreSpace) {
        ArrayList<Rectangle> retval = new ArrayList<Rectangle>();
        if (chunkList.isEmpty()) {
            return retval;
        }
        int chunkSize = chunkList.size();
        TextChunk firstChunk = chunkList.get(0);
        TextChunk lastChunk = chunkList.get(chunkSize - 1);
        Rectangle firstRectangle = firstChunk.getRectangle();
        Rectangle lastRectangle = lastChunk.getRectangle();
        if (chunkSize > 1) {
            TextChunkLocationDefaultImp textChunkLocation;
            Vector orientationVector;
            PdfFont pdfFont = firstChunk.getPdfFont();
            LineSegment ascentLine = firstChunk.getAscentLine();
            LineSegment descentLine = firstChunk.getDescentLine();
            boolean hasSameLineChunk = false;
            for (int i = 1; i < chunkSize; ++i) {
                TextChunk tmpChunk = chunkList.get(i);
                if (this.isSameLine(firstChunk, tmpChunk)) {
                    lastChunk = tmpChunk;
                    hasSameLineChunk = true;
                    continue;
                }
                if (!tmpChunk.getText().trim().equals("")) break;
            }
            if (!hasSameLineChunk) {
                lastChunk = firstChunk;
            }
            if (Math.abs((orientationVector = (textChunkLocation = (TextChunkLocationDefaultImp)firstChunk.getLocation()).getOrientationVector()).get(0) - 1.0f) < 0.001f) {
                float chunkWidth = lastRectangle.getX() - firstRectangle.getX() + lastRectangle.getWidth();
                float fontSize = ascentLine.getStartPoint().get(1) - descentLine.getStartPoint().get(1);
                Rectangle keywordRect = this.getKeywordRect(0, chunkWidth, firstChunk, lastChunk, pdfFont, fontSize, keyword, kmpnext);
                retval.add(keywordRect);
            } else if (Math.abs(orientationVector.get(1) - 1.0f) < 0.001f) {
                float chunkHeight = lastRectangle.getY() - firstRectangle.getY() + lastRectangle.getHeight();
                float fontSize = descentLine.getStartPoint().get(0) - ascentLine.getStartPoint().get(0);
                Rectangle keywordRect = this.getKeywordRect(90, chunkHeight, firstChunk, lastChunk, pdfFont, fontSize, keyword, kmpnext);
                float w = keywordRect.getWidth();
                retval.add(new Rectangle(keywordRect.getX(), keywordRect.getY(), -w, keywordRect.getHeight()));
            } else if (Math.abs(orientationVector.get(0) + 1.0f) < 0.001f) {
                float chunkWidth = lastRectangle.getX() - firstRectangle.getX() + lastRectangle.getWidth();
                float fontSize = descentLine.getStartPoint().get(1) - ascentLine.getStartPoint().get(1);
                Rectangle keywordRect = this.getKeywordRect(180, chunkWidth, firstChunk, lastChunk, pdfFont, fontSize, keyword, kmpnext);
                float w = keywordRect.getWidth();
                float h = keywordRect.getHeight();
                retval.add(new Rectangle(keywordRect.getX(), keywordRect.getY(), -w, -h));
            } else if (Math.abs(orientationVector.get(1) + 1.0f) < 0.001f) {
                float chunkHeight = firstRectangle.getY() - lastRectangle.getY() + firstRectangle.getHeight();
                float fontSize = ascentLine.getStartPoint().get(0) - descentLine.getStartPoint().get(0);
                Rectangle keywordRect = this.getKeywordRect(270, chunkHeight, firstChunk, lastChunk, pdfFont, fontSize, keyword, kmpnext);
                float w = keywordRect.getWidth();
                retval.add(new Rectangle(keywordRect.getX(), keywordRect.getY(), w, -keywordRect.getHeight()));
            }
        } else {
            LineSegment ascentLine = firstChunk.getAscentLine();
            LineSegment descentLine = firstChunk.getDescentLine();
            TextChunkLocationDefaultImp textChunkLocation = (TextChunkLocationDefaultImp)firstChunk.getLocation();
            Vector orientationVector = textChunkLocation.getOrientationVector();
            if (Math.abs(orientationVector.get(0) - 1.0f) < 0.001f) {
                float h = ascentLine.getStartPoint().get(1) - descentLine.getStartPoint().get(1);
                this.getKeywordRect(0, retval, firstChunk, h, keyword, kmpnext, ignoreCharNumSpace, ignoreSpace);
            } else if (Math.abs(orientationVector.get(1) - 1.0f) < 0.001f) {
                float h = descentLine.getStartPoint().get(0) - ascentLine.getStartPoint().get(0);
                this.getKeywordRect(90, retval, firstChunk, h, keyword, kmpnext, ignoreCharNumSpace, ignoreSpace);
            } else if (Math.abs(orientationVector.get(0) + 1.0f) < 0.001f) {
                float h = descentLine.getStartPoint().get(1) - ascentLine.getStartPoint().get(1);
                this.getKeywordRect(180, retval, firstChunk, h, keyword, kmpnext, ignoreCharNumSpace, ignoreSpace);
            } else if (Math.abs(orientationVector.get(1) + 1.0f) < 0.001f) {
                float h = ascentLine.getStartPoint().get(0) - descentLine.getStartPoint().get(0);
                this.getKeywordRect(270, retval, firstChunk, h, keyword, kmpnext, ignoreCharNumSpace, ignoreSpace);
            }
        }
        return retval;
    }

    private Rectangle getKeywordRect(int rotation, float chunkWidth, TextChunk firstChunk, TextChunk lastChunk, PdfFont pdfFont, float fontSize, String keyword, int[] kmpnext) {
        Rectangle firstRectangle = firstChunk.getRectangle();
        Rectangle lastRectangle = lastChunk.getRectangle();
        String firstString = keyword.substring(0, 1);
        String firstChunkText = firstChunk.getText();
        int offsetOfKeywordInFirstChunk = firstChunkText.lastIndexOf(firstString);
        int[] result = new int[2];
        try {
            result = KMPUtil.getEqualsSubString(firstChunkText, keyword, kmpnext);
            offsetOfKeywordInFirstChunk = result[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        float offsetPoundsFirst = 0.0f;
        if (offsetOfKeywordInFirstChunk != -1) {
            float boundaryWidth;
            String stringBeforeKeyword = firstChunkText.substring(0, offsetOfKeywordInFirstChunk);
            offsetPoundsFirst = pdfFont.getWidth(stringBeforeKeyword, fontSize);
            float totalWidth = pdfFont.getWidth(firstChunkText, fontSize);
            if (totalWidth > (boundaryWidth = firstChunk.getRectangle().getWidth())) {
                offsetPoundsFirst = offsetPoundsFirst * boundaryWidth / totalWidth;
            }
        }
        int offsetOfKeywordInLastChunk = -1;
        String lastChunkText = lastChunk.getText();
        if (!firstRectangle.equalsWithEpsilon(lastRectangle)) {
            String lastString = keyword.substring(kmpnext.length - 1);
            offsetOfKeywordInLastChunk = lastChunkText.indexOf(lastString);
        }
        float offsetPoundsLast = 0.0f;
        if (offsetOfKeywordInLastChunk != -1) {
            float boundaryWidth;
            String stringAfterKeyword = lastChunkText.substring(offsetOfKeywordInLastChunk + 1);
            offsetPoundsLast = pdfFont.getWidth(stringAfterKeyword, fontSize);
            float totalWidth = pdfFont.getWidth(lastChunkText, fontSize);
            if (totalWidth > (boundaryWidth = lastChunk.getRectangle().getWidth())) {
                offsetPoundsLast = offsetPoundsLast * boundaryWidth / totalWidth;
            }
        }
        offsetPoundsFirst = (int)(offsetPoundsFirst + 0.5f);
        offsetPoundsLast = (int)(offsetPoundsLast + 0.5f);
        chunkWidth = lastRectangle.getX() - firstRectangle.getX() > 2.0f ? lastRectangle.getX() - firstRectangle.getX() + lastRectangle.getWidth() : Math.abs(lastRectangle.getY() - firstRectangle.getY()) + lastRectangle.getWidth();
        float x = firstRectangle.getX() + offsetPoundsFirst;
        float y = firstRectangle.getY();
        float w = Math.abs(chunkWidth) - offsetPoundsFirst - offsetPoundsLast;
        float h = firstRectangle.getHeight();
        if (rotation == 90) {
            w = Math.abs(firstRectangle.getHeight());
            h = Math.abs(chunkWidth - offsetPoundsFirst - offsetPoundsLast);
        } else if (rotation == 180) {
            x = firstRectangle.getX() - offsetPoundsFirst;
        } else if (rotation == 270) {
            w = Math.abs(firstRectangle.getHeight());
            h = Math.abs(chunkWidth - offsetPoundsFirst - offsetPoundsLast);
        }
        return new Rectangle(x, y, w, h);
    }

    private void getKeywordRect(int rotation, List<Rectangle> retval, TextChunk firstChunk, float fontSize, String keyword, int[] kmpnext, boolean ignoreCharNumSpace, boolean ignoreSpace) {
        String originFirstChunkText;
        float offsetPounds = 0.0f;
        boolean flag = true;
        int offsetStartIndex = 0;
        Rectangle firstRectangle = firstChunk.getRectangle();
        PdfFont pdfFont = firstChunk.getPdfFont();
        String firstChunkText = originFirstChunkText = firstChunk.getText();
        while (flag) {
            if (!firstChunkText.equals("")) {
                KeywordPosition keywordPosition = null;
                keywordPosition = ignoreSpace ? KMPUtil.getFirstPosition(firstChunkText, keyword, kmpnext, ignoreCharNumSpace) : KMPUtil.getFirstPosition(firstChunkText, keyword, kmpnext);
                if (keywordPosition != null) {
                    int chunkTextLength;
                    int nextTextIndex;
                    float y;
                    float x;
                    int startIndex = keywordPosition.getStartIndex();
                    int endIndex = keywordPosition.getEndIndex();
                    String stringBeforeKeyword = originFirstChunkText.substring(0, startIndex + offsetStartIndex);
                    offsetPounds = pdfFont.getWidth(stringBeforeKeyword, fontSize);
                    offsetPounds = (int)(offsetPounds + 0.5f);
                    String realKeyword = firstChunkText.substring(startIndex, endIndex + 1);
                    float w = pdfFont.getWidth(realKeyword, fontSize);
                    if (rotation == 90) {
                        x = firstRectangle.getX();
                        y = firstRectangle.getY() + offsetPounds;
                        retval.add(new Rectangle(x, y, -fontSize, w));
                    } else if (rotation == 180) {
                        x = firstRectangle.getX() - offsetPounds;
                        y = firstRectangle.getY();
                        retval.add(new Rectangle(x, y, -w, -fontSize));
                    } else if (rotation == 270) {
                        x = firstRectangle.getX();
                        y = firstRectangle.getY() - offsetPounds;
                        retval.add(new Rectangle(x, y, fontSize, -w));
                    } else {
                        x = firstRectangle.getX() + offsetPounds;
                        y = firstRectangle.getY();
                        retval.add(new Rectangle(x, y, w, fontSize));
                    }
                    offsetStartIndex = endIndex + offsetStartIndex + 1;
                    if (offsetStartIndex > originFirstChunkText.length()) {
                        offsetStartIndex = originFirstChunkText.length();
                    }
                    firstChunkText = firstChunkText.substring((nextTextIndex = endIndex + 1) > (chunkTextLength = firstChunkText.length()) ? chunkTextLength : nextTextIndex);
                    continue;
                }
                flag = false;
                continue;
            }
            flag = false;
        }
    }

    private boolean isSameLine(TextChunk firstChunk, TextChunk secondChunk) {
        boolean sameLine = firstChunk.sameLine(secondChunk);
        return sameLine;
    }
}

