/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.keyword;

import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.geom.LineSegment;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.keyword.ITextChunkLocation;

public class TextChunk
implements Comparable<TextChunk> {
    protected final String text;
    protected final ITextChunkLocation location;
    protected LineSegment baseLine;
    protected LineSegment ascentLine;
    protected LineSegment descentLine;
    protected PdfFont pdfFont;

    public TextChunk(String string, ITextChunkLocation loc) {
        this.text = string;
        this.location = loc;
    }

    public TextChunk(String string, ITextChunkLocation loc, LineSegment baseLine, LineSegment ascentLine, LineSegment descentLine) {
        this.text = string;
        this.location = loc;
        this.baseLine = baseLine;
        this.ascentLine = ascentLine;
        this.descentLine = descentLine;
    }

    public TextChunk(String string, ITextChunkLocation loc, PdfFont pdfFont, LineSegment baseLine, LineSegment ascentLine, LineSegment descentLine) {
        this.text = string;
        this.location = loc;
        this.pdfFont = pdfFont;
        this.baseLine = baseLine;
        this.ascentLine = ascentLine;
        this.descentLine = descentLine;
    }

    public String getText() {
        return this.text;
    }

    public PdfFont getPdfFont() {
        return this.pdfFont;
    }

    public LineSegment getBaseLine() {
        return this.baseLine;
    }

    public LineSegment getAscentLine() {
        return this.ascentLine;
    }

    public LineSegment getDescentLine() {
        return this.descentLine;
    }

    public ITextChunkLocation getLocation() {
        return this.location;
    }

    public Rectangle getRectangle() {
        float x0 = this.descentLine.getStartPoint().get(0);
        float y0 = this.descentLine.getStartPoint().get(1);
        float h = this.ascentLine.getStartPoint().get(1) - this.descentLine.getStartPoint().get(1);
        float w = Math.abs(this.descentLine.getStartPoint().get(0) - this.descentLine.getEndPoint().get(0));
        if (w == 0.0f) {
            w = h;
        }
        if (w == 0.0f && h == 0.0f) {
            h = this.ascentLine.getStartPoint().get(0) - this.descentLine.getStartPoint().get(0);
            w = Math.abs(this.descentLine.getStartPoint().get(1) - this.descentLine.getEndPoint().get(1));
        }
        Rectangle chunkRectangle = new Rectangle(x0, y0, w, h);
        return chunkRectangle;
    }

    @Override
    public int compareTo(TextChunk rhs) {
        return this.location.compareTo(rhs.location);
    }

    public void printDiagnostics() {
        System.out.println("Text (@" + this.location.getStartLocation() + " -> " + this.location.getEndLocation() + "): " + this.text);
        System.out.println("orientationMagnitude: " + this.location.orientationMagnitude());
        System.out.println("distPerpendicular: " + this.location.distPerpendicular());
        System.out.println("distParallel: " + this.location.distParallelStart());
    }

    public boolean sameLine(TextChunk lastChunk) {
        return this.getLocation().sameLine(lastChunk.getLocation());
    }
}

