/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.styledxmlparser.jsoup.nodes;

import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.helper.KeyVal;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.nodes.Attributes;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.nodes.Element;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.parser.Tag;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.select.Elements;
import java.util.ArrayList;
import java.util.List;

public class FormElement
extends Element {
    private final Elements elements = new Elements();

    public FormElement(Tag tag, String baseUri, Attributes attributes) {
        super(tag, baseUri, attributes);
    }

    public Elements elements() {
        return this.elements;
    }

    public FormElement addElement(Element element) {
        this.elements.add(element);
        return this;
    }

    public List<KeyVal> formData() {
        ArrayList<KeyVal> data = new ArrayList<KeyVal>();
        for (Element el : this.elements) {
            String name;
            if (!el.tag().isFormSubmittable() || el.hasAttr("disabled") || (name = el.attr("name")).length() == 0) continue;
            String type = el.attr("type");
            if ("select".equals(el.tagName())) {
                Element option;
                Elements options = el.select("option[selected]");
                boolean set = false;
                for (Element option2 : options) {
                    data.add(KeyVal.create(name, option2.val()));
                    set = true;
                }
                if (set || (option = el.select("option").first()) == null) continue;
                data.add(KeyVal.create(name, option.val()));
                continue;
            }
            if ("checkbox".equalsIgnoreCase(type) || "radio".equalsIgnoreCase(type)) {
                if (!el.hasAttr("checked")) continue;
                String val = el.val().length() > 0 ? el.val() : "on";
                data.add(KeyVal.create(name, val));
                continue;
            }
            data.add(KeyVal.create(name, el.val()));
        }
        return data;
    }
}

