/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.bean.appearance;

import cfca.sadk.com.itextpdf.io.image.ImageData;
import cfca.sadk.com.itextpdf.io.image.ImageDataFactory;
import cfca.sadk.com.itextpdf.layout.property.TextAlignment;
import cfca.sadk.com.itextpdf.layout.property.VerticalAlignment;
import cfca.sadk.seal.base.bean.appearance.TextAppearance;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.system.SADKDebugger;

public class BlankAppearance
extends TextAppearance {
    private byte[] stamperSr;
    private int imageScale = 0;
    private int signType = -1;
    private float textRectHeight;
    private float textRectHeightPercent;
    private float imageRectHeight;
    private TextAlignment alignmentH = TextAlignment.CENTER;
    private VerticalAlignment alignmentV = VerticalAlignment.MIDDLE;
    private VerticalAlignment graphicAlignmentV = VerticalAlignment.MIDDLE;
    private boolean changeImageHeight = true;
    private boolean reverseRectangle = false;
    private ImageData imageData;

    @Override
    public byte[] getStamperSr() {
        return this.stamperSr;
    }

    public void setStamperSr(byte[] stamperSr) throws SealException {
        this.stamperSr = stamperSr;
        if (null != stamperSr && this.signType == 3) {
            boolean isSupportImageType = ImageDataFactory.isSupportedType(stamperSr);
            if (isSupportImageType) {
                this.imageData = ImageDataFactory.create(stamperSr);
            } else {
                throw new SealException("imageType is not support!");
            }
        }
    }

    public int getImageScale() {
        return this.imageScale;
    }

    public float getTextRectHeight() {
        return this.textRectHeight;
    }

    public void setTextRectHeight(float textRectHeight) {
        this.textRectHeight = textRectHeight;
    }

    public void setTextRectHeightPercent(float textRectHeightPercent) throws SealException {
        if (textRectHeightPercent <= 0.0f || textRectHeightPercent > 1.0f) {
            throw new SealException("The value of textRectHeightPercent must be greater than 0 and less than or equal to 1 ");
        }
        this.textRectHeightPercent = textRectHeightPercent;
    }

    public float getTextRectHeightPercent() {
        return this.textRectHeightPercent;
    }

    public float getImageRectHeight() {
        return this.imageRectHeight;
    }

    public void setImageRectHeight(float imageRectHeight) {
        this.imageRectHeight = imageRectHeight;
    }

    public void setImageScale(int imageScale) {
        this.imageScale = imageScale;
    }

    @Override
    public TextAlignment getAlignmentH() {
        return this.alignmentH;
    }

    @Override
    public void setAlignmentH(TextAlignment alignmentH) {
        this.alignmentH = alignmentH;
    }

    @Override
    public VerticalAlignment getAlignmentV() {
        return this.alignmentV;
    }

    @Override
    public void setAlignmentV(VerticalAlignment alignmentV) {
        this.alignmentV = alignmentV;
    }

    public VerticalAlignment getGraphicAlignmentV() {
        return this.graphicAlignmentV;
    }

    public void setGraphicAlignmentV(VerticalAlignment graphicAlignmentV) {
        this.graphicAlignmentV = graphicAlignmentV;
    }

    public boolean isChangeImageHeight() {
        return this.changeImageHeight;
    }

    public void setChangeImageHeight(boolean changeImageHeight) {
        this.changeImageHeight = changeImageHeight;
    }

    public boolean isReverseRectangle() {
        return this.reverseRectangle;
    }

    public void setReverseRectangle(boolean reverseRectangle) {
        this.reverseRectangle = reverseRectangle;
    }

    public int getSignType() {
        return this.signType;
    }

    public void setSignType(int signType) {
        this.signType = signType;
    }

    public ImageData getImageData() {
        return this.imageData;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("BlankAppearance>>>>>>Running");
        buffer.append("\n stamperSr: ");
        buffer.append(SADKDebugger.dump((byte[])this.stamperSr));
        return buffer.toString() + "\n" + super.toString();
    }
}

