/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCS7SignedData;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.com.itextpdf.io.source.RASInputStream;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.signatures.ITSAClient;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.seal.base.bean.sign.SignInfoConfig;
import cfca.sadk.seal.base.config.SysEnv;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.external.AbstractExternalP7Signer;
import cfca.sadk.seal.base.util.Constants;
import cfca.sadk.seal.base.util.ParamsCheckUtil;
import cfca.sadk.seal.base.util.PdfHashUtil;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Arrays;

public class AsynCFCASigner
extends AbstractExternalP7Signer {
    private static Logger businessLog = LoggerFactory.getLogger(AsynCFCASigner.class);
    private byte[] p1Sig;
    private int estimatedSize;
    private Session session;
    protected Mechanism mechanism;
    protected X509Cert[] signCerts;
    protected X509Cert signCert;
    protected boolean isContainChain;
    private ITSAClient tsaClient;
    private byte[] pkcs7Data;
    private boolean isSecondHash;
    private byte[] originHash;

    public AsynCFCASigner(SignInfoConfig signatureConfig, byte[] p1Sig) throws SealException {
        this.p1Sig = null;
        this.estimatedSize = 8192;
        this.session = null;
        this.mechanism = null;
        this.signCert = null;
        this.isContainChain = false;
        this.tsaClient = null;
        this.pkcs7Data = null;
        this.isSecondHash = false;
        this.originHash = null;
        if (p1Sig == null || p1Sig.length == 0) {
            throw new SealException("AsynCFCASigner externalPKCS1 is null");
        }
        this.mechanism = signatureConfig.getSignAlg();
        this.signInfoConfig = signatureConfig;
        this.estimatedSize = signatureConfig.getPKCS7SigEstimatedSize();
        this.session = this.getSession(signatureConfig.getSession());
        this.tsaClient = signatureConfig.getTsaClient();
        this.signCerts = signatureConfig.getCerts();
        ParamsCheckUtil.checkCertValidity(this.signCerts[0]);
        this.signCert = signatureConfig.getSignCert();
        this.isContainChain = signatureConfig.isP7ContainChain();
        this.p1Sig = Mechanisms.isSM2WithSM3((Mechanism)this.mechanism) ? this.GetP1SignatureValue(p1Sig) : p1Sig;
        this.isSecondHash = signatureConfig.isSecondHash();
        this.originHash = signatureConfig.getOriginHash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsynCFCASigner(byte[] p7Sig, Mechanism mechanism) throws SealException {
        block7: {
            this.p1Sig = null;
            this.estimatedSize = 8192;
            this.session = null;
            this.mechanism = null;
            this.signCert = null;
            this.isContainChain = false;
            this.tsaClient = null;
            this.pkcs7Data = null;
            this.isSecondHash = false;
            this.originHash = null;
            if (p7Sig == null || p7Sig.length == 0) {
                throw new SealException("AsynCFCASigner externalPKCS7 is null");
            }
            boolean isDer = false;
            try {
                if (ASN1Parser.isDERSequence((byte[])p7Sig)) {
                    isDer = true;
                }
            }
            catch (PKIException e) {
                businessLog.error("AsynCFCASigner construct failed", (Throwable)e);
            }
            finally {
                if (isDer) break block7;
                throw new SealException("p7Sig encoding required DERSequence");
            }
        }
        this.pkcs7Data = p7Sig;
        this.mechanism = mechanism;
    }

    @Override
    public byte[] sign(InputStream paramInputStream) throws GeneralSecurityException {
        byte[] signedData = null;
        try {
            if (this.p1Sig != null) {
                X509Cert[] tmpSignCerts = this.signCerts;
                if (!this.isContainChain) {
                    tmpSignCerts = new X509Cert[]{this.signCerts[0]};
                }
                byte[] timeStampPKCS7 = this.getTimeStamp(this.tsaClient, this.SM2RStoASN1(this.p1Sig));
                if (this.tsaClient != null) {
                    ParamsCheckUtil.checkTimestampValidity(this.tsaClient.getSignTime(), this.signCerts[0]);
                }
                if (this.isSecondHash) {
                    byte[] hash;
                    if (Mechanisms.isSM2WithSM3((Mechanism)this.mechanism)) {
                        SM2PublicKey sm2PublicKey = (SM2PublicKey)this.signCert.getPublicKey();
                        if (sm2PublicKey == null) {
                            throw new GeneralSecurityException("sm2PublicKey is null");
                        }
                        hash = PdfHashUtil.calculateHashOfSourceData((RASInputStream)paramInputStream, this.mechanism, null);
                    } else {
                        hash = PdfHashUtil.calculateHashOfSourceData((RASInputStream)paramInputStream, Mechanisms.M_SHA1_RSA, null);
                    }
                    if (!Arrays.equals(hash, this.originHash)) {
                        throw new PKIException("hash value is not equal!");
                    }
                }
                signedData = this.packagePKCS7(this.session, null, this.p1Sig, this.mechanism, timeStampPKCS7, null, tmpSignCerts, this.originHash);
            } else {
                PKCS7SignedData p7Data = new PKCS7SignedData(this.session);
                p7Data.loadBase64(this.pkcs7Data);
                ParamsCheckUtil.checkCertValidity(p7Data.getSignerX509Cert());
                if (this.isSecondHash) {
                    if (p7Data.getSourceData() == null) {
                        throw new SealException("the signature is P7 Attach type,but the sourceData is null!");
                    }
                } else if (p7Data.getSignedData().getContentInfo().getContent() != null) {
                    throw new SealException("the signature is P7 Attach type,but the flag is not secondHash!");
                }
                this.p1Sig = p7Data.getSignature();
                if (this.tsaClient != null) {
                    ParamsCheckUtil.checkTimestampValidity(this.tsaClient.getSignTime(), p7Data.getSignerX509Cert());
                    byte[] timeStampPKCS7 = this.getTimeStamp(this.tsaClient, this.SM2RStoASN1(this.p1Sig));
                    signedData = this.rebuildPKCS7(this.session, this.pkcs7Data, null, this.mechanism, timeStampPKCS7, null, null);
                } else {
                    signedData = this.pkcs7Data;
                }
            }
            this.estimatedSize = signedData.length;
            return signedData;
        }
        catch (SealException e) {
            businessLog.error("sign error:", (Throwable)e);
            throw new GeneralSecurityException(e.getMessage(), e);
        }
        catch (PKIException e) {
            businessLog.error("sign error:", (Throwable)e);
            throw new GeneralSecurityException(e.getMessage(), e);
        }
        catch (Exception e) {
            businessLog.error("sign error:", (Throwable)e);
            throw new GeneralSecurityException("AsynCFCASigner sign error:", e);
        }
    }

    @Override
    public void modifySigningDictionary(PdfDictionary signDic) {
        signDic.put(PdfName.Filter, PdfName.Adobe_PPKLite);
        if (Mechanisms.isSM2WithSM3((Mechanism)this.mechanism)) {
            signDic.put(PdfName.Filter, Constants.OLD_SM2_FILTER);
            if (this.isSecondHash) {
                signDic.put(PdfName.SubFilter, SysEnv.isUseCFCASubFilter() ? Constants.CFCA_SM2_ATTACH_FILTER : Constants.SM2_ATTACH_FILTER);
            } else {
                signDic.put(PdfName.SubFilter, SysEnv.isUseCFCASubFilter() ? Constants.CFCA_SM2_FILTER : Constants.SM2_FILTER);
            }
        } else if (this.isSecondHash && Mechanisms.M_SHA1_RSA.equals((Object)this.mechanism)) {
            signDic.put(PdfName.SubFilter, PdfName.Adbe_pkcs7_sha1);
        } else {
            signDic.put(PdfName.SubFilter, PdfName.Adbe_pkcs7_detached);
        }
    }

    @Override
    public int getEstimatedSize() {
        return this.estimatedSize + 64;
    }

    @Override
    public void setTsaClient(ITSAClient tsaClient) {
        this.tsaClient = tsaClient;
    }

    public void setMechanism(Mechanism mechanism) {
        this.mechanism = mechanism;
    }

    public byte[] getOriginHash() {
        return this.originHash;
    }

    @Override
    public void setOriginHash(byte[] originHash) {
        this.originHash = originHash;
    }

    public void setSecondHash(boolean isSecondHash) {
        this.isSecondHash = isSecondHash;
    }
}

