/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.seal.base.config.SysEnv;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.MethodCostTimeUtil;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.sadk.x509.certificate.X509CertVerifier;

public class CertVerifyUtil {
    private static final Logger logger = LoggerFactory.getLogger(CertVerifyUtil.class);

    public static boolean verifyCertSign(X509Cert x509Cert) throws SealException {
        String methodName = "verifyCertSign";
        MethodCostTimeUtil.recordStartTime(methodName);
        boolean verifyResult = true;
        if (null == x509Cert) {
            throw new IllegalArgumentException("x509Cert is null!");
        }
        if (SysEnv.isTrustCertLoaded()) {
            try {
                verifyResult = X509CertVerifier.validateCertSign((X509Cert)x509Cert);
            }
            catch (PKIException e) {
                throw new SealException(e.getMessage() + ":" + x509Cert.getSubject());
            }
        }
        MethodCostTimeUtil.recordEndTime(methodName);
        return verifyResult;
    }
}

