/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import cfca.sadk.com.itextpdf.kernel.geom.PageSize;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfPage;
import cfca.sadk.seal.base.exception.SealException;

public class CoordinateUtil {
    public static Rectangle convert(PageSize pagesize, Rectangle rect) throws SealException {
        if (null == rect) {
            throw new SealException("Rectangle is null!");
        }
        float x = rect.getX();
        float y = rect.getY();
        float width = rect.getWidth();
        float height = rect.getHeight();
        float pageHeight = pagesize.getHeight();
        float newY = pageHeight - y - height;
        Rectangle newRect = new Rectangle(x, newY, width, height);
        return newRect;
    }

    public static Rectangle getKeywordRect(Rectangle rect, Rectangle externalRect, float offsetX, float offsetY) {
        float externalWidth = externalRect.getWidth();
        float externalHeight = externalRect.getHeight();
        float x = rect.getX() - externalWidth / 2.0f + rect.getWidth() / 2.0f + offsetX;
        float y = rect.getY() + rect.getHeight() / 2.0f - externalHeight / 2.0f + offsetY;
        return new Rectangle(x, y, externalWidth, externalHeight);
    }

    public static Rectangle getKeywordRect(Rectangle rect, Rectangle externalRect, float offsetX, float offsetY, int style) {
        float externalWidth = externalRect.getWidth();
        float externalHeight = externalRect.getHeight();
        float x = 0.0f;
        float y = 0.0f;
        if (style == 2) {
            x = rect.getX() - externalWidth + offsetX;
            y = rect.getY() + rect.getHeight() / 2.0f - externalHeight / 2.0f + offsetY;
        } else if (style == 3) {
            x = rect.getX() + rect.getWidth() + offsetX;
            y = rect.getY() + rect.getHeight() / 2.0f - externalHeight / 2.0f + offsetY;
        } else if (style == 4) {
            x = rect.getX() - externalWidth / 2.0f + rect.getWidth() / 2.0f + offsetX;
            y = rect.getY() + rect.getHeight() + offsetY;
        } else if (style == 5) {
            x = rect.getX() - externalWidth / 2.0f + rect.getWidth() / 2.0f + offsetX;
            y = rect.getY() - externalHeight + offsetY;
        } else {
            x = rect.getX() - externalWidth / 2.0f + rect.getWidth() / 2.0f + offsetX;
            y = rect.getY() + rect.getHeight() / 2.0f - externalHeight / 2.0f + offsetY;
        }
        return new Rectangle(x, y, externalWidth, externalHeight);
    }

    public static Rectangle rectangleFromViewToDocument(PdfPage pdfPage, Rectangle rectView) {
        Rectangle pageRect0;
        int rotation = pdfPage.getRotation();
        Rectangle pageSize = pdfPage.getPageSize();
        Rectangle pageRect = pageRect0 = rectView;
        if (90 == (rotation %= 360)) {
            float x0 = pageSize.getWidth() - pageRect0.getHeight() - pageRect0.getY();
            float y0 = pageRect0.getX();
            float width0 = pageRect0.getHeight();
            float height0 = pageRect0.getWidth();
            pageRect = new Rectangle(x0, y0, width0, height0);
        } else if (180 == rotation) {
            float x0 = pageSize.getWidth() - pageRect0.getX() - pageRect0.getWidth();
            float y0 = pageSize.getHeight() - pageRect0.getY() - pageRect0.getHeight();
            float width0 = pageRect0.getWidth();
            float height0 = pageRect0.getHeight();
            pageRect = new Rectangle(x0, y0, width0, height0);
        } else if (270 == rotation) {
            float x0 = pageRect0.getBottom();
            float y0 = pageSize.getHeight() - pageRect0.getLeft() - pageRect0.getWidth();
            float width0 = pageRect0.getHeight();
            float height0 = pageRect0.getWidth();
            pageRect = new Rectangle(x0, y0, width0, height0);
        }
        return pageRect;
    }

    public static Rectangle rectangleToTransformedCoordinate(PdfPage pdfPage, Rectangle untransformedRect) {
        Rectangle pageRect0;
        int rotation = pdfPage.getRotation();
        Rectangle pageSize = pdfPage.getPageSize();
        Rectangle transformedRect = pageRect0 = untransformedRect;
        if (90 == (rotation %= 360)) {
            float x0 = pageSize.getWidth() - pageRect0.getHeight() - pageRect0.getY();
            float y0 = pageRect0.getX();
            float width0 = pageRect0.getHeight();
            float height0 = pageRect0.getWidth();
            transformedRect = new Rectangle(x0, y0, width0, height0);
        } else if (180 == rotation) {
            float x0 = pageSize.getWidth() - pageRect0.getX() - pageRect0.getWidth();
            float y0 = pageSize.getHeight() - pageRect0.getY() - pageRect0.getHeight();
            float width0 = pageRect0.getWidth();
            float height0 = pageRect0.getHeight();
            transformedRect = new Rectangle(x0, y0, width0, height0);
        } else if (270 == rotation) {
            float x0 = pageRect0.getBottom();
            float y0 = pageSize.getHeight() - pageRect0.getLeft() - pageRect0.getWidth();
            float width0 = pageRect0.getHeight();
            float height0 = pageRect0.getWidth();
            transformedRect = new Rectangle(x0, y0, width0, height0);
        }
        return transformedRect;
    }

    public static Rectangle rectangleToUntransformedCoordinate(PdfPage pdfPage, Rectangle transformedRect) {
        PdfPage page = pdfPage;
        int rotation = page.getRotation();
        Rectangle pageSizeRect = page.getPageSizeWithRotation();
        Rectangle untransformedRect = new Rectangle(transformedRect);
        if (90 == rotation) {
            float x = transformedRect.getY();
            float y = pageSizeRect.getWidth() - transformedRect.getX() - transformedRect.getWidth();
            float width = transformedRect.getHeight();
            float height = transformedRect.getWidth();
            untransformedRect = new Rectangle(x, y, width, height);
        } else if (180 == rotation) {
            float x = pageSizeRect.getWidth() - transformedRect.getX() - transformedRect.getWidth();
            float y = pageSizeRect.getHeight() - transformedRect.getHeight() - transformedRect.getHeight();
            float width = transformedRect.getWidth();
            float height = transformedRect.getHeight();
            untransformedRect = new Rectangle(x, y, width, height);
        } else if (270 == rotation) {
            float x = pageSizeRect.getWidth() - transformedRect.getY() - transformedRect.getHeight();
            float y = transformedRect.getX();
            float width = transformedRect.getHeight();
            float height = transformedRect.getWidth();
            untransformedRect = new Rectangle(x, y, width, height);
        }
        return untransformedRect;
    }
}

