/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfPage;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.PdfKeywordCanvasProcessor;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.SimpleTextExtractionStrategy;
import cfca.sadk.seal.base.exception.SealException;
import java.io.IOException;
import java.io.InputStream;

public class ExtractionUtil {
    private static Logger businessLog = LoggerFactory.getLogger(ExtractionUtil.class);

    public static String simpleTextExtraction(InputStream inputStream, String preFix, String postFix) throws SealException {
        businessLog.info("simpleTextExtraction begin...");
        PdfDocument pdfDocument = null;
        try {
            PdfPage page;
            StringBuilder resultText = new StringBuilder();
            PdfReader reader = new PdfReader(inputStream);
            pdfDocument = new PdfDocument(reader);
            SimpleTextExtractionStrategy strategy = new SimpleTextExtractionStrategy();
            PdfKeywordCanvasProcessor parser = new PdfKeywordCanvasProcessor(strategy);
            for (int i = pdfDocument.getNumberOfPages(); i > 0 && (page = pdfDocument.getPage(i)) != null; --i) {
                parser.processPageContent(page);
                String onePageText = strategy.getResultantText();
                if (preFix != null && !preFix.isEmpty()) {
                    String keywordText;
                    int postIndex;
                    int index = onePageText.indexOf(preFix);
                    if (index != -1 && postFix != null && !postFix.isEmpty() && (postIndex = (keywordText = onePageText.substring(index + preFix.length())).indexOf(postFix)) != -1) {
                        resultText.append(keywordText.substring(0, postIndex));
                        break;
                    }
                } else {
                    resultText.append(onePageText);
                }
                parser.reset();
            }
            pdfDocument.close();
            String string = resultText.toString();
            return string;
        }
        catch (Exception e) {
            businessLog.error("simpleTextExtraction failed ", (Throwable)e);
            throw new SealException("simpleTextExtraction failed ", e);
        }
        finally {
            if (pdfDocument != null) {
                pdfDocument.close();
            }
            businessLog.info("simpleTextExtraction end...");
        }
    }

    public static String simpleTextExtraction(InputStream inputStream) throws SealException {
        businessLog.info("simpleTextExtraction begin...");
        PdfDocument pdfDocument = null;
        try {
            PdfPage page;
            StringBuilder resultText = new StringBuilder();
            PdfReader reader = new PdfReader(inputStream);
            pdfDocument = new PdfDocument(reader);
            SimpleTextExtractionStrategy strategy = new SimpleTextExtractionStrategy();
            PdfKeywordCanvasProcessor parser = new PdfKeywordCanvasProcessor(strategy);
            for (int i = 1; i <= pdfDocument.getNumberOfPages() && (page = pdfDocument.getPage(i)) != null; ++i) {
                parser.processPageContent(page);
                String onePageText = strategy.getResultantText();
                resultText.append(onePageText);
                parser.reset();
            }
            pdfDocument.close();
            String string = resultText.toString();
            return string;
        }
        catch (Exception e) {
            businessLog.error("simpleTextExtraction failed ", (Throwable)e);
            throw new SealException("simpleTextExtraction failed ", e);
        }
        finally {
            if (pdfDocument != null) {
                pdfDocument.close();
            }
            businessLog.info("simpleTextExtraction end...");
        }
    }

    public static String simpleTextExtraction(InputStream inputStream, int pageNum) throws SealException {
        businessLog.info("simpleTextExtraction begin...");
        PdfDocument pdfDocument = null;
        try {
            StringBuilder resultText = new StringBuilder();
            PdfReader reader = new PdfReader(inputStream);
            pdfDocument = new PdfDocument(reader);
            SimpleTextExtractionStrategy strategy = new SimpleTextExtractionStrategy();
            PdfKeywordCanvasProcessor parser = new PdfKeywordCanvasProcessor(strategy);
            int totalPages = pdfDocument.getNumberOfPages();
            if (pageNum < 1 || pageNum > totalPages) {
                throw new SealException("pageNum must bettwen 1 and " + totalPages + " current page is " + pageNum);
            }
            PdfPage page = pdfDocument.getPage(pageNum);
            if (page != null) {
                parser.processPageContent(page);
                String onePageText = strategy.getResultantText();
                resultText.append(onePageText);
                parser.reset();
            }
            pdfDocument.close();
            String string = resultText.toString();
            return string;
        }
        catch (IOException e) {
            businessLog.error("simpleTextExtraction failed ", (Throwable)e);
            throw new SealException("simpleTextExtraction failed ", e);
        }
        finally {
            if (pdfDocument != null) {
                pdfDocument.close();
            }
            businessLog.info("simpleTextExtraction end...");
        }
    }
}

