/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.google.typography.font.sfntly.Font;
import cfca.sadk.com.google.typography.font.sfntly.FontFactory;
import cfca.sadk.com.google.typography.font.sfntly.Tag;
import cfca.sadk.com.google.typography.font.sfntly.table.core.CMapTable;
import cfca.sadk.com.google.typography.font.tools.sfnttool.GlyphCoverage;
import cfca.sadk.com.google.typography.font.tools.subsetter.RenumberingSubsetter;
import cfca.sadk.com.itextpdf.io.font.FontProgram;
import cfca.sadk.com.itextpdf.io.font.FontProgramFactory;
import cfca.sadk.com.itextpdf.io.source.ByteArrayOutputStream;
import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.font.PdfFontFactory;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.MethodCostTimeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FontUtil {
    private static Logger businessLog = LoggerFactory.getLogger(FontUtil.class);
    private static FontProgram fontProgram = null;
    private static FontFactory fontFactory = FontFactory.getInstance();
    private static Font[] fontArray = null;
    private static Set<Integer> removeTables = new HashSet<Integer>();
    private static List<CMapTable.CMapId> cmapIds = new ArrayList<CMapTable.CMapId>();
    private static FontUtil instance = null;
    private static final float MIN_FONT_SIZE = 1.0f;
    private static final float NEED_CALCULATA = 0.0f;

    public static FontUtil getInstance() throws SealException {
        return FontUtil.getInstance("config/simsun_new.ttf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FontUtil getInstance(String ttfTile) throws SealException {
        if (instance != null) return instance;
        Class<FontUtil> clazz = FontUtil.class;
        synchronized (FontUtil.class) {
            FontUtil temp = instance;
            if (temp != null) return instance;
            FileInputStream fis = null;
            try {
                fontProgram = FontProgramFactory.createFont(ttfTile, true);
                File fontFile = new File(ttfTile);
                fis = new FileInputStream(fontFile);
                byte[] fontBytes = new byte[(int)fontFile.length()];
                fis.read(fontBytes);
                fontArray = fontFactory.loadFonts(fontBytes);
                cmapIds.add(CMapTable.CMapId.WINDOWS_BMP);
                removeTables.add(Tag.BASE);
                removeTables.add(Tag.GDEF);
                removeTables.add(Tag.GPOS);
                removeTables.add(Tag.GSUB);
                removeTables.add(Tag.JSTF);
                removeTables.add(Tag.DSIG);
                removeTables.add(Tag.gasp);
                removeTables.add(Tag.hdmx);
                removeTables.add(Tag.kern);
                removeTables.add(Tag.LTSH);
                removeTables.add(Tag.PCLT);
                removeTables.add(Tag.VDMX);
                removeTables.add(Tag.vhea);
                removeTables.add(Tag.vmtx);
                removeTables.add(Tag.EBLC);
                removeTables.add(Tag.EBDT);
                removeTables.add(Tag.EBSC);
                removeTables.add(Tag.CFF);
                removeTables.add(Tag.VORG);
                removeTables.add(Tag.maxp);
                removeTables.add(Tag.fpgm);
                removeTables.add(Tag.prep);
                removeTables.add(Tag.cvt);
                removeTables.add(Tag.intValue(new byte[]{109, 111, 114, 116}));
                removeTables.add(Tag.intValue(new byte[]{109, 111, 114, 120}));
                instance = temp = new FontUtil();
            }
            catch (FileNotFoundException e) {
                businessLog.error("FileNotFoundException", (Throwable)e);
                throw new SealException("FontUtil getInstance() FileNotFoundException", e);
            }
            catch (IOException e) {
                businessLog.error("IOException", (Throwable)e);
                throw new SealException("FontUtil getInstance() IOException", e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        throw new SealException("FontUtil close() IOException", e);
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public PdfFont subsetFont(String signString) throws SealException {
        PdfFont font = null;
        String methodid = MethodCostTimeUtil.recordStartTime("subsetFont");
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.subsetFontFile(outputStream, signString);
            font = PdfFontFactory.createFont(outputStream.toByteArray(), "Identity-H", false, false);
            outputStream = null;
        }
        catch (IOException e) {
            businessLog.error("subsetFont() IOException", (Throwable)e);
            throw new SealException("subsetFont() IOException", e);
        }
        finally {
            MethodCostTimeUtil.recordEndTime(methodid);
        }
        return font;
    }

    public void subsetFontFile(File outputFile, String subsetString) throws SealException, IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outputFile);
            this.subsetFontFile(fos, subsetString);
        }
        catch (Exception e) {
            throw new SealException("subsetFontFile", e);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public void subsetFontFile(OutputStream outputStream, String subsetString) throws IOException {
        Font newFont = fontArray[0];
        boolean isValidFont = false;
        if (subsetString != null) {
            List<Integer> glyphs = GlyphCoverage.getGlyphCoverage(newFont, subsetString);
            RenumberingSubsetter subsetter = new RenumberingSubsetter(fontArray[0], fontFactory);
            subsetter.setCMaps(cmapIds, 1);
            subsetter.setGlyphs(glyphs);
            subsetter.setRemoveTables(removeTables);
            newFont = subsetter.subset().build();
            isValidFont = true;
        }
        fontFactory.serializeFont(newFont, outputStream);
        if (isValidFont) {
            newFont.clearTableMap();
        }
        newFont = null;
    }

    public PdfFont createPdfFont() throws SealException {
        PdfFont font = null;
        try {
            font = PdfFontFactory.createFont(fontProgram, "Identity-H", false);
        }
        catch (IOException e) {
            throw new SealException("createPdfFont failed", e);
        }
        return font;
    }

    public PdfFont createPdfFont(String baseFontName) throws SealException {
        PdfFont font = null;
        try {
            font = PdfFontFactory.createFont(baseFontName, "Identity-H", false, false);
        }
        catch (IOException e) {
            throw new SealException("load baseFontName failed" + baseFontName, e);
        }
        return font;
    }

    public PdfFont createPdfFont(FontProgram fontProgram) throws SealException {
        PdfFont font = null;
        try {
            font = PdfFontFactory.createFont(fontProgram, "Identity-H", false);
        }
        catch (IOException e) {
            throw new SealException("createPdfFont failed", e);
        }
        return font;
    }

    public float normalizeFontSize(float fs, PdfFont localFont, Rectangle bBox, String value) throws SealException {
        float height = bBox.getHeight() - 4.0f;
        float width = bBox.getWidth() - 4.0f;
        if (fs == 0.0f) {
            int[] fontBbox = localFont.getFontProgram().getFontMetrics().getBbox();
            float baseWidth = localFont.getWidth(value, 1.0f);
            fs = height * 75.0f / (float)(fontBbox[2] - fontBbox[1]) * 1000.0f / 100.0f;
            if (baseWidth != 0.0f) {
                fs = Math.min(fs, width / (float)(fontBbox[2] - fontBbox[1]) * 1000.0f);
                fs = this.getFontSize(fs, baseWidth, width);
            }
        }
        fs = (float)Math.ceil(fs);
        return fs;
    }

    private float getFontSize(float fs, float words, float width) {
        if (fs > 0.1f) {
            if (fs * words > width) {
                fs = fs * 9.0f / 10.0f;
                return this.getFontSize(fs, words, width);
            }
            return fs;
        }
        return 0.1f;
    }

    public static FontProgram getFontProgram() {
        return fontProgram;
    }
}

