/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.google.typography.font.sfntly.Font;
import cfca.sadk.com.google.typography.font.sfntly.FontFactory;
import cfca.sadk.com.google.typography.font.sfntly.Tag;
import cfca.sadk.com.google.typography.font.sfntly.table.core.CMapTable;
import cfca.sadk.com.google.typography.font.tools.sfnttool.GlyphCoverage;
import cfca.sadk.com.google.typography.font.tools.subsetter.RenumberingSubsetter;
import cfca.sadk.com.itextpdf.io.font.FontProgram;
import cfca.sadk.com.itextpdf.io.font.FontProgramFactory;
import cfca.sadk.com.itextpdf.io.source.ByteArrayOutputStream;
import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.font.PdfFontFactory;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.FontUtil;
import cfca.sadk.seal.base.util.MethodCostTimeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UCS4FontUtil {
    private static Logger businessLog = LoggerFactory.getLogger(FontUtil.class);
    private static FontProgram fontProgram = null;
    private static FontFactory fontFactory = FontFactory.getInstance();
    private static Font[] fontArray = null;
    private static Set<Integer> removeTables = new HashSet<Integer>();
    private static List<CMapTable.CMapId> cmapIds = new ArrayList<CMapTable.CMapId>();
    private static UCS4FontUtil instance = null;

    public static UCS4FontUtil getInstance() throws SealException {
        return UCS4FontUtil.getInstance("config/UCS4.ttf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UCS4FontUtil getInstance(String ttfTile) throws SealException {
        if (instance != null) return instance;
        Class<FontUtil> clazz = FontUtil.class;
        synchronized (FontUtil.class) {
            UCS4FontUtil temp = instance;
            if (temp != null) return instance;
            FileInputStream fis = null;
            try {
                fontProgram = FontProgramFactory.createFont(ttfTile, true);
                File fontFile = new File(ttfTile);
                fis = new FileInputStream(fontFile);
                byte[] fontBytes = new byte[(int)fontFile.length()];
                fis.read(fontBytes);
                fontArray = fontFactory.loadFonts(fontBytes);
                cmapIds.add(CMapTable.CMapId.WINDOWS_BMP);
                cmapIds.add(CMapTable.CMapId.WINDOWS_UCS4);
                removeTables.add(Tag.BASE);
                removeTables.add(Tag.GDEF);
                removeTables.add(Tag.GPOS);
                removeTables.add(Tag.GSUB);
                removeTables.add(Tag.JSTF);
                removeTables.add(Tag.DSIG);
                removeTables.add(Tag.gasp);
                removeTables.add(Tag.hdmx);
                removeTables.add(Tag.kern);
                removeTables.add(Tag.LTSH);
                removeTables.add(Tag.PCLT);
                removeTables.add(Tag.VDMX);
                removeTables.add(Tag.vhea);
                removeTables.add(Tag.vmtx);
                removeTables.add(Tag.EBLC);
                removeTables.add(Tag.EBDT);
                removeTables.add(Tag.EBSC);
                removeTables.add(Tag.CFF);
                removeTables.add(Tag.VORG);
                removeTables.add(Tag.maxp);
                removeTables.add(Tag.fpgm);
                removeTables.add(Tag.prep);
                removeTables.add(Tag.cvt);
                removeTables.add(Tag.intValue(new byte[]{109, 111, 114, 116}));
                removeTables.add(Tag.intValue(new byte[]{109, 111, 114, 120}));
                instance = temp = new UCS4FontUtil();
            }
            catch (FileNotFoundException e) {
                businessLog.error("FileNotFoundException", (Throwable)e);
                throw new SealException("FontUtil getInstance() FileNotFoundException", e);
            }
            catch (IOException e) {
                businessLog.error("IOException", (Throwable)e);
                throw new SealException("FontUtil getInstance() IOException", e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        throw new SealException("FontUtil close() IOException", e);
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public PdfFont subsetFont(String signString) throws SealException {
        PdfFont font = null;
        String methodid = MethodCostTimeUtil.recordStartTime("subsetFont");
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.subsetFontFile(outputStream, signString);
            font = PdfFontFactory.createFont(outputStream.toByteArray(), "Identity-H", false, false);
        }
        catch (IOException e) {
            businessLog.error("subsetFont() IOException", (Throwable)e);
            throw new SealException("subsetFont() IOException", e);
        }
        finally {
            MethodCostTimeUtil.recordEndTime(methodid);
        }
        return font;
    }

    public void subsetFontFile(File outputFile, String subsetString) throws SealException, IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outputFile);
            this.subsetFontFile(fos, subsetString);
        }
        catch (Exception e) {
            throw new SealException("subsetFontFile", e);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public void subsetFontFile(OutputStream outputStream, String subsetString) throws IOException {
        Font newFont = fontArray[0];
        boolean isValidFont = false;
        if (subsetString != null) {
            List<Integer> glyphs = GlyphCoverage.getGlyphCoverage(newFont, subsetString);
            RenumberingSubsetter subsetter = new RenumberingSubsetter(fontArray[0], fontFactory);
            subsetter.setCMaps(cmapIds, 2);
            subsetter.setGlyphs(glyphs);
            subsetter.setRemoveTables(removeTables);
            newFont = subsetter.subset().build();
            isValidFont = true;
        }
        fontFactory.serializeFont(newFont, outputStream);
        if (isValidFont) {
            newFont.clearTableMap();
        }
        newFont = null;
    }

    public PdfFont createPdfFont() throws SealException {
        PdfFont font = null;
        try {
            font = PdfFontFactory.createFont(fontProgram, "Identity-H", false);
        }
        catch (IOException e) {
            throw new SealException("createPdfFont failed", e);
        }
        return font;
    }
}

