/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfWriter;
import cfca.sadk.com.itextpdf.kernel.pdf.StampingProperties;
import cfca.sadk.com.itextpdf.kernel.pdf.filespec.PdfFileSpec;
import cfca.sadk.seal.base.bean.annotation.Annotation;
import cfca.sadk.seal.base.bean.annotation.AnnotationList;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.ParamsCheckUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.io.FileUtils;

public class FileAttachmentUtil {
    private static Logger businessLog = LoggerFactory.getLogger(FileAttachmentUtil.class);

    public static void addAttachmentList(byte[] pdfData, OutputStream outputStream, AnnotationList annotationList) throws IOException, SealException {
        if (null == pdfData) {
            throw new SealException("pdfData is null");
        }
        try {
            PdfReader reader = new PdfReader(pdfData);
            FileAttachmentUtil.addAttachmentList(reader, outputStream, annotationList);
        }
        catch (SealException e) {
            businessLog.error("addAttachmentList failed", (Throwable)e);
            throw e;
        }
    }

    public static void addAttachmentList(InputStream inputStream, OutputStream outputStream, AnnotationList annotationList) throws IOException, SealException {
        if (null == inputStream) {
            throw new SealException("inputStream is null");
        }
        try {
            PdfReader reader = new PdfReader(inputStream);
            FileAttachmentUtil.addAttachmentList(reader, outputStream, annotationList);
        }
        catch (SealException e) {
            businessLog.error("addAttachmentList failed", (Throwable)e);
            throw e;
        }
    }

    public static void addAttachmentList(PdfReader reader, OutputStream outputStream, AnnotationList annotationList) throws SealException, IOException {
        PdfDocument pdfDoc = null;
        long start = System.currentTimeMillis();
        if (null == outputStream) {
            throw new SealException("outputStream is null");
        }
        if (null == annotationList || annotationList.size() == 0) {
            throw new SealException("annotationList is null");
        }
        try {
            PdfWriter writer = new PdfWriter(outputStream);
            StampingProperties properties = new StampingProperties();
            pdfDoc = new PdfDocument(reader, writer, properties, true);
            ParamsCheckUtil.checkSignature(pdfDoc);
            for (int i = 0; i < annotationList.size(); ++i) {
                String fileDisplay;
                Annotation annotation = (Annotation)annotationList.get(i);
                String filePath = annotation.getFilePath();
                byte[] fileData = annotation.getFileData();
                if (null == filePath && fileData == null) {
                    businessLog.error("parameter filePath or fileData is required!");
                    throw new SealException("parameter filePath or fileData is required!");
                }
                if (null == fileData) {
                    fileData = FileUtils.readFileToByteArray((File)new File(filePath));
                }
                if (null == (fileDisplay = annotation.getFileDisplay())) {
                    businessLog.error("parameter fileDisplay is required!");
                    throw new SealException("parameter fileDisplay is required!");
                }
                PdfFileSpec spec = PdfFileSpec.createEmbeddedFileSpec(pdfDoc, fileData, "", fileDisplay, null, null, PdfName.AFRelationship, true);
                pdfDoc.addFileAttachment(UUID.randomUUID().toString(), spec);
            }
        }
        catch (SealException e) {
            businessLog.error("addAttachmentList failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("addAttachmentList failed:", (Throwable)e);
            throw new SealException("addAttachmentList failed:", e);
        }
        finally {
            if (null != pdfDoc) {
                pdfDoc.close();
            }
            long end = System.currentTimeMillis();
            businessLog.info("addAttachmentList end...cost=" + (end - start) + "ms");
        }
    }

    public static byte[] getFileAttachment(byte[] pdfData, String attachFileDisplay) throws IOException, SealException {
        long start = System.currentTimeMillis();
        if (null == pdfData) {
            throw new SealException("pdfData is null");
        }
        if (attachFileDisplay == null || attachFileDisplay.length() == 0) {
            throw new SealException("attachFileDisplay is null");
        }
        byte[] attachBytes = null;
        PdfDocument pdfDoc = null;
        try {
            PdfArray pdfArray;
            pdfDoc = new PdfDocument(new PdfReader(pdfData), true);
            PdfDictionary rootDictionary = (PdfDictionary)pdfDoc.getCatalog().getPdfObject();
            PdfDictionary namesDictionary = rootDictionary.getAsDictionary(PdfName.Names);
            PdfDictionary embeddedDictionary = namesDictionary.getAsDictionary(PdfName.EmbeddedFiles);
            if (embeddedDictionary != null && (pdfArray = embeddedDictionary.getAsArray(PdfName.Names)) != null) {
                int size = pdfArray.size();
                for (int i = 0; i < size; ++i) {
                    PdfDictionary valueDictionary;
                    String key;
                    PdfDictionary nameDictionary = pdfArray.getAsDictionary(i);
                    if (nameDictionary == null || !attachFileDisplay.equals(key = nameDictionary.getAsString(PdfName.UF).toUnicodeString()) || (valueDictionary = nameDictionary.getAsDictionary(PdfName.EF)) == null) continue;
                    attachBytes = valueDictionary.getAsStream(PdfName.UF).getBytes();
                }
                pdfDoc.close();
            }
            byte[] byArray = attachBytes;
            return byArray;
        }
        catch (Exception e) {
            businessLog.error("getFileAttachment:", (Throwable)e);
            throw new SealException("getFileAttachment:", e);
        }
        finally {
            if (null != pdfDoc) {
                pdfDoc.close();
            }
            long end = System.currentTimeMillis();
            businessLog.info("getFileAttachment end...cost=" + (end - start) + "ms");
        }
    }

    public static HashMap<String, byte[]> getFileAttachment(byte[] pdfData) throws IOException, SealException {
        if (null == pdfData) {
            throw new SealException("pdfData is null");
        }
        try {
            PdfReader reader = new PdfReader(pdfData);
            return FileAttachmentUtil.getFileAttachment(reader);
        }
        catch (SealException e) {
            businessLog.error("getFileAttachment failed", (Throwable)e);
            throw e;
        }
    }

    public static HashMap<String, byte[]> getFileAttachment(InputStream inputStream) throws IOException, SealException {
        if (null == inputStream) {
            throw new SealException("inputStream is null");
        }
        try {
            PdfReader reader = new PdfReader(inputStream);
            return FileAttachmentUtil.getFileAttachment(reader);
        }
        catch (SealException e) {
            businessLog.error("getFileAttachment failed", (Throwable)e);
            throw e;
        }
    }

    public static HashMap<String, byte[]> getFileAttachment(PdfReader reader) throws IOException, SealException {
        HashMap<String, byte[]> resultMap = new HashMap<String, byte[]>();
        long start = System.currentTimeMillis();
        PdfDocument pdfDoc = null;
        try {
            PdfArray pdfArray;
            pdfDoc = new PdfDocument(reader, true);
            PdfDictionary rootDictionary = (PdfDictionary)pdfDoc.getCatalog().getPdfObject();
            PdfDictionary namesDictionary = rootDictionary.getAsDictionary(PdfName.Names);
            PdfDictionary embeddedDictionary = namesDictionary.getAsDictionary(PdfName.EmbeddedFiles);
            if (embeddedDictionary != null && (pdfArray = embeddedDictionary.getAsArray(PdfName.Names)) != null) {
                int size = pdfArray.size();
                for (int i = 0; i < size; ++i) {
                    byte[] attachBytes = null;
                    PdfDictionary nameDictionary = pdfArray.getAsDictionary(i);
                    if (nameDictionary == null) continue;
                    String key = nameDictionary.getAsString(PdfName.UF).toUnicodeString();
                    PdfDictionary valueDictionary = nameDictionary.getAsDictionary(PdfName.EF);
                    if (valueDictionary != null) {
                        attachBytes = valueDictionary.getAsStream(PdfName.UF).getBytes();
                    }
                    if (key != null && key.trim().equals("")) {
                        key = UUID.randomUUID().toString();
                    }
                    resultMap.put(key, attachBytes);
                }
                pdfDoc.close();
            }
            HashMap<String, byte[]> hashMap = resultMap;
            return hashMap;
        }
        catch (Exception e) {
            businessLog.error("getFileAttachment:", (Throwable)e);
            throw new SealException("getFileAttachment:", e);
        }
        finally {
            if (null != pdfDoc) {
                pdfDoc.close();
            }
            long end = System.currentTimeMillis();
            businessLog.info("getFileAttachment end...cost=" + (end - start) + "ms");
        }
    }
}

