/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.forms.PdfAcroForm;
import cfca.sadk.com.itextpdf.forms.fields.PdfButtonFormField;
import cfca.sadk.com.itextpdf.forms.fields.PdfFormField;
import cfca.sadk.com.itextpdf.forms.fields.PdfSignatureFormField;
import cfca.sadk.com.itextpdf.forms.fields.PdfTextFormField;
import cfca.sadk.com.itextpdf.io.source.ByteArrayOutputStream;
import cfca.sadk.com.itextpdf.kernel.color.Color;
import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfIndirectReference;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNumber;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfPage;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfString;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfWriter;
import cfca.sadk.com.itextpdf.kernel.pdf.StampingProperties;
import cfca.sadk.com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import cfca.sadk.com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import cfca.sadk.com.itextpdf.layout.Document;
import cfca.sadk.com.itextpdf.layout.border.Border;
import cfca.sadk.com.itextpdf.layout.element.Cell;
import cfca.sadk.com.itextpdf.layout.element.Paragraph;
import cfca.sadk.com.itextpdf.layout.element.Table;
import cfca.sadk.com.itextpdf.layout.property.UnitValue;
import cfca.sadk.com.itextpdf.layout.property.VerticalAlignment;
import cfca.sadk.com.itextpdf.signatures.SignatureUtil;
import cfca.sadk.seal.base.bean.form.CheckBoxCellRender;
import cfca.sadk.seal.base.bean.form.FormFieldInfo;
import cfca.sadk.seal.base.bean.form.RadioCellRenderer;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.CoordinateUtil;
import cfca.sadk.seal.base.util.FontUtil;
import cfca.sadk.seal.base.util.FontsFactory;
import cfca.sadk.seal.base.util.MethodCostTimeUtil;
import cfca.sadk.seal.base.util.PDFUtil;
import cfca.sadk.seal.base.util.ParamsCheckUtil;
import cfca.sadk.seal.base.util.StringUtil;
import cfca.sadk.seal.base.util.UCS4FontUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FormFieldUtil {
    private static Logger businessLog = LoggerFactory.getLogger(FormFieldUtil.class);
    public static final String CHECKBOXSTATE_ON = "Yes";
    public static final String CHECKBOXSTATE_OFF = "Off";
    public static final String PAGENUM = "pageNum";
    public static final String RECTANGLE = "rectangle";
    public static final String FIELDNAME = "fieldName";
    public static final String PAGEHEIGHT = "pageHeight";
    public static final String FIELDVALUE = "fieldValue";

    public static byte[] removeAllFields(byte[] pdfData, int fieldType, boolean isThrowException) throws SealException, IOException {
        if (pdfData == null || pdfData.length == 0) {
            throw new SealException("pdfData is null");
        }
        PdfReader pdfReader = new PdfReader(pdfData);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        FormFieldUtil.removeAllFields(pdfReader, (OutputStream)output, fieldType, isThrowException);
        return output.toByteArray();
    }

    public static void removeAllFields(InputStream inputStream, OutputStream outputStream, int fieldType, boolean isThrowException) throws SealException, IOException {
        if (inputStream == null) {
            throw new SealException("inputStream is null");
        }
        if (outputStream == null) {
            throw new SealException("outputStream is null");
        }
        PdfReader pdfReader = new PdfReader(inputStream);
        FormFieldUtil.removeAllFields(pdfReader, outputStream, fieldType, isThrowException);
    }

    private static void removeAllFields(PdfReader pdfReader, OutputStream outputStream, int fieldType, boolean isThrowException) throws SealException {
        PdfDocument pdfDoc = null;
        Document doc = null;
        try {
            int i;
            pdfDoc = new PdfDocument(pdfReader, new PdfWriter(outputStream));
            SignatureUtil sigUtil = new SignatureUtil(pdfDoc);
            List<String> sigNames = sigUtil.getSignatureNames();
            int size = sigNames.size();
            if (size > 0) {
                throw new SealException("document has been signed! can not add field! ");
            }
            doc = new Document(pdfDoc);
            PdfAcroForm form = PdfAcroForm.getAcroForm(pdfDoc, true);
            Map<String, PdfFormField> fieldMap = form.getFormFields();
            Iterator<Map.Entry<String, PdfFormField>> iterator = fieldMap.entrySet().iterator();
            ArrayList<String> fieldNameList = new ArrayList<String>();
            while (iterator.hasNext()) {
                Map.Entry<String, PdfFormField> field = iterator.next();
                String fieldName = field.getKey();
                PdfFormField formField = field.getValue();
                if ((fieldType & 2) == 2 && formField instanceof PdfTextFormField) {
                    fieldNameList.add(fieldName);
                    continue;
                }
                if ((fieldType & 1) == 1 && formField instanceof PdfButtonFormField) {
                    fieldNameList.add(fieldName);
                    continue;
                }
                if ((fieldType & 4) != 4 || !(formField instanceof PdfSignatureFormField)) continue;
                fieldNameList.add(fieldName);
            }
            for (i = 0; i < fieldNameList.size(); ++i) {
                boolean removeState = false;
                String fieldName = (String)fieldNameList.get(i);
                removeState = form.removeField(fieldName);
                if (removeState) {
                    businessLog.info(fieldName + " is removed");
                    continue;
                }
                if (!isThrowException) continue;
                throw new SealException(fieldName + " is not found!");
            }
            for (i = 1; i <= pdfDoc.getNumberOfPages(); ++i) {
                PdfPage page = pdfDoc.getPage(i);
                PdfArray annots = ((PdfDictionary)page.getPdfObject()).getAsArray(PdfName.Annots);
                if (annots != null) {
                    int annotSize = annots.size();
                    for (int j = annotSize - 1; j >= 0; --j) {
                        PdfObject parentFT;
                        PdfDictionary annot = annots.getAsDictionary(j);
                        PdfObject buttonAnnot = annot.get(PdfName.FT);
                        if (buttonAnnot != null) {
                            if ((fieldType & 2) == 2 && buttonAnnot.equals(PdfName.Tx)) {
                                annots.remove(j);
                                continue;
                            }
                            if ((fieldType & 1) == 1 && buttonAnnot.equals(PdfName.Btn)) {
                                annots.remove(j);
                                continue;
                            }
                            if ((fieldType & 4) != 4 || !buttonAnnot.equals(PdfName.Sig)) continue;
                            annots.remove(j);
                            continue;
                        }
                        PdfDictionary parentAnnot = annot.getAsDictionary(PdfName.Parent);
                        if (parentAnnot == null || (parentFT = parentAnnot.get(PdfName.FT)) == null) continue;
                        if ((fieldType & 2) == 2 && parentFT.equals(PdfName.Tx)) {
                            annots.remove(j);
                            continue;
                        }
                        if ((fieldType & 1) == 1 && parentFT.equals(PdfName.Btn)) {
                            annots.remove(j);
                            continue;
                        }
                        if ((fieldType & 4) != 4 || !parentFT.equals(PdfName.Sig)) continue;
                        annots.remove(j);
                    }
                }
                page.setModified();
            }
        }
        catch (SealException e) {
            businessLog.error("removeAllFields failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("removeAllFields failed:", (Throwable)e);
            throw new SealException("removeAllFields failed", e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
            if (doc != null) {
                doc.close();
            }
        }
    }

    public static byte[] removeFields(byte[] pdfData, List<String> fieldNameList, boolean isThrowException) throws SealException, IOException {
        if (pdfData == null || pdfData.length == 0) {
            throw new SealException("pdfData is null");
        }
        PdfReader pdfReader = new PdfReader(pdfData);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        FormFieldUtil.removeFields(pdfReader, (OutputStream)output, fieldNameList, isThrowException);
        return output.toByteArray();
    }

    public static void removeFields(InputStream inputStream, OutputStream outputStream, List<String> fieldNameList, boolean isThrowException) throws SealException, IOException {
        if (inputStream == null) {
            throw new SealException("inputStream is null");
        }
        if (outputStream == null) {
            throw new SealException("outputStream is null");
        }
        if (fieldNameList == null || fieldNameList.isEmpty()) {
            throw new SealException("fieldNameList is null");
        }
        PdfReader pdfReader = new PdfReader(inputStream);
        FormFieldUtil.removeFields(pdfReader, outputStream, fieldNameList, isThrowException);
    }

    private static void removeFields(PdfReader pdfReader, OutputStream outputStream, List<String> fieldNameList, boolean isThrowException) throws SealException {
        PdfDocument pdfDoc = null;
        Document doc = null;
        try {
            String fieldName;
            int k;
            pdfDoc = new PdfDocument(pdfReader, new PdfWriter(outputStream));
            SignatureUtil sigUtil = new SignatureUtil(pdfDoc);
            List<String> sigNames = sigUtil.getSignatureNames();
            int size = sigNames.size();
            if (size > 0) {
                throw new SealException("document has been signed! can not add field! ");
            }
            doc = new Document(pdfDoc);
            PdfAcroForm form = PdfAcroForm.getAcroForm(pdfDoc, true);
            for (k = 0; k < fieldNameList.size(); ++k) {
                fieldName = fieldNameList.get(k);
                boolean removeState = form.removeField(fieldName);
                if (removeState) {
                    businessLog.info(fieldName + " is removed");
                    continue;
                }
                if (!isThrowException) continue;
                throw new SealException(fieldName + " is not found!");
            }
            for (k = 0; k < fieldNameList.size(); ++k) {
                fieldName = fieldNameList.get(k);
                for (int i = 1; i <= pdfDoc.getNumberOfPages(); ++i) {
                    PdfPage page = pdfDoc.getPage(i);
                    PdfArray annots = ((PdfDictionary)page.getPdfObject()).getAsArray(PdfName.Annots);
                    if (annots != null) {
                        int annotSize = annots.size();
                        for (int j = annotSize - 1; j >= 0; --j) {
                            PdfString parentAnnotName;
                            PdfDictionary annot = annots.getAsDictionary(j);
                            PdfString annotName = annot.getAsString(PdfName.T);
                            if (annotName != null) {
                                if (!annotName.getValue().equals(fieldName)) continue;
                                annots.remove(j);
                                continue;
                            }
                            PdfDictionary parentAnnot = annot.getAsDictionary(PdfName.Parent);
                            if (parentAnnot == null || (parentAnnotName = parentAnnot.getAsString(PdfName.T)) == null || !parentAnnotName.getValue().equals(fieldName)) continue;
                            annots.remove(j);
                        }
                    }
                    page.setModified();
                }
            }
        }
        catch (SealException e) {
            businessLog.error("removeFields failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("removeFields failed:", (Throwable)e);
            throw new SealException("removeFields failed", e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
            if (doc != null) {
                doc.close();
            }
        }
    }

    public static byte[] addFieldList(byte[] pdfData, List<FormFieldInfo> formFieldInfoList) throws SealException, IOException {
        if (pdfData == null || pdfData.length == 0) {
            throw new SealException("pdfData is null");
        }
        PdfReader pdfReader = new PdfReader(pdfData);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        FormFieldUtil.addFieldList(pdfReader, (OutputStream)output, formFieldInfoList);
        return output.toByteArray();
    }

    public static void addFieldList(InputStream inputStream, OutputStream outputStream, List<FormFieldInfo> formFieldInfoList) throws SealException, IOException {
        if (inputStream == null) {
            throw new SealException("inputStream is null");
        }
        if (outputStream == null) {
            throw new SealException("outputStream is null");
        }
        if (formFieldInfoList == null || formFieldInfoList.isEmpty()) {
            throw new SealException("formFieldInfoList is null");
        }
        PdfReader pdfReader = new PdfReader(inputStream);
        FormFieldUtil.addFieldList(pdfReader, outputStream, formFieldInfoList);
    }

    private static void addFieldList(PdfReader reader, OutputStream outputStream, List<FormFieldInfo> formFieldInfoList) throws SealException {
        PdfDocument pdfDoc = null;
        Document doc = null;
        try {
            pdfDoc = new PdfDocument(reader, new PdfWriter(outputStream));
            SignatureUtil sigUtil = new SignatureUtil(pdfDoc);
            List<String> sigNames = sigUtil.getSignatureNames();
            int size = sigNames.size();
            if (size > 0) {
                throw new SealException("document has been signed! can not add field! ");
            }
            doc = new Document(pdfDoc);
            PdfAcroForm form = PdfAcroForm.getAcroForm(pdfDoc, true);
            HashSet<String> groupNameSet = new HashSet<String>();
            for (int k = 0; k < formFieldInfoList.size(); ++k) {
                PdfFormField formField;
                Rectangle rect;
                FormFieldInfo formFieldInfo = formFieldInfoList.get(k);
                String fieldType = formFieldInfo.getFieldType();
                if ("TextField".equals(fieldType)) {
                    rect = formFieldInfo.getRect();
                    String fieldName = formFieldInfo.getFieldName();
                    formField = form.getField(fieldName);
                    if (null != formField) {
                        throw new SealException("form \"" + fieldName + "\" has been existed! use different field name.");
                    }
                    String defaultValue = formFieldInfo.getTextValue();
                    int pageNum = formFieldInfo.getPageNum();
                    PdfFont font = formFieldInfo.getFont();
                    float fontSize = formFieldInfo.getFontSize();
                    boolean multiline = formFieldInfo.isMultiline();
                    Color color = formFieldInfo.getFontColor();
                    if (null == rect) {
                        throw new SealException("field rectangle can not be null!");
                    }
                    if (null == defaultValue) {
                        throw new SealException("text value can not be null!");
                    }
                    if (null == fieldName) {
                        throw new SealException("field name can not be null!");
                    }
                    ParamsCheckUtil.checkPageNum(pdfDoc, pageNum);
                    PdfPage pdfPage = pdfDoc.getPage(pageNum);
                    Rectangle pageRect = CoordinateUtil.rectangleToTransformedCoordinate(pdfPage, rect);
                    PdfTextFormField field = PdfFormField.createText(pdfDoc, pageRect, fieldName, defaultValue, font, fontSize, multiline, color);
                    int justification = formFieldInfo.getJustification();
                    int rotation = pdfPage.getRotation();
                    if ((rotation %= 360) > 0) {
                        PdfDictionary mkDict = ((PdfDictionary)field.getPdfObject()).getAsDictionary(PdfName.MK);
                        if (null == mkDict) {
                            mkDict = new PdfDictionary();
                            mkDict.put(PdfName.R, new PdfNumber(rotation));
                        } else {
                            mkDict.put(PdfName.R, new PdfNumber(rotation));
                        }
                        field.put(PdfName.MK, mkDict);
                    }
                    field.setJustification(justification);
                    form.addField(field, pdfPage);
                    continue;
                }
                if ("CheckBoxField".equals(fieldType)) {
                    rect = formFieldInfo.getRect();
                    int pageNum = formFieldInfo.getPageNum();
                    ParamsCheckUtil.checkPageNum(pdfDoc, pageNum);
                    float checkboxWidth = formFieldInfo.getCheckBoxWidth();
                    List<String> descList = formFieldInfo.getCheckBoxList();
                    String checkBoxName = formFieldInfo.getFieldName();
                    if (StringUtil.isEmpty(checkBoxName)) {
                        String groupName = formFieldInfo.getGroupName();
                        if (null == groupName || "".equals(groupName.trim())) {
                            groupName = "checkbox";
                        }
                        FormFieldUtil.checkGroupName(groupName, groupNameSet);
                        if (null == descList) {
                            throw new IllegalArgumentException("CheckBoxList is null");
                        }
                        int columns = descList.size();
                        Table table = null;
                        int gpStyle = formFieldInfo.getGroupStyle();
                        if (1 == gpStyle) {
                            table = (Table)new Table(UnitValue.createPercentArray(FormFieldUtil.getFieldTableArray(columns))).setWidthPercent(100.0f);
                        } else if (0 == gpStyle) {
                            table = (Table)new Table(UnitValue.createPercentArray(new float[]{checkboxWidth, rect.getWidth() - checkboxWidth})).setWidthPercent(100.0f);
                        } else {
                            throw new IllegalArgumentException("group style is unsupported:either GroupStyle.ALIGN_HORIZONTAL or GroupStyle.ALIGN_VERTICAL");
                        }
                        for (int i = 0; i < columns; ++i) {
                            String cellValue = descList.get(i);
                            Cell cell = new Cell();
                            cell.setBorder(Border.NO_BORDER);
                            cell.setNextRenderer(new CheckBoxCellRender(cell, groupName + i, cellValue));
                            table.addCell(cell);
                            if (!StringUtil.isNotEmpty(cellValue)) continue;
                            cell = new Cell().add(new Paragraph(cellValue));
                            cell.setBorder(Border.NO_BORDER);
                            table.addCell(cell);
                        }
                        table.setMargin(0.0f);
                        table.setFont(FontUtil.getInstance().createPdfFont());
                        table.setFontColor(formFieldInfo.getFontColor());
                        table.setFixedPosition(rect.getX(), rect.getY(), rect.getWidth());
                        table.setPageNumber(pageNum);
                        table.setVerticalAlignment(VerticalAlignment.MIDDLE);
                        doc.add(table);
                        continue;
                    }
                    FormFieldUtil.checkGroupName(checkBoxName, groupNameSet);
                    PdfButtonFormField checkBox = PdfFormField.createCheckBox(pdfDoc, rect, checkBoxName, CHECKBOXSTATE_OFF, 1);
                    PdfPage pdfPage = pdfDoc.getPage(pageNum);
                    checkBox.setBorderWidth(formFieldInfo.getCheckBoxBorderWidth());
                    form.addField(checkBox, pdfPage);
                    continue;
                }
                if ("RadioField".equals(fieldType)) {
                    rect = formFieldInfo.getRect();
                    int pageNum = formFieldInfo.getPageNum();
                    ParamsCheckUtil.checkPageNum(pdfDoc, pageNum);
                    float radioWidth = formFieldInfo.getRadioWidth();
                    String groupName = formFieldInfo.getGroupName();
                    if (null == groupName || "".equals(groupName.trim())) {
                        groupName = "radioGroup";
                    }
                    FormFieldUtil.checkGroupName(groupName, groupNameSet);
                    String defaultRadioSelectIdx = formFieldInfo.getDefaultRadioSelectIndex();
                    List<String> radioList = formFieldInfo.getRadioList();
                    PdfButtonFormField radioGroup = PdfFormField.createRadioGroup(pdfDoc, groupName, defaultRadioSelectIdx);
                    int columns = radioList.size();
                    Table table = null;
                    int gpStyle = formFieldInfo.getGroupStyle();
                    if (1 == gpStyle) {
                        table = new Table(UnitValue.createPercentArray(FormFieldUtil.getFieldTableArray(columns))).useAllAvailableWidth();
                    } else if (0 == gpStyle) {
                        table = new Table(UnitValue.createPercentArray(new float[]{radioWidth, rect.getWidth() - radioWidth})).useAllAvailableWidth();
                    } else {
                        throw new IllegalArgumentException("group style is unsupported:either GroupStyle.ALIGN_HORIZONTAL or GroupStyle.ALIGN_VERTICAL");
                    }
                    for (int i = 0; i < columns; ++i) {
                        String cellValue = radioList.get(i);
                        Cell cell = new Cell();
                        cell.setBorder(Border.NO_BORDER);
                        cell.setNextRenderer(new RadioCellRenderer(cell, radioGroup, String.valueOf(i)));
                        table.addCell(cell);
                        cell = new Cell().add(new Paragraph(cellValue));
                        cell.setBorder(Border.NO_BORDER);
                        table.addCell(cell);
                    }
                    table.setMargin(0.0f);
                    table.setFont(formFieldInfo.getFont());
                    table.setFixedPosition(rect.getX(), rect.getY(), rect.getWidth());
                    table.setPageNumber(pageNum);
                    doc.add(table);
                    PdfAcroForm.getAcroForm(pdfDoc, true).addField(radioGroup, pdfDoc.getPage(pageNum));
                    continue;
                }
                if ("ImageField".equals(fieldType)) {
                    String fieldName = formFieldInfo.getFieldName();
                    int pageNum = formFieldInfo.getPageNum();
                    formField = form.getField(fieldName);
                    if (null != formField) {
                        throw new SealException("form \"" + fieldName + "\" has been existed! use different field name.");
                    }
                    Rectangle rect2 = formFieldInfo.getRect();
                    if (null == rect2) {
                        throw new SealException("field rectangle can not be null!");
                    }
                    if (null == fieldName) {
                        throw new SealException("field name can not be null!");
                    }
                    ParamsCheckUtil.checkPageNum(pdfDoc, pageNum);
                    PdfPage pdfPage = pdfDoc.getPage(pageNum);
                    Rectangle pageRect = CoordinateUtil.rectangleToTransformedCoordinate(pdfPage, rect2);
                    PdfButtonFormField buttonField = PdfFormField.createButton(pdfDoc, pageRect, 65536);
                    buttonField.setFieldName(fieldName);
                    form.addField(buttonField, pdfPage);
                    continue;
                }
                throw new IllegalArgumentException("FieldType is unsupported:" + fieldType);
            }
            doc.close();
            pdfDoc.close();
        }
        catch (SealException e) {
            businessLog.error("formFieldInfoList failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("formFieldInfoList failed:", (Throwable)e);
            throw new SealException("formFieldInfoList failed", e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
            if (doc != null) {
                doc.close();
            }
        }
    }

    public static void fillFieldList(InputStream inputStream, OutputStream outputStream, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowException, boolean checkRequired, PdfFont allFont, Map<String, String> checkBoxMap, int checkBoxBorderWidth, Map<String, Integer> radioButtonMap) throws SealException, IOException {
        if (inputStream == null) {
            throw new SealException("inputStream is null");
        }
        if (outputStream == null) {
            throw new SealException("outputStream is null");
        }
        PdfReader pdfReader = new PdfReader(inputStream);
        FormFieldUtil.fillFieldList(pdfReader, outputStream, formFieldInfoList, flattenFields, isThrowException, checkRequired, allFont, checkBoxMap, checkBoxBorderWidth, radioButtonMap);
    }

    public static byte[] fillFieldList(byte[] pdfData, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowException, boolean checkRequired, PdfFont allFont, Map<String, String> checkBoxMap, int checkBoxBorderWidth, Map<String, Integer> radioButtonMap) throws SealException, IOException {
        if (pdfData == null || pdfData.length == 0) {
            throw new SealException("pdfData is null");
        }
        PdfReader pdfReader = new PdfReader(pdfData);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        FormFieldUtil.fillFieldList(pdfReader, (OutputStream)output, formFieldInfoList, flattenFields, isThrowException, checkRequired, allFont, checkBoxMap, checkBoxBorderWidth, radioButtonMap);
        return output.toByteArray();
    }

    private static void fillFieldList(PdfReader reader, OutputStream outputStream, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowException, boolean checkRequired, PdfFont allFont, Map<String, String> checkBoxMap, int checkBoxBorderWidth, Map<String, Integer> radioButtonMap) throws SealException {
        block52: {
            String methodPrex = "fillFieldList";
            String methodid = MethodCostTimeUtil.recordStartTime(methodPrex);
            PdfDocument doc = null;
            boolean useFileFont = false;
            boolean isValidInvoke = false;
            boolean isflattenFields = false;
            try {
                Object state;
                PdfFormField pdfFormField;
                PdfFormField field;
                StampingProperties properties = new StampingProperties();
                doc = new PdfDocument(reader, new PdfWriter(outputStream), properties, false);
                ParamsCheckUtil.checkSignature(doc);
                if (null != allFont) {
                    doc.addFont(allFont);
                    useFileFont = true;
                }
                PdfAcroForm form = PdfAcroForm.getAcroForm(doc, true);
                HashMap requiredFieldsMap = new HashMap();
                if (checkRequired) {
                    Map<String, PdfFormField> formFieldInfoMap = form.getFormFields();
                    for (Map.Entry<String, PdfFormField> singleEntry : formFieldInfoMap.entrySet()) {
                        field = singleEntry.getValue();
                        if (!(field instanceof PdfTextFormField) || !field.isRequired()) continue;
                        String fieldName = field.getFieldName().toUnicodeString();
                        requiredFieldsMap.put(fieldName, null);
                    }
                }
                if (formFieldInfoList != null && formFieldInfoList.size() > 0) {
                    for (int i = 0; i < formFieldInfoList.size(); ++i) {
                        isValidInvoke = true;
                        FormFieldInfo formFieldInfo = formFieldInfoList.get(i);
                        String fieldName = formFieldInfo.getFieldName();
                        if (null == fieldName || fieldName.isEmpty()) {
                            throw new SealException("fieldName is null");
                        }
                        field = form.getField(fieldName);
                        if (field != null && field instanceof PdfTextFormField) {
                            float fontSize;
                            PdfTextFormField textField = (PdfTextFormField)field;
                            boolean isAutoScale = false;
                            String text = formFieldInfo.getTextValue();
                            if (null == text || text.isEmpty()) {
                                throw new SealException("textValue is null");
                            }
                            PdfString pdfString = textField.getDefaultAppearance();
                            Object[] splits = null;
                            String fontName = null;
                            if (null != pdfString) {
                                splits = PdfTextFormField.splitDAelements(pdfString.toUnicodeString());
                                fontName = String.valueOf(splits[0]);
                            }
                            PdfFont font = formFieldInfo.getFont();
                            if (PDFUtil.containsUCS4Glyph(text)) {
                                font = UCS4FontUtil.getInstance().subsetFont(text);
                                textField.setFont(font, false);
                            } else if (useFileFont) {
                                textField.setFont(allFont, false);
                            } else {
                                if (null != fontName && null == font) {
                                    font = FontsFactory.getInstance().getSubSetFont(fontName, text, false);
                                }
                                if (null == font) {
                                    font = FontUtil.getInstance().subsetFont(text);
                                }
                                textField.setFont(font, false);
                            }
                            Color color = formFieldInfo.getFontColor();
                            if (null != color) {
                                textField.setColor(color, false);
                            }
                            if ((fontSize = formFieldInfo.getFontSize()) > 0.0f) {
                                textField.setBold(formFieldInfo.isBold());
                                textField.setItalic(formFieldInfo.isItalic());
                                textField.setFontSize(fontSize, false);
                            } else if (splits != null && ((Float)splits[1]).floatValue() == 0.0f) {
                                isAutoScale = true;
                            }
                            if (formFieldInfo.isUseParamJustfication()) {
                                int justification = formFieldInfo.getJustification();
                                textField.setJustification(justification, false);
                            }
                            textField.setValue(text);
                            textField.setReadOnly(true);
                            if (isAutoScale) {
                                textField.setFontSizeAutoScale();
                            }
                            requiredFieldsMap.remove(fieldName);
                            continue;
                        }
                        if (field != null && field instanceof PdfButtonFormField) {
                            byte[] imageBytes = formFieldInfo.getImageBytes();
                            if (null == imageBytes) {
                                throw new IllegalArgumentException("imageBytes is null");
                            }
                            PdfButtonFormField buttonField = (PdfButtonFormField)field;
                            ((PdfDictionary)buttonField.getPdfObject()).remove(PdfName.A);
                            buttonField.setImage(imageBytes);
                            if (flattenFields == null) continue;
                            for (int k = 0; k < flattenFields.length; ++k) {
                                String flattenName = flattenFields[k];
                                PdfFormField flattenField = form.getField(fieldName);
                                if (flattenField == null || !fieldName.equals(flattenName)) continue;
                                form.partialFormFlattening(fieldName);
                                isflattenFields = true;
                            }
                            continue;
                        }
                        if (!isThrowException) continue;
                        throw new SealException("no textField found fieldName=" + fieldName);
                    }
                }
                if (checkRequired && requiredFieldsMap.size() > 0) {
                    throw new SealException("textField must be filled, fieldName is" + requiredFieldsMap.keySet());
                }
                Map<String, PdfFormField> formFields = form.getFormFields();
                if (checkBoxMap != null && checkBoxMap.size() > 0) {
                    for (String key : checkBoxMap.keySet()) {
                        isValidInvoke = true;
                        pdfFormField = formFields.get(key);
                        if (null != pdfFormField && pdfFormField instanceof PdfButtonFormField) {
                            state = checkBoxMap.get(key);
                            if (CHECKBOXSTATE_ON.equals(state) || CHECKBOXSTATE_OFF.equals(state)) {
                                ((PdfButtonFormField)pdfFormField).setValue((String)state);
                                ((PdfButtonFormField)pdfFormField).setBorderWidth(checkBoxBorderWidth);
                                if (flattenFields == null) continue;
                                for (int k = 0; k < flattenFields.length; ++k) {
                                    String fieldName = flattenFields[k];
                                    PdfFormField field2 = form.getField(fieldName);
                                    if (field2 == null || !fieldName.equals(key)) continue;
                                    form.partialFormFlattening(fieldName);
                                    isflattenFields = true;
                                }
                                continue;
                            }
                            throw new SealException("checkBox key=" + key + " value=" + (String)state + " is wrong,please use FormFieldUtil.CHECKBOXSTATE_ON or FormFieldUtil.CHECKBOXSTATE_OFF for value");
                        }
                        if (!isThrowException) continue;
                        throw new SealException("checkBox key=" + key + " is not exists");
                    }
                    if (isflattenFields) {
                        form.flattenFields();
                    }
                }
                if (radioButtonMap != null && radioButtonMap.size() > 0) {
                    for (String key : radioButtonMap.keySet()) {
                        isValidInvoke = true;
                        pdfFormField = formFields.get(key);
                        if (null != pdfFormField && pdfFormField instanceof PdfButtonFormField) {
                            state = radioButtonMap.get(key);
                            if (null == state) {
                                throw new IllegalArgumentException("radio group " + key + " is null");
                            }
                            int intState = (Integer)state;
                            PdfArray kids = pdfFormField.getKids();
                            if (kids != null) {
                                int radioSize = kids.size();
                                if (intState <= 0 || intState > radioSize) {
                                    throw new IllegalArgumentException("radio index is wrong,input index is " + state + " , total index is " + radioSize);
                                }
                            }
                            ((PdfButtonFormField)pdfFormField).setValue(String.valueOf(--intState));
                            ((PdfButtonFormField)pdfFormField).setBorderWidth(1.0f);
                            if (flattenFields == null) continue;
                            for (int k = 0; k < flattenFields.length; ++k) {
                                String fieldName = flattenFields[k];
                                PdfFormField field3 = form.getField(fieldName);
                                if (field3 == null || !fieldName.equals(key)) continue;
                                form.partialFormFlattening(fieldName);
                                isflattenFields = true;
                            }
                            continue;
                        }
                        if (!isThrowException) continue;
                        throw new SealException("radio group key=" + key + " is not exists");
                    }
                    if (isflattenFields) {
                        form.flattenFields();
                    }
                }
                if (!isValidInvoke) {
                    throw new SealException("no fieldInfo found!");
                }
                if (flattenFields == null || flattenFields.length <= 0) break block52;
                form.setGenerateAppearance(false);
                boolean flattenAll = "FLATTEN_LEFTOVER_TEXT_BUTTON_FORMFIELD".equals(flattenFields[0]);
                if (flattenFields.length == 1 && (flattenAll || "FLATTEN_LEFTOVER_FORMFIELD".equals(flattenFields[0]))) {
                    Map<String, PdfFormField> formFieldInfoMap = form.getFormFields();
                    for (Map.Entry<String, PdfFormField> singleEntry : formFieldInfoMap.entrySet()) {
                        PdfString flattenFieldName;
                        PdfFormField field4 = singleEntry.getValue();
                        if (field4 == null || !(field4 instanceof PdfTextFormField) && (!(field4 instanceof PdfButtonFormField) || !flattenAll) || (flattenFieldName = field4.getFieldName()) == null) continue;
                        form.partialFormFlattening(flattenFieldName.getValue());
                        isflattenFields = true;
                    }
                } else {
                    for (int k = 0; k < flattenFields.length; ++k) {
                        String fieldName = flattenFields[k];
                        PdfFormField field5 = form.getField(fieldName);
                        if (field5 == null) continue;
                        form.partialFormFlattening(fieldName);
                        isflattenFields = true;
                    }
                }
                if (isflattenFields) {
                    form.flattenFields();
                }
            }
            catch (SealException e) {
                businessLog.error("fillTextFormField failed:", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                businessLog.error("fillTextFormField failed:", (Throwable)e);
                throw new SealException("fillTextFormField failed", e);
            }
            finally {
                if (doc != null) {
                    doc.close();
                }
                MethodCostTimeUtil.recordEndTime(methodid);
            }
        }
    }

    public static Map<String, PdfFormField> getAllFields(byte[] sourceData) throws SealException {
        if (sourceData == null || sourceData.length == 0) {
            throw new SealException("pdfData is null");
        }
        try {
            PdfReader reader = new PdfReader(sourceData);
            return FormFieldUtil.getAllFields(reader);
        }
        catch (SealException e) {
            throw e;
        }
        catch (Exception e) {
            businessLog.error("getAllFields failed", (Throwable)e);
            throw new SealException("getAllFields failed", e);
        }
    }

    public static Map<String, PdfFormField> getAllFields(InputStream inputStream) throws SealException {
        if (inputStream == null) {
            throw new SealException("inputStream is null");
        }
        try {
            PdfReader reader = new PdfReader(inputStream);
            return FormFieldUtil.getAllFields(reader);
        }
        catch (SealException e) {
            throw e;
        }
        catch (Exception e) {
            businessLog.error("getAllFields failed:", (Throwable)e);
            throw new SealException("getAllFields failed", e);
        }
    }

    public static List<String> getTextFormFields(byte[] pdfData) throws SealException {
        if (pdfData == null || pdfData.length == 0) {
            throw new SealException("pdfData is null");
        }
        try {
            List<String> resultList = FormFieldUtil.getTextFormFields(new PdfReader(pdfData));
            return resultList;
        }
        catch (SealException e) {
            businessLog.error("getTextFormFields failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("getTextFormFields failed:", (Throwable)e);
            throw new SealException("getTextFormFields failed", e);
        }
    }

    public static List<Map<String, Object>> getTextFormFieldsWithKids(byte[] pdfData) throws SealException {
        if (pdfData == null || pdfData.length == 0) {
            throw new SealException("pdfData is null");
        }
        try {
            List<Map<String, Object>> resultList = FormFieldUtil.getTextFormFieldsInfo(new PdfReader(pdfData));
            return resultList;
        }
        catch (SealException e) {
            businessLog.error("getTextFormFields failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("getTextFormFields failed:", (Throwable)e);
            throw new SealException("getTextFormFields failed", e);
        }
    }

    public static List<String> getTextFormFields(InputStream inputStream) throws SealException {
        if (inputStream == null) {
            throw new SealException("inputStream is null");
        }
        try {
            List<String> resultList = FormFieldUtil.getTextFormFields(new PdfReader(inputStream));
            return resultList;
        }
        catch (SealException e) {
            businessLog.error("getTextFormFields failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("getTextFormFields failed:", (Throwable)e);
            throw new SealException("getTextFormFields failed", e);
        }
    }

    public static void fillTextFormField(InputStream inputStream, OutputStream outputStream, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, boolean checkRequired, PdfFont allFont) throws SealException {
        FormFieldUtil.fillTextFormField(inputStream, null, outputStream, formFieldInfoList, flattenFields, isThrowNoFieldException, checkRequired, allFont);
    }

    public static void fillTextFormField(InputStream inputStream, OutputStream outputStream, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException) throws SealException {
        FormFieldUtil.fillTextFormField(inputStream, null, outputStream, formFieldInfoList, flattenFields, isThrowNoFieldException, false, null);
    }

    public static void fillTextFormField(InputStream inputStream, OutputStream outputStream, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, PdfFont allFont) throws SealException {
        FormFieldUtil.fillTextFormField(inputStream, null, outputStream, formFieldInfoList, flattenFields, isThrowNoFieldException, false, allFont);
    }

    public static byte[] fillTextFormField(byte[] pdfData, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException) throws SealException {
        return FormFieldUtil.fillTextFormField(pdfData, null, formFieldInfoList, flattenFields, isThrowNoFieldException, false, null);
    }

    public static byte[] fillTextFormField(byte[] pdfData, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, PdfFont allFont) throws SealException {
        return FormFieldUtil.fillTextFormField(pdfData, null, formFieldInfoList, flattenFields, isThrowNoFieldException, false, allFont);
    }

    public static void fillAndCheckTextFormField(InputStream inputStream, OutputStream outputStream, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, boolean checkRequired) throws SealException, IOException {
        if (inputStream == null) {
            throw new SealException("inputStream is null");
        }
        PdfReader reader = new PdfReader(inputStream);
        FormFieldUtil.fillTextFormField(reader, outputStream, formFieldInfoList, flattenFields, isThrowNoFieldException, checkRequired, null);
    }

    public static void fillAndCheckTextFormField(InputStream inputStream, OutputStream outputStream, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, boolean checkRequired, PdfFont allFont) throws SealException, IOException {
        if (inputStream == null) {
            throw new SealException("inputStream is null");
        }
        PdfReader reader = new PdfReader(inputStream);
        FormFieldUtil.fillTextFormField(reader, outputStream, formFieldInfoList, flattenFields, isThrowNoFieldException, checkRequired, allFont);
    }

    public static byte[] fillAndCheckTextFormField(byte[] pdfData, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, boolean checkRequired) throws SealException {
        if (pdfData == null || pdfData.length == 0) {
            throw new SealException("pdfData is null");
        }
        try {
            PdfReader reader = new PdfReader(pdfData);
            return FormFieldUtil.fillTextFormField(reader, formFieldInfoList, flattenFields, isThrowNoFieldException, checkRequired);
        }
        catch (SealException e) {
            throw e;
        }
        catch (Exception e) {
            businessLog.error("getAllFields failed", (Throwable)e);
            throw new SealException("getAllFields failed", e);
        }
    }

    public static byte[] fillCheckBox(byte[] sourceData, Map<String, String> checkBoxMap, boolean isThrowException) throws SealException {
        return FormFieldUtil.fillCheckBox(sourceData, checkBoxMap, isThrowException, 1);
    }

    public static byte[] fillCheckBox(byte[] sourceData, Map<String, String> checkBoxMap, boolean isThrowException, int borderWidth) throws SealException {
        businessLog.info("fillCheckBox begin...");
        byte[] resultPdf = null;
        PdfDocument pdfDoc = null;
        boolean isflattenFields = false;
        try {
            PdfReader reader = new PdfReader(sourceData);
            ByteArrayOutputStream os = new ByteArrayOutputStream(sourceData.length + 8192);
            pdfDoc = new PdfDocument(reader, new PdfWriter(os), new StampingProperties(), false);
            PdfAcroForm form = PdfAcroForm.getAcroForm(pdfDoc, true);
            Map<String, PdfFormField> formFields = form.getFormFields();
            if (checkBoxMap != null && checkBoxMap.size() > 0) {
                for (String key : checkBoxMap.keySet()) {
                    PdfFormField pdfFormField = formFields.get(key);
                    if (null != pdfFormField && pdfFormField instanceof PdfButtonFormField) {
                        String state = checkBoxMap.get(key);
                        if (CHECKBOXSTATE_ON.equals(state) || CHECKBOXSTATE_OFF.equals(state)) {
                            ((PdfButtonFormField)pdfFormField).setValue(state);
                            ((PdfButtonFormField)pdfFormField).setBorderWidth(borderWidth);
                            form.partialFormFlattening(key);
                            isflattenFields = true;
                            continue;
                        }
                        throw new SealException("checkBox key=" + key + " value=" + state + " is wrong,please use FormFieldUtil.CHECKBOXSTATE_ON or FormFieldUtil.CHECKBOXSTATE_OFF for value");
                    }
                    if (!isThrowException) continue;
                    throw new SealException("checkBox key=" + key + " is not exists");
                }
                if (isflattenFields) {
                    form.flattenFields();
                }
            }
            pdfDoc.close();
            resultPdf = os.toByteArray();
        }
        catch (SealException e) {
            businessLog.error("fillCheckBox failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("fillCheckBox failed", (Throwable)e);
            throw new SealException("fillCheckBox failed", e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
            businessLog.info("fillCheckBox end...");
        }
        return resultPdf;
    }

    public static boolean[] haveFields(InputStream inputStream, String[] fields) throws IOException, SealException {
        if (inputStream == null) {
            throw new SealException("inputStream is null");
        }
        if (fields == null) {
            throw new SealException("fields is null");
        }
        return FormFieldUtil.haveFields(new PdfReader(inputStream), fields);
    }

    public static boolean[] haveFields(byte[] pdfData, String[] fields) throws IOException, SealException {
        if (pdfData == null) {
            throw new SealException("pdfData is null");
        }
        if (fields == null) {
            throw new SealException("fields is null");
        }
        return FormFieldUtil.haveFields(new PdfReader(pdfData), fields);
    }

    public static void addTextFormField(InputStream inputStream, OutputStream outputStream, FormFieldInfo formFieldInfo) throws SealException {
        if (inputStream == null) {
            throw new SealException("inputStream is null");
        }
        if (outputStream == null) {
            throw new SealException("outputStream is null");
        }
        if (formFieldInfo == null) {
            throw new SealException("formFieldInfo is null");
        }
        PdfDocument pdfDoc = null;
        try {
            pdfDoc = new PdfDocument(new PdfReader(inputStream), new PdfWriter(outputStream));
            SignatureUtil sigUtil = new SignatureUtil(pdfDoc);
            List<String> sigNames = sigUtil.getSignatureNames();
            int size = sigNames.size();
            String fieldName = formFieldInfo.getFieldName();
            if (size > 0) {
                throw new SealException("document has been signed! can not add form '" + fieldName + "'.");
            }
            PdfAcroForm form = PdfAcroForm.getAcroForm(pdfDoc, true);
            Rectangle rect = formFieldInfo.getRect();
            PdfFormField formField = form.getField(fieldName);
            if (null != formField) {
                throw new SealException("form \"" + fieldName + "\" has been existed! use different field name.");
            }
            String defaultValue = formFieldInfo.getTextValue();
            int pageNum = formFieldInfo.getPageNum();
            PdfFont font = formFieldInfo.getFont();
            float fontSize = formFieldInfo.getFontSize();
            boolean multiline = formFieldInfo.isMultiline();
            Color color = formFieldInfo.getFontColor();
            if (null == rect) {
                throw new SealException("field rectangle can not be null!");
            }
            if (null == defaultValue) {
                throw new SealException("text value can not be null!");
            }
            if (null == fieldName) {
                throw new SealException("field name can not be null!");
            }
            PdfPage pdfPage = pdfDoc.getPage(pageNum);
            Rectangle pageRect = CoordinateUtil.rectangleToTransformedCoordinate(pdfPage, rect);
            PdfTextFormField field = PdfFormField.createText(pdfDoc, pageRect, fieldName, defaultValue, font, fontSize, multiline, color);
            int justification = formFieldInfo.getJustification();
            int rotation = pdfPage.getRotation();
            if ((rotation %= 360) > 0) {
                PdfDictionary mkDict = ((PdfDictionary)field.getPdfObject()).getAsDictionary(PdfName.MK);
                if (null == mkDict) {
                    mkDict = new PdfDictionary();
                    mkDict.put(PdfName.R, new PdfNumber(rotation));
                } else {
                    mkDict.put(PdfName.R, new PdfNumber(rotation));
                }
                field.put(PdfName.MK, mkDict);
            }
            field.setJustification(justification);
            form.addField(field, pdfPage);
            pdfDoc.close();
        }
        catch (IOException e) {
            businessLog.error("addTextFormField failed:" + formFieldInfo.toString());
            throw new SealException("addTextFormField failed", e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
        }
    }

    public static void addCheckBoxFormField(InputStream inputStream, OutputStream outputStream, FormFieldInfo formFieldInfo) throws SealException {
        PdfDocument pdfDoc = null;
        try {
            pdfDoc = new PdfDocument(new PdfReader(inputStream), new PdfWriter(outputStream));
            Document doc = new Document(pdfDoc);
            Rectangle rect = formFieldInfo.getRect();
            int pageNum = formFieldInfo.getPageNum();
            List<String> descList = formFieldInfo.getRadioList();
            int columns = descList.size();
            Table table = new Table(columns * 2);
            for (int i = 0; i < columns; ++i) {
                String cellValue = descList.get(i);
                Cell cell = new Cell();
                cell.setBorder(Border.NO_BORDER);
                cell.setNextRenderer(new CheckBoxCellRender(cell, "checkbox" + i, cellValue));
                table.addCell(cell);
                cell = new Cell().add(new Paragraph(cellValue));
                cell.setBorder(Border.NO_BORDER);
                table.addCell(cell);
            }
            table.setHeight(rect.getHeight() / 2.0f);
            table.setMargin(0.0f);
            table.setFont(FontUtil.getInstance().createPdfFont());
            table.setFontColor(Color.RED);
            table.setFixedPosition(rect.getX(), rect.getY(), rect.getWidth());
            table.setPageNumber(pageNum);
            table.setVerticalAlignment(VerticalAlignment.MIDDLE);
            doc.add(table);
            doc.close();
        }
        catch (SealException e) {
            businessLog.error("addCheckBoxFormField failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("addCheckBoxFormField failed:" + formFieldInfo.toString());
            throw new SealException("addCheckBoxFormField failed", e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
        }
    }

    public static void addRadioFormField(InputStream inputStream, OutputStream outputStream, FormFieldInfo formFieldInfo) throws SealException {
        PdfDocument pdfDoc = null;
        try {
            pdfDoc = new PdfDocument(new PdfReader(inputStream), new PdfWriter(outputStream));
            Document doc = new Document(pdfDoc);
            Rectangle rect = formFieldInfo.getRect();
            int pageNum = formFieldInfo.getPageNum();
            String groupName = formFieldInfo.getGroupName();
            String defaultSelectName = formFieldInfo.getDefaultRadioSelectIndex();
            List<String> descList = formFieldInfo.getRadioList();
            PdfButtonFormField radioGroup = PdfFormField.createRadioGroup(pdfDoc, groupName, defaultSelectName);
            PdfDictionary BSDict = new PdfDictionary();
            BSDict.put(PdfName.S, PdfName.I);
            BSDict.put(PdfName.W, new PdfNumber(1));
            radioGroup.put(PdfName.BS, BSDict);
            PdfDictionary MKDict = new PdfDictionary();
            MKDict.put(PdfName.BC, new PdfArray(new float[]{0.0f}));
            MKDict.put(PdfName.BG, new PdfArray(new float[]{1.0f}));
            radioGroup.put(PdfName.MK, MKDict);
            int columns = descList.size();
            Table table = new Table(columns * 2);
            for (int i = 0; i < columns; ++i) {
                String cellValue = descList.get(i);
                Cell cell = new Cell();
                cell.setBorder(Border.NO_BORDER);
                cell.setNextRenderer(new RadioCellRenderer(cell, radioGroup, cellValue));
                table.addCell(cell);
                cell = new Cell().add(new Paragraph(cellValue));
                cell.setBorder(Border.NO_BORDER);
                table.addCell(cell);
            }
            table.setHeight(rect.getHeight() / 2.0f);
            table.setMargin(0.0f);
            table.setFont(formFieldInfo.getFont());
            table.setFixedPosition(rect.getX(), rect.getY(), rect.getWidth());
            doc.add(table);
            PdfAcroForm.getAcroForm(pdfDoc, true).addField(radioGroup, pdfDoc.getPage(pageNum));
            doc.close();
        }
        catch (Exception e) {
            businessLog.error("addRadioFormField failed:" + formFieldInfo.toString());
            throw new SealException("addRadioFormField failed", e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
        }
    }

    private static void fillTextFormField(InputStream inputStream, byte[] openPassword, OutputStream outputStream, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, boolean checkRequired, PdfFont allFont) throws SealException {
        businessLog.info("fillTextFormField begin...");
        if (inputStream == null) {
            throw new SealException("inputStream is null");
        }
        try {
            PdfReader reader = new PdfReader(inputStream);
            if (null != openPassword) {
                reader.setOpenPassword(openPassword);
            }
            FormFieldUtil.fillTextFormField(reader, outputStream, formFieldInfoList, flattenFields, isThrowNoFieldException, checkRequired, allFont);
        }
        catch (SealException e) {
            businessLog.error("fillTextFormField failed:", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            businessLog.error("fillTextFormField failed:", (Throwable)e);
            throw new SealException("fillTextFormField failed", e);
        }
        finally {
            businessLog.info("fillTextFormField end...");
        }
    }

    private static byte[] fillTextFormField(byte[] pdfData, byte[] openPassword, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, boolean checkRequired, PdfFont allFont) throws SealException {
        businessLog.info("fillTextFormField begin...");
        if (pdfData == null) {
            throw new SealException("pdfData is null");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(pdfData.length + 8192);
        byte[] distPdfData = null;
        try {
            PdfReader reader = new PdfReader(pdfData);
            if (null != openPassword) {
                reader.setOpenPassword(openPassword);
            }
            FormFieldUtil.fillTextFormField(reader, (OutputStream)outputStream, formFieldInfoList, flattenFields, isThrowNoFieldException, checkRequired, allFont);
            byte[] byArray = distPdfData = outputStream.toByteArray();
            return byArray;
        }
        catch (SealException e) {
            businessLog.error("fillTextFormField failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("fillTextFormField failed:", (Throwable)e);
            throw new SealException("fillTextFormField failed", e);
        }
        finally {
            try {
                outputStream.reset();
                outputStream.close();
                outputStream = null;
            }
            catch (IOException e) {
                businessLog.error("fillTextFormField failed:", (Throwable)e);
            }
            businessLog.info("fillTextFormField end...");
        }
    }

    private static List<String> getTextFormFields(PdfReader reader) throws SealException {
        if (reader == null) {
            throw new SealException("PdfReader is null");
        }
        String methodPrex = "getTextFormFields";
        String methodid = MethodCostTimeUtil.recordStartTime(methodPrex);
        PdfDocument doc = null;
        ArrayList<String> resultList = new ArrayList<String>();
        try {
            doc = new PdfDocument(reader);
            PdfAcroForm form = PdfAcroForm.getAcroForm(doc, true);
            Map<String, PdfFormField> formFieldInfoMap = form.getFormFields();
            for (Map.Entry<String, PdfFormField> singleEntry : formFieldInfoMap.entrySet()) {
                PdfFormField field = singleEntry.getValue();
                if (!(field instanceof PdfTextFormField)) continue;
                resultList.add(singleEntry.getKey());
            }
            if (resultList.size() == 0) {
                throw new SealException("no textField found");
            }
            ArrayList<String> arrayList = resultList;
            return arrayList;
        }
        catch (SealException e) {
            businessLog.error("getTextFormFields failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("getTextFormFields failed:", (Throwable)e);
            throw new SealException("getTextFormFields failed", e);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
            MethodCostTimeUtil.recordEndTime(methodid);
        }
    }

    private static List<Map<String, Object>> getTextFormFieldsInfo(PdfReader reader) throws SealException {
        if (reader == null) {
            throw new SealException("PdfReader is null");
        }
        String methodPrex = "getTextFormFieldsInfo";
        String methodid = MethodCostTimeUtil.recordStartTime(methodPrex);
        PdfDocument doc = null;
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        try {
            doc = new PdfDocument(reader);
            PdfAcroForm form = PdfAcroForm.getAcroForm(doc, false);
            if (null != form) {
                Map<String, PdfFormField> formFieldInfoMap = form.getFormFields();
                for (Map.Entry<String, PdfFormField> singleEntry : formFieldInfoMap.entrySet()) {
                    PdfFormField field = singleEntry.getValue();
                    if (!(field instanceof PdfTextFormField)) continue;
                    PdfArray kids = field.getKids();
                    if (kids != null) {
                        for (int i = 0; i < kids.size(); ++i) {
                            PdfObject kid = kids.get(i);
                            if (kid.isIndirectReference()) {
                                kid = ((PdfIndirectReference)kid).getRefersTo();
                            }
                            PdfFormField subField = new PdfFormField((PdfDictionary)kid);
                            PdfWidgetAnnotation oneWidget = subField.getWidgets().get(0);
                            HashMap<String, Object> oneEntry = FormFieldUtil.getOneEntry(doc, oneWidget, singleEntry.getKey(), i);
                            String value = subField.getValueAsString();
                            oneEntry.put(FIELDVALUE, value);
                            resultList.add(oneEntry);
                        }
                        continue;
                    }
                    PdfWidgetAnnotation widget = singleEntry.getValue().getWidgets().get(0);
                    HashMap<String, Object> oneEntry = FormFieldUtil.getOneEntry(doc, widget, singleEntry.getKey(), -1);
                    String value = field.getValueAsString();
                    oneEntry.put(FIELDVALUE, value);
                    resultList.add(oneEntry);
                }
            }
            if (resultList.size() == 0) {
                throw new SealException("no textField found");
            }
            ArrayList<Map<String, Object>> arrayList = resultList;
            return arrayList;
        }
        catch (SealException e) {
            businessLog.error("getTextFormFieldsInfo failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("getTextFormFieldsInfo failed:", (Throwable)e);
            throw new SealException("getTextFormFieldsInfo failed", e);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
            MethodCostTimeUtil.recordEndTime(methodid);
        }
    }

    private static byte[] fillTextFormField(PdfReader reader, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, boolean checkRequired, PdfFont allFont) throws SealException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        FormFieldUtil.fillTextFormField(reader, (OutputStream)output, formFieldInfoList, flattenFields, isThrowNoFieldException, checkRequired, allFont);
        return output.toByteArray();
    }

    private static byte[] fillTextFormField(PdfReader reader, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, boolean checkRequired) throws SealException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        FormFieldUtil.fillTextFormField(reader, (OutputStream)output, formFieldInfoList, flattenFields, isThrowNoFieldException, checkRequired, null);
        return output.toByteArray();
    }

    private static void fillTextFormField(PdfReader reader, OutputStream outputStream, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, boolean checkRequired, PdfFont allFont) throws SealException {
        block38: {
            if (reader == null) {
                throw new SealException("PdfReader is null");
            }
            if (outputStream == null) {
                throw new SealException("outputStream is null");
            }
            String methodPrex = "fillTextFormField-Stream";
            String methodid = MethodCostTimeUtil.recordStartTime(methodPrex);
            PdfDocument doc = null;
            boolean isAppend = flattenFields == null;
            boolean useFileFont = false;
            try {
                String fieldName;
                PdfFormField field;
                StampingProperties properties = new StampingProperties();
                if (isAppend) {
                    properties.useAppendMode();
                }
                doc = new PdfDocument(reader, new PdfWriter(outputStream), properties, false);
                ParamsCheckUtil.checkSignature(doc);
                if (null != allFont) {
                    doc.addFont(allFont);
                    useFileFont = true;
                }
                PdfAcroForm form = PdfAcroForm.getAcroForm(doc, true);
                HashMap requiredFieldsMap = new HashMap();
                if (checkRequired) {
                    Map<String, PdfFormField> formFieldInfoMap = form.getFormFields();
                    for (Map.Entry<String, PdfFormField> singleEntry : formFieldInfoMap.entrySet()) {
                        field = singleEntry.getValue();
                        if (!(field instanceof PdfTextFormField) || !field.isRequired()) continue;
                        String fieldName2 = field.getFieldName().toUnicodeString();
                        requiredFieldsMap.put(fieldName2, null);
                    }
                }
                if (formFieldInfoList != null) {
                    for (int i = 0; i < formFieldInfoList.size(); ++i) {
                        FormFieldInfo formFieldInfo = formFieldInfoList.get(i);
                        fieldName = formFieldInfo.getFieldName();
                        if (null == fieldName || fieldName.isEmpty()) {
                            throw new SealException("fieldName is null");
                        }
                        field = form.getField(fieldName);
                        if (field != null && field instanceof PdfTextFormField) {
                            float fontSize;
                            PdfTextFormField textField = (PdfTextFormField)field;
                            boolean isAutoScale = false;
                            String text = formFieldInfo.getTextValue();
                            if (null == text || text.isEmpty()) {
                                throw new SealException("textValue is null");
                            }
                            PdfString pdfString = textField.getDefaultAppearance();
                            Object[] splits = null;
                            String fontName = null;
                            if (null != pdfString) {
                                splits = PdfTextFormField.splitDAelements(pdfString.toUnicodeString());
                                fontName = String.valueOf(splits[0]);
                            }
                            PdfFont font = formFieldInfo.getFont();
                            if (PDFUtil.containsUCS4Glyph(text)) {
                                font = UCS4FontUtil.getInstance().subsetFont(text);
                                textField.setFont(font, false);
                            } else if (useFileFont) {
                                textField.setFont(allFont, false);
                            } else {
                                if (null != fontName && null == font) {
                                    font = FontsFactory.getInstance().getSubSetFont(fontName, text, false);
                                }
                                if (null == font) {
                                    font = FontUtil.getInstance().subsetFont(text);
                                }
                                textField.setFont(font, false);
                            }
                            Color color = formFieldInfo.getFontColor();
                            if (null != color) {
                                textField.setColor(color, false);
                            }
                            if ((fontSize = formFieldInfo.getFontSize()) > 0.0f) {
                                textField.setFontSize(fontSize, false);
                                textField.setBold(formFieldInfo.isBold());
                                textField.setItalic(formFieldInfo.isItalic());
                            } else if (splits != null && ((Float)splits[1]).floatValue() == 0.0f) {
                                isAutoScale = true;
                            }
                            if (formFieldInfo.isUseParamJustfication()) {
                                int justification = formFieldInfo.getJustification();
                                textField.setJustification(justification, false);
                            }
                            textField.setValue(text);
                            textField.setReadOnly(true);
                            if (isAutoScale) {
                                textField.setFontSizeAutoScale();
                            }
                            requiredFieldsMap.remove(fieldName);
                            continue;
                        }
                        if (!isThrowNoFieldException) continue;
                        throw new SealException("no textField found fieldName=" + fieldName);
                    }
                } else {
                    throw new IllegalArgumentException("formFieldInfoList is null!");
                }
                if (checkRequired && requiredFieldsMap.size() > 0) {
                    throw new SealException("textField must be filled, fieldName is" + requiredFieldsMap.keySet());
                }
                boolean isflattenFields = false;
                if (flattenFields == null || flattenFields.length <= 0) break block38;
                form.setGenerateAppearance(false);
                if (flattenFields.length == 1 && "FLATTEN_LEFTOVER_FORMFIELD".equals(flattenFields[0])) {
                    Map<String, PdfFormField> formFieldInfoMap = form.getFormFields();
                    for (Map.Entry<String, PdfFormField> singleEntry : formFieldInfoMap.entrySet()) {
                        PdfFormField field2 = singleEntry.getValue();
                        if (field2 == null || !(field2 instanceof PdfTextFormField)) continue;
                        form.partialFormFlattening(field2.getFieldName().getValue());
                        isflattenFields = true;
                    }
                } else {
                    for (int k = 0; k < flattenFields.length; ++k) {
                        fieldName = flattenFields[k];
                        field = form.getField(fieldName);
                        if (field == null) continue;
                        form.partialFormFlattening(fieldName);
                        isflattenFields = true;
                    }
                }
                if (isflattenFields) {
                    form.flattenFields();
                }
            }
            catch (SealException e) {
                businessLog.error("fillTextFormField failed:", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                businessLog.error("fillTextFormField failed:", (Throwable)e);
                throw new SealException("fillTextFormField failed", e);
            }
            finally {
                if (doc != null) {
                    doc.close();
                }
                MethodCostTimeUtil.recordEndTime(methodid);
            }
        }
    }

    private static void fillTextFormField(PdfReader reader, OutputStream outputStream, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, PdfFont allFont) throws SealException {
        FormFieldUtil.fillTextFormField(reader, outputStream, formFieldInfoList, flattenFields, isThrowNoFieldException, false, allFont);
    }

    private static boolean[] haveFields(PdfReader reader, String[] fields) throws IOException {
        PdfDocument doc = null;
        boolean[] haveFields = null;
        try {
            doc = new PdfDocument(reader);
            PdfAcroForm form = PdfAcroForm.getAcroForm(doc, false);
            if (null == form) {
                throw new IOException("no field found!");
            }
            Map<String, PdfFormField> fieldsMap = form.getFormFields();
            int fieldsLength = fields.length;
            haveFields = new boolean[fieldsLength];
            for (int i = 0; i < fieldsLength; ++i) {
                haveFields[i] = fieldsMap.containsKey(fields[i]);
            }
            doc.close();
            boolean[] blArray = haveFields;
            return blArray;
        }
        catch (Exception e) {
            businessLog.error("process haveFields() failed", (Throwable)e);
            throw new IOException(e.getMessage());
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, PdfFormField> getAllFields(PdfReader reader) throws SealException {
        PdfDocument pdfDoc = null;
        try {
            Map<String, PdfFormField> formFields;
            pdfDoc = new PdfDocument(reader, false);
            PdfAcroForm form = PdfAcroForm.getAcroForm(pdfDoc, true);
            Map<String, PdfFormField> map = formFields = form.getFormFields();
            return map;
        }
        catch (Exception e) {
            businessLog.error("getAllFields failed", (Throwable)e);
            Map<String, PdfFormField> map = null;
            return map;
        }
        finally {
            if (null != pdfDoc) {
                pdfDoc.close();
            }
        }
    }

    private static HashMap<String, Object> getOneEntry(PdfDocument doc, PdfAnnotation oneWidget, String fieldName, int index) {
        HashMap<String, Object> oneEntry = new HashMap<String, Object>();
        PdfDictionary pageDictionary = oneWidget.getPageObject();
        PdfPage page = doc.getPage(pageDictionary);
        int pageNum = doc.getPageNumber(page);
        PdfArray rect = oneWidget.getRectangle();
        float lx = rect.getAsNumber(0).floatValue();
        float ly = rect.getAsNumber(1).floatValue();
        float rx = rect.getAsNumber(2).floatValue();
        float ry = rect.getAsNumber(3).floatValue();
        oneEntry.put(PAGENUM, pageNum);
        oneEntry.put(PAGEHEIGHT, Float.valueOf(page.getPageSize().getHeight()));
        oneEntry.put(RECTANGLE, new Rectangle(lx, ly, rx - lx, ry - ly));
        if (index != -1) {
            oneEntry.put(FIELDNAME, fieldName + "#" + index);
        } else {
            oneEntry.put(FIELDNAME, fieldName);
        }
        return oneEntry;
    }

    private static float[] getFieldTableArray(int columns) {
        if (columns <= 0) {
            throw new IllegalArgumentException("columns is less than zero!");
        }
        float onepercent = 100.0f / (float)(columns * 5);
        float[] percentArray = new float[columns * 2];
        int position = 0;
        for (int i = 0; i < columns; ++i) {
            percentArray[position] = onepercent;
            percentArray[position + 1] = 4.0f * onepercent;
            position += 2;
        }
        return percentArray;
    }

    private static void checkGroupName(String fieldName, HashSet<String> hashSet) {
        boolean isExists = hashSet.contains(fieldName);
        if (isExists) {
            throw new IllegalArgumentException("fieldName = " + fieldName + " is exists!");
        }
        hashSet.add(fieldName);
    }

    public static interface FormFieldType {
        public static final int BUTTON = 1;
        public static final int TEXT = 2;
        public static final int BLANK_SIGNATURE = 4;
    }
}

