/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import android.os.Build;
import android.util.Log;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Protocol;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 82\u00020\u0001:\u00046789B=\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016J \u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010\u00102\u0006\u0010#\u001a\u00020\u001eH\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010\u00132\u0006\u0010+\u001a\u00020\u0010H\u0016J\u0010\u0010,\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u00020\u00102\b\u00100\u001a\u0004\u0018\u000101H\u0016J\u001a\u00102\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u00102\b\u00103\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u00104\u001a\u000205H\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lokhttp3/internal/platform/AndroidPlatform;", "Lokhttp3/internal/platform/Platform;", "sslParametersClass", "Ljava/lang/Class;", "sslSocketClass", "setUseSessionTickets", "Ljava/lang/reflect/Method;", "setHostname", "getAlpnSelectedProtocol", "setAlpnProtocols", "(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;)V", "closeGuard", "Lokhttp3/internal/platform/AndroidPlatform$CloseGuard;", "api23IsCleartextTrafficPermitted", "", "hostname", "", "networkPolicyClass", "networkSecurityPolicy", "", "api24IsCleartextTrafficPermitted", "buildCertificateChainCleaner", "Lokhttp3/internal/tls/CertificateChainCleaner;", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "buildTrustRootIndex", "Lokhttp3/internal/tls/TrustRootIndex;", "configureTlsExtensions", "", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "protocols", "", "Lokhttp3/Protocol;", "connectSocket", "socket", "Ljava/net/Socket;", "address", "Ljava/net/InetSocketAddress;", "connectTimeout", "", "getSelectedProtocol", "getStackTraceForCloseable", "closer", "isCleartextTrafficPermitted", "log", "level", "message", "t", "", "logCloseableLeak", "stackTrace", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "AndroidCertificateChainCleaner", "CloseGuard", "Companion", "CustomTrustRootIndex", "okhttp"})
public final class AndroidPlatform
extends Platform {
    private final CloseGuard closeGuard;
    private final Class<?> sslParametersClass;
    private final Class<?> sslSocketClass;
    private final Method setUseSessionTickets;
    private final Method setHostname;
    private final Method getAlpnSelectedProtocol;
    private final Method setAlpnProtocols;
    private static final int MAX_LOG_LENGTH = 4000;
    public static final Companion Companion = new Companion(null);

    @Override
    public void connectSocket(@NotNull Socket socket, @NotNull InetSocketAddress address, int connectTimeout) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)socket, (String)"socket");
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        try {
            socket.connect(address, connectTimeout);
        }
        catch (ClassCastException e) {
            if (Build.VERSION.SDK_INT == 26) {
                throw (Throwable)new IOException("Exception in connect", e);
            }
            throw (Throwable)e;
        }
    }

    @Override
    @Nullable
    protected X509TrustManager trustManager(@NotNull SSLSocketFactory sslSocketFactory) {
        X509TrustManager x509TrustManager;
        X509TrustManager x509TrustManager2;
        Intrinsics.checkParameterIsNotNull((Object)sslSocketFactory, (String)"sslSocketFactory");
        Object context = Platform.Companion.readFieldOrNull(sslSocketFactory, this.sslParametersClass, "sslParameters");
        if (context == null) {
            try {
                Class<?> gmsSslParametersClass;
                Class<?> clazz = gmsSslParametersClass = Class.forName("com.google.android.gms.org.conscrypt.SSLParametersImpl", false, sslSocketFactory.getClass().getClassLoader());
                Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"gmsSslParametersClass");
                context = Platform.Companion.readFieldOrNull(sslSocketFactory, clazz, "sslParameters");
            }
            catch (ClassNotFoundException e) {
                return super.trustManager(sslSocketFactory);
            }
        }
        Object obj = context;
        if (obj == null) {
            Intrinsics.throwNpe();
        }
        if ((x509TrustManager2 = (x509TrustManager = Platform.Companion.readFieldOrNull(obj, X509TrustManager.class, "x509TrustManager"))) == null) {
            x509TrustManager2 = Platform.Companion.readFieldOrNull(context, X509TrustManager.class, "trustManager");
        }
        return x509TrustManager2;
    }

    public void configureTlsExtensions(@NotNull SSLSocket sslSocket, @Nullable String hostname, @NotNull List<? extends Protocol> protocols) {
        Intrinsics.checkParameterIsNotNull((Object)sslSocket, (String)"sslSocket");
        Intrinsics.checkParameterIsNotNull(protocols, (String)"protocols");
        if (!this.sslSocketClass.isInstance(sslSocket)) {
            return;
        }
        try {
            if (hostname != null) {
                this.setUseSessionTickets.invoke((Object)sslSocket, true);
                this.setHostname.invoke((Object)sslSocket, hostname);
            }
            this.setAlpnProtocols.invoke((Object)sslSocket, new Object[]{Platform.Companion.concatLengthPrefixed(protocols)});
        }
        catch (IllegalAccessException e) {
            throw (Throwable)((Object)new AssertionError((Object)e));
        }
        catch (InvocationTargetException e) {
            throw (Throwable)((Object)new AssertionError((Object)e));
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(@NotNull SSLSocket socket) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)socket, (String)"socket");
        if (this.sslSocketClass.isInstance(socket)) {
            String string2;
            try {
                String string3;
                byte[] alpnResult = (byte[])this.getAlpnSelectedProtocol.invoke((Object)socket, new Object[0]);
                if (alpnResult != null) {
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF_8");
                    Charset charset2 = charset;
                    boolean bl = false;
                    string3 = new String(alpnResult, charset2);
                } else {
                    string3 = null;
                }
                string2 = string3;
            }
            catch (IllegalAccessException e) {
                throw (Throwable)((Object)new AssertionError((Object)e));
            }
            catch (InvocationTargetException e) {
                throw (Throwable)((Object)new AssertionError((Object)e));
            }
            string = string2;
        } else {
            string = null;
        }
        return string;
    }

    @Override
    public void log(int level, @NotNull String message, @Nullable Throwable t) {
        int logLevel;
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        String logMessage = message;
        int n = logLevel = level == 5 ? 5 : 3;
        if (t != null) {
            logMessage = logMessage + "\n" + Log.getStackTraceString((Throwable)t);
        }
        int length = logMessage.length();
        for (int i = 0; i < length; ++i) {
            int end;
            int newline = StringsKt.indexOf$default((CharSequence)logMessage, (char)'\n', (int)i, (boolean)false, (int)4, null);
            newline = newline != -1 ? newline : length;
            do {
                String string;
                int n2 = i + 4000;
                boolean bl = false;
                end = Math.min(newline, n2);
                String string2 = logMessage;
                String string3 = "OkHttp";
                int n3 = logLevel;
                bl = false;
                String string4 = string2;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring(i, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                Log.println((int)n3, (String)string3, (String)string);
            } while ((i = end) < newline);
        }
    }

    @Override
    @Nullable
    public Object getStackTraceForCloseable(@NotNull String closer) {
        Intrinsics.checkParameterIsNotNull((Object)closer, (String)"closer");
        return this.closeGuard.createAndOpen(closer);
    }

    @Override
    public void logCloseableLeak(@NotNull String message, @Nullable Object stackTrace) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        boolean reported = this.closeGuard.warnIfOpen(stackTrace);
        if (!reported) {
            this.log(5, message, null);
        }
    }

    @Override
    public boolean isCleartextTrafficPermitted(@NotNull String hostname) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)hostname, (String)"hostname");
        try {
            Class<?> networkPolicyClass = Class.forName("android.security.NetworkSecurityPolicy");
            Method getInstanceMethod = networkPolicyClass.getMethod("getInstance", new Class[0]);
            Object networkSecurityPolicy = getInstanceMethod.invoke(null, new Object[0]);
            Class<?> clazz = networkPolicyClass;
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"networkPolicyClass");
            Object object = networkSecurityPolicy;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"networkSecurityPolicy");
            bl = this.api24IsCleartextTrafficPermitted(hostname, clazz, object);
        }
        catch (ClassNotFoundException e) {
            bl = super.isCleartextTrafficPermitted(hostname);
        }
        catch (NoSuchMethodException e) {
            bl = super.isCleartextTrafficPermitted(hostname);
        }
        catch (IllegalAccessException e) {
            throw (Throwable)((Object)new AssertionError("unable to determine cleartext support", e));
        }
        catch (IllegalArgumentException e) {
            throw (Throwable)((Object)new AssertionError("unable to determine cleartext support", e));
        }
        catch (InvocationTargetException e) {
            throw (Throwable)((Object)new AssertionError("unable to determine cleartext support", e));
        }
        return bl;
    }

    private final boolean api24IsCleartextTrafficPermitted(String hostname, Class<?> networkPolicyClass, Object networkSecurityPolicy) throws InvocationTargetException, IllegalAccessException {
        boolean bl;
        try {
            Method isCleartextTrafficPermittedMethod = networkPolicyClass.getMethod("isCleartextTrafficPermitted", String.class);
            Object object = isCleartextTrafficPermittedMethod.invoke(networkSecurityPolicy, hostname);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
            }
            bl = (Boolean)object;
        }
        catch (NoSuchMethodException e) {
            bl = this.api23IsCleartextTrafficPermitted(hostname, networkPolicyClass, networkSecurityPolicy);
        }
        return bl;
    }

    private final boolean api23IsCleartextTrafficPermitted(String hostname, Class<?> networkPolicyClass, Object networkSecurityPolicy) throws InvocationTargetException, IllegalAccessException {
        boolean bl;
        try {
            Method isCleartextTrafficPermittedMethod = networkPolicyClass.getMethod("isCleartextTrafficPermitted", new Class[0]);
            Object object = isCleartextTrafficPermittedMethod.invoke(networkSecurityPolicy, new Object[0]);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
            }
            bl = (Boolean)object;
        }
        catch (NoSuchMethodException e) {
            bl = super.isCleartextTrafficPermitted(hostname);
        }
        return bl;
    }

    @Override
    @NotNull
    public CertificateChainCleaner buildCertificateChainCleaner(@NotNull X509TrustManager trustManager) {
        CertificateChainCleaner certificateChainCleaner;
        Intrinsics.checkParameterIsNotNull((Object)trustManager, (String)"trustManager");
        try {
            Class<?> extensionsClass = Class.forName("android.net.http.X509TrustManagerExtensions");
            Constructor<?> constructor = extensionsClass.getConstructor(X509TrustManager.class);
            Object extensions = constructor.newInstance(trustManager);
            Method checkServerTrusted = extensionsClass.getMethod("checkServerTrusted", X509Certificate[].class, String.class, String.class);
            Object obj = extensions;
            Intrinsics.checkExpressionValueIsNotNull(obj, (String)"extensions");
            Method method = checkServerTrusted;
            Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"checkServerTrusted");
            certificateChainCleaner = new AndroidCertificateChainCleaner(obj, method);
        }
        catch (Exception e) {
            certificateChainCleaner = super.buildCertificateChainCleaner(trustManager);
        }
        return certificateChainCleaner;
    }

    @Override
    @NotNull
    public TrustRootIndex buildTrustRootIndex(@NotNull X509TrustManager trustManager) {
        TrustRootIndex trustRootIndex;
        Intrinsics.checkParameterIsNotNull((Object)trustManager, (String)"trustManager");
        try {
            Method method;
            Method method2 = method = trustManager.getClass().getDeclaredMethod("findTrustAnchorByIssuerAndSignature", X509Certificate.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"method");
            method2.setAccessible(true);
            trustRootIndex = new CustomTrustRootIndex(trustManager, method);
        }
        catch (NoSuchMethodException e) {
            trustRootIndex = super.buildTrustRootIndex(trustManager);
        }
        return trustRootIndex;
    }

    public AndroidPlatform(@NotNull Class<?> sslParametersClass, @NotNull Class<?> sslSocketClass, @NotNull Method setUseSessionTickets, @NotNull Method setHostname, @NotNull Method getAlpnSelectedProtocol, @NotNull Method setAlpnProtocols) {
        Intrinsics.checkParameterIsNotNull(sslParametersClass, (String)"sslParametersClass");
        Intrinsics.checkParameterIsNotNull(sslSocketClass, (String)"sslSocketClass");
        Intrinsics.checkParameterIsNotNull((Object)setUseSessionTickets, (String)"setUseSessionTickets");
        Intrinsics.checkParameterIsNotNull((Object)setHostname, (String)"setHostname");
        Intrinsics.checkParameterIsNotNull((Object)getAlpnSelectedProtocol, (String)"getAlpnSelectedProtocol");
        Intrinsics.checkParameterIsNotNull((Object)setAlpnProtocols, (String)"setAlpnProtocols");
        this.sslParametersClass = sslParametersClass;
        this.sslSocketClass = sslSocketClass;
        this.setUseSessionTickets = setUseSessionTickets;
        this.setHostname = setHostname;
        this.getAlpnSelectedProtocol = getAlpnSelectedProtocol;
        this.setAlpnProtocols = setAlpnProtocols;
        this.closeGuard = CloseGuard.Companion.get();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lokhttp3/internal/platform/AndroidPlatform$AndroidCertificateChainCleaner;", "Lokhttp3/internal/tls/CertificateChainCleaner;", "x509TrustManagerExtensions", "", "checkServerTrusted", "Ljava/lang/reflect/Method;", "(Ljava/lang/Object;Ljava/lang/reflect/Method;)V", "clean", "", "Ljava/security/cert/Certificate;", "chain", "hostname", "", "equals", "", "other", "hashCode", "", "okhttp"})
    public static final class AndroidCertificateChainCleaner
    extends CertificateChainCleaner {
        private final Object x509TrustManagerExtensions;
        private final Method checkServerTrusted;

        @Override
        @NotNull
        public List<Certificate> clean(@NotNull List<? extends Certificate> chain, @NotNull String hostname) throws SSLPeerUnverifiedException {
            List list;
            Intrinsics.checkParameterIsNotNull(chain, (String)"chain");
            Intrinsics.checkParameterIsNotNull((Object)hostname, (String)"hostname");
            try {
                Collection $this$toTypedArray$iv = chain;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                X509Certificate[] x509CertificateArray = thisCollection$iv.toArray(new X509Certificate[0]);
                if (x509CertificateArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                X509Certificate[] certificates = x509CertificateArray;
                Object object = this.checkServerTrusted.invoke(this.x509TrustManagerExtensions, certificates, "RSA", hostname);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<java.security.cert.Certificate>");
                }
                list = (List)object;
            }
            catch (InvocationTargetException e) {
                SSLPeerUnverifiedException exception = new SSLPeerUnverifiedException(e.getMessage());
                exception.initCause(e);
                throw (Throwable)exception;
            }
            catch (IllegalAccessException e) {
                throw (Throwable)((Object)new AssertionError((Object)e));
            }
            return list;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof AndroidCertificateChainCleaner;
        }

        public int hashCode() {
            return 0;
        }

        public AndroidCertificateChainCleaner(@NotNull Object x509TrustManagerExtensions, @NotNull Method checkServerTrusted) {
            Intrinsics.checkParameterIsNotNull((Object)x509TrustManagerExtensions, (String)"x509TrustManagerExtensions");
            Intrinsics.checkParameterIsNotNull((Object)checkServerTrusted, (String)"checkServerTrusted");
            this.x509TrustManagerExtensions = x509TrustManagerExtensions;
            this.checkServerTrusted = checkServerTrusted;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lokhttp3/internal/platform/AndroidPlatform$CloseGuard;", "", "getMethod", "Ljava/lang/reflect/Method;", "openMethod", "warnIfOpenMethod", "(Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;)V", "createAndOpen", "closer", "", "warnIfOpen", "", "closeGuardInstance", "Companion", "okhttp"})
    public static final class CloseGuard {
        private final Method getMethod;
        private final Method openMethod;
        private final Method warnIfOpenMethod;
        public static final Companion Companion = new Companion(null);

        @Nullable
        public final Object createAndOpen(@NotNull String closer) {
            Intrinsics.checkParameterIsNotNull((Object)closer, (String)"closer");
            if (this.getMethod != null) {
                try {
                    Object closeGuardInstance = this.getMethod.invoke(null, new Object[0]);
                    Method method = this.openMethod;
                    if (method == null) {
                        Intrinsics.throwNpe();
                    }
                    method.invoke(closeGuardInstance, closer);
                    return closeGuardInstance;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public final boolean warnIfOpen(@Nullable Object closeGuardInstance) {
            boolean reported = false;
            if (closeGuardInstance != null) {
                try {
                    Method method = this.warnIfOpenMethod;
                    if (method == null) {
                        Intrinsics.throwNpe();
                    }
                    method.invoke(closeGuardInstance, new Object[0]);
                    reported = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return reported;
        }

        public CloseGuard(@Nullable Method getMethod, @Nullable Method openMethod, @Nullable Method warnIfOpenMethod) {
            this.getMethod = getMethod;
            this.openMethod = openMethod;
            this.warnIfOpenMethod = warnIfOpenMethod;
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lokhttp3/internal/platform/AndroidPlatform$CloseGuard$Companion;", "", "()V", "get", "Lokhttp3/internal/platform/AndroidPlatform$CloseGuard;", "okhttp"})
        public static final class Companion {
            @NotNull
            public final CloseGuard get() {
                Method getMethod = null;
                Method openMethod = null;
                Method warnIfOpenMethod = null;
                try {
                    Class<?> closeGuardClass = Class.forName("dalvik.system.CloseGuard");
                    getMethod = closeGuardClass.getMethod("get", new Class[0]);
                    openMethod = closeGuardClass.getMethod("open", String.class);
                    warnIfOpenMethod = closeGuardClass.getMethod("warnIfOpen", new Class[0]);
                }
                catch (Exception _) {
                    getMethod = null;
                    openMethod = null;
                    warnIfOpenMethod = null;
                }
                return new CloseGuard(getMethod, openMethod, warnIfOpenMethod);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\b\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lokhttp3/internal/platform/AndroidPlatform$CustomTrustRootIndex;", "Lokhttp3/internal/tls/TrustRootIndex;", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "findByIssuerAndSignatureMethod", "Ljava/lang/reflect/Method;", "(Ljavax/net/ssl/X509TrustManager;Ljava/lang/reflect/Method;)V", "component1", "component2", "copy", "equals", "", "other", "", "findByIssuerAndSignature", "Ljava/security/cert/X509Certificate;", "cert", "hashCode", "", "toString", "", "okhttp"})
    public static final class CustomTrustRootIndex
    implements TrustRootIndex {
        private final X509TrustManager trustManager;
        private final Method findByIssuerAndSignatureMethod;

        @Override
        @Nullable
        public X509Certificate findByIssuerAndSignature(@NotNull X509Certificate cert) {
            X509Certificate x509Certificate;
            Intrinsics.checkParameterIsNotNull((Object)cert, (String)"cert");
            try {
                Object object = this.findByIssuerAndSignatureMethod.invoke((Object)this.trustManager, cert);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.security.cert.TrustAnchor");
                }
                TrustAnchor trustAnchor = (TrustAnchor)object;
                x509Certificate = trustAnchor.getTrustedCert();
            }
            catch (IllegalAccessException e) {
                throw (Throwable)((Object)new AssertionError("unable to get issues and signature", e));
            }
            catch (InvocationTargetException e) {
                x509Certificate = null;
            }
            return x509Certificate;
        }

        public CustomTrustRootIndex(@NotNull X509TrustManager trustManager, @NotNull Method findByIssuerAndSignatureMethod) {
            Intrinsics.checkParameterIsNotNull((Object)trustManager, (String)"trustManager");
            Intrinsics.checkParameterIsNotNull((Object)findByIssuerAndSignatureMethod, (String)"findByIssuerAndSignatureMethod");
            this.trustManager = trustManager;
            this.findByIssuerAndSignatureMethod = findByIssuerAndSignatureMethod;
        }

        private final X509TrustManager component1() {
            return this.trustManager;
        }

        private final Method component2() {
            return this.findByIssuerAndSignatureMethod;
        }

        @NotNull
        public final CustomTrustRootIndex copy(@NotNull X509TrustManager trustManager, @NotNull Method findByIssuerAndSignatureMethod) {
            Intrinsics.checkParameterIsNotNull((Object)trustManager, (String)"trustManager");
            Intrinsics.checkParameterIsNotNull((Object)findByIssuerAndSignatureMethod, (String)"findByIssuerAndSignatureMethod");
            return new CustomTrustRootIndex(trustManager, findByIssuerAndSignatureMethod);
        }

        @NotNull
        public static /* synthetic */ CustomTrustRootIndex copy$default(CustomTrustRootIndex customTrustRootIndex, X509TrustManager x509TrustManager, Method method, int n, Object object) {
            if ((n & 1) != 0) {
                x509TrustManager = customTrustRootIndex.trustManager;
            }
            if ((n & 2) != 0) {
                method = customTrustRootIndex.findByIssuerAndSignatureMethod;
            }
            return customTrustRootIndex.copy(x509TrustManager, method);
        }

        @NotNull
        public String toString() {
            return "CustomTrustRootIndex(trustManager=" + this.trustManager + ", findByIssuerAndSignatureMethod=" + this.findByIssuerAndSignatureMethod + ")";
        }

        public int hashCode() {
            X509TrustManager x509TrustManager = this.trustManager;
            Method method = this.findByIssuerAndSignatureMethod;
            return (x509TrustManager != null ? x509TrustManager.hashCode() : 0) * 31 + (method != null ? ((Object)method).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CustomTrustRootIndex)) break block3;
                    CustomTrustRootIndex customTrustRootIndex = (CustomTrustRootIndex)object;
                    if (!Intrinsics.areEqual((Object)this.trustManager, (Object)customTrustRootIndex.trustManager) || !Intrinsics.areEqual((Object)this.findByIssuerAndSignatureMethod, (Object)customTrustRootIndex.findByIssuerAndSignatureMethod)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lokhttp3/internal/platform/AndroidPlatform$Companion;", "", "()V", "MAX_LOG_LENGTH", "", "buildIfSupported", "Lokhttp3/internal/platform/Platform;", "okhttp"})
    public static final class Companion {
        @Nullable
        public final Platform buildIfSupported() {
            Class<?> sslParametersClass = null;
            Class<?> sslSocketClass = null;
            try {
                Class<?> clazz = Class.forName("com.android.org.conscrypt.SSLParametersImpl");
                Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(\"com.andro\u2026crypt.SSLParametersImpl\")");
                sslParametersClass = clazz;
                Class<?> clazz2 = Class.forName("com.android.org.conscrypt.OpenSSLSocketImpl");
                Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"Class.forName(\"com.andro\u2026crypt.OpenSSLSocketImpl\")");
                sslSocketClass = clazz2;
            }
            catch (ClassNotFoundException _) {
                return null;
            }
            if (Build.VERSION.SDK_INT >= 21) {
                try {
                    Method setUseSessionTickets = sslSocketClass.getDeclaredMethod("setUseSessionTickets", Boolean.TYPE);
                    Method setHostname = sslSocketClass.getMethod("setHostname", String.class);
                    Method getAlpnSelectedProtocol = sslSocketClass.getMethod("getAlpnSelectedProtocol", new Class[0]);
                    Method setAlpnProtocols = sslSocketClass.getMethod("setAlpnProtocols", byte[].class);
                    Method method = setUseSessionTickets;
                    Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"setUseSessionTickets");
                    Method method2 = setHostname;
                    Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"setHostname");
                    Method method3 = getAlpnSelectedProtocol;
                    Intrinsics.checkExpressionValueIsNotNull((Object)method3, (String)"getAlpnSelectedProtocol");
                    Method method4 = setAlpnProtocols;
                    Intrinsics.checkExpressionValueIsNotNull((Object)method4, (String)"setAlpnProtocols");
                    return new AndroidPlatform(sslParametersClass, sslSocketClass, method, method2, method3, method4);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            throw (Throwable)new IllegalStateException("Expected Android API level 21+ but was " + Build.VERSION.SDK_INT);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

