/*
 * Decompiled with CFR 0.152.
 */
package com.steelbridgelabs.oss.neo4j.structure;

import com.steelbridgelabs.oss.neo4j.structure.Neo4JBoltSupport;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JDatabaseCommand;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JElement;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JElementIdProvider;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JGraph;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JSession;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JVertex;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.types.Entity;
import org.neo4j.driver.v1.types.Relationship;

public class Neo4JEdge
extends Neo4JElement
implements Edge {
    private final Object id;
    private final Neo4JGraph graph;
    private final Neo4JSession session;
    private final Neo4JElementIdProvider<?> edgeIdProvider;
    private final Map<String, Neo4JEdgeProperty> properties = new HashMap<String, Neo4JEdgeProperty>();
    private final String label;
    private final Neo4JVertex out;
    private final Neo4JVertex in;
    private Object generatedId = null;
    private boolean dirty = false;
    private boolean newEdge;
    private Set<String> removedProperties = new HashSet<String>();
    private Map<String, Neo4JEdgeProperty> originalProperties;

    Neo4JEdge(Neo4JGraph graph, Neo4JSession session, Neo4JElementIdProvider<?> edgeIdProvider, String label, Neo4JVertex out, Neo4JVertex in) {
        Objects.requireNonNull(graph, "graph cannot be null");
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(edgeIdProvider, "edgeIdProvider cannot be null");
        Objects.requireNonNull(label, "label cannot be null");
        Objects.requireNonNull(this.properties, "properties cannot be null");
        Objects.requireNonNull(out, "out cannot be null");
        Objects.requireNonNull(in, "in cannot be null");
        this.graph = graph;
        this.session = session;
        this.edgeIdProvider = edgeIdProvider;
        this.label = label;
        this.out = out;
        this.in = in;
        this.id = edgeIdProvider.generate();
        this.originalProperties = new HashMap<String, Neo4JEdgeProperty>();
        this.newEdge = true;
    }

    Neo4JEdge(Neo4JGraph graph, Neo4JSession session, Neo4JElementIdProvider<?> edgeIdProvider, Neo4JVertex out, Relationship relationship, Neo4JVertex in) {
        Objects.requireNonNull(graph, "graph cannot be null");
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(edgeIdProvider, "edgeIdProvider cannot be null");
        Objects.requireNonNull(out, "out cannot be null");
        Objects.requireNonNull(relationship, "relationship cannot be null");
        Objects.requireNonNull(in, "in cannot be null");
        this.graph = graph;
        this.session = session;
        this.edgeIdProvider = edgeIdProvider;
        this.id = edgeIdProvider.get((Entity)relationship);
        this.label = relationship.type();
        String idFieldName = edgeIdProvider.fieldName();
        StreamSupport.stream(relationship.keys().spliterator(), false).filter(key -> !key.equals(idFieldName)).forEach(key -> {
            Value value = relationship.get(key);
            this.properties.put((String)key, new Neo4JEdgeProperty<Object>(this, (String)key, value.asObject()));
        });
        this.out = out;
        this.in = in;
        this.originalProperties = new HashMap<String, Neo4JEdgeProperty>(this.properties);
        this.newEdge = false;
    }

    public Iterator<Vertex> vertices(Direction direction) {
        this.graph.tx().readWrite();
        if (direction == Direction.OUT) {
            return Stream.of(this.out).iterator();
        }
        if (direction == Direction.IN) {
            return Stream.of(this.in).iterator();
        }
        return Stream.of(this.out, this.in).iterator();
    }

    public Object id() {
        return this.id != null ? this.id : this.generatedId;
    }

    public String label() {
        return this.label;
    }

    public Graph graph() {
        return this.graph;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean isTransient() {
        return this.newEdge;
    }

    public <V> Property<V> property(String name, V value) {
        ElementHelper.validateProperty((String)name, value);
        Neo4JBoltSupport.checkPropertyValue(value);
        this.graph.tx().readWrite();
        Neo4JEdgeProperty<V> propertyValue = new Neo4JEdgeProperty<V>(this, name, value);
        this.properties.put(name, propertyValue);
        this.session.dirtyEdge(this);
        this.dirty = true;
        return propertyValue;
    }

    public <V> Property<V> property(String key) {
        Objects.requireNonNull(key, "key cannot be null");
        Neo4JEdgeProperty propertyValue = this.properties.get(key);
        if (propertyValue != null) {
            return propertyValue;
        }
        return Property.empty();
    }

    public void remove() {
        this.graph.tx().readWrite();
        this.session.removeEdge(this, true);
    }

    public <V> Iterator<Property<V>> properties(String ... propertyKeys) {
        Objects.requireNonNull(propertyKeys, "propertyKeys cannot be null");
        if (propertyKeys.length == 1) {
            Property propertyValue = this.properties.get(propertyKeys[0]);
            if (propertyValue != null) {
                return Collections.singleton(propertyValue).iterator();
            }
            return Collections.emptyIterator();
        }
        if (propertyKeys.length == 0) {
            return this.properties.values().stream().map(value -> value).collect(Collectors.toList()).iterator();
        }
        return Arrays.stream(propertyKeys).map(key -> this.properties.get(key)).filter(Objects::nonNull).collect(Collectors.toList()).iterator();
    }

    private Map<String, Object> statementParameters() {
        Map<String, Object> parameters = this.properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Neo4JEdgeProperty)entry.getValue()).value()));
        this.removedProperties.forEach(name -> parameters.put((String)name, null));
        String idFieldName = this.edgeIdProvider.fieldName();
        if (this.id != null && idFieldName != null) {
            parameters.put(idFieldName, this.id);
        }
        return parameters;
    }

    @Override
    public Neo4JDatabaseCommand insertCommand() {
        Value parameters = Values.parameters((Object[])new Object[]{"oid", this.out.id(), "iid", this.in.id(), "ep", this.statementParameters()});
        if (this.id == null) {
            String statement = this.out.matchStatement("o", "oid") + " " + this.in.matchStatement("i", "iid") + " CREATE (o)-[r:`" + this.label + "`{ep}]->(i) RETURN " + this.edgeIdProvider.matchPredicateOperand("r");
            return new Neo4JDatabaseCommand(new Statement(statement, parameters), result -> {
                if (result.hasNext()) {
                    Record record = result.next();
                    this.generatedId = this.edgeIdProvider.processIdentifier(record.get(0).asObject());
                }
            });
        }
        String statement = this.out.matchStatement("o", "oid") + " " + this.in.matchStatement("i", "iid") + " CREATE (o)-[:`" + this.label + "`{ep}]->(i)";
        return new Neo4JDatabaseCommand(new Statement(statement, parameters));
    }

    @Override
    public Neo4JDatabaseCommand updateCommand() {
        if (this.dirty) {
            String statement = this.out.matchStatement("o", "oid") + " " + this.in.matchStatement("i", "iid") + " MATCH (o)-[r:`" + this.label + "`]->(i) WHERE " + this.edgeIdProvider.matchPredicateOperand("r") + " = {id} SET r = {rp}";
            Value parameters = Values.parameters((Object[])new Object[]{"oid", this.out.id(), "iid", this.in.id(), "id", this.id(), "rp", this.statementParameters()});
            return new Neo4JDatabaseCommand(new Statement(statement, parameters), result -> {});
        }
        return null;
    }

    @Override
    public Neo4JDatabaseCommand deleteCommand() {
        String statement = this.out.matchStatement("o", "oid") + " " + this.in.matchStatement("i", "iid") + " MATCH (o)-[r:`" + this.label + "`]->(i) WHERE " + this.edgeIdProvider.matchPredicateOperand("r") + " = {id} DELETE r";
        Value parameters = Values.parameters((Object[])new Object[]{"oid", this.out.id(), "iid", this.in.id(), "id", this.id()});
        return new Neo4JDatabaseCommand(new Statement(statement, parameters), result -> {});
    }

    void commit() {
        this.originalProperties = new HashMap<String, Neo4JEdgeProperty>(this.properties);
        this.removedProperties.clear();
        this.dirty = false;
        this.newEdge = false;
    }

    void rollback() {
        this.out.addOutEdge(this);
        this.in.addInEdge(this);
        this.properties.clear();
        this.properties.putAll(this.originalProperties);
        this.removedProperties.clear();
        this.dirty = false;
    }

    public boolean equals(Object object) {
        return object instanceof Edge && (this.id != null ? ElementHelper.areEqual((Element)this, (Object)object) : super.equals(object));
    }

    public int hashCode() {
        return this.id != null ? ElementHelper.hashCode((Element)this) : super.hashCode();
    }

    public String toString() {
        return StringFactory.edgeString((Edge)this);
    }

    private static class Neo4JEdgeProperty<T>
    implements Property<T> {
        private final Neo4JEdge edge;
        private final String name;
        private final T value;

        Neo4JEdgeProperty(Neo4JEdge edge, String name, T value) {
            Objects.requireNonNull(edge, "edge cannot be null");
            Objects.requireNonNull(name, "name cannot be null");
            Objects.requireNonNull(value, "value cannot be null");
            this.edge = edge;
            this.name = name;
            this.value = value;
        }

        public String key() {
            return this.name;
        }

        public T value() throws NoSuchElementException {
            return this.value;
        }

        public boolean isPresent() {
            return true;
        }

        public Element element() {
            return this.edge;
        }

        public void remove() {
            this.edge.properties.remove(this.name);
            this.edge.removedProperties.add(this.name);
            this.edge.dirty = true;
            this.edge.session.dirtyEdge(this.edge);
        }

        public boolean equals(Object object) {
            return object instanceof Property && ElementHelper.areEqual((Property)this, (Object)object);
        }

        public int hashCode() {
            return ElementHelper.hashCode((Property)this);
        }

        public String toString() {
            return StringFactory.propertyString((Property)this);
        }
    }
}

