/*
 * Decompiled with CFR 0.152.
 */
package com.steelbridgelabs.oss.neo4j.structure;

import com.steelbridgelabs.oss.neo4j.structure.Neo4JElementIdProvider;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JGraphFactory;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JGraphFeatures;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JReadPartition;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JSession;
import com.steelbridgelabs.oss.neo4j.structure.partitions.NoReadPartition;
import com.steelbridgelabs.oss.neo4j.structure.summary.ResultSummaryLogger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.AbstractThreadLocalTransaction;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactoryClass;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.TransactionException;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;

@Graph.OptIns(value={@Graph.OptIn(value="org.apache.tinkerpop.gremlin.structure.StructureStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessStandardSuite")})
@GraphFactoryClass(value=Neo4JGraphFactory.class)
public class Neo4JGraph
implements Graph {
    private final Neo4JReadPartition partition;
    private final Set<String> vertexLabels;
    private final Driver driver;
    private final Neo4JElementIdProvider<?> vertexIdProvider;
    private final Neo4JElementIdProvider<?> edgeIdProvider;
    private final ThreadLocal<Neo4JSession> session = ThreadLocal.withInitial(() -> null);
    private final Neo4JTransaction transaction = new Neo4JTransaction();
    private final Configuration configuration;
    private final boolean readonly;
    private final Iterable<String> bookmarks;
    private final Set<Consumer<Neo4JGraph>> closeListeners = new HashSet<Consumer<Neo4JGraph>>();

    public Neo4JGraph(Driver driver, Neo4JElementIdProvider<?> vertexIdProvider, Neo4JElementIdProvider<?> edgeIdProvider) {
        Objects.requireNonNull(driver, "driver cannot be null");
        Objects.requireNonNull(vertexIdProvider, "vertexIdProvider cannot be null");
        Objects.requireNonNull(edgeIdProvider, "edgeIdProvider cannot be null");
        this.partition = new NoReadPartition();
        this.vertexLabels = Collections.emptySet();
        this.driver = driver;
        this.vertexIdProvider = vertexIdProvider;
        this.edgeIdProvider = edgeIdProvider;
        this.configuration = null;
        this.readonly = false;
        this.bookmarks = null;
    }

    public Neo4JGraph(Driver driver, Neo4JElementIdProvider<?> vertexIdProvider, Neo4JElementIdProvider<?> edgeIdProvider, boolean readonly, String ... bookmarks) {
        Objects.requireNonNull(driver, "driver cannot be null");
        Objects.requireNonNull(vertexIdProvider, "vertexIdProvider cannot be null");
        Objects.requireNonNull(edgeIdProvider, "edgeIdProvider cannot be null");
        this.partition = new NoReadPartition();
        this.vertexLabels = Collections.emptySet();
        this.driver = driver;
        this.vertexIdProvider = vertexIdProvider;
        this.edgeIdProvider = edgeIdProvider;
        this.configuration = null;
        this.readonly = readonly;
        this.bookmarks = Arrays.asList(bookmarks);
    }

    public Neo4JGraph(Neo4JReadPartition partition, String[] vertexLabels, Driver driver, Neo4JElementIdProvider<?> vertexIdProvider, Neo4JElementIdProvider<?> edgeIdProvider) {
        Objects.requireNonNull(partition, "partition cannot be null");
        Objects.requireNonNull(vertexLabels, "vertexLabels cannot be null");
        Objects.requireNonNull(driver, "driver cannot be null");
        Objects.requireNonNull(vertexIdProvider, "vertexIdProvider cannot be null");
        Objects.requireNonNull(edgeIdProvider, "edgeIdProvider cannot be null");
        this.partition = partition;
        this.vertexLabels = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(vertexLabels)));
        this.driver = driver;
        if (!partition.containsVertex(this.vertexLabels)) {
            throw new IllegalArgumentException("Invalid vertexLabels, vertices created by the graph will not be part of the given partition");
        }
        this.vertexIdProvider = vertexIdProvider;
        this.edgeIdProvider = edgeIdProvider;
        this.configuration = null;
        this.readonly = false;
        this.bookmarks = null;
    }

    public Neo4JGraph(Neo4JReadPartition partition, String[] vertexLabels, Driver driver, Neo4JElementIdProvider<?> vertexIdProvider, Neo4JElementIdProvider<?> edgeIdProvider, boolean readonly, String ... bookmarks) {
        Objects.requireNonNull(partition, "partition cannot be null");
        Objects.requireNonNull(vertexLabels, "vertexLabels cannot be null");
        Objects.requireNonNull(driver, "driver cannot be null");
        Objects.requireNonNull(vertexIdProvider, "vertexIdProvider cannot be null");
        Objects.requireNonNull(edgeIdProvider, "edgeIdProvider cannot be null");
        this.partition = partition;
        this.vertexLabels = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(vertexLabels)));
        this.driver = driver;
        if (!partition.containsVertex(this.vertexLabels)) {
            throw new IllegalArgumentException("Invalid vertexLabels, vertices created by the graph will not be part of the given partition");
        }
        this.vertexIdProvider = vertexIdProvider;
        this.edgeIdProvider = edgeIdProvider;
        this.configuration = null;
        this.readonly = readonly;
        this.bookmarks = Arrays.asList(bookmarks);
    }

    Neo4JGraph(Neo4JReadPartition partition, String[] vertexLabels, Driver driver, Neo4JElementIdProvider<?> vertexIdProvider, Neo4JElementIdProvider<?> edgeIdProvider, Configuration configuration, boolean readonly, String ... bookmarks) {
        Objects.requireNonNull(partition, "partition cannot be null");
        Objects.requireNonNull(vertexLabels, "vertexLabels cannot be null");
        Objects.requireNonNull(driver, "driver cannot be null");
        Objects.requireNonNull(vertexIdProvider, "vertexIdProvider cannot be null");
        Objects.requireNonNull(edgeIdProvider, "edgeIdProvider cannot be null");
        Objects.requireNonNull(configuration, "configuration cannot be null");
        this.partition = partition;
        this.vertexLabels = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(vertexLabels)));
        this.driver = driver;
        if (!partition.containsVertex(this.vertexLabels)) {
            throw new IllegalArgumentException("Invalid vertexLabels, vertices created by the graph will not be part of the given partition");
        }
        this.vertexIdProvider = vertexIdProvider;
        this.edgeIdProvider = edgeIdProvider;
        this.configuration = configuration;
        this.readonly = readonly;
        this.bookmarks = Arrays.asList(bookmarks);
    }

    Neo4JSession currentSession() {
        Neo4JSession session = this.session.get();
        if (session == null) {
            session = new Neo4JSession(this, this.driver.session(this.readonly ? AccessMode.READ : AccessMode.WRITE, this.bookmarks), this.vertexIdProvider, this.edgeIdProvider, this.readonly);
            this.session.set(session);
        }
        return session;
    }

    public Neo4JReadPartition getPartition() {
        return this.partition;
    }

    public Neo4JElementIdProvider<?> getVertexIdProvider() {
        return this.vertexIdProvider;
    }

    public Neo4JElementIdProvider<?> getEdgeIdProvider() {
        return this.edgeIdProvider;
    }

    public Set<String> vertexLabels() {
        return this.vertexLabels;
    }

    public String lastBookmark() {
        Neo4JSession session = this.currentSession();
        return session.lastBookmark();
    }

    public Vertex addVertex(Object ... keyValues) {
        if (this.readonly) {
            throw Graph.Exceptions.vertexAdditionsNotSupported();
        }
        Neo4JSession session = this.currentSession();
        this.transaction.readWrite();
        return session.addVertex(keyValues);
    }

    public void createIndex(String label, String propertyName) {
        Objects.requireNonNull(label, "label cannot be null");
        Objects.requireNonNull(propertyName, "propertyName cannot be null");
        Neo4JSession session = this.currentSession();
        this.transaction.readWrite();
        session.executeStatement(new Statement("CREATE INDEX ON :`" + label + "`(" + propertyName + ")"));
    }

    public <C extends GraphComputer> C compute(Class<C> implementation) throws IllegalArgumentException {
        throw Graph.Exceptions.graphComputerNotSupported();
    }

    public GraphComputer compute() throws IllegalArgumentException {
        throw Graph.Exceptions.graphComputerNotSupported();
    }

    public Iterator<Vertex> vertices(Object ... ids) {
        Neo4JSession session = this.currentSession();
        this.transaction.readWrite();
        return session.vertices(ids);
    }

    public Iterator<Vertex> vertices(Statement statement) {
        Objects.requireNonNull(statement, "statement cannot be null");
        Neo4JSession session = this.currentSession();
        this.transaction.readWrite();
        StatementResult result = session.executeStatement(statement);
        Iterator<Vertex> iterator = session.vertices(result).collect(Collectors.toCollection(LinkedList::new)).iterator();
        ResultSummaryLogger.log(result.consume());
        return iterator;
    }

    public Iterator<Vertex> vertices(String statement) {
        Objects.requireNonNull(statement, "statement cannot be null");
        return this.vertices(new Statement(statement));
    }

    public Iterator<Vertex> vertices(String statement, Map<String, Object> parameters) {
        Objects.requireNonNull(statement, "statement cannot be null");
        Objects.requireNonNull(parameters, "parameters cannot be null");
        return this.vertices(new Statement(statement, parameters));
    }

    public Iterator<Edge> edges(Object ... ids) {
        Neo4JSession session = this.currentSession();
        this.transaction.readWrite();
        return session.edges(ids);
    }

    public Iterator<Edge> edges(Statement statement) {
        Objects.requireNonNull(statement, "statement cannot be null");
        Neo4JSession session = this.currentSession();
        this.transaction.readWrite();
        StatementResult result = session.executeStatement(statement);
        Iterator<Edge> iterator = session.edges(result).collect(Collectors.toCollection(LinkedList::new)).iterator();
        ResultSummaryLogger.log(result.consume());
        return iterator;
    }

    public Iterator<Edge> edges(String statement) {
        Objects.requireNonNull(statement, "statement cannot be null");
        return this.edges(new Statement(statement));
    }

    public Iterator<Edge> edges(String statement, Map<String, Object> parameters) {
        Objects.requireNonNull(statement, "statement cannot be null");
        Objects.requireNonNull(parameters, "parameters cannot be null");
        return this.edges(new Statement(statement, parameters));
    }

    public StatementResult execute(Statement statement) {
        Objects.requireNonNull(statement, "statement cannot be null");
        Neo4JSession session = this.currentSession();
        this.transaction.readWrite();
        return session.executeStatement(statement);
    }

    public StatementResult execute(String statement) {
        Objects.requireNonNull(statement, "statement cannot be null");
        return this.execute(new Statement(statement));
    }

    public StatementResult execute(String statement, Map<String, Object> parameters) {
        Objects.requireNonNull(statement, "statement cannot be null");
        Objects.requireNonNull(parameters, "parameters cannot be null");
        return this.execute(new Statement(statement, parameters));
    }

    public boolean isProfilerEnabled() {
        Neo4JSession session = this.currentSession();
        return session.isProfilerEnabled();
    }

    public void setProfilerEnabled(boolean value) {
        Neo4JSession session = this.currentSession();
        session.setProfilerEnabled(value);
    }

    public Transaction tx() {
        return this.transaction;
    }

    public Graph.Variables variables() {
        throw Graph.Exceptions.variablesNotSupported();
    }

    public Configuration configuration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Neo4JSession session = this.session.get();
        if (session != null) {
            session.close();
            this.session.remove();
        }
        Set<Consumer<Neo4JGraph>> set = this.closeListeners;
        synchronized (set) {
            this.closeListeners.forEach(consumer -> consumer.accept(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCloseListener(Consumer<Neo4JGraph> consumer) {
        Objects.requireNonNull(consumer, "consumer cannot be null");
        Set<Consumer<Neo4JGraph>> set = this.closeListeners;
        synchronized (set) {
            this.closeListeners.add(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCloseListener(Consumer<Neo4JGraph> consumer) {
        Objects.requireNonNull(consumer, "consumer cannot be null");
        Set<Consumer<Neo4JGraph>> set = this.closeListeners;
        synchronized (set) {
            this.closeListeners.remove(consumer);
        }
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, (String)"");
    }

    public Graph.Features features() {
        return new Neo4JGraphFeatures(this.readonly);
    }

    private class Neo4JTransaction
    extends AbstractThreadLocalTransaction {
        Neo4JTransaction() {
            super((Graph)Neo4JGraph.this);
        }

        protected void doOpen() {
            Neo4JSession session = Neo4JGraph.this.currentSession();
            session.beginTransaction();
        }

        protected void doCommit() throws TransactionException {
            Neo4JSession session = Neo4JGraph.this.currentSession();
            session.commit();
        }

        protected void doRollback() throws TransactionException {
            Neo4JSession session = Neo4JGraph.this.currentSession();
            session.rollback();
        }

        public boolean isOpen() {
            Neo4JSession session = Neo4JGraph.this.currentSession();
            return session.isTransactionOpen();
        }

        protected void doClose() {
            super.doClose();
            Neo4JSession session = Neo4JGraph.this.currentSession();
            session.closeTransaction();
        }
    }
}

