/*
 * Decompiled with CFR 0.152.
 */
package com.steelbridgelabs.oss.neo4j.structure;

import java.util.Objects;
import java.util.UUID;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;

public final class Neo4JGraphConfigurationBuilder {
    public static final String Neo4JGraphNameConfigurationKey = "neo4j.graph.name";
    public static final String Neo4JIdentifierConfigurationKey = "neo4j.identifier";
    public static final String Neo4JUrlConfigurationKey = "neo4j.url";
    public static final String Neo4JHostnameConfigurationKey = "neo4j.hostname";
    public static final String Neo4JPortConfigurationKey = "neo4j.port";
    public static final String Neo4JUsernameConfigurationKey = "neo4j.username";
    public static final String Neo4JPasswordConfigurationKey = "neo4j.password";
    public static final String Neo4JReadonlyConfigurationKey = "neo4j.readonly";
    public static final String Neo4JVertexIdProviderClassNameConfigurationKey = "neo4j.vertexIdProvider";
    public static final String Neo4JEdgeIdProviderClassNameConfigurationKey = "neo4j.edgeIdProvider";
    public static final String Neo4JPropertyIdProviderClassNameConfigurationKey = "neo4j.propertyIdProvider";
    private final String hostname;
    private final short port;
    private final String username;
    private final String password;
    private final boolean readonly;
    private String graphName;
    private String identifier;
    private String vertexIdProviderClassName = null;
    private String edgeIdProviderClassName = null;
    private String propertyIdProviderClassName = null;
    private String elementIdProviderClassName = null;

    private Neo4JGraphConfigurationBuilder(String hostname, short port, String username, String password, boolean readonly) {
        Objects.requireNonNull(hostname, "hostname cannot be null");
        Objects.requireNonNull(username, "username cannot be null");
        Objects.requireNonNull(password, "password cannot be null");
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
        this.readonly = readonly;
    }

    public static Neo4JGraphConfigurationBuilder connect(String hostname, short port, String username, String password) {
        return new Neo4JGraphConfigurationBuilder(hostname, port, username, password, false);
    }

    public static Neo4JGraphConfigurationBuilder connect(String hostname, short port, String username, String password, boolean readonly) {
        return new Neo4JGraphConfigurationBuilder(hostname, port, username, password, readonly);
    }

    public static Neo4JGraphConfigurationBuilder connect(String hostname, String username, String password) {
        return new Neo4JGraphConfigurationBuilder(hostname, 7687, username, password, false);
    }

    public static Neo4JGraphConfigurationBuilder connect(String hostname, String username, String password, boolean readonly) {
        return new Neo4JGraphConfigurationBuilder(hostname, 7687, username, password, readonly);
    }

    public Neo4JGraphConfigurationBuilder withIdentifier(String identifier) {
        Objects.requireNonNull(identifier, "identifier cannot be null");
        this.identifier = identifier;
        return this;
    }

    public Neo4JGraphConfigurationBuilder withName(String graphName) {
        this.graphName = graphName;
        return this;
    }

    public Neo4JGraphConfigurationBuilder withVertexIdProvider(Class<?> provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        this.vertexIdProviderClassName = provider.getName();
        return this;
    }

    public Neo4JGraphConfigurationBuilder withEdgeIdProvider(Class<?> provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        this.edgeIdProviderClassName = provider.getName();
        return this;
    }

    public Neo4JGraphConfigurationBuilder withPropertyIdProvider(Class<?> provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        this.propertyIdProviderClassName = provider.getName();
        return this;
    }

    public Neo4JGraphConfigurationBuilder withElementIdProvider(Class<?> provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        this.elementIdProviderClassName = provider.getName();
        return this;
    }

    public Configuration build() {
        BaseConfiguration configuration = new BaseConfiguration();
        configuration.setProperty(Neo4JIdentifierConfigurationKey, (Object)(this.identifier != null ? this.identifier : UUID.randomUUID().toString()));
        configuration.setProperty(Neo4JUrlConfigurationKey, (Object)("bolt://" + this.hostname + ":" + this.port));
        configuration.setProperty(Neo4JHostnameConfigurationKey, (Object)this.hostname);
        configuration.setProperty(Neo4JPortConfigurationKey, (Object)this.port);
        configuration.setProperty(Neo4JUsernameConfigurationKey, (Object)this.username);
        configuration.setProperty(Neo4JPasswordConfigurationKey, (Object)this.password);
        configuration.setProperty(Neo4JReadonlyConfigurationKey, (Object)this.readonly);
        configuration.setProperty(Neo4JGraphNameConfigurationKey, (Object)this.graphName);
        configuration.setProperty(Neo4JVertexIdProviderClassNameConfigurationKey, (Object)(this.vertexIdProviderClassName != null ? this.vertexIdProviderClassName : this.elementIdProviderClassName));
        configuration.setProperty(Neo4JEdgeIdProviderClassNameConfigurationKey, (Object)(this.edgeIdProviderClassName != null ? this.edgeIdProviderClassName : this.elementIdProviderClassName));
        configuration.setProperty(Neo4JPropertyIdProviderClassNameConfigurationKey, (Object)(this.propertyIdProviderClassName != null ? this.propertyIdProviderClassName : this.elementIdProviderClassName));
        return configuration;
    }
}

