/*
 * Decompiled with CFR 0.152.
 */
package com.steelbridgelabs.oss.neo4j.structure;

import com.steelbridgelabs.oss.neo4j.structure.Neo4JElementIdProvider;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JGraph;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JReadPartition;
import com.steelbridgelabs.oss.neo4j.structure.partitions.AnyLabelReadPartition;
import com.steelbridgelabs.oss.neo4j.structure.partitions.NoReadPartition;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;

public class Neo4JGraphFactory {
    private static final Map<String, Driver> instances = new ConcurrentHashMap<String, Driver>();

    public static Graph open(Configuration configuration) {
        if (configuration == null) {
            throw Graph.Exceptions.argumentCanNotBeNull((String)"configuration");
        }
        try {
            String graphName = configuration.getString("neo4j.graph.name");
            Driver driver = Neo4JGraphFactory.createDriverInstance(configuration);
            Neo4JElementIdProvider<?> vertexIdProvider = Neo4JGraphFactory.loadProvider(driver, configuration.getString("neo4j.vertexIdProvider"));
            Neo4JElementIdProvider<?> edgeIdProvider = Neo4JGraphFactory.loadProvider(driver, configuration.getString("neo4j.edgeIdProvider"));
            boolean readonly = configuration.getBoolean("neo4j.readonly");
            Neo4JGraph graph = graphName != null ? new Neo4JGraph((Neo4JReadPartition)new AnyLabelReadPartition(graphName), new String[]{graphName}, driver, vertexIdProvider, edgeIdProvider, configuration, readonly, new String[0]) : new Neo4JGraph((Neo4JReadPartition)new NoReadPartition(), new String[0], driver, vertexIdProvider, edgeIdProvider, configuration, readonly, new String[0]);
            return graph;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Error creating Graph instance from configuration", ex);
        }
    }

    static Driver createDriverInstance(Configuration configuration) {
        Objects.requireNonNull(configuration, "configuration cannot be null");
        String identifier = Objects.requireNonNull(configuration.getString("neo4j.identifier"), "Configuration does not contain identifier value");
        return instances.computeIfAbsent(identifier, key -> {
            Config config = Config.build().toConfig();
            return GraphDatabase.driver((String)configuration.getString("neo4j.url"), (AuthToken)AuthTokens.basic((String)configuration.getString("neo4j.username"), (String)configuration.getString("neo4j.password")), (Config)config);
        });
    }

    static Neo4JElementIdProvider<?> loadProvider(Driver driver, String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (className != null) {
            Class<?> type = Class.forName(className);
            try {
                Constructor<?> constructor = type.getConstructor(Driver.class);
                return (Neo4JElementIdProvider)constructor.newInstance(driver);
            }
            catch (NoSuchMethodException | InvocationTargetException ex) {
                return (Neo4JElementIdProvider)type.newInstance();
            }
        }
        return null;
    }
}

