/*
 * Decompiled with CFR 0.152.
 */
package com.steelbridgelabs.oss.neo4j.structure;

import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.FeatureDescriptor;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class Neo4JGraphFeatures
implements Graph.Features {
    private final Graph.Features.GraphFeatures graphFeatures = new Neo4JGraphGraphFeatures();
    private final Graph.Features.VertexFeatures vertexFeatures;
    private final Graph.Features.EdgeFeatures edgeFeatures;

    Neo4JGraphFeatures(boolean readonly) {
        this.vertexFeatures = new Neo4JVertexFeatures(readonly);
        this.edgeFeatures = new Neo4JEdgeFeatures(readonly);
    }

    public Graph.Features.GraphFeatures graph() {
        return this.graphFeatures;
    }

    public Graph.Features.VertexFeatures vertex() {
        return this.vertexFeatures;
    }

    public Graph.Features.EdgeFeatures edge() {
        return this.edgeFeatures;
    }

    public String toString() {
        return StringFactory.featureString((Graph.Features)this);
    }

    private static class Neo4JElementFeatures
    implements Graph.Features.ElementFeatures {
        private final boolean readonly;

        Neo4JElementFeatures(boolean readonly) {
            this.readonly = readonly;
        }

        @FeatureDescriptor(name="AddProperty")
        public boolean supportsAddProperty() {
            return !this.readonly;
        }

        @FeatureDescriptor(name="RemoveProperty")
        public boolean supportsRemoveProperty() {
            return !this.readonly;
        }

        @FeatureDescriptor(name="UserSuppliedIds")
        public boolean supportsUserSuppliedIds() {
            return false;
        }

        @FeatureDescriptor(name="StringIds")
        public boolean supportsStringIds() {
            return false;
        }

        @FeatureDescriptor(name="UuidIds")
        public boolean supportsUuidIds() {
            return false;
        }

        @FeatureDescriptor(name="AnyIds")
        public boolean supportsAnyIds() {
            return false;
        }

        @FeatureDescriptor(name="CustomIds")
        public boolean supportsCustomIds() {
            return false;
        }
    }

    private static class Neo4JEdgeFeatures
    extends Neo4JElementFeatures
    implements Graph.Features.EdgeFeatures {
        private final Graph.Features.EdgePropertyFeatures edgePropertyFeatures = new Neo4JEdgePropertyFeatures();
        private final boolean readonly;

        Neo4JEdgeFeatures(boolean readonly) {
            super(readonly);
            this.readonly = readonly;
        }

        @FeatureDescriptor(name="AddEdges")
        public boolean supportsAddEdges() {
            return !this.readonly;
        }

        @FeatureDescriptor(name="RemoveEdges")
        public boolean supportsRemoveEdges() {
            return !this.readonly;
        }

        public Graph.Features.EdgePropertyFeatures properties() {
            return this.edgePropertyFeatures;
        }

        private static class Neo4JEdgePropertyFeatures
        implements Graph.Features.EdgePropertyFeatures {
            private Neo4JEdgePropertyFeatures() {
            }

            @FeatureDescriptor(name="SerializableValues")
            public boolean supportsSerializableValues() {
                return false;
            }

            @FeatureDescriptor(name="ByteValues")
            public boolean supportsByteValues() {
                return false;
            }

            @FeatureDescriptor(name="FloatValues")
            public boolean supportsFloatValues() {
                return false;
            }

            @FeatureDescriptor(name="IntegerValues")
            public boolean supportsIntegerValues() {
                return false;
            }

            @FeatureDescriptor(name="MapValues")
            public boolean supportsMapValues() {
                return false;
            }

            @FeatureDescriptor(name="MixedListValues")
            public boolean supportsMixedListValues() {
                return false;
            }

            @FeatureDescriptor(name="BooleanArrayValues")
            public boolean supportsBooleanArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="ByteArrayValues")
            public boolean supportsByteArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="DoubleArrayValues")
            public boolean supportsDoubleArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="FloatArrayValues")
            public boolean supportsFloatArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="IntegerArrayValues")
            public boolean supportsIntegerArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="StringArrayValues")
            public boolean supportsStringArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="LongArrayValues")
            public boolean supportsLongArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="UniformListValues")
            public boolean supportsUniformListValues() {
                return false;
            }
        }
    }

    private static class Neo4JVertexFeatures
    extends Neo4JElementFeatures
    implements Graph.Features.VertexFeatures {
        private final Graph.Features.VertexPropertyFeatures vertexPropertyFeatures;
        private final boolean readonly;

        Neo4JVertexFeatures(boolean readonly) {
            super(readonly);
            this.readonly = readonly;
            this.vertexPropertyFeatures = new Neo4JVertexPropertyFeatures(readonly);
        }

        @FeatureDescriptor(name="AddVertices")
        public boolean supportsAddVertices() {
            return !this.readonly;
        }

        @FeatureDescriptor(name="RemoveVertices")
        public boolean supportsRemoveVertices() {
            return !this.readonly;
        }

        public Graph.Features.VertexPropertyFeatures properties() {
            return this.vertexPropertyFeatures;
        }

        @FeatureDescriptor(name="MetaProperties")
        public boolean supportsMetaProperties() {
            return false;
        }

        @FeatureDescriptor(name="MultiProperties")
        public boolean supportsMultiProperties() {
            return false;
        }

        public VertexProperty.Cardinality getCardinality(String key) {
            return VertexProperty.Cardinality.single;
        }

        private static class Neo4JVertexPropertyFeatures
        implements Graph.Features.VertexPropertyFeatures {
            private final boolean readonly;

            Neo4JVertexPropertyFeatures(boolean readonly) {
                this.readonly = readonly;
            }

            @FeatureDescriptor(name="RemoveProperty")
            public boolean supportsRemoveProperty() {
                return !this.readonly;
            }

            @FeatureDescriptor(name="UserSuppliedIds")
            public boolean supportsUserSuppliedIds() {
                return false;
            }

            @FeatureDescriptor(name="StringIds")
            public boolean supportsStringIds() {
                return false;
            }

            @FeatureDescriptor(name="UuidIds")
            public boolean supportsUuidIds() {
                return false;
            }

            @FeatureDescriptor(name="CustomIds")
            public boolean supportsCustomIds() {
                return false;
            }

            @FeatureDescriptor(name="AnyIds")
            public boolean supportsAnyIds() {
                return false;
            }

            @FeatureDescriptor(name="SerializableValues")
            public boolean supportsSerializableValues() {
                return false;
            }

            @FeatureDescriptor(name="ByteValues")
            public boolean supportsByteValues() {
                return false;
            }

            @FeatureDescriptor(name="FloatValues")
            public boolean supportsFloatValues() {
                return false;
            }

            @FeatureDescriptor(name="IntegerValues")
            public boolean supportsIntegerValues() {
                return false;
            }

            @FeatureDescriptor(name="MapValues")
            public boolean supportsMapValues() {
                return false;
            }

            @FeatureDescriptor(name="MixedListValues")
            public boolean supportsMixedListValues() {
                return false;
            }

            @FeatureDescriptor(name="BooleanArrayValues")
            public boolean supportsBooleanArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="ByteArrayValues")
            public boolean supportsByteArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="DoubleArrayValues")
            public boolean supportsDoubleArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="FloatArrayValues")
            public boolean supportsFloatArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="IntegerArrayValues")
            public boolean supportsIntegerArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="StringArrayValues")
            public boolean supportsStringArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="LongArrayValues")
            public boolean supportsLongArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="UniformListValues")
            public boolean supportsUniformListValues() {
                return false;
            }
        }
    }

    private static class Neo4JGraphGraphFeatures
    implements Graph.Features.GraphFeatures {
        private Graph.Features.VariableFeatures variableFeatures = new Neo4JVariableFeatures();

        private Neo4JGraphGraphFeatures() {
        }

        public Graph.Features.VariableFeatures variables() {
            return this.variableFeatures;
        }

        @FeatureDescriptor(name="Computer")
        public boolean supportsComputer() {
            return false;
        }

        @FeatureDescriptor(name="ThreadedTransactions")
        public boolean supportsThreadedTransactions() {
            return false;
        }

        private static class Neo4JVariableFeatures
        implements Graph.Features.VariableFeatures {
            private Neo4JVariableFeatures() {
            }

            @FeatureDescriptor(name="BooleanValues")
            public boolean supportsBooleanValues() {
                return false;
            }

            @FeatureDescriptor(name="ByteValues")
            public boolean supportsByteValues() {
                return false;
            }

            @FeatureDescriptor(name="DoubleValues")
            public boolean supportsDoubleValues() {
                return false;
            }

            @FeatureDescriptor(name="FloatValues")
            public boolean supportsFloatValues() {
                return false;
            }

            @FeatureDescriptor(name="IntegerValues")
            public boolean supportsIntegerValues() {
                return false;
            }

            @FeatureDescriptor(name="LongValues")
            public boolean supportsLongValues() {
                return false;
            }

            @FeatureDescriptor(name="MapValues")
            public boolean supportsMapValues() {
                return false;
            }

            @FeatureDescriptor(name="MixedListValues")
            public boolean supportsMixedListValues() {
                return false;
            }

            @FeatureDescriptor(name="BooleanArrayValues")
            public boolean supportsBooleanArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="ByteArrayValues")
            public boolean supportsByteArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="DoubleArrayValues")
            public boolean supportsDoubleArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="FloatArrayValues")
            public boolean supportsFloatArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="IntegerArrayValues")
            public boolean supportsIntegerArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="StringArrayValues")
            public boolean supportsStringArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="LongArrayValues")
            public boolean supportsLongArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="SerializableValues")
            public boolean supportsSerializableValues() {
                return false;
            }

            @FeatureDescriptor(name="StringValues")
            public boolean supportsStringValues() {
                return false;
            }

            @FeatureDescriptor(name="UniformListValues")
            public boolean supportsUniformListValues() {
                return false;
            }
        }
    }
}

