/*
 * Decompiled with CFR 0.152.
 */
package com.steelbridgelabs.oss.neo4j.structure;

import com.steelbridgelabs.oss.neo4j.structure.Neo4JDatabaseCommand;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JEdge;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JElementIdProvider;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JGraph;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JReadPartition;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JVertex;
import com.steelbridgelabs.oss.neo4j.structure.summary.ResultSummaryLogger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.types.Entity;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.driver.v1.types.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Neo4JSession
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Neo4JSession.class);
    private final Neo4JGraph graph;
    private final Neo4JReadPartition partition;
    private final Session session;
    private final Neo4JElementIdProvider<?> vertexIdProvider;
    private final Neo4JElementIdProvider<?> edgeIdProvider;
    private final Map<Object, Neo4JVertex> vertices = new HashMap<Object, Neo4JVertex>();
    private final Map<Object, Neo4JEdge> edges = new HashMap<Object, Neo4JEdge>();
    private final Set<Object> deletedVertices = new HashSet<Object>();
    private final Set<Object> deletedEdges = new HashSet<Object>();
    private final Set<Neo4JVertex> transientVertices = new HashSet<Neo4JVertex>();
    private final Set<Neo4JEdge> transientEdges = new HashSet<Neo4JEdge>();
    private final Map<Object, Neo4JVertex> transientVertexIndex = new HashMap<Object, Neo4JVertex>();
    private final Map<Object, Neo4JEdge> transientEdgeIndex = new HashMap<Object, Neo4JEdge>();
    private final Set<Neo4JVertex> vertexUpdateQueue = new HashSet<Neo4JVertex>();
    private final Set<Neo4JEdge> edgeUpdateQueue = new HashSet<Neo4JEdge>();
    private final Set<Neo4JVertex> vertexDeleteQueue = new HashSet<Neo4JVertex>();
    private final Set<Neo4JEdge> edgeDeleteQueue = new HashSet<Neo4JEdge>();
    private final boolean readonly;
    private Transaction transaction;
    private boolean verticesLoaded = false;
    private boolean edgesLoaded = false;
    private boolean profilerEnabled = false;

    Neo4JSession(Neo4JGraph graph, Session session, Neo4JElementIdProvider<?> vertexIdProvider, Neo4JElementIdProvider<?> edgeIdProvider, boolean readonly) {
        Objects.requireNonNull(graph, "graph cannot be null");
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(vertexIdProvider, "vertexIdProvider cannot be null");
        Objects.requireNonNull(edgeIdProvider, "edgeIdProvider cannot be null");
        if (logger.isDebugEnabled()) {
            logger.debug("Creating session [{}]", (Object)session.hashCode());
        }
        this.graph = graph;
        this.partition = graph.getPartition();
        this.session = session;
        this.vertexIdProvider = vertexIdProvider;
        this.edgeIdProvider = edgeIdProvider;
        this.readonly = readonly;
    }

    public Transaction beginTransaction() {
        if (this.transaction != null && this.transaction.isOpen()) {
            throw Transaction.Exceptions.transactionAlreadyOpen();
        }
        this.transaction = this.session.beginTransaction();
        if (logger.isDebugEnabled()) {
            logger.debug("Beginning transaction on session [{}]-[{}]", (Object)this.session.hashCode(), (Object)this.transaction.hashCode());
        }
        return this.transaction;
    }

    boolean isTransactionOpen() {
        return this.transaction != null && this.transaction.isOpen();
    }

    void commit() {
        if (this.transaction != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Committing transaction [{}]", (Object)this.transaction.hashCode());
            }
            this.transaction.success();
            this.flush();
            this.transaction.close();
            this.transientVertices.forEach(Neo4JVertex::commit);
            this.transientEdges.forEach(Neo4JEdge::commit);
            this.vertexUpdateQueue.forEach(Neo4JVertex::commit);
            this.edgeUpdateQueue.forEach(Neo4JEdge::commit);
            this.transientVertices.forEach(vertex -> this.vertices.put(vertex.id(), (Neo4JVertex)vertex));
            this.transientEdges.forEach(edge -> this.edges.put(edge.id(), (Neo4JEdge)edge));
            this.deletedEdges.clear();
            this.edgeDeleteQueue.clear();
            this.deletedVertices.clear();
            this.vertexDeleteQueue.clear();
            this.transientEdges.clear();
            this.transientVertices.clear();
            this.transientVertexIndex.clear();
            this.transientEdgeIndex.clear();
            this.vertexUpdateQueue.clear();
            this.edgeUpdateQueue.clear();
            if (logger.isDebugEnabled()) {
                logger.debug("Successfully committed transaction [{}]", (Object)this.transaction.hashCode());
            }
            this.transaction = null;
        }
    }

    void rollback() {
        if (this.transaction != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Rolling back transaction [{}]", (Object)this.transaction.hashCode());
            }
            this.transaction.failure();
            this.transaction.close();
            if (!this.vertexUpdateQueue.isEmpty() || !this.deletedVertices.isEmpty()) {
                this.verticesLoaded = false;
            }
            if (!this.edgeUpdateQueue.isEmpty() || !this.deletedEdges.isEmpty()) {
                this.edgesLoaded = false;
            }
            this.vertexUpdateQueue.forEach(Neo4JVertex::rollback);
            this.edgeUpdateQueue.forEach(Neo4JEdge::rollback);
            this.vertexDeleteQueue.forEach(vertex -> {
                this.vertices.put(vertex.id(), (Neo4JVertex)vertex);
                vertex.rollback();
            });
            this.edgeDeleteQueue.forEach(edge -> {
                this.edges.put(edge.id(), (Neo4JEdge)edge);
                edge.rollback();
            });
            this.deletedEdges.clear();
            this.edgeDeleteQueue.clear();
            this.deletedVertices.clear();
            this.vertexDeleteQueue.clear();
            this.transientEdges.clear();
            this.transientVertices.clear();
            this.transientVertexIndex.clear();
            this.transientEdgeIndex.clear();
            this.vertexUpdateQueue.clear();
            this.edgeUpdateQueue.clear();
            if (logger.isDebugEnabled()) {
                logger.debug("Successfully rolled-back transaction [{}]", (Object)this.transaction.hashCode());
            }
            this.transaction = null;
        }
    }

    void closeTransaction() {
        if (this.transaction != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Closing transaction [{}]", (Object)this.transaction.hashCode());
            }
            this.transaction.close();
            this.transaction = null;
        }
    }

    String lastBookmark() {
        return this.session.lastBookmark();
    }

    Neo4JVertex addVertex(Object ... keyValues) {
        Objects.requireNonNull(keyValues, "keyValues cannot be null");
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        if (ElementHelper.getIdValue((Object[])keyValues).isPresent()) {
            throw Vertex.Exceptions.userSuppliedIdsNotSupported();
        }
        Neo4JVertex vertex = new Neo4JVertex(this.graph, this, this.vertexIdProvider, this.edgeIdProvider, Arrays.asList(ElementHelper.getLabelValue((Object[])keyValues).orElse("vertex").split("::")));
        this.transientVertices.add(vertex);
        ElementHelper.attachProperties((Vertex)vertex, (Object[])keyValues);
        Object id = vertex.id();
        if (id != null) {
            this.transientVertexIndex.put(id, vertex);
        }
        return vertex;
    }

    Neo4JEdge addEdge(String label, Neo4JVertex out, Neo4JVertex in, Object ... keyValues) {
        Objects.requireNonNull(label, "label cannot be null");
        Objects.requireNonNull(out, "out cannot be null");
        Objects.requireNonNull(in, "in cannot be null");
        Objects.requireNonNull(keyValues, "keyValues cannot be null");
        ElementHelper.validateLabel((String)label);
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        if (ElementHelper.getIdValue((Object[])keyValues).isPresent()) {
            throw Vertex.Exceptions.userSuppliedIdsNotSupported();
        }
        Neo4JEdge edge = new Neo4JEdge(this.graph, this, this.edgeIdProvider, label, out, in);
        this.transientEdges.add(edge);
        ElementHelper.attachProperties((Element)edge, (Object[])keyValues);
        out.addOutEdge(edge);
        in.addInEdge(edge);
        Object id = edge.id();
        if (id != null) {
            this.transientEdgeIndex.put(id, edge);
        }
        return edge;
    }

    private String generateVertexMatchPattern(String alias) {
        Set<String> labels = this.partition.vertexMatchPatternLabels();
        if (!labels.isEmpty()) {
            return "(" + alias + labels.stream().map(label -> ":`" + label + "`").collect(Collectors.joining("")) + ")";
        }
        return "(" + alias + ")";
    }

    boolean isProfilerEnabled() {
        return this.profilerEnabled;
    }

    void setProfilerEnabled(boolean profilerEnabled) {
        this.profilerEnabled = profilerEnabled;
    }

    public Iterator<Vertex> vertices(Object[] ids) {
        Objects.requireNonNull(ids, "ids cannot be null");
        Neo4JSession.verifyIdentifiers(Vertex.class, ids);
        if (!this.verticesLoaded) {
            if (ids.length > 0) {
                Set identifiers = Arrays.stream(ids).map(id -> Neo4JSession.processIdentifier(this.vertexIdProvider, id)).collect(Collectors.toSet());
                List filter = identifiers.stream().filter(id -> !this.vertices.containsKey(id) && !this.transientVertexIndex.containsKey(id)).collect(Collectors.toList());
                if (!filter.isEmpty()) {
                    String predicate = this.partition.vertexMatchPredicate("n");
                    if (filter.size() == 1) {
                        Statement statement = new Statement("MATCH " + this.generateVertexMatchPattern("n") + " WHERE " + this.vertexIdProvider.matchPredicateOperand("n") + " = {id}" + (predicate != null ? " AND " + predicate : "") + " RETURN n", Values.parameters((Object[])new Object[]{"id", filter.get(0)}));
                        StatementResult result = this.executeStatement(statement);
                        Stream<Vertex> query = this.vertices(result);
                        Iterator<Vertex> iterator = Neo4JSession.combine(Stream.concat(identifiers.stream().filter(this.vertices::containsKey).map(id -> this.vertices.get(id)), identifiers.stream().filter(this.transientVertexIndex::containsKey).map(id -> this.transientVertexIndex.get(id))), query);
                        ResultSummaryLogger.log(result.consume());
                        return iterator;
                    }
                    Statement statement = new Statement("MATCH " + this.generateVertexMatchPattern("n") + " WHERE " + this.vertexIdProvider.matchPredicateOperand("n") + " IN {ids}" + (predicate != null ? " AND " + predicate : "") + " RETURN n", Values.parameters((Object[])new Object[]{"ids", filter}));
                    StatementResult result = this.executeStatement(statement);
                    Stream<Vertex> query = this.vertices(result);
                    Iterator<Vertex> iterator = Neo4JSession.combine(Stream.concat(identifiers.stream().filter(this.vertices::containsKey).map(id -> this.vertices.get(id)), identifiers.stream().filter(this.transientVertexIndex::containsKey).map(id -> this.transientVertexIndex.get(id))), query);
                    ResultSummaryLogger.log(result.consume());
                    return iterator;
                }
                return Neo4JSession.combine(identifiers.stream().filter(this.vertices::containsKey).map(id -> this.vertices.get(id)), identifiers.stream().filter(this.transientVertexIndex::containsKey).map(id -> this.transientVertexIndex.get(id)));
            }
            String predicate = this.partition.vertexMatchPredicate("n");
            Statement statement = new Statement("MATCH " + this.generateVertexMatchPattern("n") + (predicate != null ? " WHERE " + predicate : "") + " RETURN n");
            StatementResult result = this.executeStatement(statement);
            Stream<Vertex> query = this.vertices(result);
            Iterator<Vertex> iterator = Neo4JSession.combine(this.transientVertices.stream().map(vertex -> vertex), query);
            ResultSummaryLogger.log(result.consume());
            this.verticesLoaded = true;
            return iterator;
        }
        if (ids.length > 0) {
            Set identifiers = Arrays.stream(ids).map(id -> Neo4JSession.processIdentifier(this.vertexIdProvider, id)).collect(Collectors.toSet());
            return Neo4JSession.combine(identifiers.stream().filter(this.vertices::containsKey).map(id -> this.vertices.get(id)), identifiers.stream().filter(this.transientVertexIndex::containsKey).map(id -> this.transientVertexIndex.get(id)));
        }
        return Neo4JSession.combine(this.transientVertices.stream().map(vertex -> vertex), this.vertices.values().stream().map(vertex -> vertex));
    }

    Stream<Vertex> vertices(StatementResult result) {
        Objects.requireNonNull(result, "result cannot be null");
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(result, 1280), false).map(this::loadVertex).filter(Objects::nonNull);
    }

    Iterator<Edge> edges(Object[] ids) {
        Objects.requireNonNull(ids, "ids cannot be null");
        Neo4JSession.verifyIdentifiers(Edge.class, ids);
        if (!this.edgesLoaded) {
            if (ids.length > 0) {
                Set identifiers = Arrays.stream(ids).map(id -> Neo4JSession.processIdentifier(this.edgeIdProvider, id)).collect(Collectors.toSet());
                List filter = identifiers.stream().filter(id -> !this.edges.containsKey(id) && !this.transientEdgeIndex.containsKey(id)).collect(Collectors.toList());
                if (!filter.isEmpty()) {
                    if (filter.size() == 1) {
                        Statement statement = new Statement("MATCH " + this.generateVertexMatchPattern("n") + "-[r]->" + this.generateVertexMatchPattern("m") + " WHERE " + this.edgeIdProvider.matchPredicateOperand("r") + " = {id}" + (this.partition.usesMatchPredicate() ? " AND " + this.partition.vertexMatchPredicate("n") + " AND " + this.partition.vertexMatchPredicate("m") : "") + " RETURN n, r, m", Values.parameters((Object[])new Object[]{"id", filter.get(0)}));
                        StatementResult result = this.executeStatement(statement);
                        Stream<Edge> query = this.edges(result);
                        Iterator<Edge> iterator = Neo4JSession.combine(Stream.concat(identifiers.stream().filter(this.edges::containsKey).map(id -> this.edges.get(id)), identifiers.stream().filter(this.transientEdgeIndex::containsKey).map(id -> this.transientEdgeIndex.get(id))), query);
                        ResultSummaryLogger.log(result.consume());
                        return iterator;
                    }
                    Statement statement = new Statement("MATCH " + this.generateVertexMatchPattern("n") + "-[r]->" + this.generateVertexMatchPattern("m") + " WHERE " + this.edgeIdProvider.matchPredicateOperand("r") + " in {ids}" + (this.partition.usesMatchPredicate() ? " AND " + this.partition.vertexMatchPredicate("n") + " AND " + this.partition.vertexMatchPredicate("m") : "") + " RETURN n, r, m", Values.parameters((Object[])new Object[]{"ids", filter}));
                    StatementResult result = this.executeStatement(statement);
                    Stream<Edge> query = this.edges(result);
                    Iterator<Edge> iterator = Neo4JSession.combine(Stream.concat(identifiers.stream().filter(this.edges::containsKey).map(id -> this.edges.get(id)), identifiers.stream().filter(this.transientEdgeIndex::containsKey).map(id -> this.transientEdgeIndex.get(id))), query);
                    ResultSummaryLogger.log(result.consume());
                    return iterator;
                }
                return Neo4JSession.combine(identifiers.stream().filter(this.edges::containsKey).map(id -> this.edges.get(id)), identifiers.stream().filter(this.transientEdgeIndex::containsKey).map(id -> this.transientEdgeIndex.get(id)));
            }
            Statement statement = new Statement("MATCH " + this.generateVertexMatchPattern("n") + "-[r]->" + this.generateVertexMatchPattern("m") + (this.partition.usesMatchPredicate() ? " WHERE " + this.partition.vertexMatchPredicate("n") + " AND " + this.partition.vertexMatchPredicate("m") : "") + " RETURN n, r, m");
            StatementResult result = this.executeStatement(statement);
            Stream<Edge> query = this.edges(result);
            Iterator<Edge> iterator = Neo4JSession.combine(this.transientEdges.stream().map(edge -> edge), query);
            ResultSummaryLogger.log(result.consume());
            this.edgesLoaded = true;
            return iterator;
        }
        if (ids.length > 0) {
            Set identifiers = Arrays.stream(ids).map(id -> Neo4JSession.processIdentifier(this.edgeIdProvider, id)).collect(Collectors.toSet());
            return Neo4JSession.combine(identifiers.stream().filter(this.edges::containsKey).map(id -> this.edges.get(id)), identifiers.stream().filter(this.transientEdgeIndex::containsKey).map(id -> this.transientEdgeIndex.get(id)));
        }
        return Neo4JSession.combine(this.transientEdges.stream().map(edge -> edge), this.edges.values().stream().map(edge -> edge));
    }

    Stream<Edge> edges(StatementResult result) {
        Objects.requireNonNull(result, "result cannot be null");
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(result, 1280), false).map(this::loadEdge).filter(Objects::nonNull);
    }

    private static <T> Iterator<T> combine(Stream<T> collection, Stream<T> query) {
        List copy = collection.collect(Collectors.toCollection(LinkedList::new));
        query.forEach(copy::add);
        return copy.iterator();
    }

    void removeEdge(Neo4JEdge edge, boolean explicit) {
        Object id = edge.id();
        if (this.transientEdges.contains(edge)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Deleting transient edge: {}", (Object)edge);
            }
            if (explicit) {
                edge.vertices(Direction.BOTH).forEachRemaining(vertex -> ((Neo4JVertex)vertex).removeEdge(edge));
            }
            this.transientEdges.remove(edge);
            if (id != null) {
                this.transientEdgeIndex.remove(id);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Deleting edge: {}", (Object)edge);
            }
            this.deletedEdges.add(id);
            if (explicit) {
                edge.vertices(Direction.BOTH).forEachRemaining(vertex -> ((Neo4JVertex)vertex).removeEdge(edge));
                this.edgeDeleteQueue.add(edge);
            }
            this.edgeUpdateQueue.remove(edge);
        }
        this.edges.remove(id);
    }

    private static <T> void verifyIdentifiers(Class<T> elementClass, Object ... ids) {
        Object first;
        Class<?> firstClass;
        if (ids.length > 0 && (elementClass.isAssignableFrom(firstClass = (first = ids[0]).getClass()) ? !Stream.of(ids).allMatch(id -> elementClass.isAssignableFrom(id.getClass())) : !Stream.of(ids).map(Object::getClass).allMatch(firstClass::equals))) {
            throw Graph.Exceptions.idArgsMustBeEitherIdOrElement();
        }
    }

    private static Object processIdentifier(Neo4JElementIdProvider provider, Object id) {
        if (id instanceof Vertex) {
            return ((Vertex)id).id();
        }
        if (id instanceof Edge) {
            return ((Edge)id).id();
        }
        return provider.processIdentifier(id);
    }

    private Vertex loadVertex(Record record) {
        Node node = record.get(0).asNode();
        Object vertexId = this.vertexIdProvider.get((Entity)node);
        if (!this.deletedVertices.contains(vertexId)) {
            Vertex vertex = this.vertices.get(vertexId);
            if (vertex == null) {
                if (this.partition.containsVertex(StreamSupport.stream(node.labels().spliterator(), false).collect(Collectors.toSet()))) {
                    return this.registerVertex(new Neo4JVertex(this.graph, this, this.vertexIdProvider, this.edgeIdProvider, node));
                }
                return null;
            }
            return vertex;
        }
        return null;
    }

    private Edge loadEdge(Record record) {
        Relationship relationship = record.get(1).asRelationship();
        Object edgeId = this.edgeIdProvider.get((Entity)relationship);
        if (!this.deletedEdges.contains(edgeId)) {
            Neo4JEdge edge = this.edges.get(edgeId);
            if (edge == null) {
                Neo4JVertex secondVertex;
                Node firstNode = record.get(0).asNode();
                Node secondNode = record.get(2).asNode();
                Object firstNodeId = this.vertexIdProvider.get((Entity)firstNode);
                Object secondNodeId = this.vertexIdProvider.get((Entity)secondNode);
                if (this.deletedVertices.contains(firstNodeId) || this.deletedVertices.contains(secondNodeId) || !this.partition.containsVertex(StreamSupport.stream(firstNode.labels().spliterator(), false).collect(Collectors.toSet())) || !this.partition.containsVertex(StreamSupport.stream(secondNode.labels().spliterator(), false).collect(Collectors.toSet()))) {
                    return null;
                }
                Neo4JVertex firstVertex = this.vertices.get(firstNodeId);
                if (firstVertex == null) {
                    firstVertex = new Neo4JVertex(this.graph, this, this.vertexIdProvider, this.edgeIdProvider, firstNode);
                    this.registerVertex(firstVertex);
                }
                if ((secondVertex = this.vertices.get(secondNodeId)) == null) {
                    secondVertex = new Neo4JVertex(this.graph, this, this.vertexIdProvider, this.edgeIdProvider, secondNode);
                    this.registerVertex(secondVertex);
                }
                Neo4JVertex out = relationship.startNodeId() == firstNode.id() ? firstVertex : secondVertex;
                Neo4JVertex in = relationship.endNodeId() == firstNode.id() ? firstVertex : secondVertex;
                edge = new Neo4JEdge(this.graph, this, this.edgeIdProvider, out, relationship, in);
                out.addOutEdge(edge);
                in.addInEdge(edge);
                return this.registerEdge(edge);
            }
            return edge;
        }
        return null;
    }

    private Vertex registerVertex(Neo4JVertex vertex) {
        this.vertices.put(vertex.id(), vertex);
        return vertex;
    }

    private Edge registerEdge(Neo4JEdge edge) {
        Object id = edge.id();
        this.edges.put(id, edge);
        return edge;
    }

    void removeVertex(Neo4JVertex vertex) {
        Object id = vertex.id();
        if (this.transientVertices.contains(vertex)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Deleting transient vertex: {}", (Object)vertex);
            }
            this.transientVertices.remove(vertex);
            if (id != null) {
                this.transientVertexIndex.remove(id);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Deleting vertex: {}", (Object)vertex);
            }
            this.deletedVertices.add(id);
            this.vertexDeleteQueue.add(vertex);
            this.vertexUpdateQueue.remove(vertex);
            this.vertices.remove(id);
        }
    }

    void dirtyVertex(Neo4JVertex vertex) {
        if (!this.transientVertices.contains(vertex)) {
            this.vertexUpdateQueue.add(vertex);
        }
    }

    void dirtyEdge(Neo4JEdge edge) {
        if (!this.transientEdges.contains(edge)) {
            this.edgeUpdateQueue.add(edge);
        }
    }

    private void flush() {
        try {
            this.deleteEdges();
            this.deleteVertices();
            this.createVertices();
            this.createEdges();
            this.updateEdges();
            this.updateVertices();
        }
        catch (ClientException ex) {
            if (logger.isErrorEnabled()) {
                logger.error("Error committing transaction [{}]", (Object)this.transaction.hashCode(), (Object)ex);
            }
            throw ex;
        }
    }

    private void createVertices() {
        for (Neo4JVertex vertex : this.transientVertices) {
            Neo4JDatabaseCommand command = vertex.insertCommand();
            Statement statement = command.getStatement();
            StatementResult result = this.executeStatement(statement);
            command.getCallback().accept(result);
            ResultSummaryLogger.log(result.consume());
        }
    }

    private void updateVertices() {
        for (Neo4JVertex vertex : this.vertexUpdateQueue) {
            Neo4JDatabaseCommand command = vertex.updateCommand();
            if (command == null) continue;
            Statement statement = command.getStatement();
            StatementResult result = this.executeStatement(statement);
            command.getCallback().accept(result);
            ResultSummaryLogger.log(result.consume());
        }
    }

    private void deleteVertices() {
        for (Neo4JVertex vertex : this.vertexDeleteQueue) {
            Neo4JDatabaseCommand command = vertex.deleteCommand();
            Statement statement = command.getStatement();
            StatementResult result = this.executeStatement(statement);
            command.getCallback().accept(result);
            ResultSummaryLogger.log(result.consume());
        }
    }

    private void createEdges() {
        for (Neo4JEdge edge : this.transientEdges) {
            Neo4JDatabaseCommand command = edge.insertCommand();
            Statement statement = command.getStatement();
            StatementResult result = this.executeStatement(statement);
            command.getCallback().accept(result);
            ResultSummaryLogger.log(result.consume());
        }
    }

    private void updateEdges() {
        for (Neo4JEdge edge : this.edgeUpdateQueue) {
            Neo4JDatabaseCommand command = edge.updateCommand();
            if (command == null) continue;
            Statement statement = command.getStatement();
            StatementResult result = this.executeStatement(statement);
            command.getCallback().accept(result);
            ResultSummaryLogger.log(result.consume());
        }
    }

    private void deleteEdges() {
        for (Neo4JEdge edge : this.edgeDeleteQueue) {
            Neo4JDatabaseCommand command = edge.deleteCommand();
            Statement statement = command.getStatement();
            StatementResult result = this.executeStatement(statement);
            command.getCallback().accept(result);
            ResultSummaryLogger.log(result.consume());
        }
    }

    StatementResult executeStatement(Statement statement) {
        try {
            String text;
            Statement cypherStatement = statement;
            if (this.profilerEnabled && (text = cypherStatement.text()) != null && !(text = text.toUpperCase(Locale.US)).startsWith("PROFILE") && !text.startsWith("EXPLAIN")) {
                cypherStatement = new Statement("PROFILE " + statement.text(), statement.parameters());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Executing Cypher statement on transaction [{}]: {}", (Object)this.transaction.hashCode(), (Object)cypherStatement.toString());
            }
            return this.transaction.run(cypherStatement);
        }
        catch (ClientException ex) {
            if (logger.isErrorEnabled()) {
                logger.error("Error executing Cypher statement on transaction [{}]", (Object)this.transaction.hashCode(), (Object)ex);
            }
            throw ex;
        }
    }

    @Override
    public void close() {
        this.closeTransaction();
        if (logger.isDebugEnabled()) {
            logger.debug("Closing neo4j session [{}]", (Object)this.session.hashCode());
        }
        this.session.close();
    }

    protected void finalize() throws Throwable {
        if (this.session.isOpen() && logger.isErrorEnabled()) {
            logger.error("Finalizing Neo4JSession [{}] without explicit call to close(), the code is leaking sessions!", (Object)this.session.hashCode());
        }
        super.finalize();
    }
}

