/*
 * Decompiled with CFR 0.152.
 */
package com.steelbridgelabs.oss.neo4j.structure;

import com.steelbridgelabs.oss.neo4j.structure.Neo4JBoltSupport;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JDatabaseCommand;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JEdge;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JElement;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JElementIdProvider;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JGraph;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JReadPartition;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JSession;
import com.steelbridgelabs.oss.neo4j.structure.summary.ResultSummaryLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.neo4j.driver.internal.types.TypeRepresentation;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.types.Entity;
import org.neo4j.driver.v1.types.Node;

public class Neo4JVertex
extends Neo4JElement
implements Vertex {
    public static final String LabelDelimiter = "::";
    private static final AtomicLong propertyIdProvider = new AtomicLong(0L);
    private final Object id;
    private final Neo4JGraph graph;
    private final Neo4JReadPartition partition;
    private final Neo4JSession session;
    private final Neo4JElementIdProvider<?> vertexIdProvider;
    private final Neo4JElementIdProvider<?> edgeIdProvider;
    private final Map<String, Collection<VertexProperty>> properties = new HashMap<String, Collection<VertexProperty>>();
    private final Map<String, VertexProperty.Cardinality> cardinalities = new HashMap<String, VertexProperty.Cardinality>();
    private final Set<Neo4JEdge> outEdges = new HashSet<Neo4JEdge>();
    private final Set<Neo4JEdge> inEdges = new HashSet<Neo4JEdge>();
    private final Set<String> outEdgeLabels = new HashSet<String>();
    private final Set<String> inEdgeLabels = new HashSet<String>();
    private final SortedSet<String> labelsAdded = new TreeSet<String>();
    private final SortedSet<String> labelsRemoved = new TreeSet<String>();
    private final SortedSet<String> labels;
    private final Set<String> additionalLabels;
    private Object generatedId = null;
    private boolean outEdgesLoaded = false;
    private boolean inEdgesLoaded = false;
    private boolean dirty = false;
    private SortedSet<String> matchLabels;
    private SortedSet<String> originalLabels;
    private Set<String> graphLabels;
    private Set<String> removedProperties = new HashSet<String>();
    private Map<String, Collection<VertexProperty>> originalProperties;
    private Map<String, VertexProperty.Cardinality> originalCardinalities;

    Neo4JVertex(Neo4JGraph graph, Neo4JSession session, Neo4JElementIdProvider<?> vertexIdProvider, Neo4JElementIdProvider<?> edgeIdProvider, Collection<String> labels) {
        Objects.requireNonNull(graph, "graph cannot be null");
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(vertexIdProvider, "vertexIdProvider cannot be null");
        Objects.requireNonNull(edgeIdProvider, "edgeIdProvider cannot be null");
        Objects.requireNonNull(labels, "labels cannot be null");
        this.graph = graph;
        this.partition = graph.getPartition();
        this.additionalLabels = graph.vertexLabels();
        this.session = session;
        this.vertexIdProvider = vertexIdProvider;
        this.edgeIdProvider = edgeIdProvider;
        this.labels = new TreeSet<String>(labels);
        this.originalLabels = Collections.emptySortedSet();
        this.matchLabels = Collections.emptySortedSet();
        this.graphLabels = this.additionalLabels;
        this.originalProperties = new HashMap<String, Collection<VertexProperty>>();
        this.originalCardinalities = new HashMap<String, VertexProperty.Cardinality>();
        this.id = vertexIdProvider.generate();
        this.outEdgesLoaded = true;
        this.inEdgesLoaded = true;
    }

    Neo4JVertex(Neo4JGraph graph, Neo4JSession session, Neo4JElementIdProvider<?> vertexIdProvider, Neo4JElementIdProvider<?> edgeIdProvider, Node node) {
        Objects.requireNonNull(graph, "graph cannot be null");
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(vertexIdProvider, "vertexIdProvider cannot be null");
        Objects.requireNonNull(edgeIdProvider, "edgeIdProvider cannot be null");
        Objects.requireNonNull(node, "node cannot be null");
        this.graph = graph;
        this.partition = graph.getPartition();
        this.additionalLabels = graph.vertexLabels();
        this.session = session;
        this.vertexIdProvider = vertexIdProvider;
        this.edgeIdProvider = edgeIdProvider;
        this.id = vertexIdProvider.get((Entity)node);
        this.graphLabels = StreamSupport.stream(node.labels().spliterator(), false).filter(label -> this.additionalLabels.contains(label) && !this.partition.validateLabel((String)label)).collect(Collectors.toSet());
        this.labels = StreamSupport.stream(node.labels().spliterator(), false).filter(label -> !this.graphLabels.contains(label)).collect(Collectors.toCollection(TreeSet::new));
        this.originalLabels = new TreeSet<String>(this.labels);
        this.matchLabels = StreamSupport.stream(node.labels().spliterator(), false).collect(Collectors.toCollection(TreeSet::new));
        String idFieldName = vertexIdProvider.fieldName();
        StreamSupport.stream(node.keys().spliterator(), false).filter(key -> !key.equals(idFieldName)).forEach(key -> {
            Value value = node.get(key);
            TypeRepresentation type = (TypeRepresentation)value.type();
            switch (type.constructor()) {
                case LIST: {
                    this.properties.put((String)key, value.asList().stream().map(item -> new Neo4JVertexProperty<Object>(this, propertyIdProvider.incrementAndGet(), (String)key, item)).collect(Collectors.toList()));
                    this.cardinalities.put((String)key, VertexProperty.Cardinality.list);
                    break;
                }
                case MAP: {
                    throw new RuntimeException("TODO: implement maps");
                }
                default: {
                    this.properties.put((String)key, (Collection<VertexProperty>)Collections.singletonList(new Neo4JVertexProperty<Object>(this, propertyIdProvider.incrementAndGet(), (String)key, value.asObject())));
                    this.cardinalities.put((String)key, VertexProperty.Cardinality.single);
                }
            }
        });
        this.originalProperties = new HashMap<String, Collection<VertexProperty>>(this.properties);
        this.originalCardinalities = new HashMap<String, VertexProperty.Cardinality>(this.cardinalities);
    }

    public Object id() {
        return this.id != null ? this.id : this.generatedId;
    }

    public String label() {
        return this.labels.stream().collect(Collectors.joining(LabelDelimiter));
    }

    public String[] labels() {
        return this.labels.toArray(new String[this.labels.size()]);
    }

    public boolean addLabel(String label) {
        Objects.requireNonNull(label, "label cannot be null");
        if (!this.partition.validateLabel(label)) {
            throw new IllegalArgumentException("Invalid label, label name cannot be the same as Graph partition labels");
        }
        if (this.labels.add(label)) {
            this.session.dirtyVertex(this);
            this.labelsAdded.add(label);
            return true;
        }
        return false;
    }

    public boolean removeLabel(String label) {
        Objects.requireNonNull(label, "label cannot be null");
        if (!this.partition.validateLabel(label)) {
            throw new IllegalArgumentException("Invalid label, label name cannot be removed since it is part of the Graph partition");
        }
        if (this.additionalLabels.contains(label)) {
            throw new IllegalArgumentException("Invalid label, label name cannot be removed since it is part of additional labels for vertices");
        }
        if (this.labels.remove(label)) {
            if (!this.labelsAdded.remove(label)) {
                this.session.dirtyVertex(this);
                this.labelsRemoved.add(label);
            }
            return true;
        }
        return false;
    }

    public String matchPattern(String alias) {
        if (alias != null) {
            return "(" + alias + this.processLabels(this.matchLabels, false) + ")";
        }
        return "(" + this.processLabels(this.matchLabels, false) + ")";
    }

    public String matchPredicate(String alias, String idParameterName) {
        Objects.requireNonNull(alias, "alias cannot be null");
        Objects.requireNonNull(idParameterName, "idParameterName cannot be null");
        Neo4JReadPartition partition = this.graph.getPartition();
        return this.vertexIdProvider.matchPredicateOperand(alias) + " = {" + idParameterName + "}" + (partition.usesMatchPredicate() ? " AND (" + partition.vertexMatchPredicate(alias) + ")" : "");
    }

    public String matchStatement(String alias, String idParameterName) {
        Objects.requireNonNull(alias, "alias cannot be null");
        Objects.requireNonNull(idParameterName, "idParameterName cannot be null");
        return "MATCH " + this.matchPattern(alias) + " WHERE " + this.matchPredicate(alias, idParameterName);
    }

    @Override
    public boolean isDirty() {
        return this.dirty || !this.labelsAdded.isEmpty() || !this.labelsRemoved.isEmpty();
    }

    @Override
    public boolean isTransient() {
        return this.originalLabels.isEmpty();
    }

    public Edge addEdge(String label, Vertex vertex, Object ... keyValues) {
        ElementHelper.validateLabel((String)label);
        if (vertex == null) {
            throw Graph.Exceptions.argumentCanNotBeNull((String)"vertex");
        }
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        this.graph.tx().readWrite();
        return this.session.addEdge(label, this, (Neo4JVertex)vertex, keyValues);
    }

    void removeEdge(Neo4JEdge edge) {
        this.outEdges.remove(edge);
        this.inEdges.remove(edge);
    }

    private void processEdgesWhereClause(String vertexAlias, List<Object> identifiers, String alias, StringBuilder builder, Map<String, Object> parameters) {
        String predicate = this.partition.vertexMatchPredicate(vertexAlias);
        if (!identifiers.isEmpty()) {
            builder.append(" AND NOT ").append(this.edgeIdProvider.matchPredicateOperand(alias)).append(" IN {ids}");
            parameters.put("ids", identifiers);
            if (predicate != null) {
                builder.append(" AND ").append(predicate);
            }
        } else if (predicate != null) {
            builder.append(" AND ").append(predicate);
        }
    }

    public Iterator<Edge> edges(Direction direction, String ... labels) {
        Objects.requireNonNull(direction, "direction cannot be null");
        Objects.requireNonNull(labels, "labels cannot be null");
        this.graph.tx().readWrite();
        HashSet<String> set = new HashSet<String>(Arrays.asList(labels));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", this.id());
        if (direction == Direction.OUT) {
            if (!this.outEdgesLoaded) {
                Set relationshipLabels = set.stream().filter(item -> !this.outEdgeLabels.contains(item)).collect(Collectors.toSet());
                if (set.isEmpty() || !relationshipLabels.isEmpty()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("MATCH ").append(this.matchPattern("n")).append("-[r").append(relationshipLabels.stream().map(label -> ":`" + label + "`").collect(Collectors.joining("|"))).append("]->(m").append(this.processLabels(Collections.emptySet(), true)).append(")").append(" WHERE ").append(this.vertexIdProvider.matchPredicateOperand("n")).append(" = {id}");
                    List<Object> identifiers = this.outEdges.stream().map(Neo4JEdge::id).filter(Objects::nonNull).collect(Collectors.toList());
                    this.processEdgesWhereClause("m", identifiers, "r", builder, parameters);
                    builder.append(" RETURN n, r, m");
                    Statement statement = new Statement(builder.toString(), parameters);
                    StatementResult result = this.session.executeStatement(statement);
                    Stream<Edge> query = this.session.edges(result);
                    Iterator<Edge> iterator = Stream.concat((labels.length != 0 ? this.outEdges.stream().filter(edge -> set.contains(edge.label())) : this.outEdges.stream()).map(edge -> edge), query).collect(Collectors.toList()).iterator();
                    ResultSummaryLogger.log(result.consume());
                    this.outEdgesLoaded = labels.length == 0;
                    this.outEdgeLabels.addAll(set);
                    return iterator;
                }
            }
            return this.outEdges.stream().filter(edge -> labels.length == 0 || set.contains(edge.label())).map(edge -> edge).collect(Collectors.toList()).iterator();
        }
        if (direction == Direction.IN) {
            if (!this.inEdgesLoaded) {
                Set relationshipLabels = set.stream().filter(item -> !this.inEdgeLabels.contains(item)).collect(Collectors.toSet());
                if (set.isEmpty() || !relationshipLabels.isEmpty()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("MATCH ").append(this.matchPattern("n")).append("<-[r").append(relationshipLabels.stream().map(label -> ":`" + label + "`").collect(Collectors.joining("|"))).append("]-(m").append(this.processLabels(Collections.emptySet(), true)).append(")").append(" WHERE ").append(this.vertexIdProvider.matchPredicateOperand("n")).append(" = {id}");
                    List<Object> identifiers = this.inEdges.stream().map(Neo4JEdge::id).filter(Objects::nonNull).collect(Collectors.toList());
                    this.processEdgesWhereClause("m", identifiers, "r", builder, parameters);
                    builder.append(" RETURN n, r, m");
                    Statement statement = new Statement(builder.toString(), parameters);
                    StatementResult result = this.session.executeStatement(statement);
                    Stream<Edge> query = this.session.edges(result);
                    Iterator<Edge> iterator = Stream.concat((labels.length != 0 ? this.inEdges.stream().filter(edge -> set.contains(edge.label())) : this.inEdges.stream()).map(edge -> edge), query).collect(Collectors.toList()).iterator();
                    ResultSummaryLogger.log(result.consume());
                    this.inEdgesLoaded = labels.length == 0;
                    this.inEdgeLabels.addAll(set);
                    return iterator;
                }
            }
            return this.inEdges.stream().filter(edge -> labels.length == 0 || set.contains(edge.label())).map(edge -> edge).collect(Collectors.toList()).iterator();
        }
        if (!(this.outEdgesLoaded && this.inEdgesLoaded || !set.isEmpty() && this.outEdgeLabels.containsAll(set) && this.inEdgeLabels.containsAll(set))) {
            StringBuilder builder = new StringBuilder();
            builder.append("MATCH ").append(this.matchPattern("n")).append("-[r").append(set.stream().map(label -> ":`" + label + "`").collect(Collectors.joining("|"))).append("]-(m").append(this.processLabels(Collections.emptySet(), true)).append(")").append(" WHERE ").append(this.vertexIdProvider.matchPredicateOperand("n")).append(" = {id}");
            List<Object> identifiers = Stream.concat(this.outEdges.stream(), this.inEdges.stream()).map(Neo4JEdge::id).filter(Objects::nonNull).collect(Collectors.toList());
            this.processEdgesWhereClause("m", identifiers, "r", builder, parameters);
            builder.append(" RETURN n, r, m");
            Statement statement = new Statement(builder.toString(), parameters);
            StatementResult result = this.session.executeStatement(statement);
            Stream<Edge> query = this.session.edges(result);
            Iterator<Edge> iterator = Stream.concat(Stream.concat(labels.length != 0 ? this.outEdges.stream().filter(edge -> set.contains(edge.label())) : this.outEdges.stream(), labels.length != 0 ? this.inEdges.stream().filter(edge -> set.contains(edge.label())) : this.inEdges.stream()).map(edge -> edge), query).collect(Collectors.toList()).iterator();
            ResultSummaryLogger.log(result.consume());
            this.outEdgesLoaded = this.outEdgesLoaded || labels.length == 0;
            this.inEdgesLoaded = this.inEdgesLoaded || labels.length == 0;
            this.outEdgeLabels.addAll(set);
            this.inEdgeLabels.addAll(set);
            return iterator;
        }
        return Stream.concat(labels.length != 0 ? this.inEdges.stream().filter(edge -> set.contains(edge.label())) : this.inEdges.stream(), labels.length != 0 ? this.outEdges.stream().filter(edge -> set.contains(edge.label())) : this.outEdges.stream()).map(edge -> edge).collect(Collectors.toList()).iterator();
    }

    public Iterator<Vertex> vertices(Direction direction, String ... labels) {
        Objects.requireNonNull(direction, "direction cannot be null");
        Objects.requireNonNull(labels, "labels cannot be null");
        this.graph.tx().readWrite();
        HashSet<String> set = new HashSet<String>(Arrays.asList(labels));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", this.id());
        if (direction == Direction.OUT) {
            if (!this.outEdgesLoaded) {
                Set relationshipLabels = set.stream().filter(item -> !this.outEdgeLabels.contains(item)).collect(Collectors.toSet());
                if (set.isEmpty() || !relationshipLabels.isEmpty()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("MATCH ").append(this.matchPattern("n")).append("-[r").append(relationshipLabels.stream().map(label -> ":`" + label + "`").collect(Collectors.joining("|"))).append("]->(m").append(this.processLabels(Collections.emptySet(), true)).append(")").append(" WHERE ").append(this.vertexIdProvider.matchPredicateOperand("n")).append(" = {id}");
                    List<Object> identifiers = this.outEdges.stream().map(Neo4JEdge::id).filter(Objects::nonNull).collect(Collectors.toList());
                    this.processEdgesWhereClause("m", identifiers, "r", builder, parameters);
                    builder.append(" RETURN m");
                    Statement statement = new Statement(builder.toString(), parameters);
                    StatementResult result = this.session.executeStatement(statement);
                    Stream<Vertex> query = this.session.vertices(result);
                    Iterator<Vertex> iterator = Stream.concat((labels.length != 0 ? this.outEdges.stream().filter(edge -> set.contains(edge.label())) : this.outEdges.stream()).map(Edge::inVertex), query).collect(Collectors.toList()).iterator();
                    ResultSummaryLogger.log(result.consume());
                    return iterator;
                }
            }
            return (labels.length != 0 ? this.outEdges.stream().filter(edge -> set.contains(edge.label())) : this.outEdges.stream()).map(Edge::inVertex).collect(Collectors.toList()).iterator();
        }
        if (direction == Direction.IN) {
            if (!this.inEdgesLoaded) {
                Set relationshipLabels = set.stream().filter(item -> !this.inEdgeLabels.contains(item)).collect(Collectors.toSet());
                if (set.isEmpty() || !relationshipLabels.isEmpty()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("MATCH ").append(this.matchPattern("n")).append("<-[r").append(relationshipLabels.stream().map(label -> ":`" + label + "`").collect(Collectors.joining("|"))).append("]-(m").append(this.processLabels(Collections.emptySet(), true)).append(")").append(" WHERE ").append(this.vertexIdProvider.matchPredicateOperand("n")).append(" = {id}");
                    List<Object> identifiers = this.inEdges.stream().map(Neo4JEdge::id).filter(Objects::nonNull).collect(Collectors.toList());
                    this.processEdgesWhereClause("m", identifiers, "r", builder, parameters);
                    builder.append(" RETURN m");
                    Statement statement = new Statement(builder.toString(), parameters);
                    StatementResult result = this.session.executeStatement(statement);
                    Stream<Vertex> query = this.session.vertices(result);
                    Iterator<Vertex> iterator = Stream.concat((labels.length != 0 ? this.inEdges.stream().filter(edge -> set.contains(edge.label())) : this.inEdges.stream()).map(Edge::outVertex), query).collect(Collectors.toList()).iterator();
                    ResultSummaryLogger.log(result.consume());
                    return iterator;
                }
            }
            return (labels.length != 0 ? this.inEdges.stream().filter(edge -> set.contains(edge.label())) : this.inEdges.stream()).map(Edge::outVertex).collect(Collectors.toList()).iterator();
        }
        if (!(this.outEdgesLoaded && this.inEdgesLoaded || !set.isEmpty() && this.outEdgeLabels.containsAll(set) && this.inEdgeLabels.containsAll(set))) {
            StringBuilder builder = new StringBuilder();
            builder.append("MATCH ").append(this.matchPattern("n")).append("-[r").append(set.stream().map(label -> ":`" + label + "`").collect(Collectors.joining("|"))).append("]-(m").append(this.processLabels(Collections.emptySet(), true)).append(")").append(" WHERE ").append(this.vertexIdProvider.matchPredicateOperand("n")).append(" = {id}");
            List<Object> identifiers = Stream.concat(this.outEdges.stream(), this.inEdges.stream()).map(Neo4JEdge::id).filter(Objects::nonNull).collect(Collectors.toList());
            this.processEdgesWhereClause("m", identifiers, "r", builder, parameters);
            builder.append(" RETURN m");
            Statement statement = new Statement(builder.toString(), parameters);
            StatementResult result = this.session.executeStatement(statement);
            Stream<Vertex> query = this.session.vertices(result);
            Iterator<Vertex> iterator = Stream.concat(Stream.concat((labels.length != 0 ? this.outEdges.stream().filter(edge -> set.contains(edge.label())) : this.outEdges.stream()).map(Edge::inVertex), (labels.length != 0 ? this.inEdges.stream().filter(edge -> set.contains(edge.label())) : this.inEdges.stream()).map(Edge::outVertex)), query).collect(Collectors.toList()).iterator();
            ResultSummaryLogger.log(result.consume());
            return iterator;
        }
        return Stream.concat((labels.length != 0 ? this.outEdges.stream().filter(edge -> set.contains(edge.label())) : this.outEdges.stream()).map(Edge::inVertex), (labels.length != 0 ? this.inEdges.stream().filter(edge -> set.contains(edge.label())) : this.inEdges.stream()).map(Edge::outVertex)).collect(Collectors.toList()).iterator();
    }

    public <V> VertexProperty<V> property(VertexProperty.Cardinality cardinality, String name, V value, Object ... keyValues) {
        ElementHelper.validateProperty((String)name, value);
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        if (keyValues.length != 0) {
            throw VertexProperty.Exceptions.metaPropertiesNotSupported();
        }
        Neo4JBoltSupport.checkPropertyValue(value);
        VertexProperty.Cardinality existingCardinality = this.cardinalities.get(name);
        if (existingCardinality != null && existingCardinality != cardinality) {
            throw new IllegalArgumentException(String.format(Locale.getDefault(), "Property %s has been defined with %s cardinality", name, existingCardinality));
        }
        this.graph.tx().readWrite();
        Neo4JVertexProperty<V> property = new Neo4JVertexProperty<V>(this, propertyIdProvider.incrementAndGet(), name, value);
        switch (cardinality) {
            case list: {
                Collection<VertexProperty> list = this.properties.get(name);
                if (list == null) {
                    list = new ArrayList<VertexProperty>();
                    this.properties.put(name, list);
                    this.cardinalities.put(name, VertexProperty.Cardinality.list);
                }
                if (!list.add(property)) break;
                this.session.dirtyVertex(this);
                this.dirty = true;
                break;
            }
            case set: {
                Collection<VertexProperty> set = this.properties.get(name);
                if (set == null) {
                    set = new HashSet<VertexProperty>();
                    this.properties.put(name, set);
                    this.cardinalities.put(name, VertexProperty.Cardinality.set);
                }
                if (!set.stream().noneMatch(item -> item.value().equals(value))) break;
                set.add(property);
                this.session.dirtyVertex(this);
                this.dirty = true;
                break;
            }
            default: {
                this.properties.put(name, Collections.singletonList(property));
                this.cardinalities.put(name, VertexProperty.Cardinality.single);
                this.session.dirtyVertex(this);
                this.dirty = true;
            }
        }
        return property;
    }

    public <V> VertexProperty<V> property(String key) {
        Objects.requireNonNull(key, "key cannot be null");
        Collection<VertexProperty> collection = this.properties.get(key);
        if (collection != null) {
            if (collection.size() == 1) {
                Iterator<VertexProperty> iterator = collection.iterator();
                if (iterator.hasNext()) {
                    return iterator.next();
                }
                return VertexProperty.empty();
            }
            throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey((String)key);
        }
        return VertexProperty.empty();
    }

    public <V> Iterator<VertexProperty<V>> properties(String ... propertyKeys) {
        Objects.requireNonNull(propertyKeys, "propertyKeys cannot be null");
        if (!this.properties.isEmpty()) {
            if (propertyKeys.length == 0) {
                return this.properties.entrySet().stream().flatMap(entry -> ((Collection)entry.getValue()).stream()).map(item -> item).collect(Collectors.toList()).iterator();
            }
            if (propertyKeys.length == 1) {
                Collection<VertexProperty> list = this.properties.get(propertyKeys[0]);
                if (list != null) {
                    return list.stream().map(item -> (VertexProperty)item).collect(Collectors.toList()).iterator();
                }
                return Collections.emptyIterator();
            }
            return Arrays.stream(propertyKeys).flatMap(key -> this.properties.getOrDefault(key, Collections.EMPTY_LIST).stream()).map(item -> (VertexProperty)item).collect(Collectors.toList()).iterator();
        }
        return Collections.emptyIterator();
    }

    public Graph graph() {
        return this.graph;
    }

    public void remove() {
        this.graph.tx().readWrite();
        this.outEdges.forEach(edge -> this.session.removeEdge((Neo4JEdge)edge, false));
        this.session.removeVertex(this);
    }

    void addInEdge(Neo4JEdge edge) {
        Objects.requireNonNull(edge, "edge cannot be null");
        this.inEdges.add(edge);
    }

    void addOutEdge(Neo4JEdge edge) {
        Objects.requireNonNull(edge, "edge cannot be null");
        this.outEdges.add(edge);
    }

    private Map<String, Object> statementParameters() {
        Collector<Map.Entry, Map, Map> collector = Collector.of(HashMap::new, (map, entry) -> {
            String key = (String)entry.getKey();
            Collection list = (Collection)entry.getValue();
            if (this.cardinalities.get(key) == VertexProperty.Cardinality.single) {
                Iterator iterator = list.iterator();
                if (iterator.hasNext()) {
                    map.put(key, ((VertexProperty)iterator.next()).value());
                }
            } else {
                map.put(key, list.stream().map(Property::value).collect(Collectors.toList()));
            }
        }, (map1, map2) -> map1, map -> map, new Collector.Characteristics[0]);
        Map parameters = this.properties.entrySet().stream().collect(collector);
        this.removedProperties.forEach(name -> parameters.put(name, null));
        String idFieldName = this.vertexIdProvider.fieldName();
        if (this.id != null && idFieldName != null) {
            parameters.put(idFieldName, this.id);
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Neo4JDatabaseCommand insertCommand() {
        SortedSet labels = Stream.concat(this.labels.stream(), this.additionalLabels.stream()).collect(Collectors.toCollection(TreeSet::new));
        try {
            Value parameters = Values.parameters((Object[])new Object[]{"vp", this.statementParameters()});
            if (this.id == null) {
                String statement = "CREATE (n" + this.processLabels(labels, false) + "{vp}) RETURN " + this.vertexIdProvider.matchPredicateOperand("n");
                Neo4JDatabaseCommand neo4JDatabaseCommand = new Neo4JDatabaseCommand(new Statement(statement, parameters), result -> {
                    if (result.hasNext()) {
                        Record record = result.next();
                        this.generatedId = this.vertexIdProvider.processIdentifier(record.get(0).asObject());
                    }
                });
                return neo4JDatabaseCommand;
            }
            Neo4JDatabaseCommand neo4JDatabaseCommand = new Neo4JDatabaseCommand(new Statement("CREATE (" + this.processLabels(labels, false) + "{vp})", parameters));
            return neo4JDatabaseCommand;
        }
        finally {
            this.matchLabels = labels;
        }
    }

    @Override
    public Neo4JDatabaseCommand updateCommand() {
        if (this.dirty || !this.labelsAdded.isEmpty() || !this.labelsRemoved.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            builder.append("MATCH ").append(this.matchPattern("v")).append(" WHERE ").append(this.matchPredicate("v", "id"));
            parameters.put("id", this.id());
            if (this.dirty) {
                builder.append(" SET v = {vp}");
                parameters.put("vp", this.statementParameters());
            }
            if (!this.labelsAdded.isEmpty()) {
                builder.append(!this.dirty ? " SET v" : ", v").append(this.processLabels(this.labelsAdded, false));
            }
            if (!this.labelsRemoved.isEmpty()) {
                builder.append(" REMOVE v").append(this.processLabels(this.labelsRemoved, false));
            }
            return new Neo4JDatabaseCommand(new Statement(builder.toString(), parameters));
        }
        return null;
    }

    @Override
    public Neo4JDatabaseCommand deleteCommand() {
        String statement = "MATCH " + this.matchPattern("v") + " WHERE " + this.matchPredicate("v", "id") + " DETACH DELETE v";
        Value parameters = Values.parameters((Object[])new Object[]{"id", this.id()});
        return new Neo4JDatabaseCommand(new Statement(statement, parameters));
    }

    void commit() {
        this.labelsAdded.clear();
        this.labelsRemoved.clear();
        this.originalLabels = new TreeSet<String>(this.labels);
        this.matchLabels = Stream.concat(this.originalLabels.stream(), this.graphLabels.stream()).collect(Collectors.toCollection(TreeSet::new));
        this.originalProperties = new HashMap<String, Collection<VertexProperty>>(this.properties);
        this.originalCardinalities = new HashMap<String, VertexProperty.Cardinality>(this.cardinalities);
        this.removedProperties.clear();
        this.dirty = false;
    }

    void rollback() {
        this.labelsAdded.clear();
        this.labelsRemoved.clear();
        this.labels.clear();
        this.labels.addAll(this.originalLabels);
        this.matchLabels = Stream.concat(this.originalLabels.stream(), this.graphLabels.stream()).collect(Collectors.toCollection(TreeSet::new));
        this.properties.clear();
        this.cardinalities.clear();
        this.properties.putAll(this.originalProperties);
        this.cardinalities.putAll(this.originalCardinalities);
        this.removedProperties.clear();
        this.outEdgesLoaded = false;
        this.inEdgesLoaded = false;
        this.dirty = false;
    }

    private String processLabels(Set<String> labels, boolean addPartition) {
        Set<String> partitionLabels;
        Objects.requireNonNull(labels, "labels cannot be null");
        if (addPartition && !(partitionLabels = this.partition.vertexMatchPatternLabels()).isEmpty()) {
            return Stream.concat(partitionLabels.stream(), labels.stream()).map(label -> ":`" + label + "`").collect(Collectors.joining(""));
        }
        return labels.stream().map(label -> ":`" + label + "`").collect(Collectors.joining(""));
    }

    public boolean equals(Object object) {
        return object instanceof Vertex && (this.id != null ? ElementHelper.areEqual((Element)this, (Object)object) : super.equals(object));
    }

    public int hashCode() {
        return this.id != null ? ElementHelper.hashCode((Element)this) : super.hashCode();
    }

    public String toString() {
        return StringFactory.vertexString((Vertex)this);
    }

    private static class Neo4JVertexProperty<T>
    implements VertexProperty<T> {
        private final Neo4JVertex vertex;
        private final Object id;
        private final String name;
        private final T value;

        public Neo4JVertexProperty(Neo4JVertex vertex, Object id, String name, T value) {
            Objects.requireNonNull(vertex, "vertex cannot be null");
            Objects.requireNonNull(id, "id cannot be null");
            Objects.requireNonNull(name, "name cannot be null");
            Objects.requireNonNull(value, "value cannot be null");
            this.vertex = vertex;
            this.id = id;
            this.name = name;
            this.value = value;
        }

        public Vertex element() {
            return this.vertex;
        }

        public <U> Iterator<Property<U>> properties(String ... propertyKeys) {
            throw VertexProperty.Exceptions.metaPropertiesNotSupported();
        }

        public Object id() {
            return this.id;
        }

        public <V> Property<V> property(String key, V value) {
            throw VertexProperty.Exceptions.metaPropertiesNotSupported();
        }

        public String key() {
            return this.name;
        }

        public T value() throws NoSuchElementException {
            return this.value;
        }

        public boolean isPresent() {
            return true;
        }

        public void remove() {
            VertexProperty.Cardinality cardinality = (VertexProperty.Cardinality)this.vertex.cardinalities.get(this.name);
            if (cardinality != null) {
                if (cardinality != VertexProperty.Cardinality.single) {
                    Collection vertexProperties = (Collection)this.vertex.properties.get(this.name);
                    if (vertexProperties != null) {
                        vertexProperties.remove(this);
                        if (vertexProperties.isEmpty()) {
                            this.vertex.properties.remove(this.name);
                            this.vertex.cardinalities.remove(this.name);
                            this.vertex.removedProperties.add(this.name);
                            this.vertex.dirty = true;
                            this.vertex.session.dirtyVertex(this.vertex);
                        }
                    }
                } else {
                    this.vertex.properties.remove(this.name);
                    this.vertex.cardinalities.remove(this.name);
                    this.vertex.removedProperties.add(this.name);
                    this.vertex.dirty = true;
                    this.vertex.session.dirtyVertex(this.vertex);
                }
            }
        }

        public boolean equals(Object object) {
            return object instanceof VertexProperty && ElementHelper.areEqual((VertexProperty)this, (Object)object);
        }

        public int hashCode() {
            return ElementHelper.hashCode((Element)this);
        }

        public String toString() {
            return StringFactory.propertyString((Property)this);
        }
    }
}

