/*
 * Decompiled with CFR 0.152.
 */
package com.steelbridgelabs.oss.neo4j.structure.partitions;

import com.steelbridgelabs.oss.neo4j.structure.Neo4JReadPartition;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class AllLabelReadPartition
implements Neo4JReadPartition {
    private final Set<String> labels;

    public AllLabelReadPartition(String ... labels) {
        Objects.requireNonNull(labels, "labels cannot be null");
        this.labels = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(labels)));
    }

    @Override
    public boolean validateLabel(String label) {
        Objects.requireNonNull(label, "label cannot be null");
        return !this.labels.contains(label);
    }

    @Override
    public boolean containsVertex(Set<String> labels) {
        Objects.requireNonNull(labels, "labels cannot be null");
        return this.labels.stream().allMatch(labels::contains);
    }

    @Override
    public boolean usesMatchPattern() {
        return true;
    }

    @Override
    public boolean usesMatchPredicate() {
        return false;
    }

    @Override
    public Set<String> vertexMatchPatternLabels() {
        return this.labels;
    }

    @Override
    public String vertexMatchPredicate(String alias) {
        return null;
    }
}

