/*
 * Decompiled with CFR 0.152.
 */
package com.steelbridgelabs.oss.neo4j.structure.partitions;

import com.steelbridgelabs.oss.neo4j.structure.Neo4JReadPartition;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class AnyLabelReadPartition
implements Neo4JReadPartition {
    private final Set<String> labels;

    public AnyLabelReadPartition(String ... labels) {
        Objects.requireNonNull(labels, "labels cannot be null");
        this.labels = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(labels)));
    }

    @Override
    public boolean validateLabel(String label) {
        Objects.requireNonNull(label, "label cannot be null");
        return !this.labels.contains(label);
    }

    @Override
    public boolean containsVertex(Set<String> labels) {
        Objects.requireNonNull(labels, "labels cannot be null");
        return this.labels.stream().anyMatch(labels::contains);
    }

    @Override
    public boolean usesMatchPattern() {
        return this.labels.size() == 1;
    }

    @Override
    public boolean usesMatchPredicate() {
        return this.labels.size() != 1;
    }

    @Override
    public Set<String> vertexMatchPatternLabels() {
        return this.labels.size() == 1 ? this.labels : Collections.emptySet();
    }

    @Override
    public String vertexMatchPredicate(String alias) {
        Objects.requireNonNull(alias, "alias cannot be null");
        if (this.labels.size() != 1) {
            return this.labels.stream().map(label -> alias + ":`" + label + "`").collect(Collectors.joining(" OR ", "(", ")"));
        }
        return null;
    }
}

