/*
 * Decompiled with CFR 0.152.
 */
package com.steelbridgelabs.oss.neo4j.structure.providers;

import com.steelbridgelabs.oss.neo4j.structure.Neo4JElementIdProvider;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.types.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseSequenceElementIdProvider
implements Neo4JElementIdProvider<Long> {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseSequenceElementIdProvider.class);
    public static final String DefaultIdFieldName = "id";
    public static final String DefaultSequenceNodeLabel = "UniqueIdentifierGenerator";
    public static final long DefaultPoolSize = 1000L;
    private final Driver driver;
    private final String idFieldName;
    private final String sequenceNodeLabel;
    private final long poolSize;
    private final AtomicLong atomicLong = new AtomicLong(0L);
    private final Object monitor = new Object();
    private AtomicLong maximum = new AtomicLong(0L);

    public DatabaseSequenceElementIdProvider(Driver driver) {
        Objects.requireNonNull(driver, "driver cannot be null");
        this.driver = driver;
        this.poolSize = 1000L;
        this.idFieldName = DefaultIdFieldName;
        this.sequenceNodeLabel = DefaultSequenceNodeLabel;
    }

    public DatabaseSequenceElementIdProvider(Driver driver, long poolSize, String idFieldName, String sequenceNodeLabel) {
        Objects.requireNonNull(driver, "driver cannot be null");
        Objects.requireNonNull(idFieldName, "idFieldName cannot be null");
        Objects.requireNonNull(sequenceNodeLabel, "sequenceNodeLabel cannot be null");
        this.driver = driver;
        this.poolSize = poolSize;
        this.idFieldName = idFieldName;
        this.sequenceNodeLabel = sequenceNodeLabel;
    }

    @Override
    public String fieldName() {
        return this.idFieldName;
    }

    @Override
    public Long get(Entity entity) {
        Objects.requireNonNull(entity, "entity cannot be null");
        return entity.get(this.idFieldName).asLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long generate() {
        long max = this.maximum.get();
        long identifier = this.atomicLong.incrementAndGet();
        if (identifier > max) {
            do {
                if (logger.isDebugEnabled()) {
                    logger.debug("About to request a pool of identifiers from database, maximum id: {}", (Object)max);
                }
                Object object = this.monitor;
                synchronized (object) {
                    max = this.maximum.get();
                    identifier = this.atomicLong.incrementAndGet();
                    if (identifier >= max) {
                        try (Session session = this.driver.session();
                             Transaction transaction = session.beginTransaction();){
                            Statement statement = new Statement("MERGE (g:`" + this.sequenceNodeLabel + "`) ON CREATE SET g.nextId = 1 ON MATCH SET g.nextId = g.nextId + {poolSize} RETURN g.nextId", Collections.singletonMap("poolSize", this.poolSize));
                            StatementResult result = transaction.run(statement);
                            if (result.hasNext()) {
                                Record record = result.next();
                                long nextId = record.get(0).asLong();
                                this.atomicLong.set(nextId - this.poolSize);
                                this.maximum.set(nextId);
                            }
                            transaction.success();
                        }
                        max = this.maximum.get();
                        identifier = this.atomicLong.incrementAndGet();
                        if (logger.isDebugEnabled()) {
                            logger.debug("Requested new pool of identifiers from database, current id: {}, maximum id: {}", (Object)identifier, (Object)max);
                        }
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("No need to request pool of identifiers, current id: {}, maximum id: {}", (Object)identifier, (Object)max);
                    }
                }
            } while (identifier > max);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Current identifier: {}", (Object)identifier);
        }
        return identifier;
    }

    @Override
    public Long processIdentifier(Object id) {
        Objects.requireNonNull(id, "Element identifier cannot be null");
        if (id instanceof Long) {
            return (Long)id;
        }
        if (id instanceof Number) {
            return ((Number)id).longValue();
        }
        if (id instanceof String) {
            return Long.valueOf((String)id);
        }
        throw new IllegalArgumentException(String.format("Expected an id that is convertible to Long but received %s", id.getClass()));
    }

    @Override
    public String matchPredicateOperand(String alias) {
        Objects.requireNonNull(alias, "alias cannot be null");
        return alias + "." + this.idFieldName;
    }
}

