/*
 * Decompiled with CFR 0.152.
 */
package com.steelbridgelabs.oss.neo4j.structure.providers;

import com.steelbridgelabs.oss.neo4j.structure.Neo4JElementIdProvider;
import java.util.Objects;
import org.neo4j.driver.v1.types.Entity;

public class Neo4JNativeElementIdProvider
implements Neo4JElementIdProvider<Long> {
    @Override
    public String fieldName() {
        return null;
    }

    @Override
    public Long get(Entity entity) {
        Objects.requireNonNull(entity, "entity cannot be null");
        return entity.id();
    }

    @Override
    public Long generate() {
        return null;
    }

    @Override
    public Long processIdentifier(Object id) {
        Objects.requireNonNull(id, "Element identifier cannot be null");
        if (id instanceof Long) {
            return (Long)id;
        }
        if (id instanceof Number) {
            return ((Number)id).longValue();
        }
        if (id instanceof String) {
            return Long.valueOf((String)id);
        }
        throw new IllegalArgumentException(String.format("Expected an id that is convertible to Long but received %s", id.getClass()));
    }

    @Override
    public String matchPredicateOperand(String alias) {
        Objects.requireNonNull(alias, "alias cannot be null");
        return "ID(" + alias + ")";
    }
}

