/*
 * Decompiled with CFR 0.152.
 */
package com.steelbridgelabs.oss.neo4j.structure.summary;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.summary.InputPosition;
import org.neo4j.driver.v1.summary.Notification;
import org.neo4j.driver.v1.summary.ProfiledPlan;
import org.neo4j.driver.v1.summary.ResultSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSummaryLogger {
    private static final Logger logger = LoggerFactory.getLogger(ResultSummaryLogger.class);

    private ResultSummaryLogger() {
    }

    public static void log(ResultSummary summary) {
        Objects.requireNonNull(summary, "summary cannot be null");
        if (logger.isInfoEnabled() && summary.hasProfile()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Profile for CYPHER statement: ").append(summary.statement()).append("\n");
            ProfileInformation profileInformation = new ProfileInformation();
            profileInformation.process(summary.profile());
            builder.append(profileInformation.toString());
            logger.info(builder.toString());
        }
        if (logger.isWarnEnabled()) {
            for (Notification notification : summary.notifications()) {
                InputPosition position = notification.position();
                logger.warn("CYPHER statement [{}] notification; severity: {}, code: {}, title: {}, description: {}{}", new Object[]{summary.statement(), notification.severity(), notification.code(), notification.title(), notification.description(), position != null ? ", [line: " + position.line() + ", position: " + position.column() + ", offset: " + position.offset() + "]" : ""});
            }
        }
    }

    private static class ProfileInformation {
        private static final String OperatorColumnName = "Operator";
        private static final String EstimatedRowsColumnName = "Estimated Rows";
        private static final String RowsColumnName = "Rows";
        private static final String DBHitsColumnName = "DB Hits";
        private static final String VariablesColumnName = "Variables";
        private static final String OtherInformationColumnName = "Other";
        private static final String[] otherInformationArgumentKeys = new String[]{"LegacyExpression", "LabelName", "Index", "LegacyIndex", "KeyExpressions", "EntityByIdRhs", "ExpandExpression"};
        private final List<ProfileInformationDetails> details = new LinkedList<ProfileInformationDetails>();
        private int operatorLength = "Operator".length();
        private int estimatedRowsLength = "Estimated Rows".length();
        private int rowsLength = "Rows".length();
        private int dbHitsLength = "DB Hits".length();
        private int variablesLength = "Variables".length();
        private int otherInformationLength = "Other".length();

        private ProfileInformation() {
        }

        public void process(ProfiledPlan profilePlan) {
            Objects.requireNonNull(profilePlan, "profilePlan cannot be null");
            this.process(profilePlan, 0);
        }

        private void process(ProfiledPlan profilePlan, int indentationLevel) {
            ProfileInformationDetails information = new ProfileInformationDetails();
            information.operator = ProfileInformation.printOperator(profilePlan.operatorType(), indentationLevel);
            Map arguments = profilePlan.arguments();
            information.indentationLevel = indentationLevel;
            information.estimatedRows = ProfileInformation.printEstimatedRows((Value)arguments.get("EstimatedRows"));
            information.rows = String.format(Locale.US, "%d", profilePlan.records());
            information.dbHits = String.format(Locale.US, "%d", profilePlan.dbHits());
            information.variables = profilePlan.identifiers().stream().map(String::trim).collect(Collectors.joining(", "));
            information.otherInformation = ProfileInformation.printOtherInformation(arguments);
            this.add(information);
            List children = profilePlan.children();
            for (int i = children.size() - 1; i >= 0; --i) {
                ProfiledPlan child = (ProfiledPlan)children.get(i);
                this.process(child, indentationLevel + i);
            }
        }

        private void add(ProfileInformationDetails information) {
            this.operatorLength = information.operator.length() - 2 > this.operatorLength ? information.operator.length() - 2 : this.operatorLength;
            this.estimatedRowsLength = information.estimatedRows.length() > this.estimatedRowsLength ? information.estimatedRows.length() : this.estimatedRowsLength;
            this.rowsLength = information.rows.length() > this.rowsLength ? information.rows.length() : this.rowsLength;
            this.dbHitsLength = information.dbHits.length() > this.dbHitsLength ? information.dbHits.length() : this.dbHitsLength;
            this.variablesLength = information.variables.length() > this.variablesLength ? information.variables.length() : this.variablesLength;
            this.otherInformationLength = information.otherInformation.length() > this.otherInformationLength ? information.otherInformation.length() : this.otherInformationLength;
            this.details.add(information);
        }

        private static String printOperator(String operator, int indentationLevel) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i <= indentationLevel; ++i) {
                builder.append("| ");
            }
            builder.append("+").append(operator);
            return builder.toString();
        }

        private static String printEstimatedRows(Value estimatedRows) {
            return estimatedRows != null ? String.format(Locale.US, "%d", (long)estimatedRows.asDouble()) : "";
        }

        private static String printOtherInformation(Map<String, Value> arguments) {
            return Arrays.stream(otherInformationArgumentKeys).map(arguments::get).filter(value -> value != null && !value.isNull()).map(value -> value.asObject().toString()).collect(Collectors.joining(", "));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("\n");
            builder.append("+-").append(StringUtils.repeat((String)"-", (int)this.operatorLength)).append("-+-").append(StringUtils.repeat((String)"-", (int)this.estimatedRowsLength)).append("-+-").append(StringUtils.repeat((String)"-", (int)this.rowsLength)).append("-+-").append(StringUtils.repeat((String)"-", (int)this.dbHitsLength)).append("-+-").append(StringUtils.repeat((String)"-", (int)this.variablesLength)).append("-+-").append(StringUtils.repeat((String)"-", (int)this.otherInformationLength)).append("-+\n");
            builder.append("| ").append(OperatorColumnName).append(StringUtils.repeat((String)" ", (int)(this.operatorLength - OperatorColumnName.length()))).append(" + ").append(EstimatedRowsColumnName).append(StringUtils.repeat((String)" ", (int)(this.estimatedRowsLength - EstimatedRowsColumnName.length()))).append(" + ").append(RowsColumnName).append(StringUtils.repeat((String)" ", (int)(this.rowsLength - RowsColumnName.length()))).append(" + ").append(DBHitsColumnName).append(StringUtils.repeat((String)" ", (int)(this.dbHitsLength - DBHitsColumnName.length()))).append(" + ").append(VariablesColumnName).append(StringUtils.repeat((String)" ", (int)(this.variablesLength - VariablesColumnName.length()))).append(" + ").append(OtherInformationColumnName).append(StringUtils.repeat((String)" ", (int)(this.otherInformationLength - OtherInformationColumnName.length()))).append(" |\n");
            builder.append("+-").append(StringUtils.repeat((String)"-", (int)this.operatorLength)).append("-+-").append(StringUtils.repeat((String)"-", (int)this.estimatedRowsLength)).append("-+-").append(StringUtils.repeat((String)"-", (int)this.rowsLength)).append("-+-").append(StringUtils.repeat((String)"-", (int)this.dbHitsLength)).append("-+-").append(StringUtils.repeat((String)"-", (int)this.variablesLength)).append("-+-").append(StringUtils.repeat((String)"-", (int)this.otherInformationLength)).append("-+\n");
            boolean first = true;
            int lastIndentationLevel = -1;
            for (ProfileInformationDetails item : this.details) {
                if (!first) {
                    int i;
                    if (lastIndentationLevel < item.indentationLevel) {
                        for (i = 0; i < item.indentationLevel; ++i) {
                            builder.append("| ");
                        }
                        builder.append("|\\  ");
                    } else {
                        for (i = 0; i <= item.indentationLevel; ++i) {
                            builder.append("| ");
                        }
                        builder.append("| ");
                    }
                    builder.append(StringUtils.repeat((String)" ", (int)(this.operatorLength - item.indentationLevel * 2 - 2))).append(" +-");
                    builder.append(StringUtils.repeat((String)"-", (int)this.estimatedRowsLength)).append("-+-");
                    builder.append(StringUtils.repeat((String)"-", (int)this.rowsLength)).append("-+-");
                    builder.append(StringUtils.repeat((String)"-", (int)this.dbHitsLength)).append("-+-");
                    builder.append(StringUtils.repeat((String)"-", (int)this.variablesLength)).append("-+-");
                    builder.append(StringUtils.repeat((String)"-", (int)this.otherInformationLength)).append("-+");
                    builder.append("\n");
                }
                builder.append(item.operator).append(StringUtils.repeat((String)" ", (int)(this.operatorLength - item.operator.length() + 2))).append(" |");
                builder.append(" ").append(StringUtils.repeat((String)" ", (int)(this.estimatedRowsLength - item.estimatedRows.length()))).append(item.estimatedRows).append(" |");
                builder.append(" ").append(StringUtils.repeat((String)" ", (int)(this.rowsLength - item.rows.length()))).append(item.rows).append(" |");
                builder.append(" ").append(StringUtils.repeat((String)" ", (int)(this.dbHitsLength - item.dbHits.length()))).append(item.dbHits).append(" |");
                builder.append(" ").append(item.variables).append(StringUtils.repeat((String)" ", (int)(this.variablesLength - item.variables.length()))).append(" |");
                builder.append(" ").append(item.otherInformation).append(StringUtils.repeat((String)" ", (int)(this.otherInformationLength - item.otherInformation.length()))).append(" |");
                builder.append("\n");
                first = false;
                lastIndentationLevel = item.indentationLevel;
            }
            builder.append("+-").append(StringUtils.repeat((String)"-", (int)this.operatorLength)).append("-+-").append(StringUtils.repeat((String)"-", (int)this.estimatedRowsLength)).append("-+-").append(StringUtils.repeat((String)"-", (int)this.rowsLength)).append("-+-").append(StringUtils.repeat((String)"-", (int)this.dbHitsLength)).append("-+-").append(StringUtils.repeat((String)"-", (int)this.variablesLength)).append("-+-").append(StringUtils.repeat((String)"-", (int)this.otherInformationLength)).append("-+\n");
            return builder.toString();
        }

        private static class ProfileInformationDetails {
            private int indentationLevel;
            private String operator;
            private String estimatedRows;
            private String rows;
            private String dbHits;
            private String variables;
            private String otherInformation;

            private ProfileInformationDetails() {
            }
        }
    }
}

