/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.local.client;

import com.sun.xml.ws.client.ClientTransportException;
import com.sun.xml.ws.handler.MessageContextImpl;
import com.sun.xml.ws.server.RuntimeEndpointInfo;
import com.sun.xml.ws.server.Tie;
import com.sun.xml.ws.spi.runtime.WSConnection;
import com.sun.xml.ws.spi.runtime.WebServiceContext;
import com.sun.xml.ws.transport.WSConnectionImpl;
import com.sun.xml.ws.transport.local.LocalMessage;
import com.sun.xml.ws.transport.local.server.LocalConnectionImpl;
import com.sun.xml.ws.util.ByteArrayBuffer;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalClientTransport
extends WSConnectionImpl {
    private RuntimeEndpointInfo endpointInfo;
    private Tie tie = new Tie();
    LocalMessage lm = new LocalMessage();

    public LocalClientTransport(RuntimeEndpointInfo endpointInfo) {
        this(endpointInfo, null);
    }

    public LocalClientTransport(RuntimeEndpointInfo endpointInfo, OutputStream logStream) {
        this.endpointInfo = endpointInfo;
        this.debugStream = logStream;
    }

    @Override
    public OutputStream getOutput() {
        try {
            this.lm.setOutput(new ByteArrayBuffer());
            return this.lm.getOutput();
        }
        catch (Exception ex) {
            throw new ClientTransportException("local.client.failed", ex);
        }
    }

    private static void checkMessageContentType(WSConnection con, boolean response) {
        String negotiation = System.getProperty("com.sun.xml.ws.client.ContentNegotiation", "none").intern();
        String contentType = con.getHeaders().get("Content-Type").get(0);
        if (negotiation == "none" ? contentType.indexOf("text/xml") < 0 && contentType.indexOf("application/soap+xml") < 0 && contentType.indexOf("application/xop+xml") < 0 : (negotiation == "optimistic" ? contentType.indexOf("application/fastinfoset") < 0 && contentType.indexOf("application/soap+fastinfoset") < 0 : negotiation == "pessimistic" && response && contentType.indexOf("application/fastinfoset") < 0 && contentType.indexOf("application/soap+fastinfoset") < 0)) {
            throw new RuntimeException("Invalid content type '" + contentType + "' with content negotiation set to '" + negotiation + "'.");
        }
    }

    @Override
    public void closeOutput() {
        super.closeOutput();
        LocalConnectionImpl con = new LocalConnectionImpl(this.lm);
        con.setHeaders(this.getHeaders());
        LocalClientTransport.checkMessageContentType(this, false);
        try {
            WebServiceContext wsContext = this.endpointInfo.getWebServiceContext();
            wsContext.setMessageContext(new MessageContextImpl());
            this.tie.handle(con, this.endpointInfo);
            LocalClientTransport.checkMessageContentType(con, true);
        }
        catch (Exception ex) {
            new ProtocolException("Server side Exception:" + ex);
        }
    }

    @Override
    public InputStream getInput() {
        try {
            return this.lm.getOutput().newInputStream();
        }
        catch (Exception ex) {
            throw new ClientTransportException("local.client.failed", ex);
        }
    }

    @Override
    public void setHeaders(Map<String, List<String>> headers) {
        this.lm.setHeaders(headers);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.lm.getHeaders();
    }
}

