/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.util;

import com.sun.xml.ws.encoding.xml.XMLMessage;
import com.sun.xml.ws.pept.ept.MessageInfo;
import com.sun.xml.ws.spi.runtime.WSConnection;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.http.HTTPException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConnectionUtil {
    private static final String DEFAULT_SERVER_ERROR = "<?xml version='1.0' encoding='UTF-8'?><err>Internal Server Error</err>";

    public static XMLMessage getXMLMessage(WSConnection con, MessageInfo mi) {
        try {
            Map<String, List<String>> headers = con.getHeaders();
            MimeHeaders mh = new MimeHeaders();
            if (headers != null) {
                for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                    String name = entry.getKey();
                    for (String value : entry.getValue()) {
                        try {
                            mh.addHeader(name, value);
                        }
                        catch (IllegalArgumentException ie) {}
                    }
                }
            }
            return new XMLMessage(mh, con.getInput());
        }
        catch (Exception e) {
            throw (HTTPException)new HTTPException(500).initCause((Throwable)e);
        }
    }

    private static void send(WSConnection con, XMLMessage xmlMessage) {
        try {
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            MimeHeaders mhs = xmlMessage.getMimeHeaders();
            Iterator i = mhs.getAllHeaders();
            while (i.hasNext()) {
                MimeHeader mh = (MimeHeader)i.next();
                String name = mh.getName();
                ArrayList<String> values = (ArrayList<String>)headers.get(name);
                if (values == null) {
                    values = new ArrayList<String>();
                    headers.put(name, values);
                }
                values.add(mh.getValue());
            }
            con.setHeaders(headers);
            xmlMessage.writeTo(con.getOutput());
        }
        catch (Exception e) {
            throw (HTTPException)new HTTPException(500).initCause((Throwable)e);
        }
        try {
            con.closeOutput();
        }
        catch (Exception e) {
            throw (HTTPException)new HTTPException(500).initCause((Throwable)e);
        }
    }

    public static void sendResponse(WSConnection con, XMLMessage xmlMessage) {
        XMLConnectionUtil.setStatus(con, xmlMessage.getStatus());
        XMLConnectionUtil.send(con, xmlMessage);
    }

    public static void sendResponseOneway(WSConnection con) {
        XMLConnectionUtil.setStatus(con, 202);
        con.getOutput();
        con.closeOutput();
    }

    public static void sendResponseError(WSConnection con, MessageInfo messageInfo) {
        try {
            StreamSource source = new StreamSource(new ByteArrayInputStream(DEFAULT_SERVER_ERROR.getBytes()));
            String conneg = (String)messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation");
            XMLMessage message = new XMLMessage(source, conneg == "optimistic");
            XMLConnectionUtil.setStatus(con, 500);
            XMLConnectionUtil.send(con, message);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public static Map<String, List<String>> getHeaders(WSConnection con) {
        return con.getHeaders();
    }

    public static void setHeaders(WSConnection con, Map<String, List<String>> headers) {
        con.setHeaders(headers);
    }

    public static void setStatus(WSConnection con, int status) {
        con.setStatus(status);
    }
}

