/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api;

import com.taobao.api.ApiException;
import com.taobao.api.ApiRuleException;
import com.taobao.api.FileItem;
import com.taobao.api.TaobaoClient;
import com.taobao.api.TaobaoParser;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.TaobaoResponse;
import com.taobao.api.TaobaoUploadRequest;
import com.taobao.api.internal.parser.json.ObjectJsonParser;
import com.taobao.api.internal.parser.xml.ObjectXmlParser;
import com.taobao.api.internal.util.RequestParametersHolder;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.TaobaoLogger;
import com.taobao.api.internal.util.TaobaoUtils;
import com.taobao.api.internal.util.WebUtils;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaobaoClient
implements TaobaoClient {
    private static final String APP_KEY = "app_key";
    private static final String FORMAT = "format";
    private static final String METHOD = "method";
    private static final String TIMESTAMP = "timestamp";
    private static final String VERSION = "v";
    private static final String SIGN = "sign";
    private static final String SIGN_METHOD = "sign_method";
    private static final String PARTNER_ID = "partner_id";
    private static final String SESSION = "session";
    private static final String SIMPLIFY = "simplify";
    private static final String TARGET_APP_KEY = "target_app_key";
    private String serverUrl;
    private String appKey;
    private String appSecret;
    private String format = "json";
    private String signMethod = "hmac";
    private int connectTimeout = 3000;
    private int readTimeout = 15000;
    private boolean needCheckRequest = true;
    private boolean needEnableParser = true;
    private boolean useSimplifyJson = false;
    private boolean useGzipEncoding = true;

    public DefaultTaobaoClient(String serverUrl, String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.serverUrl = serverUrl;
    }

    public DefaultTaobaoClient(String serverUrl, String appKey, String appSecret, String format) {
        this(serverUrl, appKey, appSecret);
        this.format = format;
    }

    public DefaultTaobaoClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout) {
        this(serverUrl, appKey, appSecret, format);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public DefaultTaobaoClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout, String signMethod) {
        this(serverUrl, appKey, appSecret, format, connectTimeout, readTimeout);
        this.signMethod = signMethod;
    }

    @Override
    public <T extends TaobaoResponse> T execute(TaobaoRequest<T> request) throws ApiException {
        return this.execute(request, null);
    }

    @Override
    public <T extends TaobaoResponse> T execute(TaobaoRequest<T> request, String session) throws ApiException {
        TaobaoParser<T> parser = null;
        if (this.needEnableParser) {
            parser = "xml".equals(this.format) ? new ObjectXmlParser<T>(request.getResponseClass()) : new ObjectJsonParser<T>(request.getResponseClass(), this.useSimplifyJson);
        }
        return this._execute(request, parser, session);
    }

    private <T extends TaobaoResponse> T _execute(TaobaoRequest<T> request, TaobaoParser<T> parser, String session) throws ApiException {
        if (this.needCheckRequest) {
            try {
                request.check();
            }
            catch (ApiRuleException e) {
                TaobaoResponse localResponse = null;
                try {
                    localResponse = (TaobaoResponse)request.getResponseClass().newInstance();
                }
                catch (Exception xe) {
                    throw new ApiException(xe);
                }
                localResponse.setErrorCode(e.getErrCode());
                localResponse.setMsg(e.getErrMsg());
                return (T)localResponse;
            }
        }
        RequestParametersHolder context = this.doPost(request, session);
        TaobaoResponse tRsp = null;
        if (this.needEnableParser) {
            try {
                tRsp = (TaobaoResponse)parser.parse(context.getResponseBody());
                tRsp.setBody(context.getResponseBody());
            }
            catch (RuntimeException e) {
                TaobaoLogger.logBizError(context.getResponseBody());
                throw e;
            }
        }
        try {
            tRsp = (TaobaoResponse)request.getResponseClass().newInstance();
            tRsp.setBody(context.getResponseBody());
        }
        catch (Exception e) {
            // empty catch block
        }
        tRsp.setParams(context.getApplicationParams());
        if (!tRsp.isSuccess()) {
            TaobaoLogger.logErrorScene(context, tRsp, this.appSecret);
        }
        return (T)tRsp;
    }

    public <T extends TaobaoResponse> RequestParametersHolder doPost(TaobaoRequest<T> request, String session) throws ApiException {
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        TaobaoHashMap appParams = new TaobaoHashMap((Map<? extends String, ? extends String>)request.getTextParams());
        requestHolder.setApplicationParams(appParams);
        TaobaoHashMap protocalMustParams = new TaobaoHashMap();
        protocalMustParams.put(METHOD, request.getApiMethodName());
        protocalMustParams.put(VERSION, "2.0");
        protocalMustParams.put(APP_KEY, this.appKey);
        Long timestamp = request.getTimestamp();
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        protocalMustParams.put(TIMESTAMP, (Object)new Date(timestamp));
        requestHolder.setProtocalMustParams(protocalMustParams);
        TaobaoHashMap protocalOptParams = new TaobaoHashMap();
        protocalOptParams.put(FORMAT, this.format);
        protocalOptParams.put(SIGN_METHOD, this.signMethod);
        protocalOptParams.put(SESSION, session);
        protocalOptParams.put(PARTNER_ID, this.getSdkVersion());
        protocalOptParams.put(TARGET_APP_KEY, request.getTargetAppKey());
        if (this.useSimplifyJson) {
            protocalOptParams.put(SIMPLIFY, Boolean.TRUE.toString());
        }
        requestHolder.setProtocalOptParams(protocalOptParams);
        try {
            if ("md5".equals(this.signMethod)) {
                protocalMustParams.put(SIGN, TaobaoUtils.signTopRequestNew(requestHolder, this.appSecret, false));
            } else if ("hmac".equals(this.signMethod)) {
                protocalMustParams.put(SIGN, TaobaoUtils.signTopRequestNew(requestHolder, this.appSecret, true));
            } else {
                protocalMustParams.put(SIGN, TaobaoUtils.signTopRequest(requestHolder, this.appSecret));
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        StringBuffer reqUrl = new StringBuffer(this.getServerUrl(this.serverUrl, request.getApiMethodName(), session));
        try {
            String sysMustQuery = WebUtils.buildQuery(requestHolder.getProtocalMustParams(), "UTF-8");
            String sysOptQuery = WebUtils.buildQuery(requestHolder.getProtocalOptParams(), "UTF-8");
            if (reqUrl.indexOf("?") != -1) {
                reqUrl.append("&");
            } else {
                reqUrl.append("?");
            }
            reqUrl.append(sysMustQuery);
            if (sysOptQuery != null && sysOptQuery.length() > 0) {
                reqUrl.append("&").append(sysOptQuery);
            }
            requestHolder.setRequestUrl(reqUrl.toString());
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        String rsp = null;
        try {
            if (this.useGzipEncoding) {
                request.getHeaderMap().put("Accept-Encoding", "gzip");
            }
            if (request instanceof TaobaoUploadRequest) {
                TaobaoUploadRequest uRequest = (TaobaoUploadRequest)request;
                Map<String, FileItem> fileParams = TaobaoUtils.cleanupMap(uRequest.getFileParams());
                rsp = WebUtils.doPost(reqUrl.toString(), appParams, fileParams, "UTF-8", this.connectTimeout, this.readTimeout, request.getHeaderMap());
            } else {
                rsp = WebUtils.doPost(reqUrl.toString(), (Map<String, String>)appParams, "UTF-8", this.connectTimeout, this.readTimeout, request.getHeaderMap());
            }
            requestHolder.setResponseBody(rsp);
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return requestHolder;
    }

    protected String getServerUrl(String serverUrl, String apiName, String session) {
        return serverUrl;
    }

    protected String getSdkVersion() {
        return "top-sdk-java-20151111";
    }

    public void setNeedCheckRequest(boolean needCheckRequest) {
        this.needCheckRequest = needCheckRequest;
    }

    public void setNeedEnableParser(boolean needEnableParser) {
        this.needEnableParser = needEnableParser;
    }

    public void setUseSimplifyJson(boolean useSimplifyJson) {
        this.useSimplifyJson = useSimplifyJson;
    }

    public void setNeedEnableLogger(boolean needEnableLogger) {
        TaobaoLogger.setNeedEnableLogger(needEnableLogger);
    }

    public void setIgnoreSSLCheck(boolean ignore) {
        WebUtils.setIgnoreSSLCheck(ignore);
    }

    public void setUseGzipEncoding(boolean useGzipEncoding) {
        this.useGzipEncoding = useGzipEncoding;
    }
}

