/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.util;

import com.taobao.api.ApiException;
import com.taobao.api.internal.util.WebUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtsUtils {
    private static final Set<String> CONTENT_TYPES = new HashSet<String>();
    private static final Pattern REGEX_FILE_NAME = Pattern.compile("attachment;filename=\"([\\w\\-]+)\"");

    private AtsUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File ungzip(File gzip, File toDir) throws IOException {
        toDir.mkdirs();
        File out = new File(toDir, gzip.getName());
        GZIPInputStream gin = null;
        FileOutputStream fout = null;
        try {
            FileInputStream fin = new FileInputStream(gzip);
            gin = new GZIPInputStream(fin);
            fout = new FileOutputStream(out);
            AtsUtils.copy(gin, fout);
            gin.close();
            fout.close();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            AtsUtils.closeQuietly(gin);
            AtsUtils.closeQuietly(fout);
            throw throwable;
        }
        AtsUtils.closeQuietly(gin);
        AtsUtils.closeQuietly(fout);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<File> unzip(File zip, File toDir) throws IOException {
        ZipFile zf = null;
        ArrayList<File> files = null;
        try {
            zf = new ZipFile(zip);
            files = new ArrayList<File>();
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                Object var10_9;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    new File(toDir, entry.getName()).mkdirs();
                    continue;
                }
                InputStream input = null;
                FileOutputStream output = null;
                try {
                    File f = new File(toDir, entry.getName());
                    input = zf.getInputStream(entry);
                    output = new FileOutputStream(f);
                    AtsUtils.copy(input, output);
                    files.add(f);
                    var10_9 = null;
                }
                catch (Throwable throwable) {
                    var10_9 = null;
                    AtsUtils.closeQuietly(output);
                    AtsUtils.closeQuietly(input);
                    throw throwable;
                }
                AtsUtils.closeQuietly(output);
                AtsUtils.closeQuietly(input);
                {
                }
            }
            Object var12_11 = null;
            if (zf == null) return files;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (zf == null) throw throwable;
            zf.close();
            throw throwable;
        }
        zf.close();
        return files;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File download(String url, File toDir) throws ApiException {
        toDir.mkdirs();
        HttpURLConnection conn = null;
        FileOutputStream output = null;
        File file = null;
        try {
            try {
                conn = AtsUtils.getConnection(new URL(url));
                String ctype = conn.getContentType();
                if (!CONTENT_TYPES.contains(ctype)) {
                    String rsp = WebUtils.getResponseAsString(conn);
                    throw new ApiException(rsp);
                }
                String fileName = AtsUtils.getFileName(conn);
                file = new File(toDir, fileName);
                output = new FileOutputStream(file);
                AtsUtils.copy(conn.getInputStream(), output);
                Object var8_9 = null;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            AtsUtils.closeQuietly(output);
            if (conn == null) throw throwable;
            conn.disconnect();
            throw throwable;
        }
        AtsUtils.closeQuietly(output);
        if (conn == null) return file;
        conn.disconnect();
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File download(String url, File toDir, String fileName) throws ApiException {
        toDir.mkdirs();
        HttpURLConnection conn = null;
        FileOutputStream output = null;
        File file = null;
        try {
            try {
                conn = AtsUtils.getConnection(new URL(url));
                String ctype = conn.getContentType();
                if (!CONTENT_TYPES.contains(ctype)) {
                    String rsp = WebUtils.getResponseAsString(conn);
                    throw new ApiException(rsp);
                }
                file = new File(toDir, fileName);
                output = new FileOutputStream(file);
                AtsUtils.copy(conn.getInputStream(), output);
                Object var9_9 = null;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            AtsUtils.closeQuietly(output);
            if (conn == null) throw throwable;
            conn.disconnect();
            throw throwable;
        }
        AtsUtils.closeQuietly(output);
        if (conn == null) return file;
        conn.disconnect();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkMd5sum(File file, String checkCode) throws IOException {
        boolean bl;
        DigestInputStream dInput = null;
        try {
            FileInputStream fInput = new FileInputStream(file);
            dInput = new DigestInputStream(fInput, AtsUtils.getMd5Instance());
            byte[] buf = new byte[8192];
            while (dInput.read(buf) > 0) {
            }
            byte[] bytes = dInput.getMessageDigest().digest();
            bl = AtsUtils.bytes2hex(bytes).equals(checkCode);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            AtsUtils.closeQuietly(dInput);
            throw throwable;
        }
        AtsUtils.closeQuietly(dInput);
        return bl;
    }

    private static String bytes2hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sb.append("0").append(hex);
                continue;
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    private static MessageDigest getMd5Instance() {
        try {
            return MessageDigest.getInstance("md5");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getFileName(HttpURLConnection conn) {
        String fileName = conn.getHeaderField("Content-Disposition");
        Matcher matcher = REGEX_FILE_NAME.matcher(fileName);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static HttpURLConnection getConnection(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "application/zip;text/html");
        return conn;
    }

    private static int copy(InputStream input, OutputStream output) throws IOException {
        long count = AtsUtils.copyStream(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    private static long copyStream(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[1024];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    private static void closeQuietly(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void closeQuietly(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        CONTENT_TYPES.add("application/octet-stream");
        CONTENT_TYPES.add("application/java-archive");
    }
}

