/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.endpoint.protocol;

import com.taobao.top.link.endpoint.Message;
import com.taobao.top.link.endpoint.MessageIO;
import com.taobao.top.link.endpoint.protocol.CompatibleUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.HashMap;

public class MessageDecoder02
implements MessageIO.MessageDecoder {
    public Message readMessage(ByteBuffer buffer) {
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        Message msg = new Message();
        msg.protocolVersion = 2;
        msg.messageType = buffer.get();
        HashMap<String, Object> dict = new HashMap<String, Object>();
        short headerType = buffer.getShort();
        while (headerType != 0) {
            if (headerType == 1) {
                dict.put(MessageDecoder02.readCountedString(buffer), MessageDecoder02.readCustomValue(buffer));
            } else if (headerType == 2) {
                msg.statusCode = buffer.getInt();
            } else if (headerType == 3) {
                msg.statusPhase = MessageDecoder02.readCountedString(buffer);
            } else if (headerType == 4) {
                msg.flag = buffer.getInt();
            } else if (headerType == 5) {
                msg.token = MessageDecoder02.readCountedString(buffer);
            }
            headerType = buffer.getShort();
        }
        msg.content = dict;
        buffer.order(ByteOrder.BIG_ENDIAN);
        return msg;
    }

    private static String readCountedString(ByteBuffer buffer) {
        int size = buffer.getInt();
        if (size > 0) {
            byte[] data = new byte[size];
            buffer.get(data, 0, data.length);
            return CompatibleUtil.newString(data, "UTF-8");
        }
        return null;
    }

    private static Object readCustomValue(ByteBuffer buffer) {
        byte format = buffer.get();
        switch (format) {
            case 0: {
                return null;
            }
            case 2: {
                return buffer.get();
            }
            case 3: {
                short value = buffer.getShort();
                return value;
            }
            case 4: {
                int intValue = buffer.getInt();
                return intValue;
            }
            case 5: {
                long longValue = buffer.getLong();
                return longValue;
            }
            case 6: {
                long ticks = buffer.getLong();
                return new Date(ticks);
            }
            case 7: {
                byte[] byteArray = new byte[buffer.getInt()];
                buffer.get(byteArray);
                return byteArray;
            }
        }
        return MessageDecoder02.readCountedString(buffer);
    }
}

