/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.remoting;

import com.taobao.top.link.BufferManager;
import com.taobao.top.link.Text;
import com.taobao.top.link.channel.ChannelException;
import com.taobao.top.link.channel.ChannelSender;
import com.taobao.top.link.channel.ClientChannel;
import com.taobao.top.link.channel.ClientChannelSelector;
import com.taobao.top.link.remoting.FormatterException;
import com.taobao.top.link.remoting.MethodCall;
import com.taobao.top.link.remoting.MethodReturn;
import com.taobao.top.link.remoting.RemotingClientChannelHandler;
import com.taobao.top.link.remoting.RemotingException;
import com.taobao.top.link.remoting.SynchronizedRemotingCallback;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicProxy
implements InvocationHandler {
    private int executionTimeout = 0;
    private URI remoteUri;
    private String uriString;
    private String serializationFormat;
    private ClientChannelSelector selector;
    private RemotingClientChannelHandler channelHandler;

    protected DynamicProxy(URI remoteUri, ClientChannelSelector selector, RemotingClientChannelHandler handler) {
        this.remoteUri = remoteUri;
        this.uriString = remoteUri != null ? remoteUri.toString() : "";
        this.selector = selector;
        this.channelHandler = handler;
    }

    public Object create(Class<?> interfaceClass, URI remoteUri) {
        this.uriString = remoteUri.toString();
        return Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)this);
    }

    public void setExecutionTimeout(int millisecond) {
        this.executionTimeout = millisecond;
    }

    public void setSerializationFormat(String format) {
        this.serializationFormat = format;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodCall methodCall = new MethodCall();
        methodCall.Uri = this.uriString;
        methodCall.MethodName = method.getName();
        methodCall.TypeName = method.getDeclaringClass().getName();
        methodCall.MethodSignature = method.getParameterTypes();
        methodCall.Args = args;
        MethodReturn methodReturn = this.invoke(methodCall, method.getReturnType());
        if (methodReturn.Exception == null) {
            return methodReturn.ReturnValue;
        }
        throw methodReturn.Exception;
    }

    public MethodReturn invoke(MethodCall methodCall) throws RemotingException, FormatterException {
        return this.invoke(methodCall, Object.class);
    }

    public MethodReturn invoke(MethodCall methodCall, Class<?> returnType) throws RemotingException, FormatterException {
        return this.invoke(methodCall, returnType, this.executionTimeout);
    }

    public MethodReturn invoke(MethodCall methodCall, int executionTimeoutMillisecond) throws RemotingException, FormatterException {
        return this.invoke(methodCall, Object.class, executionTimeoutMillisecond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodReturn invoke(MethodCall methodCall, Class<?> returnType, int executionTimeoutMillisecond) throws RemotingException, FormatterException {
        SynchronizedRemotingCallback syncCallback = new SynchronizedRemotingCallback();
        syncCallback.returnType = returnType;
        syncCallback.serializationFormat = this.serializationFormat;
        HashMap<String, Object> transportHeaders = new HashMap<String, Object>();
        transportHeaders.put("RequestUri", this.uriString);
        ClientChannel channel = this.getChannel();
        try {
            MethodReturn methodReturn = this.send(channel, this.channelHandler.pending(syncCallback, (short)0, transportHeaders, methodCall), syncCallback, executionTimeoutMillisecond);
            Object var9_8 = null;
            this.selector.returnChannel(channel);
            return methodReturn;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.selector.returnChannel(channel);
            throw throwable;
        }
    }

    private ClientChannel getChannel() throws RemotingException {
        try {
            ClientChannel channel = this.selector.getChannel(this.remoteUri);
            channel.setChannelHandler(this.channelHandler);
            return channel;
        }
        catch (ChannelException e) {
            throw new RemotingException(Text.RPC_CAN_NOT_GET_CHANNEL, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodReturn send(ClientChannel clientChannel, final ByteBuffer buffer, SynchronizedRemotingCallback syncCallback, int executionTimeoutMillisecond) throws RemotingException {
        buffer.flip();
        try {
            clientChannel.send(buffer, new ChannelSender.SendHandler(){

                public void onSendComplete(boolean success) {
                    BufferManager.returnBuffer(buffer);
                }
            });
        }
        catch (ChannelException e) {
            throw this.unexcepException(syncCallback, Text.RPC_SEND_ERROR, e);
        }
        try {
            syncCallback.waitReturn(executionTimeoutMillisecond);
            Object var7_6 = null;
            this.channelHandler.cancel(syncCallback);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.channelHandler.cancel(syncCallback);
            throw throwable;
        }
        if (syncCallback.getFailure() != null) {
            throw this.unexcepException(syncCallback, Text.RPC_CALL_ERROR, syncCallback.getFailure());
        }
        return syncCallback.getMethodReturn();
    }

    private RemotingException unexcepException(SynchronizedRemotingCallback callback, String message, Throwable innerException) {
        if (innerException instanceof RemotingException) {
            return (RemotingException)innerException;
        }
        return innerException != null ? new RemotingException(message, innerException) : new RemotingException(message);
    }
}

