/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.app.api.util;

import com.alibaba.common.lang.StringUtil;
import com.taobao.hsf.configuration.service.ConfigurationService;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.metadata.service.MetadataService;
import com.taobao.hsf.model.metadata.MethodSpecial;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.process.service.ProcessService;
import com.taobao.hsf.spas.SpasInit;
import com.taobao.hsf.unit.service.UnitService;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.hsf.util.HSFServiceTargetUtil;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class HSFApiProviderBean {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private final ServiceMetadata metadata = new ServiceMetadata(true);
    private final AtomicBoolean inited = new AtomicBoolean();
    private final AtomicBoolean isPublished = new AtomicBoolean();
    private static final UnitService unitService = HSFServiceContainer.getInstance(UnitService.class);
    private static final MetadataService metadataService = HSFServiceContainer.getInstance(MetadataService.class);

    public HSFApiProviderBean() {
        this.metadata.addProperty("_TIMEOUT", Integer.toString(3000));
        this.metadata.addProperty("_IDLETIMEOUT", "10");
        this.metadata.addProperty("_SERIALIZETYPE", "hessian");
        this.metadata.addProperty("v", "2.0");
        this.metadata.addProperty("_p", HSFServiceContainer.getInstance(ConfigurationService.class).getPreferedSerializer());
        if (HSFServiceContainer.getInstance(ConfigurationService.class).isHttpEnable()) {
            this.metadata.addProperty("_h", HSFServiceContainer.getInstance(ConfigurationService.class).getHttpServerPort() + "");
        }
        this.metadata.setReadyToPublish(!HSFServiceContainer.getInstance(ConfigurationService.class).isDelayedPublish());
    }

    public void init() throws Exception {
        if (!this.inited.compareAndSet(false, true)) {
            return;
        }
        SpasInit.initSpas();
        this.checkConfig();
        this.publish();
    }

    public void register() {
        if (this.metadata.setReadyToPublish(true)) {
            boolean pub = true;
            if (unitService != null) {
                pub = unitService.beforePublish(this.metadata);
            }
            if (pub) {
                metadataService.publish(this.metadata);
                LOGGER.info("HSF publish [{}:{}] success.", this.metadata.getInterfaceName(), new Object[]{this.metadata.getVersion()});
            }
        }
    }

    public void setClientTimeout(int clientTimeout) {
        this.metadata.addProperty("_TIMEOUT", "" + clientTimeout);
    }

    public void setCorePoolSize(String corePoolSize) {
        this.metadata.setCorePoolSize(corePoolSize);
    }

    public void setDelayedPublish(String delayedPublish) {
        this.metadata.addProperty("METADATA_DELAYED_PUBLISH", delayedPublish);
        if (Boolean.TRUE.toString().equals(delayedPublish)) {
            this.metadata.setReadyToPublish(false);
        }
    }

    public void setMaxPoolSize(String maxPoolSize) {
        this.metadata.setMaxPoolSize(maxPoolSize);
    }

    public void setMethodSpecials(MethodSpecial[] methodSpecials) {
        this.metadata.setMethodSpecials(methodSpecials);
    }

    public void setMethodToInjectConsumerIp(String methodName) {
        this.metadata.addProperty("METHOD_TO_INJECT_CONSUMERIP_PROP_KEY", methodName);
    }

    public void setSerializeType(String _serializeType) {
        this.metadata.addProperty("_SERIALIZETYPE", _serializeType);
        if ("java".equals(_serializeType)) {
            this.setPreferSerializeType(_serializeType);
        }
    }

    public void setPreferSerializeType(String _serializeType) {
        this.metadata.addProperty("_p", _serializeType);
    }

    public void setServiceGroup(String serviceGroup) {
        this.metadata.setGroup(serviceGroup);
        this.metadata.setDefaultGroup(serviceGroup);
    }

    public void setServiceInterface(String serviceInterface) {
        this.metadata.setInterfaceName(serviceInterface.trim());
    }

    public void setServiceInterfaceClass(Class<?> serviceInterfaceClass) {
        this.metadata.setIfClazz(serviceInterfaceClass);
    }

    public void setServiceVersion(String serviceVersion) {
        this.metadata.setVersion(serviceVersion);
    }

    public void setSupportAsynCall(String supportAsynCall) {
        this.metadata.setSupportAsyncall(supportAsynCall);
    }

    public void setTarget(Object target) {
        this.metadata.setTarget(target);
    }

    public void unregister() {
        if (this.metadata.setReadyToPublish(false)) {
            HSFServiceContainer.getInstance(MetadataService.class).unregister(this.metadata);
        }
    }

    public ServiceMetadata getMetadata() {
        return this.metadata;
    }

    public AtomicBoolean getInited() {
        return this.inited;
    }

    public void checkConfig() {
        int preferSerializeType;
        int serializeType;
        if (StringUtil.isEmpty((String)this.metadata.getInterfaceName()) && this.metadata.getIfClazz() != null) {
            this.metadata.setInterfaceName(this.metadata.getIfClazz().getName());
        }
        StringBuilder errorMsg = new StringBuilder();
        Object target = this.metadata.getTarget();
        if (null == target) {
            errorMsg.append("HSFApiProviderBean.metadata.target is null service:").append(this.metadata.getUniqueName());
            errorMsg.append(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0005", (String)"Biz-Problem", (String)errorMsg.toString()));
            this.invalidDeclaration(errorMsg.toString());
        }
        if ((serializeType = HSFServiceTargetUtil.convertSerializeType(this.metadata.getProperty("_SERIALIZETYPE"))) != 1 && serializeType != 2) {
            errorMsg.append("Property error [_SERIALIZETYPE=").append(serializeType).append("].");
            errorMsg.append(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0006", (String)"Biz-Problem", (String)errorMsg.toString()));
            this.invalidDeclaration(errorMsg.toString());
        }
        if ((preferSerializeType = HSFServiceTargetUtil.convertSerializeType(this.metadata.getProperty("_p"))) > 7 || preferSerializeType < 0) {
            errorMsg.append("Property error [_p=").append(preferSerializeType).append("].");
            this.invalidDeclaration(errorMsg.toString());
        }
        String serviceInterface = this.metadata.getInterfaceName();
        Class<?> interfaceClass = null;
        try {
            String writeMode;
            interfaceClass = this.metadata.getIfClazz();
            if (interfaceClass == null) {
                interfaceClass = Class.forName(serviceInterface);
                this.metadata.setIfClazz(interfaceClass);
            }
            if (!interfaceClass.isInterface()) {
                errorMsg.append("HSFApiProviderBean.metadata.ifClazz is not a interface[");
                errorMsg.append(serviceInterface).append("].");
                errorMsg.append(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0008", (String)"Biz-Problem", (String)errorMsg.toString()));
                this.invalidDeclaration(errorMsg.toString());
            }
            if (!interfaceClass.isAssignableFrom(target.getClass())) {
                errorMsg.append("Target class [").append(target.getClass().getName());
                errorMsg.append("] must implements [").append(serviceInterface).append("].");
                errorMsg.append(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0009", (String)"Biz-Problem", (String)errorMsg.toString()));
                this.invalidDeclaration(errorMsg.toString());
            }
            if (this.metadata.getRouteCheck() && (writeMode = this.metadata.getWriteMode()) != null && writeMode.equals("unit")) {
                int route = this.metadata.getRoute();
                if (route < 0) {
                    throw new IllegalArgumentException(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0012", (String)"Biz-Problem", (String)"invalid route while WriteMode=unit, route : "));
                }
                String methodToInjectConsumerIp = this.metadata.getProperty("METHOD_TO_INJECT_CONSUMERIP_PROP_KEY");
                for (Method m : interfaceClass.getDeclaredMethods()) {
                    if (m.getName().equals(methodToInjectConsumerIp)) continue;
                    int len = m.getParameterTypes().length;
                    if (route >= len) {
                        throw new IllegalArgumentException(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0012", (String)"Biz-Problem", (String)"invalid route while WriteMode=unit, route : "));
                    }
                    if (m.getParameterTypes()[route] == Long.TYPE || m.getParameterTypes()[route] == Long.class) continue;
                    throw new IllegalArgumentException(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0013", (String)"Biz-Problem", (String)("invalid route while WriteMode=unit, route : " + route + ", route parameter should be : long")));
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            errorMsg.append("Class HSFApiProviderBean.metadata.");
            errorMsg.append(serviceInterface).append(" not found.");
            errorMsg.append(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0014", (String)"Biz-Problem", (String)errorMsg.toString()));
            this.invalidDeclaration(errorMsg.toString());
        }
    }

    private void invalidDeclaration(String msg) {
        throw new IllegalArgumentException(msg);
    }

    public void publish() {
        if (!this.isPublished.compareAndSet(false, true)) {
            return;
        }
        try {
            boolean pub = true;
            if (unitService != null) {
                pub = unitService.beforePublish(this.metadata);
            }
            if (pub) {
                HSFServiceContainer.getInstance(ProcessService.class).publish(this.metadata);
            }
        }
        catch (Exception e) {
            LOGGER.error("HSF publish [{}:{}] failed.", this.metadata.getInterfaceName(), this.metadata.getVersion(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setConfigserverCenter(List<String> configserverCenter) {
        this.metadata.setConfigserverCenter(configserverCenter);
    }
}

