/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.app.spring.util;

import com.taobao.hsf.app.api.util.HSFApiProviderBean;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.model.metadata.MethodSpecial;
import com.taobao.hsf.remoting.service.ProviderServer;
import com.taobao.hsf.spas.SpasInit;
import com.taobao.hsf.util.AppInfoUtils;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.AbstractApplicationContext;

public final class HSFSpringProviderBean
implements InitializingBean,
ApplicationContextAware,
ApplicationListener {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private final HSFApiProviderBean providerBean = new HSFApiProviderBean();
    private final ProviderServer providerServer = HSFServiceContainer.getInstance(ProviderServer.class);
    private boolean isInSpringContainer = false;

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    public void init() throws Exception {
        if (!this.providerBean.getInited().compareAndSet(false, true)) {
            return;
        }
        SpasInit.initSpas();
        this.providerBean.checkConfig();
        this.publishIfNotInSpringContainer();
    }

    private void publishIfNotInSpringContainer() {
        if (!this.isInSpringContainer) {
            LOGGER.warn("[SpringProviderBean]\u4e0d\u662f\u5728Spring\u5bb9\u5668\u4e2d\u521b\u5efa, \u4e0d\u63a8\u8350\u4f7f\u7528");
            this.providerBean.publish();
        }
    }

    public void register() {
        this.providerBean.register();
    }

    public void republish() {
        this.register();
    }

    public void setClientTimeout(int clientTimeout) {
        this.providerBean.setClientTimeout(clientTimeout);
    }

    public void setCorePoolSize(String corePoolSize) {
        this.providerBean.setCorePoolSize(corePoolSize);
    }

    public void setDelayedPublish(String delayedPublish) {
        this.providerBean.setDelayedPublish(delayedPublish);
    }

    public void setMaxPoolSize(String maxPoolSize) {
        this.providerBean.setMaxPoolSize(maxPoolSize);
    }

    public void setMethodSpecials(MethodSpecial[] methodSpecials) {
        this.providerBean.setMethodSpecials(methodSpecials);
    }

    public void setMethodToInjectConsumerIp(String methodName) {
        this.providerBean.setMethodToInjectConsumerIp(methodName);
    }

    @Deprecated
    public void setMethodToTriggerPublish(String methodName) {
        throw new IllegalArgumentException("no longer support methodToTriggerPublish property in HSF2");
    }

    public void setPreferSerializeType(String _serializeType) {
        this.providerBean.setPreferSerializeType(_serializeType);
    }

    public void setSerializeType(String _serializeType) {
        this.providerBean.setSerializeType(_serializeType);
    }

    public void setServiceGroup(String serviceGroup) {
        this.providerBean.setServiceGroup(serviceGroup);
    }

    public void setGroup(String group) {
        this.setServiceGroup(group);
    }

    public void setServiceInterface(String serviceInterface) {
        this.providerBean.setServiceInterface(serviceInterface);
    }

    public void setInterface(String serviceInterface) {
        this.setServiceInterface(serviceInterface);
    }

    public void setServiceInterfaceClass(Class<?> serviceInterfaceClass) {
        this.providerBean.setServiceInterfaceClass(serviceInterfaceClass);
    }

    public void setServiceVersion(String serviceVersion) {
        this.providerBean.setServiceVersion(serviceVersion);
    }

    public void setVersion(String version) {
        this.setServiceVersion(version);
    }

    public void setSupportAsynCall(String supportAsynCall) {
        this.providerBean.setSupportAsynCall(supportAsynCall);
    }

    public void setTarget(Object target) {
        this.providerBean.setTarget(target);
    }

    public void setConfigserverCenter(List<String> configserverCenter) {
        this.providerBean.setConfigserverCenter(configserverCenter);
    }

    public void unregister() {
        this.providerBean.unregister();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (0 == AppInfoUtils.hsfSpringBeanCountDown) {
            AppInfoUtils.hsfSpringBeanCountDown = applicationContext.getBeanNamesForType(HSFSpringProviderBean.class).length;
        }
        if (applicationContext instanceof AbstractApplicationContext) {
            try {
                this.isInSpringContainer = true;
                LOGGER.info("\u63a5\u53e3[" + this.providerBean.getMetadata().getInterfaceName() + "]\u7248\u672c[" + this.providerBean.getMetadata().getVersion() + "]\u6dfb\u52a0Listner\u6210\u529f");
            }
            catch (Throwable t) {
                LOGGER.error("", "\u63a5\u53e3[" + this.providerBean.getMetadata().getInterfaceName() + "]\u7248\u672c[" + this.providerBean.getMetadata().getVersion() + "]\u6dfb\u52a0Listner\u6210\u529f\u5931\u8d25", t);
            }
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.providerBean.publish();
            this.setAppInitedStatus();
        } else if (event instanceof ContextClosedEvent && AppInfoUtils.appInited.compareAndSet(true, false)) {
            LOGGER.info("Spring\u5bb9\u5668\u5173\u95ed\uff0c\u8bbe\u7f6e\u5e94\u7528\u521d\u59cb\u5316\u72b6\u6001\u4e3a\u672a\u521d\u59cb\u5316\uff01");
            try {
                this.providerServer.stopHSFServer();
            }
            catch (Exception e) {
                LOGGER.error(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0037", (String)"\u73af\u5883\u95ee\u9898", (String)""), "Spring\u5bb9\u5668\u5173\u95ed\uff0c\u9500\u6bc1HSF\u76f8\u5173\u8d44\u6e90\u5931\u8d25\uff01", (Throwable)e);
            }
        }
    }

    private void setAppInitedStatus() {
        if (0 == --AppInfoUtils.hsfSpringBeanCountDown && AppInfoUtils.appInited.compareAndSet(false, true)) {
            LOGGER.info("\u6240\u6709hsfSpringBean\u521d\u59cb\u5316\u5b8c\u6210\uff0cSpring\u5bb9\u5668\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u53ef\u4ee5\u901a\u8fc7pandora\u67e5\u8be2\u5e94\u7528\u542f\u52a8\u72b6\u6001\u3002");
        }
    }
}

