/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.configuration.component;

import com.taobao.hsf.configuration.component.ConfigPropertiesRule;
import com.taobao.hsf.configuration.component.ConfigurationComponent;
import com.taobao.hsf.configuration.parser.ConfigPropertiesRuleParser;
import com.taobao.hsf.governance.GovernanceService;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.middleware.logger.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ConfigurationComponentUtil {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private static final GovernanceService governanceService = HSFServiceContainer.getInstance(GovernanceService.class, "diamond");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Properties initProperties(String configFile) {
        Properties ret = new Properties();
        InputStream in = null;
        try {
            in = ConfigurationComponent.class.getClassLoader().getResourceAsStream(configFile);
            ret.load(in);
        }
        catch (Exception e) {
            System.out.println("\u8bfb\u53d6HSF\u914d\u7f6e\u6587\u4ef6hsfconfig.properties\u5931\u8d25\uff0c\u5df2\u4f7f\u7528\u9ed8\u8ba4\u503c\u521d\u59cb\u5316HSF\u3002\u5982\u679c\u662fJAR\u4f9d\u8d56\u65b9\u5f0f\u4f7f\u7528HSF\u8bf7\u5ffd\u7565\u6b64\u5f02\u5e38\uff01");
            e.printStackTrace();
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public static final Properties initRemoteProperties() {
        String appName = System.getProperty("project.name");
        if (appName == null || appName.isEmpty()) {
            return new Properties();
        }
        String dataId = appName + ".CONFIGPROPERTIES";
        String configRawInfo = governanceService.getConfig(dataId, dataId, "HSF", 5000L, "[Configuration Component] faild to get remote configinfo for appName: " + appName);
        LOGGER.warn("configRawInfo : " + configRawInfo);
        return ConfigurationComponentUtil.parseConfigInfo(configRawInfo);
    }

    static final boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static Properties parseConfigInfo(String configRawInfo) {
        ConfigPropertiesRuleParser configRuleParse = new ConfigPropertiesRuleParser();
        ConfigPropertiesRule configRule = null;
        Properties props = null;
        try {
            configRule = configRuleParse.parse(configRawInfo);
            if (null != configRule) {
                props = configRule.getConfigProperties();
            }
        }
        catch (Exception e) {
            LOGGER.warn("[ConfigurationComponent] failed to parse config properties", new Object[]{e});
        }
        if (null == props) {
            props = new Properties();
        }
        return props;
    }
}

