/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.configuration.parser;

import com.taobao.hsf.configuration.parser.SubRuleParser;
import com.taobao.hsf.globalrule.DubboRegRule;
import com.taobao.hsf.globalrule.GlobalRule;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DubboRegRuleParser
implements SubRuleParser {
    private static final String TAG_DUBBO = "dubbo";
    private static final String TAG_DUBBO_REG_SERVER = "dubboRegServer";
    private static final String TAG_NEED_DUBBO_REGISTRY = "needDubboRegistry";

    @Override
    public boolean accept(Node node) {
        return TAG_DUBBO.equals(node.getNodeName());
    }

    @Override
    public void parse(Node node, GlobalRule globalRule) {
        DubboRegRule dubboRegRule = new DubboRegRule();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String content;
            Node cNode = children.item(i);
            if (1 != cNode.getNodeType()) continue;
            if (TAG_DUBBO_REG_SERVER.equals(cNode.getNodeName())) {
                content = cNode.getTextContent().trim();
                if (content.isEmpty()) continue;
                dubboRegRule.setDubboRegServer(content);
                continue;
            }
            if (!TAG_NEED_DUBBO_REGISTRY.equals(cNode.getNodeName()) || (content = cNode.getTextContent().trim()).isEmpty()) continue;
            dubboRegRule.setNeedDubboRegistry(Boolean.parseBoolean(content));
        }
        globalRule.setDubboRegRule(dubboRegRule);
    }
}

