/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.configuration.parser;

import com.taobao.hsf.configuration.parser.SubRuleParser;
import com.taobao.hsf.globalrule.EagleEyeRule;
import com.taobao.hsf.globalrule.GlobalRule;
import com.taobao.hsf.logger.LoggerInit;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EagleRuleParser
implements SubRuleParser {
    private static final String TAG_EAGLEEYE = "eagleeye";
    private static final String TAG_SWITCH_RPC = "rpcSwitchOffList";
    private static final String TAG_SWITCH_BIZ = "bizSwitchOffList";
    private static final String TAG_SAMPLE = "sampling";
    private static final String TAG_DUMP = "dump";
    private static final String TAG_CLUSTER_TEST = "clusterTestEnabled";
    private static final String TAG_USER_DATA = "userDataEnabled";

    @Override
    public boolean accept(Node node) {
        return TAG_EAGLEEYE.equals(node.getNodeName());
    }

    @Override
    public void parse(Node node, GlobalRule globalRuleHolder) {
        EagleEyeRule eagleEyeRule = new EagleEyeRule();
        NodeList children = node.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            String content;
            List<String> apps;
            Node cNode = children.item(j);
            if (1 != cNode.getNodeType()) continue;
            if (TAG_SWITCH_BIZ.equals(cNode.getNodeName())) {
                apps = this.getAppName(cNode);
                eagleEyeRule.getBizSwitchOffList().addAll(apps);
                continue;
            }
            if (TAG_SWITCH_RPC.equals(cNode.getNodeName())) {
                apps = this.getAppName(cNode);
                eagleEyeRule.getRpcSwitchOffList().addAll(apps);
                continue;
            }
            if (TAG_SAMPLE.equals(cNode.getNodeName())) {
                content = cNode.getTextContent().trim();
                try {
                    int interval = Integer.parseInt(content);
                    eagleEyeRule.setSampleInterval(interval);
                }
                catch (Exception e) {
                    LoggerInit.LOGGER.warn("parse EagleEye SamplingInterval error : " + content, new Object[]{e});
                }
                continue;
            }
            if (TAG_DUMP.equals(cNode.getNodeName())) {
                content = cNode.getTextContent().trim();
                eagleEyeRule.setDump(Boolean.parseBoolean(content));
                continue;
            }
            if (TAG_CLUSTER_TEST.equals(cNode.getNodeName())) {
                content = cNode.getTextContent().trim();
                boolean clusterTestEnabled = Boolean.parseBoolean(content);
                eagleEyeRule.setClusterTestEnabled(clusterTestEnabled);
                continue;
            }
            if (!TAG_USER_DATA.equals(cNode.getNodeName())) continue;
            content = cNode.getTextContent().trim();
            boolean userDataEnabled = Boolean.parseBoolean(content);
            eagleEyeRule.setUserDataEnabled(userDataEnabled);
        }
        globalRuleHolder.setEagleEyeRule(eagleEyeRule);
    }

    private List<String> getAppName(Node node) {
        String[] apps;
        ArrayList<String> appNames = new ArrayList<String>();
        String content = node.getTextContent().trim();
        for (String app : apps = content.split("\\s*,\\s*")) {
            appNames.add(app.trim());
        }
        return appNames;
    }
}

