/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.configuration.parser;

import com.taobao.hsf.configuration.parser.SubRuleParser;
import com.taobao.hsf.globalrule.GlobalRule;
import com.taobao.hsf.globalrule.VirtualCmRule;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.middleware.logger.Logger;
import java.util.ArrayList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VirtualCmRuleParser
implements SubRuleParser {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private static final String TAG_VIRTUAL_CM = "virtualCm";
    private static final String TAG_CM_GROUP = "cmGroup";

    @Override
    public boolean accept(Node node) {
        return node.getNodeName().equals(TAG_VIRTUAL_CM);
    }

    @Override
    public void parse(Node node, GlobalRule globalRuleHolder) {
        VirtualCmRule virtualCmRule = new VirtualCmRule();
        NodeList children = node.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node groupNode = children.item(j);
            if (1 != groupNode.getNodeType() || !TAG_CM_GROUP.equals(groupNode.getNodeName())) continue;
            String rawData = groupNode.getTextContent().trim();
            if (rawData == null || rawData.length() == 0) {
                LOGGER.warn("[VirtualCm Parser] empty cmGroup !");
                continue;
            }
            String[] tokens = rawData.split(",");
            ArrayList<String> cmGroup = new ArrayList<String>();
            for (String token : tokens) {
                cmGroup.add(token.trim());
            }
            virtualCmRule.addCmGroup(cmGroup);
        }
        globalRuleHolder.setVirtualCmRule(virtualCmRule);
    }
}

