/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.grouping.component;

import com.taobao.hsf.configuration.service.ConfigurationService;
import com.taobao.hsf.governance.GovernanceListener;
import com.taobao.hsf.governance.GovernanceService;
import com.taobao.hsf.grouping.service.GroupingRule;
import com.taobao.hsf.grouping.service.GroupingRuleParser;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.model.ApplicationModel;
import com.taobao.hsf.model.ConsumerServiceModel;
import com.taobao.hsf.model.ProviderServiceModel;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.process.service.ProcessHookServiceAdapter;
import com.taobao.hsf.util.AppInfoUtils;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;

public class GroupingComponent
extends ProcessHookServiceAdapter
implements GovernanceListener {
    private static final Logger LOGGER_CONFIG = LoggerInit.LOGGER_CONFIG;
    private static final AtomicBoolean inited = new AtomicBoolean(false);
    private final GroupingRuleParser ruleParser = new GroupingRuleParser();
    private final GovernanceService governanceService = HSFServiceContainer.getInstance(GovernanceService.class, HSFServiceContainer.getInstance(ConfigurationService.class).getGovernanceType());
    private GroupingRule groupingRule;

    @Override
    public void prePublish(ServiceMetadata metadata) {
        this.refreshGroup(metadata);
    }

    @Override
    public void preConsume(ServiceMetadata metadata) {
        this.refreshGroup(metadata);
    }

    private synchronized void refreshGroup(ServiceMetadata metadata) {
        this.retrieveRule(metadata);
        if (this.groupingRule == null) {
            return;
        }
        String serviceUniqueName = metadata.getUniqueName();
        String group = this.groupingRule.getGroup(serviceUniqueName, metadata.isProvider() ? "p" : "c");
        if (group == null) {
            LOGGER_CONFIG.warn(MessageFormat.format("[Grouping Component] Unsheltered service [{0}] in the grouping rule.", serviceUniqueName));
            return;
        }
        metadata.setGroup(group);
    }

    private synchronized void registerRule(String uniqueName, String rawRule) {
        if (rawRule == null || rawRule.length() == 0) {
            LOGGER_CONFIG.info("[Grouping Component] [{}] Empty Grouping rule received.", uniqueName);
            return;
        }
        LOGGER_CONFIG.info("[Grouping Component] [{}] Grouping rule received: [{}]", uniqueName, new Object[]{rawRule});
        String rawName = uniqueName.split(".GROUPINGRULE")[0];
        if ("@".equals(rawRule.trim())) {
            LOGGER_CONFIG.info("[Grouping Component] [{}] Clear command Received.", uniqueName);
            String appName = AppInfoUtils.getAppName();
            if (null != appName && appName.equals(rawName)) {
                for (ProviderServiceModel providerServiceModel : ApplicationModel.instance().allProvidedServices()) {
                    this.checkGroupForRepublish(providerServiceModel.getMetadata());
                }
            } else {
                ConsumerServiceModel consumerServiceModel = ApplicationModel.instance().getConsumedServiceModel(rawName);
                if (null != consumerServiceModel) {
                    this.checkGroupForRepublish(consumerServiceModel.getMetadata());
                }
            }
            return;
        }
        GroupingRule groupingRule = null;
        try {
            groupingRule = this.ruleParser.parse(rawName, rawRule);
        }
        catch (Throwable t) {
            LOGGER_CONFIG.info(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0022", (String)"Biz-Problem", (String)MessageFormat.format("[Grouping Component] Grouping rule [{0}] parsed failed: {1}", rawRule, t)));
            return;
        }
        if (groupingRule == null) {
            LOGGER_CONFIG.info(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0022", (String)"Biz-Problem", (String)"[Grouping Component] Invalid grouping rules received."));
            return;
        }
        if (!groupingRule.validate()) {
            LOGGER_CONFIG.info(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0022", (String)"Biz-Problem", (String)"[Grouping Component] Invalid grouping rules received."));
            return;
        }
        LOGGER_CONFIG.info(MessageFormat.format("[Grouping Component] Grouping rule parsed OK: {0}", groupingRule));
        this.groupingRule = groupingRule;
        for (ProviderServiceModel providerServiceModel : ApplicationModel.instance().allProvidedServices()) {
            this.checkGroupForRepublish(groupingRule, providerServiceModel.getMetadata());
        }
        for (ConsumerServiceModel consumerServiceModel : ApplicationModel.instance().allConsumedServices()) {
            this.checkGroupForRepublish(groupingRule, consumerServiceModel.getMetadata());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkGroupForRepublish(GroupingRule groupingRule, ServiceMetadata metadata) {
        String serviceUniqueName = metadata.getUniqueName();
        String newGroup = groupingRule.getGroup(serviceUniqueName, metadata.isProvider() ? "p" : "c");
        if (newGroup == null) {
            newGroup = metadata.getDefaultGroup();
        }
        ServiceMetadata serviceMetadata = metadata;
        synchronized (serviceMetadata) {
            if (metadata.getGroup().equals(newGroup)) {
                return;
            }
            metadata.fireMetadataBeforeChanged();
            metadata.setGroup(newGroup);
            metadata.fireMetadataAfterChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkGroupForRepublish(ServiceMetadata metadata) {
        String newGroup = metadata.getDefaultGroup();
        ServiceMetadata serviceMetadata = metadata;
        synchronized (serviceMetadata) {
            if (metadata.getGroup().equals(newGroup)) {
                return;
            }
            metadata.fireMetadataBeforeChanged();
            metadata.setGroup(newGroup);
            metadata.fireMetadataAfterChanged();
        }
    }

    private void retrieveRule(ServiceMetadata metadata) {
        if (inited.compareAndSet(false, true)) {
            String appName = AppInfoUtils.getAppName();
            if (appName == null) {
                LOGGER_CONFIG.error("", "[Grouping Component] Can not subscribe grouping rule: appName is null.");
            } else {
                String dataId = appName + ".GROUPINGRULE";
                String group = "HSF";
                this.subscribeGroupingRule(dataId, "HSF");
            }
        }
        this.subscribeGroupingRule(metadata.getUniqueName() + ".GROUPINGRULE", "HSF");
    }

    private void subscribeGroupingRule(String dataId, String group) {
        if (this.governanceService != null) {
            this.governanceService.getConfig(dataId, dataId, group, this, LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0022", (String)"Biz-Problem", (String)"[Grouping Component] Process grouping rule failed, grouping rule"));
        }
    }

    @Override
    public void process(String uniqueName, String configInfo) {
        this.registerRule(uniqueName, configInfo);
    }
}

