/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.logger;

import com.taobao.middleware.logger.Level;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.LoggerFactory;
import com.taobao.middleware.logger.support.LoggerHelper;

public class LoggerInit {
    private static final String CHARSET = "UTF-8";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"taobao.hsf");
    public static final Logger LOGGER_ADDRESS = LoggerFactory.getLogger((String)"taobao.hsf.address");
    public static final Logger LOGGER_CONFIG = LoggerFactory.getLogger((String)"taobao.hsf.config");
    public static final Logger LOGGER_CONN = LoggerFactory.getLogger((String)"taobao.hsf.connection");
    public static final String LOG_PATH = LoggerHelper.getLogpath() + "hsf";

    private static void initHSFLog() throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(LoggerInit.class.getClassLoader());
            LOGGER.setLevel(Level.INFO);
            LOGGER.activateAppenderWithTimeAndSizeRolling("hsf", "hsf.log", CHARSET, "1024MB", "yyyy-MM", 7);
            LOGGER.setAdditivity(false);
            LOGGER_ADDRESS.setLevel(Level.INFO);
            LOGGER_ADDRESS.activateAppenderWithTimeAndSizeRolling("hsf", "hsf-address.log", CHARSET, "1024MB", "yyyy-MM", 7);
            LOGGER_ADDRESS.setAdditivity(false);
            LOGGER_CONFIG.setLevel(Level.INFO);
            LOGGER_CONFIG.activateAppenderWithTimeAndSizeRolling("hsf", "hsf-config.log", CHARSET, "1024MB", "yyyy-MM", 7);
            LOGGER_CONFIG.setAdditivity(false);
            LOGGER_CONN.setLevel(Level.INFO);
            LOGGER_CONN.activateAppenderWithTimeAndSizeRolling("hsf", "hsf-connection.log", CHARSET, "1024MB", "yyyy-MM", 7);
            LOGGER_CONN.setAdditivity(false);
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    public static void changeLogLevel(String levelString) {
        try {
            levelString = LoggerInit.changeFatalToOff(levelString);
            Level level = Level.codeOf((String)levelString.toUpperCase());
            LOGGER.setLevel(Level.WARN);
            LOGGER.warn("\u6539\u53d8\u65e5\u5fd7\u7ea7\u522b\u4e3a" + level.toString());
            LOGGER.setLevel(level);
            LOGGER_ADDRESS.setLevel(level);
            LOGGER_CONFIG.setLevel(level);
        }
        catch (Throwable t) {
            LOGGER.error("", "\u6539\u53d8\u65e5\u5fd7\u7ea7\u522b\u5931\u8d25", t);
        }
    }

    private static String changeFatalToOff(String levelString) {
        if ("FATAL".equalsIgnoreCase(levelString)) {
            return "OFF";
        }
        return levelString;
    }

    static {
        try {
            LoggerInit.initHSFLog();
        }
        catch (Exception e) {
            LOGGER.error("", "", (Throwable)e);
        }
    }
}

