/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.metadata.component;

import com.taobao.hsf.address.AddressService;
import com.taobao.hsf.address.AddressSubscribeListener;
import com.taobao.hsf.address.MetadataAddressService;
import com.taobao.hsf.address.unit.UnitAddressService;
import com.taobao.hsf.configuration.service.ConfigurationService;
import com.taobao.hsf.event.Event;
import com.taobao.hsf.event.EventDispatcher;
import com.taobao.hsf.event.EventListener;
import com.taobao.hsf.exception.HSFException;
import com.taobao.hsf.governance.GovernanceListener;
import com.taobao.hsf.governance.GovernanceService;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.metadata.service.MetadataInfoStoreService;
import com.taobao.hsf.metadata.service.MetadataService;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.route.flowcontrol.FlowControlRule;
import com.taobao.hsf.route.flowcontrol.FlowControlRuleParseException;
import com.taobao.hsf.route.flowcontrol.FlowControlRuleParser;
import com.taobao.hsf.route.service.RouteRule;
import com.taobao.hsf.route.service.RouteRuleParser;
import com.taobao.hsf.route.service.RouteRuleParserException;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.hsf.util.HSFServiceTargetUtil;
import com.taobao.hsf.util.StringSplitter;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class MetadataComponent
implements MetadataService,
EventListener,
GovernanceListener,
AddressSubscribeListener {
    private static Logger LOGGER = LoggerInit.LOGGER;
    private static Logger LOGGER_CONFIG = LoggerInit.LOGGER_CONFIG;
    private static final String RULES_SUFFIX = ".RULES";
    private final ConfigurationService configurationService = HSFServiceContainer.getInstance(ConfigurationService.class);
    private final List<RouteRuleParser> routeRuleParsers = HSFServiceContainer.getInstances(RouteRuleParser.class);
    private final FlowControlRuleParser flowControlRuleParser = new FlowControlRuleParser();
    private final MetadataAddressService metadataAddressService = HSFServiceContainer.getInstance(MetadataAddressService.class, this.configurationService.getRegistryType());
    private final AddressService addressService = HSFServiceContainer.getInstance(AddressService.class);
    private final UnitAddressService unitAddressService = HSFServiceContainer.getInstance(UnitAddressService.class);
    private final GovernanceService governanceService = HSFServiceContainer.getInstance(GovernanceService.class, this.configurationService.getGovernanceType());
    private final MetadataInfoStoreService metadataInfoStoreService = HSFServiceContainer.getInstance(MetadataInfoStoreService.class);

    public MetadataComponent() {
        EventDispatcher.addEventListener(this);
        if (this.unitAddressService != null) {
            this.unitAddressService.setMetadataService(this);
        }
    }

    @Override
    public synchronized void publish(ServiceMetadata metadata) {
        try {
            this.metadataAddressService.publish(metadata);
        }
        catch (HSFException e) {
            LOGGER.error("", "publish failed", (Throwable)e);
        }
    }

    @Override
    public boolean resubscribe(ServiceMetadata metadata) {
        if (metadata == null) {
            LOGGER.info("[Metadata Component] Service metadata can not be null.");
            return false;
        }
        this.metadataAddressService.unregisterConsumer(metadata);
        try {
            Thread.sleep(400L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.metadataAddressService.subscribe(metadata, this);
            LOGGER.info(MessageFormat.format("[Metadata Component] Service [{0}] subscribe done.", metadata.getUniqueName()));
            return true;
        }
        catch (HSFException e) {
            LOGGER.info(MessageFormat.format("[Metadata Component] Service [{0}] subscribe failed.", metadata.getUniqueName()), new Object[]{e});
            return false;
        }
    }

    @Override
    public boolean republish(ServiceMetadata metadata) {
        if (metadata == null) {
            LOGGER.info("[Metadata Component] Service metadata can not be null.");
            return false;
        }
        this.unregister(metadata);
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.publish(metadata);
        LOGGER.info(MessageFormat.format("[Metadata Component] Service [{0}] published done.", metadata.getUniqueName()));
        return true;
    }

    @Override
    public void subscribe(ServiceMetadata metadata) {
        String dataId = metadata.getUniqueName() + RULES_SUFFIX;
        String group = metadata.getGroup();
        String serviceUniqueName = metadata.getUniqueName();
        if (this.governanceService != null) {
            this.governanceService.getConfig(dataId, serviceUniqueName, group, this, "[Metadata Component] Process rules failed");
        }
        try {
            this.metadataAddressService.subscribe(metadata, this);
        }
        catch (HSFException e) {
            LOGGER.error("", "subscribe failed", (Throwable)e);
        }
    }

    private void registerRule(String serviceUniqueName, String rawRule) {
        if (rawRule == null || rawRule.length() == 0) {
            LOGGER_CONFIG.warn(MessageFormat.format("[Metadata Component] Received empty rule for service [{0}].", serviceUniqueName));
            return;
        }
        LOGGER_CONFIG.warn(MessageFormat.format("[Metadata Component] Received rule for service [{0}]: {1}.", serviceUniqueName, rawRule));
        StringSplitter splitter = new StringSplitter(rawRule, "flowControl@", "Groovy_v200907@");
        if (splitter.has("Groovy_v200907@")) {
            String rawRoutingRule = splitter.get("Groovy_v200907@");
            RouteRule routingRule = this.parseRouteRule(serviceUniqueName, rawRoutingRule);
            if (routingRule != null) {
                this.addressService.setServiceRouteRule(serviceUniqueName, routingRule);
                if (this.unitAddressService != null) {
                    this.unitAddressService.setServiceRouteRule(serviceUniqueName, routingRule);
                }
            } else {
                LOGGER_CONFIG.warn(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0025", (String)"Biz-Problem", (String)("Could not parse route rule:" + rawRoutingRule)));
            }
        }
        if (splitter.has("flowControl@")) {
            String rawFlowControlRule = splitter.get("flowControl@");
            FlowControlRule flowControlRule = this.parseFlowControlRule(rawFlowControlRule);
            if (flowControlRule != null) {
                this.addressService.setFlowControlRule(serviceUniqueName, flowControlRule);
                if (this.unitAddressService != null) {
                    this.unitAddressService.setFlowControlRule(serviceUniqueName, flowControlRule);
                }
            } else {
                LOGGER_CONFIG.warn(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0026", (String)"Biz-Problem", (String)("Could not parse flowcontrol rule:" + rawFlowControlRule)));
            }
        }
    }

    private RouteRule parseRouteRule(String serviceUniqueName, String rawRoutingRule) {
        Class<?> serviceInterface;
        try {
            String interfaceName = serviceUniqueName.substring(0, serviceUniqueName.indexOf(":"));
            serviceInterface = Class.forName(interfaceName);
        }
        catch (ClassNotFoundException e) {
            LOGGER_CONFIG.error("", LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0024", (String)"Biz-Problem", (String)("[Address Component] Interface class not found: " + serviceUniqueName)), (Throwable)e);
            return null;
        }
        ArrayList<String> allMethodSigs = new ArrayList<String>();
        for (Method m : serviceInterface.getMethods()) {
            allMethodSigs.add(RouteRule.joinMethodSigs(m));
        }
        RouteRule routingRule = null;
        for (RouteRuleParser parser : this.routeRuleParsers) {
            try {
                routingRule = parser.parse(rawRoutingRule, allMethodSigs);
            }
            catch (RouteRuleParserException e) {
                LOGGER_CONFIG.error("", LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0025", (String)"Biz-Problem", (String)("[Address Component] Route rule parsed failed: " + rawRoutingRule)), (Throwable)e);
                return null;
            }
            if (routingRule == null) continue;
            break;
        }
        return routingRule;
    }

    private FlowControlRule parseFlowControlRule(String rawFlowControlRule) {
        FlowControlRule flowControlRule = null;
        if (this.flowControlRuleParser.accept(rawFlowControlRule)) {
            try {
                flowControlRule = this.flowControlRuleParser.parse(rawFlowControlRule);
                LOGGER_CONFIG.warn("[Address Pool] Flow control rule parsed OK: " + flowControlRule);
                if (!flowControlRule.validate()) {
                    return null;
                }
            }
            catch (FlowControlRuleParseException e) {
                LOGGER_CONFIG.error("", LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0026", (String)"Biz-Problem", (String)"[Address Pool] Flow control rule parsed failed."), (Throwable)e);
                return null;
            }
        }
        return flowControlRule;
    }

    @Override
    public synchronized void unregister(ServiceMetadata metadata) {
        this.metadataAddressService.unregisterProvider(metadata);
    }

    public void processUnitConfig(ServiceMetadata metadata, List<String> urls) {
        if (urls == null || urls.isEmpty()) {
            return;
        }
        for (String url : urls) {
            Properties props = HSFServiceTargetUtil.getTargetProperties(url);
            String writeMode = props.getProperty("WRITE_MODE");
            String route = props.getProperty("ROUTE");
            if (writeMode == null) continue;
            if (writeMode.equals("unit") && route != null) {
                try {
                    metadata.setRoute(Integer.parseInt(route));
                }
                catch (Exception e) {
                    LOGGER_CONFIG.warn("parse unit-route error", new Object[]{e});
                    continue;
                }
            }
            metadata.setWriteMode(writeMode);
            return;
        }
        metadata.setWriteMode(null);
    }

    @Override
    public void onEvent(Event event) {
        switch (event.getEventType()) {
            case MetaDataChanged: {
                ServiceMetadata metadata = (ServiceMetadata)event.getSource();
                if (metadata.isProvider()) {
                    if (!metadata.isReadyToPublish()) {
                        LOGGER.info("\u63a5\u53e3[" + metadata.getInterfaceName() + "]\u7248\u672c[" + metadata.getVersion() + "]\u670d\u52a1\u4f7f\u7528\u4e86\u5ef6\u8fdf\u53d1\u5e03\u529f\u80fd\uff0c\u670d\u52a1\u5f52\u7ec4\u5df2\u4fee\u6539\uff0c\u4f46\u670d\u52a1\u672a\u53d1\u5e03\uff01");
                        return;
                    }
                    this.republish(metadata);
                } else {
                    this.subscribe(metadata);
                }
                this.metadataInfoStoreService.store(metadata);
                break;
            }
            case MetaDataBeforeChanged: {
                ServiceMetadata metadata = (ServiceMetadata)event.getSource();
                if (metadata.isProvider()) break;
                this.metadataAddressService.unregisterConsumer(metadata);
                if (this.governanceService == null) break;
                this.governanceService.unRegister(metadata, RULES_SUFFIX);
                break;
            }
        }
    }

    @Override
    public void process(String uniqueName, String configInfo) {
        this.registerRule(uniqueName, configInfo);
    }

    @Override
    public void processAddress(ServiceMetadata metadata, List<String> urls) {
        if (null != urls && !urls.isEmpty()) {
            String serviceUniqueName = metadata.getUniqueName();
            this.addressService.setServiceAddresses(serviceUniqueName, urls);
            this.processUnitConfig(metadata, urls);
            if (this.unitAddressService != null) {
                this.unitAddressService.setServiceAddresses(serviceUniqueName, urls);
            }
        }
    }
}

