/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.model;

import com.taobao.hsf.model.ProviderMethodModel;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProviderServiceModel {
    private final String serviceName;
    private final Object serviceInstance;
    private final ServiceMetadata metadata;
    private final Map<String, List<ProviderMethodModel>> methods = new HashMap<String, List<ProviderMethodModel>>();
    private final Method injectConsumerIpMethod;

    public ProviderServiceModel(String serviceName, ServiceMetadata metada, Object serviceInstance) {
        if (null == serviceInstance) {
            throw new IllegalArgumentException("\u670d\u52a1[" + serviceName + "]\u7684Target\u4e3aNULL.");
        }
        this.serviceName = serviceName;
        this.metadata = metada;
        this.serviceInstance = serviceInstance;
        this.initMethod();
        this.injectConsumerIpMethod = this.getMethodToInjectCosumerIP(metada, serviceName);
    }

    public Method getInjectConsumerIpMethod() {
        return this.injectConsumerIpMethod;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ServiceMetadata getMetadata() {
        return this.metadata;
    }

    public Object getServiceInstance() {
        return this.serviceInstance;
    }

    public List<ProviderMethodModel> getAllMethods() {
        ArrayList<ProviderMethodModel> result = new ArrayList<ProviderMethodModel>();
        for (List<ProviderMethodModel> models : this.methods.values()) {
            result.addAll(models);
        }
        return result;
    }

    public ProviderMethodModel getMethodModel(String methodName, String[] argTypes) {
        List<ProviderMethodModel> methodModels = this.methods.get(methodName);
        if (methodModels != null) {
            for (ProviderMethodModel methodModel : methodModels) {
                if (!Arrays.equals(argTypes, methodModel.getMethodArgTypes())) continue;
                return methodModel;
            }
        }
        return null;
    }

    private Method getMethodToInjectCosumerIP(ServiceMetadata metadata, String serviceUniqueNamel) {
        String methodName = metadata.getProperty("METHOD_TO_INJECT_CONSUMERIP_PROP_KEY");
        if (methodName == null) {
            return null;
        }
        ProviderMethodModel pm = this.getMethodModel(methodName, new String[]{String.class.getName()});
        return pm == null ? null : pm.getMethod();
    }

    private int getServiceTimeoutValue(ServiceMetadata metadata, String methodName) {
        if (metadata.getMethodSpecial(methodName) != null) {
            return (int)metadata.getMethodSpecial(methodName).getClientTimeout();
        }
        return metadata.getTimeout();
    }

    private void initMethod() {
        for (Method method : this.metadata.getIfClazz().getMethods()) {
            method.setAccessible(true);
            List<ProviderMethodModel> methodModels = this.methods.get(method.getName());
            if (methodModels == null) {
                methodModels = new ArrayList<ProviderMethodModel>(1);
                this.methods.put(method.getName(), methodModels);
            }
            methodModels.add(new ProviderMethodModel(method, this.serviceName, this.getServiceTimeoutValue(this.metadata, method.getName())));
        }
    }
}

