/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.process.component;

import com.taobao.hsf.EnumConfigStyle;
import com.taobao.hsf.configuration.service.ConfigurationService;
import com.taobao.hsf.exception.HSFException;
import com.taobao.hsf.exception.HSFRuntimeException;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.metadata.service.MetadataInfoStoreService;
import com.taobao.hsf.metadata.service.MetadataService;
import com.taobao.hsf.model.ApplicationModel;
import com.taobao.hsf.model.ConsumerMethodModel;
import com.taobao.hsf.model.ConsumerServiceModel;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.process.service.ProcessHookService;
import com.taobao.hsf.process.service.ProcessService;
import com.taobao.hsf.remoting.service.EchoService;
import com.taobao.hsf.remoting.service.GenericService;
import com.taobao.hsf.remoting.service.RPCProtocolTemplateService;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.middleware.logger.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ProcessComponent
implements ProcessService {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private final List<ProcessHookService> hookServices = HSFServiceContainer.getInstances(ProcessHookService.class);
    private final RPCProtocolTemplateService rpcProtocolService = HSFServiceContainer.getInstance(RPCProtocolTemplateService.class);
    private final MetadataService metadataService = HSFServiceContainer.getInstance(MetadataService.class);
    private final ConfigurationService configurationService = HSFServiceContainer.getInstance(ConfigurationService.class);
    private final MetadataInfoStoreService metadataInfoStoreService = HSFServiceContainer.getInstance(MetadataInfoStoreService.class);

    @Override
    public Object consume(ServiceMetadata metadata) throws HSFException {
        if (ApplicationModel.instance().getConsumedServiceModel(metadata.getUniqueName()) != null && metadata.getConfigStyle() == EnumConfigStyle.HSF) {
            return ApplicationModel.instance().getConsumedServiceModel(metadata.getUniqueName()).getProxyObject();
        }
        for (ProcessHookService hookService : this.hookServices) {
            hookService.preConsume(metadata);
        }
        ArrayList interfaces = new ArrayList(3);
        if (metadata.getIfClazz() != null) {
            interfaces.add(metadata.getIfClazz());
        }
        if (metadata.isSupportEcho()) {
            interfaces.add(EchoService.class);
        }
        if (!GenericService.class.equals(metadata.getIfClazz())) {
            interfaces.add(GenericService.class);
        }
        Class[] interfacesArray = new Class[interfaces.size()];
        interfaces.toArray(interfacesArray);
        Object proxyObj = HSFServiceProxy.proxy(metadata, interfacesArray);
        this.metadataService.subscribe(metadata);
        for (ProcessHookService hookService : this.hookServices) {
            hookService.afterConsume(metadata);
        }
        this.metadataInfoStoreService.store(metadata);
        return proxyObj;
    }

    @Override
    public void publish(ServiceMetadata metadata) throws HSFException {
        try {
            this.rpcProtocolService.registerProvider(metadata);
        }
        catch (HSFException e) {
            LOGGER.error("HSF publish [{}] faild. please check hsf config.", metadata.getUniqueName(), (Throwable)e);
            throw e;
        }
        for (ProcessHookService hookService : this.hookServices) {
            hookService.prePublish(metadata);
        }
        if (metadata.isReadyToPublish()) {
            this.metadataService.publish(metadata);
            LOGGER.error("HSF publish [{}:{}] success.", metadata.getInterfaceName(), metadata.getVersion());
        } else {
            LOGGER.error("HSF publish [{}:{}] delay publish.", metadata.getInterfaceName(), metadata.getVersion());
        }
        for (ProcessHookService hookService : this.hookServices) {
            hookService.afterPublish(metadata);
        }
        this.metadataInfoStoreService.store(metadata);
    }

    public static class HSFServiceProxy
    implements InvocationHandler {
        private static final RPCProtocolTemplateService rpcProtocolService = HSFServiceContainer.getInstance(RPCProtocolTemplateService.class);
        private final ServiceMetadata serviceConsumerMetadata;
        private final ConsumerServiceModel serviceModel;
        private final Object instance;
        private final Method equalsMethod;
        private final Method toStringMethod;
        private final Method hashCodeMethod;

        static Object proxy(ServiceMetadata metadata, Class<?>[] classes) {
            return new HSFServiceProxy(metadata, classes).getInstance();
        }

        private HSFServiceProxy(ServiceMetadata metadata, Class<?>[] classes) {
            this.serviceConsumerMetadata = metadata;
            Method equalsMethod1 = null;
            Method toStringMethod1 = null;
            Method hashCodeMethod1 = null;
            this.instance = Proxy.newProxyInstance(this.serviceConsumerMetadata.getIfClazz().getClassLoader(), classes, (InvocationHandler)this);
            try {
                Field hashCodeFeild = this.instance.getClass().getDeclaredField("m0");
                hashCodeFeild.setAccessible(true);
                hashCodeMethod1 = (Method)hashCodeFeild.get(this.instance);
                Field equalsFeild = this.instance.getClass().getDeclaredField("m1");
                equalsFeild.setAccessible(true);
                equalsMethod1 = (Method)equalsFeild.get(this.instance);
                Field toStringFeild = this.instance.getClass().getDeclaredField("m2");
                toStringFeild.setAccessible(true);
                toStringMethod1 = (Method)toStringFeild.get(this.instance);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), new Object[]{e});
            }
            ApplicationModel.instance().initConsumerService(metadata.getUniqueName(), new ConsumerServiceModel(metadata, this.instance));
            this.serviceModel = ApplicationModel.instance().getConsumedServiceModel(metadata.getUniqueName());
            this.hashCodeMethod = hashCodeMethod1;
            this.toStringMethod = toStringMethod1;
            this.equalsMethod = equalsMethod1;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method == this.toStringMethod) {
                return this.serviceConsumerMetadata.getInterfaceName();
            }
            if (method == this.equalsMethod) {
                return proxy == args[0];
            }
            if (method == this.hashCodeMethod) {
                return System.identityHashCode(proxy);
            }
            ConsumerMethodModel methodModel = this.serviceModel.getMethodModel(method);
            return this.invoke0(methodModel, args);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object invoke0(ConsumerMethodModel methodModel, Object[] args) throws Throwable {
            AtomicInteger maxPoolSize = this.serviceConsumerMetadata.getCurConsumerMaxPoolSize();
            if (maxPoolSize == null) {
                return rpcProtocolService.invokeWithMethodObject(methodModel, args);
            }
            int currentSize = maxPoolSize.decrementAndGet();
            try {
                if (currentSize < 0) {
                    String errorMsg = MessageFormat.format("Thread pool exhausted, service:{0}, consumerMaxPoolSize:{1}", this.serviceConsumerMetadata.getUniqueName(), this.serviceConsumerMetadata.getConsumerMaxPoolSize());
                    LOGGER.warn(errorMsg);
                    throw new HSFRuntimeException(errorMsg);
                }
                Object object = rpcProtocolService.invokeWithMethodObject(methodModel, args);
                return object;
            }
            finally {
                maxPoolSize.incrementAndGet();
            }
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

