/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting;

import com.taobao.hsf.remoting.BaseRequest;
import com.taobao.hsf.remoting.BaseResponse;
import com.taobao.hsf.remoting.HeartBeatResponse;
import com.taobao.hsf.remoting.ProtocolFactory;
import com.taobao.hsf.remoting.protocol.ByteBufferWrapper;
import com.taobao.hsf.remoting.server.ServerHandler;

public class HandshakeRequest
extends BaseRequest {
    private static final ServerHandler<? extends BaseRequest> serverHandler = ProtocolFactory.instance.getServerHandler((byte)12);

    public HandshakeRequest() {
        super(12);
    }

    public HandshakeRequest(long id, int timeout) {
        super(12, id, timeout);
    }

    @Override
    public BaseResponse createErrorResponse(String responseBytes) {
        return new HeartBeatResponse(this.getRequestID());
    }

    @Override
    public ServerHandler<? extends BaseRequest> getServerHandler() {
        return serverHandler;
    }

    @Override
    public void encode(ByteBufferWrapper bytebufferWrapper) throws Exception {
        long id = this.getRequestID();
        int timeout = this.getTimeout();
        bytebufferWrapper.ensureCapacity(18);
        bytebufferWrapper.writeByte((byte)12);
        bytebufferWrapper.writeByte((byte)0);
        bytebufferWrapper.writeByte((byte)1);
        bytebufferWrapper.writeByte((byte)0);
        bytebufferWrapper.writeByte((byte)0);
        bytebufferWrapper.writeByte((byte)0);
        bytebufferWrapper.writeLong(id);
        bytebufferWrapper.writeInt(timeout);
    }

    @Override
    public int size() {
        return 0;
    }
}

