/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting;

public enum ResponseStatus {
    OK(20, "OK"),
    CLIENT_TIMEOUT(30, "client timeout"),
    SERVER_TIMEOUT(31, "server timeout"),
    BAD_REQUEST(40, "bad request"),
    BAD_RESPONSE(50, "bad response"),
    SERVICE_NOT_FOUND(60, "service not found"),
    SERVICE_ERROR(70, "service error"),
    SERVER_ERROR(80, "server error"),
    CLIENT_ERROR(90, "client error"),
    UNKNOWN_ERROR(91, "Unknow error"),
    THREADPOOL_BUSY(81, "Thread pool is busy"),
    COMM_ERROR(82, "Communication error"),
    SERVER_CLOSING(88, "server will close soon"),
    SERVER_GETCODER(10, "server send coders"),
    UNKNOW_CODE(83, "Unkown code");

    private final String message;
    private final byte code;

    private ResponseStatus(int code, String message) {
        this.code = (byte)code;
        this.message = message;
    }

    public static ResponseStatus fromCode(byte code) {
        ResponseStatus[] values;
        for (ResponseStatus value : values = ResponseStatus.values()) {
            if (value.getCode() != code) continue;
            return value;
        }
        return UNKNOW_CODE;
    }

    public String getMessage() {
        return this.message;
    }

    public byte getCode() {
        return this.code;
    }
}

