/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting;

import com.taobao.hsf.CustomizedSerializerHelper;
import com.taobao.hsf.remoting.BaseRequest;
import com.taobao.hsf.remoting.BaseResponse;
import com.taobao.hsf.remoting.ProtocolFactory;
import com.taobao.hsf.remoting.RemotingConstants;
import com.taobao.hsf.remoting.RpcResponse;
import com.taobao.hsf.remoting.protocol.ByteBufferWrapper;
import com.taobao.hsf.remoting.server.ServerHandler;
import com.taobao.hsf.remoting.util.ThreadLocalCache;
import com.taobao.hsf.remoting.util.UUIDGenerator;

public class RpcRequest
extends BaseRequest {
    private static final byte[] EXTENED_BYTES = new byte[3];
    private static final ServerHandler<? extends BaseRequest> serverHandler = ProtocolFactory.instance.getServerHandler((byte)14);
    private final String targetInstanceName;
    private final String methodName;
    private final String[] argTypes;
    private final byte[][] requestObjects;
    private final byte[] requestProps;
    private final byte codecType;
    private final int size;

    public RpcRequest(long id, int timeout, String targetInstanceName, String methodName, String[] argTypes, byte[][] requestObjects, byte[] requestProps, byte codecType, int size) {
        super(14, id, timeout);
        this.targetInstanceName = targetInstanceName;
        this.methodName = methodName;
        this.argTypes = argTypes;
        this.requestObjects = requestObjects;
        this.codecType = codecType;
        this.requestProps = requestProps;
        this.size = size;
    }

    public RpcRequest(int timeout, String targetInstanceName, String methodName, String[] argTypes, byte[][] requestObjects, byte[] requestProps, byte codecType, int size) {
        this(UUIDGenerator.getNextOpaque(), timeout, targetInstanceName, methodName, argTypes, requestObjects, requestProps, codecType, size);
    }

    public byte[] getRequestProps() {
        return this.requestProps;
    }

    public String getTargetInstanceName() {
        return this.targetInstanceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String[] getArgTypes() {
        return this.argTypes;
    }

    public byte[][] getRequestObjects() {
        return this.requestObjects;
    }

    public byte getCodecType() {
        return this.codecType;
    }

    public String getMethodKey() {
        return CustomizedSerializerHelper.catMethodName(this.targetInstanceName, this.methodName, this.argTypes);
    }

    @Override
    public BaseResponse createErrorResponse(String responseBytes) {
        return new RpcResponse(this.getRequestID(), this.codecType, responseBytes.getBytes(RemotingConstants.DEFAULT_CHARSET));
    }

    @Override
    public ServerHandler<? extends BaseRequest> getServerHandler() {
        return serverHandler;
    }

    @Override
    public void encode(ByteBufferWrapper bytebufferWrapper) throws Exception {
        int requestArgTypesLen = 0;
        int requestArgsLen = 0;
        String[] argTypes = this.getArgTypes();
        byte[][] requestArgTypes = new byte[argTypes.length][];
        for (int i = 0; i < argTypes.length; ++i) {
            requestArgTypes[i] = ThreadLocalCache.getBytes(argTypes[i]);
        }
        for (byte[] requestArgType : requestArgTypes) {
            requestArgTypesLen += requestArgType.length;
        }
        byte[][] requestObjects = this.getRequestObjects();
        if (requestObjects != null) {
            for (byte[] requestArg : requestObjects) {
                requestArgsLen += requestArg.length;
            }
        }
        byte[] targetInstanceNameBytes = ThreadLocalCache.getBytes(this.getTargetInstanceName());
        byte[] methodNameBytes = ThreadLocalCache.getBytes(this.getMethodName());
        long id = this.getRequestID();
        int timeout = this.getTimeout();
        int requestArgTypesCount = requestArgTypes.length;
        int requestPropLength = this.getRequestProps() == null ? 0 : this.getRequestProps().length;
        int capacity = 30 + requestArgTypesCount * 4 * 2 + 5 + targetInstanceNameBytes.length + methodNameBytes.length + requestArgTypesLen + requestArgsLen + requestPropLength;
        bytebufferWrapper.ensureCapacity(capacity);
        bytebufferWrapper.writeByte((byte)14);
        bytebufferWrapper.writeByte((byte)1);
        bytebufferWrapper.writeByte((byte)0);
        bytebufferWrapper.writeByte(this.getCodecType());
        bytebufferWrapper.writeBytes(EXTENED_BYTES);
        bytebufferWrapper.writeLong(id);
        bytebufferWrapper.writeInt(timeout);
        bytebufferWrapper.writeInt(targetInstanceNameBytes.length);
        bytebufferWrapper.writeInt(methodNameBytes.length);
        bytebufferWrapper.writeInt(requestArgTypesCount);
        for (byte[] requestArgType : requestArgTypes) {
            bytebufferWrapper.writeInt(requestArgType.length);
        }
        if (requestObjects != null) {
            for (byte[] requestArg : requestObjects) {
                bytebufferWrapper.writeInt(requestArg.length);
            }
        }
        bytebufferWrapper.writeInt(requestPropLength);
        bytebufferWrapper.writeBytes(targetInstanceNameBytes);
        bytebufferWrapper.writeBytes(methodNameBytes);
        for (byte[] requestArgType : requestArgTypes) {
            bytebufferWrapper.writeBytes(requestArgType);
        }
        if (requestObjects != null) {
            for (byte[] requestArg : requestObjects) {
                bytebufferWrapper.writeBytes(requestArg);
            }
        }
        if (this.getRequestProps() != null) {
            bytebufferWrapper.writeBytes(this.getRequestProps());
        }
    }

    @Override
    public int size() {
        return this.size;
    }
}

